/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file.widgets;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.shared.computils.file.resources.FileResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileSelector
extends MJPanel {
    private final Component fParent;
    private final JTextField fTextField;
    private final JButton fBrowseButton;
    private final Collection<ActionListener> fListeners = new HashSet<ActionListener>();
    private volatile File fFile = null;
    private volatile boolean fDisableDocumentListener = false;

    public FileSelector() {
        this(null);
    }

    public FileSelector(Component component) {
        this.fParent = component;
        this.fTextField = new MJTextField();
        this.fTextField.setName("DirectoryTextField");
        this.fBrowseButton = FileSelector.createBrowseButton();
        this.layoutControls(this.fTextField, this.fBrowseButton);
        this.setupListeners();
    }

    private static JButton createBrowseButton() {
        ImageIcon imageIcon = IconEnumerationUtils.getIcon((String)"open_ts_16.png");
        MJButton mJButton = new MJButton((Icon)imageIcon);
        mJButton.setToolTipText(FileResources.getString("ui.button.browse", new String[0]));
        mJButton.setName("FileBrowseButton");
        MJToolBar.configureButton((MJButton)mJButton);
        return mJButton;
    }

    public void setBrowseButtonName(String string) {
        this.fBrowseButton.setName(string);
    }

    public void setTextFieldName(String string) {
        this.fTextField.setName(string);
    }

    public Dimension getPreferredSize() {
        return new Dimension(-1, Math.max(this.fBrowseButton.getPreferredSize().height, this.fTextField.getPreferredSize().height));
    }

    public File getFile() {
        return this.fFile;
    }

    public void setFile(File file) {
        if (this.fFile != null && this.fFile.equals(file) || this.fFile == null && file == null) {
            return;
        }
        this.setFileSilently(file);
        this.dispatchFileChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileSilently(File file) {
        this.fFile = file;
        try {
            this.fDisableDocumentListener = true;
            if (this.fFile != null) {
                this.fTextField.setText(this.fFile.getAbsolutePath());
            }
        }
        finally {
            this.fDisableDocumentListener = false;
        }
    }

    private void updateFileFromTextField() {
        if (this.fDisableDocumentListener) {
            return;
        }
        String string = this.fTextField.getText();
        this.fFile = string != null && !string.isEmpty() ? new File(string) : null;
        this.dispatchFileChangedEvent();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fTextField.setEnabled(bl);
        this.fBrowseButton.setEnabled(bl);
    }

    public void setEditable(boolean bl) {
        this.fTextField.setEditable(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.fListeners.add(actionListener);
    }

    protected void configure(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
    }

    private void dispatchFileChangedEvent() {
        for (ActionListener actionListener : this.fListeners) {
            actionListener.actionPerformed(new ActionEvent((Object)this, 0, "fileChanged"));
        }
    }

    private void setupListeners() {
        this.fBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                FileSelector.this.configure(mJFileChooserPerPlatform);
                if (FileSelector.this.fFile != null) {
                    mJFileChooserPerPlatform.setCurrentDirectory(FileSelector.this.fFile);
                }
                mJFileChooserPerPlatform.showOpenDialog((Component)(FileSelector.this.fParent == null ? FileSelector.this : FileSelector.this.fParent));
                if (mJFileChooserPerPlatform.getState() == 0) {
                    FileSelector.this.setFile(mJFileChooserPerPlatform.getSelectedFile());
                }
            }
        });
        this.fTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FileSelector.this.updateFileFromTextField();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FileSelector.this.updateFileFromTextField();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FileSelector.this.updateFileFromTextField();
            }
        });
    }

    private void layoutControls(JComponent jComponent, JComponent jComponent2) {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(jComponent, 0, -1, Integer.MAX_VALUE).addComponent(jComponent2, -2, -2, -2));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent(jComponent, 0, -1, Integer.MAX_VALUE).addComponent(jComponent2, 0, -1, Integer.MAX_VALUE));
    }
}

