/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.widgets;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.toolbox.shared.computils.exceptions.ErrorDialog;
import com.mathworks.toolbox.shared.computils.widgets.resources.CompUtilWidgetResources;
import java.awt.Desktop;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ParagraphView;

public class HTMLMessagePane
extends MJEditorPane {
    private static final String MATLAB_PROTOCOL = "matlab:";
    private static final String FILE_PROTOCOL = "file:";
    private static final String MATLAB_OPEN_FUNCTION = "open";

    public HTMLMessagePane() {
        this.setContentType("text/html");
        this.setOpaque(false);
        this.setEditable(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.removeContextMenu();
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
                if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                    HTMLMessagePane.activateHyperLinkEvent(hyperlinkEvent);
                } else if (eventType == HyperlinkEvent.EventType.ENTERED) {
                    HTMLMessagePane.this.setToolTipText(hyperlinkEvent.getDescription());
                } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                    HTMLMessagePane.this.setToolTipText(null);
                }
            }
        });
    }

    public void setText(String string) {
        String string2 = string.replaceAll("\n", "<br/>");
        if (string2.trim().startsWith("/")) {
            string2 = string2.replaceFirst("/", "&#47;");
        }
        super.setText(string2);
        this.setCaretPosition(0);
    }

    public void setWrapping(boolean bl) {
        super.setWrapping(bl);
        HTMLEditorKit hTMLEditorKit = bl ? new HTMLEditorKit() : new HTMLEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return new HTMLEditorKit.HTMLFactory(){

                    @Override
                    public View create(Element element) {
                        View view = super.create(element);
                        if (view instanceof ParagraphView) {
                            return new ParagraphView(element){

                                @Override
                                public float getMinimumSpan(int n) {
                                    return super.getPreferredSpan(n);
                                }
                            };
                        }
                        return view;
                    }
                };
            }
        };
        String string = super.getText();
        this.setEditorKit(hTMLEditorKit);
        super.setText(string);
    }

    private static void activateHyperLinkEvent(HyperlinkEvent hyperlinkEvent) {
        String string = hyperlinkEvent.getDescription();
        URL uRL = hyperlinkEvent.getURL();
        if (string.startsWith(MATLAB_PROTOCOL)) {
            String string2 = string.substring(MATLAB_PROTOCOL.length());
            HTMLMessagePane.executeInMatlab(string2);
        } else if (string.startsWith(FILE_PROTOCOL)) {
            String string3 = string.substring(FILE_PROTOCOL.length());
            HTMLMessagePane.openInMatlab(string3);
        } else if (uRL != null) {
            HTMLMessagePane.openInBrowser(uRL);
        } else if (new File(string).exists()) {
            HTMLMessagePane.openInMatlab(string);
        } else {
            HTMLMessagePane.handle(new MalformedURLException(CompUtilWidgetResources.getString("exception.hyperlink", string)));
        }
    }

    private static void executeInMatlab(final String string) {
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Matlab.mtEval((String)string);
                }
                catch (Exception exception) {
                    HTMLMessagePane.handle(exception);
                }
            }
        });
    }

    private static void openInMatlab(final String string) {
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Matlab.mtFeval((String)HTMLMessagePane.MATLAB_OPEN_FUNCTION, (Object[])new Object[]{string}, (int)0);
                }
                catch (Exception exception) {
                    HTMLMessagePane.handle(exception);
                }
            }
        });
    }

    private static void openInBrowser(URL uRL) {
        try {
            Desktop.getDesktop().browse(uRL.toURI());
        }
        catch (Exception exception) {
            HTMLMessagePane.handle(exception);
        }
    }

    private static void handle(final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ErrorDialog(exception.getMessage()).show();
            }
        });
    }
}

