/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.widgets;

import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class OverlayPanel
implements ComponentBuilder {
    private static final Color GLASS_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.8f);
    private final JComponent fLayeredPanel;
    private final JComponent fGlassPanel = new MJPanel(){

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(graphics);
        }
    };
    private boolean fGlassShowing = false;

    public OverlayPanel(final JComponent jComponent) {
        this.fGlassPanel.setOpaque(false);
        this.fGlassPanel.setBackground(GLASS_COLOR);
        this.fGlassPanel.setEnabled(false);
        this.fGlassPanel.addMouseListener(new MouseAdapter(){});
        this.fLayeredPanel = new MJLayeredPane(){

            public void doLayout() {
                Dimension dimension = OverlayPanel.this.fLayeredPanel.getSize();
                jComponent.setSize(dimension);
                OverlayPanel.this.fGlassPanel.setSize(dimension);
                super.doLayout();
            }
        };
        this.fLayeredPanel.add((Component)jComponent, JLayeredPane.DEFAULT_LAYER);
    }

    public JComponent getComponent() {
        return this.fLayeredPanel;
    }

    public void setGlassEnabled(boolean bl) {
        if (bl && !this.fGlassShowing) {
            this.fGlassPanel.setVisible(true);
            this.fLayeredPanel.add((Component)this.fGlassPanel, JLayeredPane.PALETTE_LAYER);
        } else if (!bl && this.fGlassShowing) {
            this.fLayeredPanel.remove(this.fGlassPanel);
            this.fGlassPanel.setVisible(false);
        }
        this.fLayeredPanel.repaint();
        this.fGlassShowing = bl;
    }

    public void setGlassComponent(JComponent jComponent) {
        this.fGlassPanel.removeAll();
        if (jComponent != null) {
            GroupLayout groupLayout = new GroupLayout(this.fGlassPanel);
            this.fGlassPanel.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(0, 0, Integer.MAX_VALUE).addComponent(jComponent, 0, -2, -2).addGap(0, 0, Integer.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(0, 0, Integer.MAX_VALUE).addComponent(jComponent, 0, -2, -2).addGap(0, 0, Integer.MAX_VALUE));
        }
        this.fLayeredPanel.repaint();
    }
}

