/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.widgets.fileselection;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FileSelectionModel {
    private final Collection<FileSelectionListener> fListeners = new ArrayList<FileSelectionListener>();
    private final Collection<File> fSelectableFiles;

    public FileSelectionModel(Collection<File> collection) {
        this.fSelectableFiles = new ArrayList<File>(collection);
    }

    public Collection<File> getSelectableFiles() {
        return Collections.unmodifiableCollection(this.fSelectableFiles);
    }

    public void select(File file) {
        for (FileSelectionListener fileSelectionListener : this.fListeners) {
            fileSelectionListener.fileSelected(file);
        }
    }

    public void addListener(FileSelectionListener fileSelectionListener) {
        this.fListeners.add(fileSelectionListener);
    }

    public static interface FileSelectionListener {
        public void fileSelected(File var1);
    }
}

