/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.widgets.fileselection;

import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.shared.computils.widgets.fileselection.FileSelectionModel;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileSelectorWidget {
    private final DefaultListModel<File> fFileListModel;
    private final MJList fFileList;
    private final JComponent fParentPanel;
    private final FileSelectionModel fFileSelectionModel;

    public FileSelectorWidget(FileSelectionModel fileSelectionModel) {
        this.fFileSelectionModel = fileSelectionModel;
        this.fFileListModel = new DefaultListModel();
        this.fFileList = new MJList(this.fFileListModel);
        this.fFileList.setSelectionMode(0);
        this.fFileList.setName("fileList");
        this.fParentPanel = new MJScrollPane((Component)this.fFileList);
        this.fFileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                File file = (File)FileSelectorWidget.this.fFileList.getSelectedValue();
                if (file != null) {
                    FileSelectorWidget.this.fFileSelectionModel.select(file);
                }
            }
        });
        this.setFiles();
    }

    public File select(int n) {
        this.fFileList.setSelectedIndex(n);
        return this.fFileListModel.get(n);
    }

    public JComponent getComponent() {
        return this.fParentPanel;
    }

    private void setFiles() {
        Collection<File> collection = this.fFileSelectionModel.getSelectableFiles();
        this.fFileListModel.removeAllElements();
        for (File file : collection) {
            this.fFileListModel.addElement(file);
        }
        if (collection.size() == 1) {
            this.fFileList.setSelectedIndex(0);
        }
    }
}

