/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport;

import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.decorator.PopupMenuProvider;
import com.mathworks.comparisons.decorator.actionid.ActionIDCopy;
import com.mathworks.comparisons.decorator.actionid.ActionIDFind;
import com.mathworks.comparisons.decorator.actionid.ActionIDHelp;
import com.mathworks.comparisons.decorator.actionid.ActionIDPrint;
import com.mathworks.comparisons.decorator.actionid.ActionIDRefresh;
import com.mathworks.comparisons.decorator.actionid.ActionIDSaveAs;
import com.mathworks.comparisons.decorator.actionid.ActionIDSwapSides;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHtmlComponent;
import com.mathworks.comparisons.decorator.htmlreport.HTMLActionManager;
import com.mathworks.comparisons.decorator.htmlreport.toolstrip.HtmlComparisonToolstripConfigurationContributor;
import com.mathworks.comparisons.decorator.impl.ComparisonHelpAction;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.report.ActionManager;
import com.mathworks.comparisons.report.ComparisonActionManager;
import com.mathworks.comparisons.report.toolstrip.ToolstripConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripConfigurationContributor;
import com.mathworks.comparisons.util.DebugUtils;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.shared.computils.confinement.ThreadCheck;
import com.mathworks.toolbox.shared.computils.confinement.predicates.OnlyEDT;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;

public class HTMLReportDecorator
implements ComparisonReportDecorator {
    private final ComparisonEventListener fEventListener;
    private final ActionManager fActionManager;
    private ToolstripConfigurationContributor fToolstripConfigurationContributor;
    private ComparisonHtmlComponent fHtmlComponent = null;

    public HTMLReportDecorator(ComparisonEventListener comparisonEventListener) {
        Validate.notNull((Object)comparisonEventListener);
        this.fEventListener = comparisonEventListener;
        this.fActionManager = new ComparisonActionManager();
    }

    @Override
    @ThreadCheck(access=OnlyEDT.class)
    public Component createCentralComponent() {
        this.fHtmlComponent = new ComparisonHtmlComponent();
        this.initializeActions();
        this.fHtmlComponent.setPopupMenuProvider(this.createPopupMenuProvider());
        this.fToolstripConfigurationContributor = new HtmlComparisonToolstripConfigurationContributor(this.fActionManager);
        Component component = this.fHtmlComponent.getComponent();
        component.setName("HtmlComponent");
        ((JComponent)component).putClientProperty("HtmlComponent", (Object)this.fHtmlComponent);
        return component;
    }

    @Override
    @Deprecated
    public MJToolBar decorate(MJToolBar mJToolBar) {
        return mJToolBar;
    }

    @Override
    @Deprecated
    public MJMenuBar decorate(MJMenuBar mJMenuBar) {
        return mJMenuBar;
    }

    @Override
    @ThreadCheck(access=OnlyEDT.class)
    public ToolstripConfiguration getToolstripConfiguration(ToolstripConfiguration toolstripConfiguration) {
        if (this.fToolstripConfigurationContributor == null) {
            throw new IllegalStateException("Must call createCentralComponent() first.");
        }
        this.fToolstripConfigurationContributor.contributeToConfiguration(toolstripConfiguration);
        return toolstripConfiguration;
    }

    @Override
    @ThreadCheck(access=OnlyEDT.class)
    public void disableControls() {
        this.setEnabled(false);
        this.fHtmlComponent.getComponent().setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    @ThreadCheck(access=OnlyEDT.class)
    public void enableControls() {
        this.setEnabled(true);
        this.fHtmlComponent.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public ActionManager getActionManager() {
        return this.fActionManager;
    }

    public ComparisonHtmlComponent getHTMLRenderer() {
        return this.fHtmlComponent;
    }

    public Component getHtmlRendererComponent() {
        return this.fHtmlComponent.getComponent();
    }

    public void reportError(String string) {
        Action action;
        ComparisonHtmlComponent comparisonHtmlComponent = this.getHTMLRenderer();
        if (comparisonHtmlComponent != null) {
            comparisonHtmlComponent.setHtmlText(string);
        }
        if ((action = this.fActionManager.getAction(ActionIDRefresh.getInstance().getName())) != null) {
            action.setEnabled(true);
        }
    }

    public void dispose() {
        if (this.fHtmlComponent != null) {
            this.fHtmlComponent.dispose();
            this.fHtmlComponent = null;
        }
    }

    protected void initializeActions() {
        this.fActionManager.addAction(ActionIDSaveAs.getInstance().getName(), HTMLActionManager.getSaveAs((HtmlComponent)this.fHtmlComponent));
        this.fActionManager.addAction(ActionIDRefresh.getInstance().getName(), HTMLActionManager.getRefresh(this.fEventListener));
        this.fActionManager.addAction(ActionIDSwapSides.getInstance().getName(), HTMLActionManager.getSwapSides(this.fEventListener));
        this.fActionManager.addAction(ActionIDFind.getInstance().getName(), HTMLActionManager.getFind((HtmlComponent)this.fHtmlComponent));
        this.fActionManager.addAction(ActionIDPrint.getInstance().getName(), HTMLActionManager.getPrint((HtmlComponent)this.fHtmlComponent));
        this.fActionManager.addAction(ActionIDCopy.getInstance().getName(), HTMLActionManager.getCopy((HtmlComponent)this.fHtmlComponent));
        this.fActionManager.addAction(ActionIDHelp.getInstance().getName(), (Action)((Object)new ComparisonHelpAction("matlab_env_filecomparison")));
        this.disableReloadAction();
    }

    protected PopupMenuProvider createPopupMenuProvider() {
        return new DefaultPopupMenuProvider();
    }

    private void disableReloadAction() {
        if (this.fHtmlComponent == null) {
            throw new IllegalStateException("HTML Component should not be null at this stage");
        }
        HtmlActions htmlActions = this.fHtmlComponent.getActions();
        if (htmlActions == null) {
            return;
        }
        Map map = htmlActions.getBasicActions();
        if (map == null) {
            return;
        }
        Action action = (Action)map.get(StandardHtmlActionId.RELOAD);
        if (action != null) {
            action.setEnabled(false);
        }
    }

    private void setEnabled(boolean bl) {
        for (Action action : this.fActionManager.getActions()) {
            action.setEnabled(bl);
        }
    }

    protected class DefaultPopupMenuProvider
    implements PopupMenuProvider {
        protected DefaultPopupMenuProvider() {
        }

        @Override
        public MJPopupMenu createPopupMenu() {
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.setName("PopupMenu");
            mJPopupMenu.add(HTMLReportDecorator.this.fActionManager.getAction(ActionIDSaveAs.getInstance().getName()));
            mJPopupMenu.addSeparator();
            mJPopupMenu.add(HTMLReportDecorator.this.fActionManager.getAction(ActionIDRefresh.getInstance().getName()));
            mJPopupMenu.add(HTMLReportDecorator.this.fActionManager.getAction(ActionIDSwapSides.getInstance().getName()));
            mJPopupMenu.addSeparator();
            final Action action = HTMLReportDecorator.this.fActionManager.getAction(ActionIDCopy.getInstance().getName());
            action.setEnabled(false);
            HTMLReportDecorator.this.fHtmlComponent.getSelectedText((HtmlDataListener)new HtmlDataListener<String>(){

                public void dataRetrieved(final String string) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            action.setEnabled(string != null && !string.isEmpty());
                        }
                    });
                }
            });
            mJPopupMenu.add(action);
            mJPopupMenu.add(HTMLReportDecorator.this.fActionManager.getAction(ActionIDPrint.getInstance().getName()));
            if (DebugUtils.hasDebugSetting(DebugUtils.DebugSetting.ALLOW_VIEW_SOURCE)) {
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(HTMLActionManager.getViewSource((HtmlComponent)HTMLReportDecorator.this.fHtmlComponent));
            }
            mJPopupMenu.setLightWeightPopupEnabled(false);
            return mJPopupMenu;
        }
    }
}

