/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport.toolstrip;

import com.mathworks.comparisons.decorator.actionid.ActionIDEditFilters;
import com.mathworks.comparisons.filter.ComparisonFilterStateProvider;
import com.mathworks.comparisons.report.ActionManager;
import com.mathworks.comparisons.report.toolstrip.FilterToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfigurationContributor;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class ListComparisonViewTabConfigurationContributor
implements ToolstripTabConfigurationContributor {
    private static final String RESOURCE_BUNDLE_NAME = "com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_List_Comparison_View_Toolstrip";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.comparisons.decorator.htmlreport.toolstrip.resources.RES_List_Comparison_View_Toolstrip");
    private final ActionManager fActionManager;
    private final ComparisonFilterStateProvider fFiltersProvider;
    private final ActionListener fFilterActionListener;

    public ListComparisonViewTabConfigurationContributor(ActionManager actionManager, ComparisonFilterStateProvider comparisonFilterStateProvider, ActionListener actionListener) {
        this.fActionManager = actionManager;
        this.fFiltersProvider = comparisonFilterStateProvider;
        this.fFilterActionListener = actionListener;
    }

    @Override
    public void contributeToConfiguration(ToolstripTabConfiguration toolstripTabConfiguration) {
        this.configureFilter(toolstripTabConfiguration);
    }

    private void configureFilter(ToolstripTabConfiguration toolstripTabConfiguration) {
        final TSToolSet tSToolSet = new FilterToolSetFactory(this.fFiltersProvider, this.fFilterActionListener, new TSToolSet.ListDecorator(){

            public void decorateList(PopupList popupList) {
                DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
                int n = ListComparisonViewTabConfigurationContributor.getIndexOfListItem(defaultListModel, "modes_group");
                if (n < 0) {
                    return;
                }
                int n2 = ListComparisonViewTabConfigurationContributor.getIndexOfListItem(defaultListModel, "filters_group");
                if (n2 < 0) {
                    return;
                }
                if (n - n2 != 1) {
                    ListItem listItem = (ListItem)defaultListModel.getElementAt(n - 1);
                    listItem.setAttribute((Attribute)ListItem.HAS_SEPARATOR, (Object)true);
                }
                defaultListModel.add(n, ListComparisonViewTabConfigurationContributor.this.createAddRemoveFilterListItem(popupList));
            }
        }).createToolSet();
        toolstripTabConfiguration.addToolSetFactory(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private ListItem createAddRemoveFilterListItem(PopupList popupList) {
        String string = ActionIDEditFilters.getInstance().getName();
        ListItem listItem = new ListItem(string);
        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)RESOURCE_BUNDLE.getString("List.item.add.filter"));
        listItem.setAttribute(TSFactory.ACTION_ATTRIBUTE, (Object)new EditFiltersChildAction(this.fActionManager.getAction(string), popupList));
        return listItem;
    }

    private static int getIndexOfListItem(ListModel listModel, String string) {
        for (int i = 0; i < listModel.getSize(); ++i) {
            ListItem listItem = (ListItem)listModel.getElementAt(i);
            if (!string.equals(listItem.getName())) continue;
            return i;
        }
        return -1;
    }

    private static class EditFiltersChildAction
    extends ChildAction {
        private final PopupList fList;

        protected EditFiltersChildAction(Action action, PopupList popupList) {
            super(action);
            this.fList = popupList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            this.disableMultiSelect();
        }

        private void disableMultiSelect() {
            OverlayManager overlayManager = OverlayManagers.get((Component)this.fList);
            if (overlayManager != null) {
                overlayManager.setAllowMultiSelect((Component)this.fList, false);
            }
        }
    }
}

