/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.gui.preferences;

import com.mathworks.comparisons.prefs.ColorProfile;
import com.mathworks.comparisons.prefs.ColorProfileBuilder;
import com.mathworks.comparisons.util.ColorManager;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.jmi.MatlabLanguage;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.prefs.ColorItem;
import com.mathworks.mlwidgets.prefs.SyntaxHighlightingColorPanel;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTable;
import com.mathworks.widgets.color.ColorPicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ColorsPanel
extends MJPanel {
    private static ColorsPanel sPrefsPanel = null;
    private static MJPanel sSampleTablePanel;
    private static final ResourceBundle RES_COLORS_PANEL;
    private static final ResourceBundle RES_COLOR_PROFILE_SERIALIZER;
    private static final String DEFAULT_PROFILE_NAME;
    private static final String DEFAULT_PROFILE_MODIFIED_NAME;
    private static final String LEFT_KEY;
    private static final String RIGHT_KEY;
    private static final String MODIFIED_LINE_KEY;
    private static final String MODIFIED_CONTENT_KEY;
    private static final String MERGED_KEY;
    private static final String MAIN_PANEL = "MainPanel";
    private static final String PICKERS_PANEL_NAME = "ColorPickersPanel";
    private static final String PROFILE_PANEL_NAME = "ProfilePanel";
    private static final String SAVEAS_BUTTON_NAME = "SaveAsButton";
    private static final String DELETE_BUTTON_NAME = "DeleteButton";
    private static final String RESET_BUTTON_NAME = "ResetButton";
    private static final String PROFILE_COMBOBOX_NAME = "ProfileComboBox";
    private static final String SAMPLE_TABLE_NAME = "SampleTable";
    private static final String SAMPLE_TABLE_PANEL_NAME = "SampleTablePanel";
    private static final String SAMPLE_PANEL_NAME = "SamplePanel";
    private static final String PROFILE_LABEL_NAME = "ProfileLabel";
    private static MJComboBox sComboBox;
    private static final MJButton RESET_BUTTON;
    private final MJButton fDeleteButton = new MJButton(ResourceManager.getString(RES_COLORS_PANEL, "button.delete"));
    private ColorItem<MJLabel> fLeftDifferenceColorItem;
    private ColorItem<MJLabel> fRightDifferenceColorItem;
    private ColorItem<MJLabel> fModifiedLineColorItem;
    private ColorItem<MJLabel> fModifiedContentColorItem;
    private ColorItem<MJLabel> fMergedColorItem;
    private static final ColorManager COLOR_MANAGER;
    private static ColorProfile sDefaultModifiedProfile;
    private static boolean sDefaultProfileReset;
    private static ColorProfile sCurrentProfile;

    public ColorsPanel() {
        sCurrentProfile = COLOR_MANAGER.getInitialProfile();
        sDefaultProfileReset = false;
        Component component = this.createPickersPanel();
        Component component2 = ColorsPanel.createSamplePanel();
        Component component3 = this.createProfilePanel();
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        this.add(component);
        this.add(component2);
        this.add(component3);
        this.setName(MAIN_PANEL);
    }

    public static MJPanel createPrefsPanel() {
        sPrefsPanel = new ColorsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            if (sCurrentProfile.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME) && !ColorsPanel.isProfileSaved(DEFAULT_PROFILE_MODIFIED_NAME)) {
                COLOR_MANAGER.removeProfileByName(DEFAULT_PROFILE_NAME);
            }
            COLOR_MANAGER.saveProfile(sCurrentProfile);
            COLOR_MANAGER.setLastChosenProfileName(sCurrentProfile.getName());
            COLOR_MANAGER.updateCurrentProfile(sCurrentProfile);
            if (!sCurrentProfile.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME)) {
                RESET_BUTTON.setEnabled(false);
            }
        } else if (!bl && sDefaultProfileReset) {
            ColorsPanel.swapLastChosenIfNeededTo(DEFAULT_PROFILE_MODIFIED_NAME);
            COLOR_MANAGER.saveProfile(sDefaultModifiedProfile);
            COLOR_MANAGER.removeProfileByName(DEFAULT_PROFILE_NAME);
        }
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_comparison_color_prefs"};
    }

    private Component createPickersPanel() {
        SyntaxHighlightingColorPanel syntaxHighlightingColorPanel = new SyntaxHighlightingColorPanel(null);
        this.fLeftDifferenceColorItem = syntaxHighlightingColorPanel.addLabelItem(ResourceManager.getString(RES_COLORS_PANEL, "label.left.side"), LEFT_KEY, sCurrentProfile.getLeftDifferenceColor(), (ActionListener)new ColorPickerActionListener(LEFT_KEY));
        this.fRightDifferenceColorItem = syntaxHighlightingColorPanel.addLabelItem(ResourceManager.getString(RES_COLORS_PANEL, "label.right.side"), RIGHT_KEY, sCurrentProfile.getRightDifferenceColor(), (ActionListener)new ColorPickerActionListener(RIGHT_KEY));
        this.fModifiedLineColorItem = syntaxHighlightingColorPanel.addLabelItem(ResourceManager.getString(RES_COLORS_PANEL, "label.modified.line"), MODIFIED_LINE_KEY, sCurrentProfile.getModifiedLineColor(), (ActionListener)new ColorPickerActionListener(MODIFIED_LINE_KEY));
        this.fModifiedContentColorItem = syntaxHighlightingColorPanel.addLabelItem(ResourceManager.getString(RES_COLORS_PANEL, "label.modified.content"), MODIFIED_CONTENT_KEY, sCurrentProfile.getModifiedContentColor(), (ActionListener)new ColorPickerActionListener(MODIFIED_CONTENT_KEY));
        this.fMergedColorItem = syntaxHighlightingColorPanel.addLabelItem(ResourceManager.getString(RES_COLORS_PANEL, "label.merged.line"), MERGED_KEY, sCurrentProfile.getMergedColor(), (ActionListener)new ColorPickerActionListener(MERGED_KEY));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setName(PICKERS_PANEL_NAME);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceManager.getString(RES_COLORS_PANEL, "bordertitle.colors"));
        mJPanel.setBorder((Border)titledBorder);
        mJPanel.add((Component)syntaxHighlightingColorPanel, (Object)"Center");
        return mJPanel;
    }

    private static Component createSamplePanel() {
        sSampleTablePanel = new MJPanel((LayoutManager)new BorderLayout());
        sSampleTablePanel.setName(SAMPLE_TABLE_PANEL_NAME);
        SamplePanel samplePanel = new SamplePanel();
        sSampleTablePanel.add((Component)((Object)samplePanel), (Object)"Center");
        MJPanel mJPanel = new MJPanel();
        mJPanel.setName(SAMPLE_PANEL_NAME);
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(ResourceManager.getString(RES_COLORS_PANEL, "bordertitle.sample")));
        mJPanel.setLayout((LayoutManager)new MGridLayout(1, 0, 4, 4, 131072));
        mJPanel.add((Component)sSampleTablePanel);
        return mJPanel;
    }

    private Component createProfilePanel() {
        MJPanel mJPanel = new MJPanel();
        mJPanel.setName(PROFILE_PANEL_NAME);
        mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        MJLabel mJLabel = new MJLabel(ResourceManager.getString(RES_COLORS_PANEL, "bordertitle.profile"));
        mJLabel.setName(PROFILE_LABEL_NAME);
        sComboBox = new MJComboBox();
        sComboBox.setName(PROFILE_COMBOBOX_NAME);
        sComboBox.setPreferredSize(new Dimension(100, 20));
        sComboBox.getAccessibleContext().setAccessibleName("Profiles");
        sComboBox.addActionListener((ActionListener)new ComboActionListener());
        RESET_BUTTON.setName(RESET_BUTTON_NAME);
        MJButton mJButton = new MJButton(ResourceManager.getString(RES_COLORS_PANEL, "button.saveas"));
        mJButton.setName(SAVEAS_BUTTON_NAME);
        this.fDeleteButton.setName(DELETE_BUTTON_NAME);
        RESET_BUTTON.addActionListener((ActionListener)new ResetButtonActionListener());
        mJButton.addActionListener((ActionListener)new SaveAsButtonActionListener());
        this.fDeleteButton.addActionListener((ActionListener)new DeleteButtonActionListener());
        List<String> list = COLOR_MANAGER.getProfileNames();
        for (String string : list) {
            sComboBox.addItem((Object)new ComboBoxItem(COLOR_MANAGER.getProfileByName(string)));
        }
        sCurrentProfile = COLOR_MANAGER.getLastChosenProfile();
        ComboBoxItem comboBoxItem = ColorsPanel.getComboBoxItemByName(sCurrentProfile.getName());
        if (comboBoxItem != null) {
            sComboBox.setSelectedItem((Object)comboBoxItem);
        }
        mJPanel.add((Component)mJLabel);
        mJPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        mJPanel.add((Component)sComboBox);
        mJPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        mJPanel.add((Component)mJButton);
        mJPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        mJPanel.add((Component)this.fDeleteButton);
        mJPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        mJPanel.add((Component)RESET_BUTTON);
        return mJPanel;
    }

    private void updateColorPickerColors() {
        this.fLeftDifferenceColorItem.getColorPicker().setValue((Object)sCurrentProfile.getLeftDifferenceColor());
        this.fRightDifferenceColorItem.getColorPicker().setValue((Object)sCurrentProfile.getRightDifferenceColor());
        this.fModifiedLineColorItem.getColorPicker().setValue((Object)sCurrentProfile.getModifiedLineColor());
        this.fModifiedContentColorItem.getColorPicker().setValue((Object)sCurrentProfile.getModifiedContentColor());
        this.fMergedColorItem.getColorPicker().setValue((Object)sCurrentProfile.getMergedColor());
    }

    private static ComboBoxItem getComboBoxItemByName(String string) {
        for (int i = 0; i < sComboBox.getItemCount(); ++i) {
            ComboBoxItem comboBoxItem = (ComboBoxItem)sComboBox.getItemAt(i);
            if (!string.equals(comboBoxItem.getName())) continue;
            return comboBoxItem;
        }
        return null;
    }

    private static void swapLastChosenIfNeededTo(String string) {
        String string2 = null;
        if (string.equals(DEFAULT_PROFILE_NAME)) {
            string2 = DEFAULT_PROFILE_MODIFIED_NAME;
        } else if (string.equals(DEFAULT_PROFILE_MODIFIED_NAME)) {
            string2 = DEFAULT_PROFILE_NAME;
        }
        if (COLOR_MANAGER.getLastChosenProfile().getName().equals(string2)) {
            COLOR_MANAGER.setLastChosenProfileName(string);
        }
    }

    private static boolean isProfileSaved(String string) {
        return COLOR_MANAGER.getProfileNames().contains(string);
    }

    private static String createHTMLColor(Color color, String string) {
        return "<FONT style=\"BACKGROUND-COLOR:" + String.format("%02x", color.getRed()) + String.format("%02x", color.getGreen()) + String.format("%02x", color.getBlue()) + "\">" + string;
    }

    static {
        RES_COLORS_PANEL = ResourceBundle.getBundle("com.mathworks.comparisons.gui.resources.RES_ColorsPanel");
        RES_COLOR_PROFILE_SERIALIZER = ResourceBundle.getBundle("com.mathworks.comparisons.prefs.resources.RES_ColorProfileSerializer");
        DEFAULT_PROFILE_NAME = ResourceManager.getString(RES_COLOR_PROFILE_SERIALIZER, "message.default.settings");
        DEFAULT_PROFILE_MODIFIED_NAME = ResourceManager.getString(RES_COLOR_PROFILE_SERIALIZER, "message.default.settings.modified");
        LEFT_KEY = ResourceManager.getString(RES_COLORS_PANEL, "key.left");
        RIGHT_KEY = ResourceManager.getString(RES_COLORS_PANEL, "key.right");
        MODIFIED_LINE_KEY = ResourceManager.getString(RES_COLORS_PANEL, "key.modifiedline");
        MODIFIED_CONTENT_KEY = ResourceManager.getString(RES_COLORS_PANEL, "key.modifiedcontent");
        MERGED_KEY = ResourceManager.getString(RES_COLORS_PANEL, "key.merge");
        RESET_BUTTON = new MJButton(ResourceManager.getString(RES_COLORS_PANEL, "button.reset"));
        COLOR_MANAGER = ColorManager.getInstance();
        sDefaultProfileReset = false;
        sCurrentProfile = null;
    }

    private static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            MJLabel mJLabel = (MJLabel)object;
            if (n == 0 && n2 == 1) {
                this.setText("<html>sum = " + ColorsPanel.createHTMLColor(sCurrentProfile.getModifiedContentColor(), "100</FONT>;"));
            } else if (n == 0 && n2 == 3) {
                this.setText("<html>sum = " + ColorsPanel.createHTMLColor(sCurrentProfile.getModifiedContentColor(), "200</FONT>;"));
            } else {
                this.setText(mJLabel.getText());
            }
            if (n == 0 && (n2 == 1 || n2 == 2 || n2 == 3)) {
                this.setBackground(sCurrentProfile.getModifiedLineColor());
            } else if (n == 2 && (n2 == 1 || n2 == 2)) {
                this.setBackground(sCurrentProfile.getLeftDifferenceColor());
            } else if (n == 5 && (n2 == 1 || n2 == 2 || n2 == 3)) {
                this.setBackground(sCurrentProfile.getMergedColor());
            } else if (n == 6 && (n2 == 2 || n2 == 3)) {
                this.setBackground(sCurrentProfile.getRightDifferenceColor());
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private final MJLabel[] fRow0 = new MJLabel[]{new MJLabel(" 1"), new MJLabel("<html>sum = " + ColorsPanel.access$2900(ColorsPanel.access$200().getModifiedContentColor(), "100</FONT>;") + "</html>"), new MJLabel(" x"), new MJLabel("<html>sum = " + ColorsPanel.access$2900(ColorsPanel.access$200().getModifiedContentColor(), "200</FONT>;") + "</html>"), new MJLabel(" 1")};
        private final MJLabel[] fRow1 = new MJLabel[]{new MJLabel(" 2"), new MJLabel("for i = 1:10"), new MJLabel(" ."), new MJLabel("for i = 1:10"), new MJLabel(" 2")};
        private final MJLabel[] fRow2 = new MJLabel[]{new MJLabel(" 3"), new MJLabel("    disp(num2str(sum))"), new MJLabel(" <"), new MJLabel(" "), new MJLabel(" -")};
        private final MJLabel[] fRow3 = new MJLabel[]{new MJLabel(" 4"), new MJLabel("    sum = sum + i;"), new MJLabel(" ."), new MJLabel("    sum = sum + i;"), new MJLabel(" 3")};
        private final MJLabel[] fRow4 = new MJLabel[]{new MJLabel(" 5"), new MJLabel("end"), new MJLabel(" ."), new MJLabel("end"), new MJLabel(" 4")};
        private final MJLabel[] fRow5 = new MJLabel[]{new MJLabel(" 6"), new MJLabel("result = sum/i;"), new MJLabel(" ."), new MJLabel("result = sum/i;"), new MJLabel(" 5")};
        private final MJLabel[] fRow6 = new MJLabel[]{new MJLabel(" -"), new MJLabel(" "), new MJLabel(" >"), new MJLabel("disp(num2str(result))"), new MJLabel(" 6")};
        private final String[] fColumnNames = new String[]{"First", "Second", "Third", "Fourth", "Fifth"};
        private final MJLabel[][] fData = new MJLabel[][]{this.fRow0, this.fRow1, this.fRow2, this.fRow3, this.fRow4, this.fRow5, this.fRow6};

        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.fColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.fData.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.fData[n][n2];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.fData[n][n2] = (MJLabel)object;
            this.fireTableCellUpdated(n, n2);
        }
    }

    private static class SamplePanel
    extends MJPanel {
        private final MJTable fTable = new MJTable((TableModel)new MyTableModel());

        SamplePanel() {
            super((LayoutManager)new BorderLayout());
            this.fTable.setName(ColorsPanel.SAMPLE_TABLE_NAME);
            this.fTable.setShowGrid(false);
            this.add((Component)this.fTable, "Center");
            this.fTable.setDefaultRenderer(MJLabel.class, (TableCellRenderer)new ColorRenderer());
            this.fTable.getColumnModel().getColumn(0).setMaxWidth(10);
            this.fTable.getColumnModel().getColumn(2).setMaxWidth(10);
            this.fTable.getColumnModel().getColumn(4).setMaxWidth(10);
        }
    }

    private class ColorPickerActionListener
    implements ActionListener {
        private final String fPrefKey;

        private ColorPickerActionListener(String string) {
            this.fPrefKey = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPicker colorPicker = (ColorPicker)actionEvent.getSource();
            Color color = (Color)colorPicker.getValue();
            Color color2 = this.fPrefKey.equals(LEFT_KEY) ? color : sCurrentProfile.getLeftDifferenceColor();
            Color color3 = this.fPrefKey.equals(RIGHT_KEY) ? color : sCurrentProfile.getRightDifferenceColor();
            Color color4 = this.fPrefKey.equals(MODIFIED_LINE_KEY) ? color : sCurrentProfile.getModifiedLineColor();
            Color color5 = this.fPrefKey.equals(MODIFIED_CONTENT_KEY) ? color : sCurrentProfile.getModifiedContentColor();
            Color color6 = this.fPrefKey.equals(MERGED_KEY) ? color : sCurrentProfile.getMergedColor();
            Map<String, Color> map = sCurrentProfile.getColorsMap();
            sCurrentProfile.setLeftDifferenceColor(color2);
            sCurrentProfile.setRightDifferenceColor(color3);
            sCurrentProfile.setModifiedLineColor(color4);
            sCurrentProfile.setModifiedContentColor(color5);
            sCurrentProfile.setMergedColor(color6);
            if (!map.equals(sCurrentProfile.getColorsMap())) {
                RESET_BUTTON.setEnabled(true);
                if (sCurrentProfile.getName().equals(DEFAULT_PROFILE_NAME)) {
                    sCurrentProfile = new ColorProfile(new ColorProfileBuilder(DEFAULT_PROFILE_MODIFIED_NAME, sCurrentProfile.getColorsMap()));
                    ComboBoxItem comboBoxItem = ColorsPanel.getComboBoxItemByName(DEFAULT_PROFILE_NAME);
                    comboBoxItem.setName(DEFAULT_PROFILE_MODIFIED_NAME);
                    ColorsPanel.this.fDeleteButton.setEnabled(false);
                }
            }
        }
    }

    private class ComboActionListener
    implements ActionListener {
        private ComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJComboBox mJComboBox = (MJComboBox)actionEvent.getSource();
            String string = mJComboBox.getSelectedItem().toString();
            ColorProfile colorProfile = sCurrentProfile.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME) && !ColorsPanel.isProfileSaved(DEFAULT_PROFILE_MODIFIED_NAME) ? COLOR_MANAGER.getDefaultProfile() : COLOR_MANAGER.getProfileByName(sCurrentProfile.getName());
            if (!colorProfile.getColorsMap().equals(sCurrentProfile.getColorsMap())) {
                String string2 = ResourceManager.getString(RES_COLORS_PANEL, "message.save", sCurrentProfile.getName());
                int n = JOptionPane.showConfirmDialog((Component)sSampleTablePanel, string2, ResourceManager.getString(RES_COLORS_PANEL, "save.as.dialog.title"), 1);
                if (n == 0) {
                    COLOR_MANAGER.saveProfile(sCurrentProfile);
                    if (sCurrentProfile.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME) && ColorsPanel.isProfileSaved(DEFAULT_PROFILE_NAME)) {
                        ColorsPanel.swapLastChosenIfNeededTo(DEFAULT_PROFILE_MODIFIED_NAME);
                        COLOR_MANAGER.removeProfileByName(DEFAULT_PROFILE_NAME);
                    }
                } else if (n == 1) {
                    if (sCurrentProfile.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME) && !ColorsPanel.isProfileSaved(DEFAULT_PROFILE_MODIFIED_NAME)) {
                        ComboBoxItem comboBoxItem = ColorsPanel.getComboBoxItemByName(DEFAULT_PROFILE_MODIFIED_NAME);
                        comboBoxItem.setName(DEFAULT_PROFILE_NAME);
                    }
                } else if (n == 2) {
                    ComboBoxItem comboBoxItem = ColorsPanel.getComboBoxItemByName(sCurrentProfile.getName());
                    sComboBox.setSelectedItem((Object)comboBoxItem);
                    return;
                }
            }
            if (string.equals(DEFAULT_PROFILE_NAME)) {
                ColorsPanel.this.fDeleteButton.setEnabled(false);
                RESET_BUTTON.setEnabled(false);
            } else if (string.equals(DEFAULT_PROFILE_MODIFIED_NAME)) {
                ColorsPanel.this.fDeleteButton.setEnabled(false);
                RESET_BUTTON.setEnabled(true);
            } else {
                ColorsPanel.this.fDeleteButton.setEnabled(true);
                RESET_BUTTON.setEnabled(false);
            }
            sCurrentProfile = COLOR_MANAGER.getProfileByName(string);
            ColorsPanel.this.updateColorPickerColors();
        }
    }

    private static class ComboBoxItem {
        private String fProfileName;

        private ComboBoxItem(ColorProfile colorProfile) {
            this.fProfileName = colorProfile.getName();
        }

        public String toString() {
            return this.fProfileName;
        }

        public String getName() {
            return this.fProfileName;
        }

        public void setName(String string) {
            this.fProfileName = string;
        }
    }

    private class DeleteButtonActionListener
    implements ActionListener {
        private DeleteButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ComboBoxItem comboBoxItem = ColorsPanel.getComboBoxItemByName(sCurrentProfile.getName());
            if (comboBoxItem != null) {
                ActionListener[] actionListenerArray = sComboBox.getActionListeners();
                for (ActionListener actionListener : actionListenerArray) {
                    sComboBox.removeActionListener(actionListener);
                }
                sComboBox.removeItem((Object)comboBoxItem);
                COLOR_MANAGER.removeProfileByName(sCurrentProfile.getName());
                ComboBoxItem comboBoxItem2 = ColorsPanel.getComboBoxItemByName(DEFAULT_PROFILE_NAME) != null ? ColorsPanel.getComboBoxItemByName(DEFAULT_PROFILE_NAME) : ColorsPanel.getComboBoxItemByName(DEFAULT_PROFILE_MODIFIED_NAME);
                sComboBox.setSelectedItem((Object)comboBoxItem2);
                sCurrentProfile = COLOR_MANAGER.getProfileByName(comboBoxItem2.getName());
                COLOR_MANAGER.setLastChosenProfileName(comboBoxItem2.getName());
                ColorsPanel.this.updateColorPickerColors();
                if (comboBoxItem2.getName().equals(DEFAULT_PROFILE_NAME)) {
                    ColorsPanel.this.fDeleteButton.setEnabled(false);
                    RESET_BUTTON.setEnabled(false);
                } else if (comboBoxItem2.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME)) {
                    ColorsPanel.this.fDeleteButton.setEnabled(false);
                    RESET_BUTTON.setEnabled(true);
                }
                for (ActionListener actionListener : actionListenerArray) {
                    sComboBox.addActionListener(actionListener);
                }
            }
        }
    }

    private static class SaveAsButtonActionListener
    implements ActionListener {
        private SaveAsButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ComboBoxItem comboBoxItem;
            boolean bl;
            boolean bl2;
            boolean bl3;
            String string;
            String string2 = ResourceManager.getString(RES_COLORS_PANEL, "message.enter");
            int n = -1;
            do {
                if ((string = JOptionPane.showInputDialog((Component)((Object)sPrefsPanel), string2, ResourceManager.getString(RES_COLORS_PANEL, "save.as.dialog.title"), n)) == null) {
                    return;
                }
                bl3 = false;
                for (int i = 0; i < sComboBox.getItemCount(); ++i) {
                    comboBoxItem = (ComboBoxItem)sComboBox.getItemAt(i);
                    if (!string.equals(comboBoxItem.getName())) continue;
                    bl3 = true;
                }
                bl2 = false;
                if (string.equals(DEFAULT_PROFILE_NAME)) {
                    bl2 = true;
                }
                bl = true;
                if (string.isEmpty() || !MatlabLanguage.isValidVariableName((String)string)) {
                    bl = false;
                }
                if (!bl) {
                    string2 = ResourceManager.getString(RES_COLORS_PANEL, "message.valid", string);
                } else if (bl2) {
                    string2 = ResourceManager.getString(RES_COLORS_PANEL, "message.default");
                } else if (bl3) {
                    string2 = ResourceManager.getString(RES_COLORS_PANEL, "message.exist", string);
                }
                n = 2;
            } while (string.isEmpty() || bl3 || bl2 || !bl);
            if (sCurrentProfile.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME)) {
                ComboBoxItem comboBoxItem2 = ColorsPanel.getComboBoxItemByName(DEFAULT_PROFILE_MODIFIED_NAME);
                comboBoxItem2.setName(DEFAULT_PROFILE_NAME);
                if (!ColorsPanel.isProfileSaved(DEFAULT_PROFILE_NAME)) {
                    ColorsPanel.swapLastChosenIfNeededTo(DEFAULT_PROFILE_NAME);
                    COLOR_MANAGER.removeProfileByName(DEFAULT_PROFILE_MODIFIED_NAME);
                    COLOR_MANAGER.saveProfile(COLOR_MANAGER.getDefaultProfile());
                }
            }
            ColorProfile colorProfile = new ColorProfile(new ColorProfileBuilder(string, sCurrentProfile.getColorsMap()));
            COLOR_MANAGER.saveProfile(colorProfile);
            sCurrentProfile = colorProfile;
            comboBoxItem = new ComboBoxItem(colorProfile);
            sComboBox.addItem((Object)comboBoxItem);
            sComboBox.setSelectedItem((Object)comboBoxItem);
        }
    }

    private class ResetButtonActionListener
    implements ActionListener {
        private ResetButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (sCurrentProfile.getName().equals(DEFAULT_PROFILE_MODIFIED_NAME)) {
                if (ColorsPanel.isProfileSaved(DEFAULT_PROFILE_MODIFIED_NAME)) {
                    ColorsPanel.swapLastChosenIfNeededTo(DEFAULT_PROFILE_NAME);
                    COLOR_MANAGER.removeProfileByName(DEFAULT_PROFILE_MODIFIED_NAME);
                    sDefaultModifiedProfile = sCurrentProfile;
                    sDefaultProfileReset = true;
                }
                ColorProfile colorProfile = COLOR_MANAGER.getDefaultProfile();
                sCurrentProfile = colorProfile;
                COLOR_MANAGER.saveProfile(colorProfile);
                ComboBoxItem comboBoxItem = ColorsPanel.getComboBoxItemByName(DEFAULT_PROFILE_MODIFIED_NAME);
                comboBoxItem.setName(DEFAULT_PROFILE_NAME);
            } else {
                sCurrentProfile = COLOR_MANAGER.getProfileByName(sCurrentProfile.getName());
            }
            RESET_BUTTON.setEnabled(false);
            ColorsPanel.this.updateColorPickerColors();
        }
    }
}

