/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.prefs;

import com.mathworks.comparisons.prefs.ColorProfile;
import com.mathworks.comparisons.prefs.ColorProfileBuilder;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingNameDuplicationException;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import com.mathworks.util.FileUtils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;

public class ColorProfileSerializer {
    public static final String COMPARISONS_SETTINGS_PATH = FileUtils.getPreferencesDirectory() + File.separator + "comparisons.settings";
    public static final String COMPARISONS_SETTINGS_PATH_CORRUPTED = COMPARISONS_SETTINGS_PATH + ".corrupted";
    private static final Map<String, Color> DEFAULT_COLORS = new HashMap<String, Color>(){
        {
            this.put("LeftDifferenceColor", new Color(221, 255, 221));
            this.put("RightDifferenceColor", new Color(221, 255, 221));
            this.put("ModifiedLineColor", new Color(255, 221, 221));
            this.put("ModifiedContentColor", new Color(255, 180, 180));
            this.put("MergedColor", new Color(192, 192, 192));
        }
    };
    private static final ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.comparisons.prefs.resources.RES_ColorProfileSerializer");
    private static final String currentProfileSettingsName = "currentProfile";
    private static final MVM MATLAB_VM = MvmContext.get();
    private static final SettingPath SETTINGS_ROOT = new SettingPath(MATLAB_VM);

    private ColorProfileSerializer() {
    }

    public static ColorProfile getProfileByName(String string) {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        try {
            SettingPath settingPath = ColorProfileSerializer.getProfileSettingPath(string);
            for (String string2 : DEFAULT_COLORS.keySet()) {
                Setting setting = new Setting(settingPath, Color.class, string2);
                hashMap.put(string2, (Color)setting.get());
            }
        }
        catch (SettingNotFoundException | SettingTypeException throwable) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
            return ColorProfileSerializer.getDefaultProfile();
        }
        return new ColorProfile(new ColorProfileBuilder(string, hashMap));
    }

    public static void saveProfile(ColorProfile colorProfile) {
        try {
            if (ColorProfileSerializer.doesProfileExist(colorProfile)) {
                ColorProfileSerializer.saveExistingProfile(colorProfile);
            } else {
                ColorProfileSerializer.saveNewProfile(colorProfile);
            }
        }
        catch (SettingNotFoundException | SettingTypeException throwable) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
        }
    }

    private static void saveExistingProfile(ColorProfile colorProfile) {
        try {
            SettingPath settingPath = ColorProfileSerializer.getProfileSettingPath(colorProfile.getName());
            for (String string : DEFAULT_COLORS.keySet()) {
                Setting setting = new Setting(settingPath, Color.class, string);
                setting.set((Object)colorProfile.getColorsMap().get(string));
            }
        }
        catch (SettingAccessException | SettingNotFoundException | SettingTypeException | SettingValidationException throwable) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
        }
    }

    private static void saveNewProfile(ColorProfile colorProfile) {
        try {
            SettingPath settingPath = ColorProfileSerializer.getComparisonsColorsPath();
            settingPath = settingPath.addNode(UUID.randomUUID().toString());
            settingPath.addSetting("profileName", (Object)colorProfile.getName());
            for (String string : DEFAULT_COLORS.keySet()) {
                settingPath.addSetting(string, (Object)colorProfile.getColorsMap().get(string));
            }
        }
        catch (SettingAccessException | SettingNameDuplicationException | SettingNotFoundException | SettingValidationException throwable) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
        }
    }

    public static void removeProfileByName(String string) {
        try {
            SettingPath settingPath = ColorProfileSerializer.getProfileSettingPath(string);
            settingPath.delete();
        }
        catch (SettingAccessException | SettingNotFoundException | SettingTypeException throwable) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
        }
    }

    public static List<String> getProfileNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (String string : ColorProfileSerializer.getAllProfileIDs()) {
                SettingPath settingPath = new SettingPath(SETTINGS_ROOT, new String[]{"comparisons", "colors", string});
                Setting setting = new Setting(settingPath, String.class, "profileName");
                arrayList.add((String)setting.get());
            }
        }
        catch (SettingNotFoundException | SettingTypeException throwable) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
            arrayList.add(ColorProfileSerializer.getDefaultProfile().getName());
        }
        return arrayList;
    }

    public static ColorProfile getLastChosenProfile() {
        String string;
        try {
            SettingPath settingPath = ColorProfileSerializer.getCurrentProfilePath();
            Setting setting = new Setting(settingPath, String.class, "lastChosen");
            string = (String)setting.get();
        }
        catch (Exception exception) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
            return ColorProfileSerializer.getDefaultProfile();
        }
        return ColorProfileSerializer.getProfileByName(string);
    }

    public static void setLastChosenProfileName(String string) {
        try {
            SettingPath settingPath = ColorProfileSerializer.getCurrentProfilePath();
            Setting setting = new Setting(settingPath, String.class, "lastChosen");
            setting.set((Object)string);
        }
        catch (SettingAccessException | SettingNotFoundException | SettingTypeException | SettingValidationException throwable) {
            ColorProfileSerializer.checkIfSettingsFileMissingOrCorrupted();
        }
    }

    private static void checkIfSettingsFileMissingOrCorrupted() {
        if (ColorProfileSerializer.doesSettingsFileExist()) {
            if (ColorProfileSerializer.replaceSettingsFile()) {
                System.out.println(ResourceManager.getString(RES, "message.corrupted.settings.file"));
            }
        } else if (ColorProfileSerializer.createNewSettingsFile()) {
            System.out.println(ResourceManager.getString(RES, "message.missing.settings.file"));
        }
    }

    public static boolean doesSettingsFileExist() {
        File file = new File(COMPARISONS_SETTINGS_PATH);
        return file.exists();
    }

    public static boolean createNewSettingsFile() {
        try {
            ColorProfileSerializer.deleteComparisonsNode();
            SettingPath settingPath = new SettingPath(SETTINGS_ROOT, new String[0]);
            settingPath = settingPath.addNode("comparisons");
            settingPath = settingPath.addNode("colors");
            ColorProfileSerializer.saveProfile(ColorProfileSerializer.getDefaultProfile());
            settingPath = settingPath.addNode(currentProfileSettingsName);
            settingPath.addSetting("lastChosen", (Object)ColorProfileSerializer.getDefaultProfile().getName());
            return true;
        }
        catch (SettingAccessException | SettingNameDuplicationException | SettingNotFoundException | SettingValidationException throwable) {
            System.out.println(ResourceManager.getString(RES, "message.failed"));
            return false;
        }
    }

    private static boolean replaceSettingsFile() {
        try {
            File file;
            File file2 = new File(COMPARISONS_SETTINGS_PATH_CORRUPTED);
            if (file2.exists()) {
                int n = 1;
                do {
                    file2 = new File(COMPARISONS_SETTINGS_PATH_CORRUPTED + "_" + n);
                    ++n;
                } while (file2.exists());
            }
            if ((file = new File(COMPARISONS_SETTINGS_PATH)).renameTo(file2)) {
                return ColorProfileSerializer.createNewSettingsFile();
            }
            System.out.println(ResourceManager.getString(RES, "message.failed"));
            return false;
        }
        catch (Exception exception) {
            System.out.println(ResourceManager.getString(RES, "message.failed"));
            return false;
        }
    }

    public static void deleteComparisonsNode() {
        try {
            SettingPath settingPath = new SettingPath(SETTINGS_ROOT, new String[0]);
            if (settingPath.isChildNode("comparisons")) {
                settingPath = new SettingPath(SETTINGS_ROOT, new String[]{"comparisons"});
                settingPath.delete();
            }
        }
        catch (SettingAccessException | SettingNotFoundException throwable) {
            // empty catch block
        }
    }

    public static ColorProfile getDefaultProfile() {
        return new ColorProfile(new ColorProfileBuilder(ResourceManager.getString(RES, "message.default.settings"), DEFAULT_COLORS));
    }

    private static SettingPath getComparisonsColorsPath() throws SettingNotFoundException {
        return new SettingPath(SETTINGS_ROOT, new String[]{"comparisons", "colors"});
    }

    private static SettingPath getCurrentProfilePath() throws SettingNotFoundException {
        return new SettingPath(SETTINGS_ROOT, new String[]{"comparisons", "colors", currentProfileSettingsName});
    }

    private static List<String> getAllProfileIDs() throws SettingNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        SettingPath settingPath = ColorProfileSerializer.getComparisonsColorsPath();
        for (String string : settingPath.getChildNames()) {
            if (string.equals(currentProfileSettingsName)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static boolean doesProfileExist(ColorProfile colorProfile) throws SettingNotFoundException, SettingTypeException {
        return ColorProfileSerializer.getProfileSettingPath(colorProfile.getName()) != null;
    }

    private static SettingPath getProfileSettingPath(String string) throws SettingNotFoundException, SettingTypeException {
        for (String string2 : ColorProfileSerializer.getAllProfileIDs()) {
            SettingPath settingPath = new SettingPath(SETTINGS_ROOT, new String[]{"comparisons", "colors", string2});
            Setting setting = new Setting(settingPath, String.class, "profileName");
            if (!((String)setting.get()).equals(string)) continue;
            return settingPath;
        }
        return null;
    }
}

