/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourceProperty;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.ComparisonSourceType;
import com.mathworks.comparisons.source.impl.ComparisonSourceListener;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.util.AbstractPropertyValueGetter;
import com.mathworks.comparisons.util.ResourceManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.Validate;

public abstract class ComparisonSourceImpl
implements ComparisonSource {
    private final ComparisonSourceType fType;
    private final AbstractPropertyValueGetter<ComparisonSource, ComparisonSourceProperty, ComparisonSourcePropertyInfo<?>> fPropertyGetter;
    private final Collection<ComparisonSourceListener> fListeners = new CopyOnWriteArrayList<ComparisonSourceListener>();

    protected ComparisonSourceImpl(ComparisonSourceType comparisonSourceType) {
        Validate.notNull((Object)comparisonSourceType);
        this.fType = comparisonSourceType;
        this.fPropertyGetter = new AbstractPropertyValueGetter();
    }

    @Override
    public void addListener(ComparisonSourceListener comparisonSourceListener) {
        Validate.notNull((Object)comparisonSourceListener);
        this.fListeners.add(comparisonSourceListener);
    }

    @Override
    public void removeListener(ComparisonSourceListener comparisonSourceListener) {
        this.fListeners.remove(comparisonSourceListener);
    }

    public void dispose() {
        this.fListeners.clear();
    }

    public Object getPropertyValue(ComparisonSourceProperty comparisonSourceProperty, ComparisonSourcePropertyInfo ... comparisonSourcePropertyInfoArray) {
        this.throwExceptionIfSourceDoesNotHaveProperty(comparisonSourceProperty);
        return this.fPropertyGetter.get(this, comparisonSourceProperty, comparisonSourcePropertyInfoArray);
    }

    @Override
    public boolean hasProperty(ComparisonSourceProperty comparisonSourceProperty) {
        return this.fType.hasProperty(comparisonSourceProperty);
    }

    @Override
    public boolean hasProperties(List<ComparisonSourceProperty> list) {
        return this.fType.hasProperties(list);
    }

    @Override
    public List<ComparisonSourceProperty> getProperties() {
        return this.fType.getProperties();
    }

    @Override
    public boolean isOutOfSync() {
        return false;
    }

    @Override
    public void sync() {
    }

    public String toString() {
        return this.hasProperty(CSPropertyName.getInstance()) ? (String)this.getPropertyValue(CSPropertyName.getInstance(), new ComparisonSourcePropertyInfo[0]) : super.toString();
    }

    protected Object getLocalPropertyValue(ComparisonSource comparisonSource, ComparisonSourceProperty comparisonSourceProperty, ComparisonSourcePropertyInfo ... comparisonSourcePropertyInfoArray) {
        this.throwExceptionIfSourceDoesNotHaveProperty(comparisonSourceProperty);
        return this.fPropertyGetter.get(comparisonSource, comparisonSourceProperty, comparisonSourcePropertyInfoArray);
    }

    protected void throwExceptionIfSourceDoesNotHaveProperty(ComparisonSourceProperty comparisonSourceProperty) {
        if (!this.hasProperty(comparisonSourceProperty)) {
            throw new UnsupportedOperationException(ResourceManager.format("exception.unknownproperty", comparisonSourceProperty.getName()));
        }
    }

    protected void notifyListenersOfChangedOnDisk() {
        for (ComparisonSourceListener comparisonSourceListener : this.fListeners) {
            comparisonSourceListener.changedOnDisk();
        }
    }

    protected Collection<ComparisonSourceListener> getListeners() {
        return new CopyOnWriteArrayList<ComparisonSourceListener>(this.fListeners);
    }
}

