/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.FileSetFilter;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public abstract class FileChooser {
    private static boolean sFileShowChooser = true;

    public abstract File[] showOpenDialog();

    public abstract File showSaveDialog();

    public abstract void setMultiSelectionEnabled(boolean var1);

    public abstract void setAcceptAllFileFilterUsed(boolean var1);

    public abstract boolean acceptsAllFiles();

    public abstract List<FileFilter> getFilters();

    public static FileChooser create(Component component, String string, File file, boolean bl, List<FileSetFilter> list) {
        return new PlatformChooser(component, string, file, list, bl);
    }

    public static FileChooser create(Component component, String string, File file) {
        return new PlatformChooser(component, string, file);
    }

    private static class PlatformChooser
    extends FileChooser {
        private final MJFileChooserPerPlatform fChooser;
        private final Component fParent;

        PlatformChooser(Component component, String string, File file) {
            this.fParent = component;
            this.fChooser = new MJFileChooserPerPlatform();
            this.fChooser.setDialogTitle(string);
            if (file != null) {
                this.fChooser.setCurrentDirectory(file);
            }
            this.fChooser.setMultiSelectionEnabled(false);
            this.fChooser.setFileSelectionMode(1);
        }

        PlatformChooser(Component component, String string, File file, List<FileSetFilter> list, boolean bl) {
            this.fParent = component;
            this.fChooser = new MJFileChooserPerPlatform();
            this.fChooser.setDialogTitle(string);
            if (file != null) {
                this.fChooser.setCurrentDirectory(file);
            }
            this.fChooser.setMultiSelectionEnabled(true);
            if (bl) {
                this.fChooser.setFileSelectionMode(2);
            }
            if (list != null) {
                for (FileSetFilter fileSetFilter : list) {
                    this.fChooser.addChoosableFileFilter((FilePatternFilter)fileSetFilter);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public File[] showOpenDialog() {
            if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
                return DeployToolTestUtils.showSimpleFileChooser();
            }
            if (this.testSetMainFile(false)) {
                this.fChooser.showOpenDialog(this.fParent);
                File[] fileArray = this.fChooser.isMultiSelectionEnabled() ? (this.fChooser.getState() == 0 ? this.fChooser.getSelectedFiles() : null) : new File[]{this.fChooser.getState() == 0 ? this.fChooser.getSelectedFile() : null};
                if (fileArray != null && fileArray.length > 0 && fileArray[0] != null) {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    ArrayList<File> arrayList2 = new ArrayList<File>();
                    for (File file : fileArray) {
                        if (file.exists()) {
                            arrayList.add(file);
                            continue;
                        }
                        arrayList2.add(file);
                    }
                    fileArray = arrayList.toArray(new File[arrayList.size()]);
                    if (!arrayList2.isEmpty()) {
                        void var4_6;
                        String string = BuiltInResources.getString("error.missing.files");
                        for (File file : arrayList2) {
                            String string2 = (String)var4_6 + file.getAbsolutePath();
                        }
                        MJOptionPane.showMessageDialog((Component)ProjectGUI.getInstance().getCurrentClient().getComponent(), (Object)var4_6, (String)BuiltInResources.getString("error.addfiles.title"), (int)0);
                    }
                }
                this.testSetMainFile(true);
                return fileArray;
            }
            return null;
        }

        private synchronized boolean testSetMainFile(boolean bl) {
            boolean bl2 = sFileShowChooser;
            sFileShowChooser = bl;
            return bl2;
        }

        @Override
        public File showSaveDialog() {
            this.fChooser.showSaveDialog(this.fParent);
            return this.fChooser.getState() == 0 ? this.fChooser.getSelectedFile() : null;
        }

        @Override
        public void setMultiSelectionEnabled(boolean bl) {
            this.fChooser.setMultiSelectionEnabled(bl);
        }

        @Override
        public void setAcceptAllFileFilterUsed(boolean bl) {
            this.fChooser.setAcceptAllFileFilterUsed(bl);
        }

        @Override
        public boolean acceptsAllFiles() {
            return this.fChooser.isAcceptAllFileFilterUsed();
        }

        @Override
        public List<FileFilter> getFilters() {
            LinkedList<FileFilter> linkedList = new LinkedList<FileFilter>();
            Iterator iterator = this.fChooser.getChoosableFileFilterList().iterator();
            while (iterator.hasNext()) {
                linkedList.add((FileFilter)iterator.next());
            }
            return linkedList;
        }
    }
}

