/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mwswing.MJLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;

public class HyperlinkMJLabel
extends MJLabel {
    private Color NormalHyperlinkColor = new Color(2118279);
    private Color MouseoverHyperlinkColor = new Color(252, 0, 55);
    private List<MouseAdapter> mouseAdapters = new ArrayList<MouseAdapter>();

    public HyperlinkMJLabel(String string) {
        this.setText(string);
        this.setForeground(this.NormalHyperlinkColor);
        this.setCursor(new Cursor(12));
        this.setBorder(BorderFactory.createEmptyBorder());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                HyperlinkMJLabel.this.setForeground(HyperlinkMJLabel.this.MouseoverHyperlinkColor);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                HyperlinkMJLabel.this.setForeground(HyperlinkMJLabel.this.NormalHyperlinkColor);
            }
        };
        this.mouseAdapters.add(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                HyperlinkMJLabel.this.invalidate();
                HyperlinkMJLabel.this.validate();
                HyperlinkMJLabel.this.repaint();
            }
        });
    }

    public HyperlinkMJLabel(String string, MouseAdapter mouseAdapter) {
        this(string);
        this.addMouseListener(mouseAdapter);
        this.mouseAdapters.add(mouseAdapter);
    }

    public HyperlinkMJLabel(String string, MouseAdapter mouseAdapter, String string2) {
        this(string, mouseAdapter);
        this.setName(string2);
    }

    public HyperlinkMJLabel(String string, MouseAdapter mouseAdapter, String string2, String string3) {
        this(string, mouseAdapter, string2);
    }

    public void setText(String string) {
        super.setText(string.replaceAll("<[^>]*>", ""));
    }

    public void setTextRemoveTags(String string, boolean bl) {
        if (!bl) {
            super.setText(string);
        } else {
            this.setText(string);
        }
    }

    public void formatAsError() {
        this.addUnderline();
        this.setHyperlinkColors(Color.RED, new Color(255, 96, 26));
    }

    public void setHyperlinkColors(Color color, Color color2) {
        this.NormalHyperlinkColor = color;
        this.MouseoverHyperlinkColor = color2;
        this.setForeground(this.NormalHyperlinkColor);
    }

    public void addUnderline() {
        Font font = this.getFont();
        Map<TextAttribute, ?> map = font.getAttributes();
        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.setFont(font.deriveFont(map));
    }

    public void close() {
        for (MouseAdapter mouseAdapter : this.mouseAdapters) {
            this.removeMouseListener(mouseAdapter);
        }
    }

    public void lineWrap() {
        String string = this.getText();
        this.setTextRemoveTags("<html>" + string + "</html>", false);
    }
}

