/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.ProjectAction;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class HelpAction
extends ProjectAction {
    private final Component fDialogParent;
    private static final Matlab MATLAB = new Matlab();
    public static final String KEY = "HELP";
    public static final Icon ICON = new ImageIcon(HelpAction.class.getResource("/com/mathworks/common/icons/resources/help_ts_16.png"));
    private static final String HELP_PATH = File.separator + "compiler" + File.separator + "compiler.map";
    private static final String HELP_ID = "deployment_tool_project_open";

    public HelpAction(Component component) {
        super(KEY, ICON);
        this.fDialogParent = component;
        this.setEnabled(!PluginManager.getTargets().isEmpty());
    }

    @Override
    public boolean requiresOpenProject() {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Project project = ProjectGUI.getInstance().getCurrentProject();
        if (project != null) {
            Target target = project.getConfiguration().getTarget();
            String string = target.getHelpTopicKey();
            String string2 = HelpAction.resolveHelpMapPath(target.getHelpMapPath());
            if (string != null && string2 != null) {
                MLHelpServices.cshDisplayTopic((Object)this.fDialogParent, (String)string2, (String)string);
                return;
            }
        }
        MATLAB.evalNoOutput("helpview(fullfile(docroot,'toolbox','" + HELP_PATH + "'), " + "'" + HELP_ID + "','CSHelpWindow'" + ");");
    }

    private static String resolveHelpMapPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = MLHelpServices.getDocRoot();
        File file = new File(new File(string2), string);
        return file.getAbsolutePath();
    }
}

