/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.ActionGroup;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.desktop.AbstractProjectClient;
import com.mathworks.project.impl.desktop.CustomizableToolbar;
import com.mathworks.project.impl.desktop.HistoryComboBox;
import com.mathworks.project.impl.desktop.ProjectAction;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plaf.ActionMenuItemUI;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.DropdownButton;
import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public abstract class ToolbarProjectClient
extends AbstractProjectClient {
    private final LinkedHashMap<String, ProjectAction> fActions;
    private final List<String> fDefaultToolBarComponents;
    private final HistoryComboBox fHistory = new HistoryComboBox(this);
    private final DropdownButton fActionButton;
    private CustomizableToolbar fToolBar;

    protected ToolbarProjectClient(String string, String string2) {
        super(string, string2);
        this.fActions = new LinkedHashMap();
        this.fDefaultToolBarComponents = new ArrayList<String>();
        this.fDefaultToolBarComponents.add("history");
        this.fActionButton = this.createActionButton();
    }

    protected void addAction(ProjectAction projectAction, boolean bl) {
        this.fActions.put(projectAction.getKey(), projectAction);
        if (bl) {
            this.fDefaultToolBarComponents.add(projectAction.getKey());
        }
    }

    public ProjectAction getAction(String string) {
        return this.fActions.get(string);
    }

    public JComponent getToolBar() {
        return this.fToolBar.getComponent();
    }

    @Override
    public void disableChangeActionsWhileRunning(final DeploymentProcess deploymentProcess) {
        final String[] stringArray = new String[]{"NEW", "OPEN", "BUILD", "PACKAGE", "RENAME_PROJECT"};
        deploymentProcess.addMonitor(new DeploymentProcessMonitor(){
            private boolean[] iPriorStates;
            private boolean iPriorAddEntityState;

            public void commandStarted(String string) {
            }

            public void commandOutput(String string) {
            }

            public void commandError(String string) {
            }

            public void failed() {
                this.finished();
            }

            public void canceled() {
                this.finished();
            }

            public void subProcessStarted(SubProcessType subProcessType) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ActionGroup actionGroup;
                        if (iPriorStates == null && (actionGroup = ToolbarProjectClient.this.getAddEntityActionGroup()) != null) {
                            iPriorAddEntityState = actionGroup.isAnyEnabled();
                            actionGroup.setEnabled(false);
                            1.access$002(this, new boolean[stringArray.length]);
                            for (int i = 0; i < stringArray.length; ++i) {
                                ProjectAction projectAction = ToolbarProjectClient.this.getAction(stringArray[i]);
                                if (projectAction == null) continue;
                                (this).iPriorStates[i] = projectAction.isEnabled();
                                projectAction.setEnabled(false);
                            }
                        }
                    }
                });
            }

            public void finished() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ActionGroup actionGroup;
                        if (iPriorStates != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                ProjectAction projectAction = ToolbarProjectClient.this.getAction(stringArray[i]);
                                projectAction.setEnabled(iPriorStates[i]);
                            }
                        }
                        if ((actionGroup = ToolbarProjectClient.this.getAddEntityActionGroup()) != null) {
                            actionGroup.setEnabled(iPriorAddEntityState);
                        }
                    }
                });
                deploymentProcess.removeMonitor((DeploymentProcessMonitor)this);
            }

            static /* synthetic */ boolean[] access$002(1 var0, boolean[] blArray) {
                var0.iPriorStates = blArray;
                return blArray;
            }
        });
    }

    protected DropdownButton createActionButton() {
        DropdownButton dropdownButton = new DropdownButton();
        dropdownButton.setIcon((Icon)DocumentIcon.ACTIONS.getIcon());
        dropdownButton.setDisabledIcon(UIManager.getLookAndFeel().getDisabledIcon((JComponent)dropdownButton, DocumentIcon.ACTIONS.getIcon()));
        dropdownButton.setToolTipText(BuiltInResources.getString("tooltip.actions"));
        MJToolBar.configureButton((MJButton)dropdownButton);
        if (PlatformInfo.isMacintosh()) {
            dropdownButton.setMargin(new Insets(5, 6, 6, 6));
        } else {
            dropdownButton.setMargin(new Insets(1, 4, 2, 4));
        }
        dropdownButton.setPopupMenuCustomizer(new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                ToolbarProjectClient.this.customizeActionMenu(jPopupMenu);
            }
        });
        return dropdownButton;
    }

    protected abstract void customizeActionMenu(JPopupMenu var1);

    @Override
    protected void projectTypeChanged() {
        super.projectTypeChanged();
        this.fHistory.flushRendererCache();
    }

    @Override
    public void loadingFinished(Project project) {
        super.loadingFinished(project);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolbarProjectClient.this.fHistory.setSelectedItem(ToolbarProjectClient.this.getProject().getFile());
            }
        });
    }

    @Override
    public void loadingFailed() {
        super.loadingFailed();
        if (this.getProject() != null) {
            this.fHistory.reselectCurrentProject();
        }
    }

    protected ActionGroup getAddEntityActionGroup() {
        return null;
    }

    protected List<ProjectAction> filterActionsForToolbar() {
        ArrayList<ProjectAction> arrayList = new ArrayList<ProjectAction>();
        for (ProjectAction projectAction : this.fActions.values()) {
            if (!projectAction.isApplicable(this.getProject()) || projectAction.getButtonOnlyIcon() == null) continue;
            arrayList.add(projectAction);
        }
        return arrayList;
    }

    protected List<String> filterDefaultToolbarComponents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.fDefaultToolBarComponents) {
            ProjectAction projectAction = this.fActions.get(string);
            if (projectAction != null && (!projectAction.isApplicable(this.getProject()) || projectAction.getButtonOnlyIcon() == null)) continue;
            arrayList.add(string.toLowerCase(Locale.ENGLISH));
        }
        return arrayList;
    }

    protected static void addToActionMenu(JPopupMenu jPopupMenu, MJAbstractAction mJAbstractAction) {
        JMenuItem jMenuItem = jPopupMenu.add((Action)mJAbstractAction);
        jMenuItem.setUI(new ActionMenuItemUI());
        if (jMenuItem.getIcon() == null) {
            jMenuItem.setIcon(mJAbstractAction.getButtonOnlyIcon());
        }
    }

    public void setBackground(Color color) {
        super.setBackground(this.fToolBar == null ? color : this.fToolBar.getComponent().getBackground());
    }

    @Override
    protected void switchToNoProjectMode() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolbarProjectClient.this.fHistory.reselectCurrentProject();
                ToolbarProjectClient.super.switchToNoProjectMode();
            }
        });
    }

    @Override
    protected void updateToolbar() {
        if (this.fActions.isEmpty()) {
            return;
        }
        if (this.fToolBar != null) {
            this.fToolBar.dispose();
        }
        if (!this.fDefaultToolBarComponents.contains("actions")) {
            this.fDefaultToolBarComponents.add("actions");
        }
        String string = "9b";
        Target target = null;
        if (this.getProject() != null) {
            target = this.getProject().getConfiguration().getTarget();
            string = target.getPlugin().getKey();
        }
        this.fToolBar = new CustomizableToolbar(this, this.filterActionsForToolbar(), this.filterDefaultToolbarComponents(), (JComponent)this.fActionButton, this.fHistory.getComponent(), string, target != null && target.getPackageScript() != null);
        this.setToolbarComponent(this.fToolBar.getComponent(), true);
        this.setBackground(this.fToolBar.getComponent().getBackground());
    }

    @Override
    protected void disableActionsRequiringOpenProject() {
        for (ProjectAction projectAction : this.fActions.values()) {
            if (!projectAction.requiresOpenProject()) continue;
            projectAction.setEnabled(false);
        }
    }

    @Override
    protected void enableActionsRequiringOpenProject() {
        for (ProjectAction projectAction : this.fActions.values()) {
            if (!projectAction.requiresOpenProject()) continue;
            projectAction.setEnabled(true);
        }
    }
}

