/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectPrefs;
import com.mathworks.project.impl.engine.AntEntryPoint;
import com.mathworks.project.impl.engine.ProcessWrapperImpl;
import com.mathworks.project.impl.util.Matlab;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

final class AntCommand
implements Command {
    private final String fInputXml;
    private final String fLabel;
    private final String fProjectXml;
    private final String fTargetName;
    private ProcessWrapperImpl fProcessWrapper;

    AntCommand(String string) {
        XmlReader xmlReader;
        this.fInputXml = string;
        try {
            xmlReader = XmlApi.getInstance().read(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid command XML: " + string, exception);
        }
        this.fLabel = xmlReader.readAttribute("display-label") != null ? StringUtils.normalizeSpace(xmlReader.readAttribute("display-label")) : (xmlReader.readText("display-label") != null ? StringUtils.normalizeSpace(xmlReader.readText("display-label")) : "ant:\r\n" + this.fInputXml);
        XmlReader xmlReader2 = xmlReader.getChild(new String[0]);
        if (xmlReader2.isPresent() && xmlReader2.getCurrentElementName().equals("project")) {
            this.fProjectXml = xmlReader2.getCurrentSubtree().getXML();
            this.fTargetName = xmlReader2.getChild(new String[]{"target"}).readAttribute("name");
        } else if (xmlReader2.isPresent() && xmlReader2.getCurrentElementName().equals("target")) {
            this.fTargetName = xmlReader2.readAttribute("name");
            XmlWriter xmlWriter = XmlApi.getInstance().create("project");
            xmlWriter.writeAttribute("name", (Object)"project");
            XmlReader xmlReader3 = xmlReader2;
            while (xmlReader3.isPresent()) {
                xmlWriter.writeXML(xmlReader3.getXML());
                xmlReader3 = xmlReader3.next();
            }
            this.fProjectXml = xmlWriter.getXML();
        } else {
            this.fTargetName = "implicit";
            XmlWriter xmlWriter = XmlApi.getInstance().create("project");
            xmlWriter.writeAttribute("name", (Object)"project");
            XmlWriter xmlWriter2 = xmlWriter.createElement("target");
            xmlWriter2.writeAttribute("name", (Object)this.fTargetName);
            XmlReader xmlReader4 = xmlReader2;
            while (xmlReader4.isPresent()) {
                xmlWriter2.writeXML(xmlReader4.getXML());
                xmlReader4 = xmlReader4.next();
            }
            this.fProjectXml = xmlWriter.getXML();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandStatus commandStatus) {
        File file;
        String string = BuiltInResources.getString("ant.failed");
        File file2 = new File(System.getProperty("java.home"));
        File file3 = new File(file2, "bin");
        File file4 = new File(file3, "java");
        if (PlatformInfo.isWindows()) {
            file4 = new File(file3, "java.exe");
        }
        try (PrintWriter printWriter = null;){
            file = File.createTempFile("build", ".xml");
            printWriter = new PrintWriter(file, "UTF8");
            printWriter.print(this.fProjectXml);
        }
        File file5 = null;
        try {
            file5 = new File(Matlab.matlabRoot(), "java");
        }
        catch (IllegalStateException illegalStateException) {
            commandStatus.printErrorLine(string);
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)illegalStateException));
            return;
        }
        File file6 = new File(file5, "patch");
        File file7 = new File(file5, "jar" + File.separator + "project" + File.separator + "impl.jar");
        File file8 = new File(file5, "jarext" + File.separator + "ant.jar");
        File file9 = new File(file5, "jarext" + File.separator + "ant-launcher.jar");
        StringWriter stringWriter = new StringWriter();
        Integer n = ProjectPrefs.ANT_HEAP_LIMIT.get();
        if (n == null || n < 1) {
            n = 64;
        }
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("\"%s\" -Xmx%sM -classpath \"%s\" -Djava.library.path=\"%s\" " + AntEntryPoint.class.getName() + " \"%s\" %s", file4.getAbsolutePath(), n.toString(), file6.getAbsolutePath() + File.pathSeparator + file7.getAbsolutePath() + File.pathSeparator + file8.getAbsolutePath() + File.pathSeparator + file9.getAbsolutePath(), System.getProperty("java.library.path"), file.getAbsolutePath(), this.fTargetName);
        printWriter.close();
        this.fProcessWrapper = new ProcessWrapperImpl(this, stringWriter.toString(), commandStatus, string, new Runnable(){

            @Override
            public void run() {
                file.delete();
            }
        });
        this.fProcessWrapper.execute();
    }

    public String toString() {
        return this.fLabel;
    }

    public void cancel() {
        if (this.fProcessWrapper != null) {
            this.fProcessWrapper.cancel();
        }
    }
}

