/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.project.api.CustomFileSetAction;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.ReadableEntityInstance;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.FileAndEntityActions;
import com.mathworks.project.impl.HyperlinkMJLabel;
import com.mathworks.project.impl.filesetui.CustomFileSetTree;
import com.mathworks.project.impl.filesetui.DefaultFileSetTree;
import com.mathworks.project.impl.filesetui.DescriptionLabel;
import com.mathworks.project.impl.filesetui.EntityControls;
import com.mathworks.project.impl.filesetui.FileChangeNotifier;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.filesetui.FileSetLinkUtils;
import com.mathworks.project.impl.filesetui.FileSetTree;
import com.mathworks.project.impl.filesetui.LinkBar;
import com.mathworks.project.impl.model.EntityDefinition;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileReferenceMode;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.util.CollectionMap;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FileSetEditor {
    private final Project fProject;
    private final MJPanel fComponent;
    private final FileSetEditorGroup fGroup;
    private final FileSetInstance fSet;
    private final CustomFileSetAction fCustomFileSetAction;
    private final DescriptionLabel fDescriptionLabel;
    private final LinkBar fControls;
    private final PropertyChangeListener fFileSetListener;
    private final PropertyChangeListener fSpecialFileListener;
    private final Map<FileAndEntityActions, MJAbstractAction> fActions;
    private final List<HyperlinkMJLabel> fLinks;
    private final PropertyChangeSupport fPropertySupport;
    private final FileSetTree fTree;
    private final FileChangeNotifier fFileChangeNotifier;
    private final boolean fShowLinks;
    private MJPopupMenu fPopupMenu;
    private HyperlinkMJLabel fAddLink;
    private Action fRenameEntityAction;
    private TreePath[] fLastSelectionPaths;
    private int[] fLastSelectionRows;
    private int fLastCount;
    private String fHeaderText;
    private String fHeaderToolTipText;
    public static final Color DESCRIPTION_FOREGROUND = ColorUtils.convertToCurrentColorScheme((Color)new Color(120, 120, 120), (Color)UIManager.getColor("Label.foreground"));
    static final Color BACKGROUND = UIManager.getColor("TextArea.background");
    public static final String HEADER_TEXT_PROPERTY = "header-text";

    public FileSetEditor(Project project, FileSetInstance fileSetInstance, FileSetEditorGroup fileSetEditorGroup) {
        this(project, fileSetInstance, fileSetEditorGroup, true);
    }

    public FileSetEditor(Project project, FileSetInstance fileSetInstance, FileSetEditorGroup fileSetEditorGroup, boolean bl) {
        this(project, fileSetInstance, fileSetEditorGroup, bl, true);
    }

    public FileSetEditor(Project project, FileSetInstance fileSetInstance, FileSetEditorGroup fileSetEditorGroup, boolean bl, boolean bl2) {
        this(project, fileSetInstance, fileSetEditorGroup, bl, bl2, "");
    }

    public FileSetEditor(Project project, FileSetInstance fileSetInstance, FileSetEditorGroup fileSetEditorGroup, boolean bl, boolean bl2, String string) {
        this.fProject = project;
        this.fSet = fileSetInstance;
        this.fGroup = fileSetEditorGroup;
        this.fShowLinks = bl2;
        this.fComponent = new MJPanel();
        this.fComponent.setOpaque(false);
        this.fComponent.setName(this.fSet.toString());
        this.fLinks = new ArrayList<HyperlinkMJLabel>();
        this.fPropertySupport = new PropertyChangeSupport(this);
        fileSetEditorGroup.addEditor(this);
        this.fLastCount = -1;
        this.fComponent.setLayout((LayoutManager)new FormLayout("d:grow", "d, 3dlu, p"));
        this.fDescriptionLabel = new DescriptionLabel(this.fSet.getDefinition().getDescription() == null ? "" : this.fSet.getDefinition().getDescription());
        this.fControls = new LinkBar();
        this.fFileSetListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileSetEditor.this.updateControls();
                FileSetEditor.this.restoreSelection();
            }
        };
        final HashSet<String> hashSet = new HashSet<String>();
        for (SpecialFile fileAndEntityActionsArray : this.fSet.getDefinition().getSpecialFiles()) {
            hashSet.add(fileAndEntityActionsArray.getKey());
        }
        this.fSpecialFileListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (hashSet.contains(propertyChangeEvent.getPropertyName())) {
                    FileSetEditor.this.updateControls();
                }
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FileSetEditor.this.fControls.getComponent().invalidate();
                        FileSetEditor.this.fControls.getComponent().validate();
                        FileSetEditor.this.fControls.getComponent().doLayout();
                        FileSetEditor.this.fControls.getComponent().repaint();
                        FileSetEditor.this.fComponent.invalidate();
                        FileSetEditor.this.fComponent.validate();
                        FileSetEditor.this.fComponent.repaint();
                    }
                });
            }
        };
        this.fTree = this.fSet.getDefinition().getCustomDataWidgetClassName() != null ? new CustomFileSetTree(fileSetEditorGroup, this) : (project.getConfiguration().getTargetKey().equals("target.mlapps") ? new DefaultFileSetTree(fileSetEditorGroup, this, true, string) : new DefaultFileSetTree(fileSetEditorGroup, this, false));
        this.fFileChangeNotifier = new FileChangeNotifier(this.fSet, new ParameterRunnable<File>(){

            public void run(File file) {
                FileSetEditor.this.fileChanged(file);
            }
        });
        String string2 = this.fSet.getDefinition().getCustomFileSetActionClassName();
        if (string2 != null) {
            try {
                Class<?> exception = Class.forName(string2);
                Constructor<?> constructor = exception.getConstructor(new Class[0]);
                this.fCustomFileSetAction = (CustomFileSetAction)constructor.newInstance(new Object[0]);
                this.fCustomFileSetAction.addVisibilityListener((ReadableConfiguration)this.fProject.getConfiguration(), new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        FileSetEditor.this.updateControls();
                    }
                });
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not instantiate custom file-set action class: '" + (String)string2 + "'. Please ensure that it is a public class implementing CustomFileSetAction.", exception);
            }
        } else {
            this.fCustomFileSetAction = null;
        }
        this.fSet.addPropertyChangeListener(this.fFileSetListener);
        this.fProject.addPropertyChangeListener(this.fSpecialFileListener);
        this.fTree.getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent) || !PlatformInfo.isMacintosh() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (!FileSetEditor.this.getSelectedEntities().isEmpty()) {
                        FileSetEditor.this.showEntityPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                    } else if (!FileSetEditor.this.fGroup.getSelectedFiles().isEmpty()) {
                        if (FileSetEditor.this.fGroup.getSelectedExplicitFiles().isEmpty()) {
                            FileSetEditor.this.showDynamicFilePopupMenu(mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            FileSetEditor.this.showExplicitFilePopupMenu(mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                } else if (MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent)) {
                    if (!FileSetEditor.this.fGroup.getSelectedFiles().isEmpty()) {
                        FileAndEntityActions.OPEN_FILE.run(FileSetEditor.this.fGroup);
                    }
                } else {
                    TreePath treePath = FileSetEditor.this.fTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null && treePath.getLastPathComponent() instanceof EntityControls) {
                        Rectangle rectangle = FileSetEditor.this.fTree.getRowBounds(FileSetEditor.this.fTree.getRowForPath(treePath));
                        Point point = new Point((int)((double)mouseEvent.getX() - rectangle.getX()), (int)((double)mouseEvent.getY() - rectangle.getY()));
                        ((EntityControls)treePath.getLastPathComponent()).doClick(point);
                    }
                }
            }
        });
        this.fTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileSetEditor.access$802(FileSetEditor.this, FileSetEditor.this.getSelectionModel().getSelectionPaths());
                        FileSetEditor.access$902(FileSetEditor.this, FileSetEditor.this.getSelectionModel().getSelectionRows());
                        FileSetEditor.this.updateRenameEntityAction();
                    }
                });
            }
        });
        this.fTree.addModelChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FileSetEditor.this.updateDisplay(false);
                FileSetEditor.this.fControls.getComponent().invalidate();
                FileSetEditor.this.fControls.getComponent().validate();
                FileSetEditor.this.fControls.getComponent().doLayout();
                FileSetEditor.this.fControls.getComponent().repaint();
                FileSetEditor.this.fComponent.invalidate();
                FileSetEditor.this.fComponent.validate();
                FileSetEditor.this.fComponent.repaint();
            }
        });
        this.fActions = new LinkedHashMap<FileAndEntityActions, MJAbstractAction>();
        this.fRenameEntityAction = null;
        for (FileAndEntityActions fileAndEntityActions : FileAndEntityActions.values()) {
            if (!fileAndEntityActions.isApplicableOnCurrentPlatform()) continue;
            MJAbstractAction mJAbstractAction = fileAndEntityActions.instantiate(this.fGroup);
            if (fileAndEntityActions == FileAndEntityActions.RENAME) {
                this.fRenameEntityAction = mJAbstractAction;
            }
            this.fActions.put(fileAndEntityActions, mJAbstractAction);
        }
        this.setHeaderText(this.fSet.getDefinition().getName());
        this.updateDisplay(false);
        this.updateControls();
        this.updateRenameEntityAction();
    }

    public void addModelChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.fTree.addModelChangeListener(changeListener);
        }
    }

    public void fileChanged(File file) {
        this.fTree.fileChanged(file);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void setHeaderText(String string) {
        String string2 = this.fHeaderText;
        this.fHeaderText = string;
        this.fPropertySupport.firePropertyChange(HEADER_TEXT_PROPERTY, string2, this.fHeaderText);
    }

    public String getHeaderText() {
        return this.fHeaderText;
    }

    private void setHeaderToolTipText(String string) {
        String string2 = this.fHeaderToolTipText;
        this.fHeaderToolTipText = string;
        this.fPropertySupport.firePropertyChange("header-tooltip", string2, this.fHeaderToolTipText);
    }

    public String getHeaderToolTipText() {
        return this.fHeaderToolTipText;
    }

    private boolean isApplicableToSelection(FileAndEntityActions fileAndEntityActions) {
        if (fileAndEntityActions == FileAndEntityActions.REMOVE && !this.supportsEntityAddAndRemove() && this.fGroup.getSelectedFiles().isEmpty()) {
            return false;
        }
        if (fileAndEntityActions == FileAndEntityActions.OPEN_FILE && this.fGroup.getSelectedOpenableFiles().isEmpty()) {
            return false;
        }
        return fileAndEntityActions.isVisible(this.fGroup.getSelectedFiles());
    }

    private void showEntityPopupMenu(int n, int n2) {
        this.showPopupMenu(n, n2, new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                for (Map.Entry entry : FileSetEditor.this.fActions.entrySet()) {
                    if (!FileSetEditor.this.isApplicableToSelection((FileAndEntityActions)((Object)entry.getKey())) || !((FileAndEntityActions)((Object)entry.getKey())).isApplicableToEntities()) continue;
                    jPopupMenu.add((Action)entry.getValue());
                }
            }
        });
    }

    private void showDynamicFilePopupMenu(int n, int n2) {
        this.showPopupMenu(n, n2, new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                for (Map.Entry entry : FileSetEditor.this.fActions.entrySet()) {
                    if (!FileSetEditor.this.isApplicableToSelection((FileAndEntityActions)((Object)entry.getKey())) || !((FileAndEntityActions)((Object)entry.getKey())).isApplicableToDynamicFiles()) continue;
                    jPopupMenu.add((Action)entry.getValue());
                }
            }
        });
    }

    private void showExplicitFilePopupMenu(int n, int n2) {
        this.showPopupMenu(n, n2, new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                for (Map.Entry object : FileSetEditor.this.fActions.entrySet()) {
                    if (!FileSetEditor.this.isApplicableToSelection((FileAndEntityActions)((Object)object.getKey())) || !((FileAndEntityActions)((Object)object.getKey())).isApplicableToExplicitFiles()) continue;
                    jPopupMenu.add((Action)object.getValue());
                }
                List<File> list = FileSetEditor.this.getSelectedFiles();
                if (list.size() == 1) {
                    FileReferenceMode fileReferenceMode = FileSetEditor.this.fSet.getReferenceMode((File)list.get(0));
                    SpecialFile specialFile = FileSetEditor.this.getSpecialFile((File)list.get(0));
                    if (specialFile != null) {
                        for (FileReferenceMode fileReferenceMode2 : specialFile.getSupportedReferenceModes()) {
                            if (fileReferenceMode2 == fileReferenceMode || !fileReferenceMode2.isSupportedOnCurrentPlatform() || !fileReferenceMode2.isLocationPortable((File)list.get(0))) continue;
                            jPopupMenu.add((Action)((Object)new ReferenceModeChangeAction((File)list.get(0), fileReferenceMode2)));
                        }
                    }
                }
            }
        });
    }

    private SpecialFile getSpecialFile(File file) {
        for (SpecialFile specialFile : this.fSet.getDefinition().getSpecialFiles()) {
            File file2 = this.fProject.getConfiguration().getSpecialFileLocation(specialFile);
            if (!file2.equals(file)) continue;
            return specialFile;
        }
        return null;
    }

    private void showPopupMenu(int n, int n2, PopupMenuCustomizer popupMenuCustomizer) {
        if (this.fPopupMenu != null) {
            this.fPopupMenu.dispose();
        }
        this.fPopupMenu = new MJPopupMenu();
        this.fPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                FileSetEditor.this.fGroup.revalidateAndRepaintAll();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                FileSetEditor.this.fPopupMenu = null;
                FileSetEditor.this.fGroup.revalidateAndRepaintAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                FileSetEditor.this.fPopupMenu = null;
                FileSetEditor.this.fGroup.revalidateAndRepaintAll();
            }
        });
        popupMenuCustomizer.customize((JPopupMenu)this.fPopupMenu);
        this.fPopupMenu.show((Component)this.fTree.getComponent(), n, n2);
    }

    public void dispose() {
        if (this.fCustomFileSetAction != null) {
            this.fCustomFileSetAction.dispose();
        }
        this.fSet.removePropertyChangeListener(this.fFileSetListener);
        this.fProject.removePropertyChangeListener(this.fSpecialFileListener);
        this.fTree.dispose();
        this.fLinks.clear();
        this.fGroup.getDataTransferSupport().uninstall((Component)this.fComponent);
        this.fFileChangeNotifier.dispose();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public FileSetInstance getFileSet() {
        return this.fSet;
    }

    public CustomFileSetAction getCustomFileSetAction() {
        return this.fCustomFileSetAction;
    }

    public void startRenaming(EntityInstance entityInstance) {
        this.fTree.startEditingAtPath(new TreePath(new Object[]{this.fSet, entityInstance}));
    }

    public EntityDefinition getSecondLevelEntity() {
        List<EntityDefinition> list = this.fSet.getDefinition().getRootLevelEntities();
        if (list.isEmpty()) {
            return null;
        }
        List<EntityDefinition> list2 = list.get(0).getChildren();
        return !list2.isEmpty() ? list2.get(0) : null;
    }

    public boolean supportsEntityAddAndRemove() {
        EntityDefinition entityDefinition = this.getSecondLevelEntity();
        return entityDefinition != null && (entityDefinition.getMinCount() != 1 || entityDefinition.getMaxCount() != 1);
    }

    public EntityInstance getTargetEntity(Point point) {
        Point point2 = SwingUtilities.convertPoint((Component)this.fComponent, point, this.fTree.getComponent());
        List<Object> list = new ArrayList();
        if (!this.fSet.getRootEntities().isEmpty()) {
            list = this.fSet.getChildren((ReadableEntityInstance)this.fSet.getRootEntities().iterator().next());
            for (EntityInstance entityInstance : list) {
                TreePath treePath = new TreePath(new Object[]{this.fTree.getRoot(), entityInstance});
                int n = (int)this.fTree.getPathBounds(treePath).getY();
                Object object = this.fTree.getChild(entityInstance, this.fTree.getChildCount(entityInstance) - 1);
                TreePath treePath2 = new TreePath(new Object[]{this.fTree.getRoot(), entityInstance, object});
                Rectangle rectangle = this.fTree.getPathBounds(treePath2);
                int n2 = (int)(rectangle.getY() + rectangle.getHeight());
                if (!(point2.getY() >= (double)n) || !(point2.getY() <= (double)n2)) continue;
                return entityInstance;
            }
        }
        return list.isEmpty() ? null : (EntityInstance)list.get(0);
    }

    public EntityInstance addNewEntity(boolean bl) {
        EntityInstance entityInstance;
        assert (this.fSet.getDefinition().getHierarchyLevels() > 1);
        if (!this.fSet.getRootEntities().isEmpty()) {
            entityInstance = this.fSet.getRootEntities().get(0);
        } else {
            entityInstance = new EntityInstance(this.fSet.getDefinition().getRootLevelEntities().get(0));
            this.fSet.add(entityInstance);
        }
        EntityDefinition entityDefinition = this.fSet.getDefinition().getRootLevelEntities().get(0).getChildren().get(0);
        final EntityInstance entityInstance2 = new EntityInstance(entityDefinition);
        this.fSet.assignDefaultName(entityInstance, entityInstance2);
        this.fSet.addChild(entityInstance, entityInstance2);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileSetEditor.this.startRenaming(entityInstance2);
                }
            });
        }
        return entityInstance2;
    }

    public List<TreePath> getSelectedPaths() {
        TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
        return treePathArray == null ? new ArrayList<TreePath>(0) : new ArrayList<TreePath>(Arrays.asList(treePathArray));
    }

    public void removePaths(List<TreePath> list) {
        HashSet<File> hashSet = new HashSet<File>();
        HashSet<EntityInstance> hashSet2 = new HashSet<EntityInstance>();
        CollectionMap collectionMap = new CollectionMap(HashMap.class, HashSet.class);
        for (TreePath object : list) {
            Object object2 = object.getLastPathComponent();
            if (object2 instanceof File) {
                File file = (File)object2;
                Object object3 = object.getPathComponent(object.getPathCount() - 2);
                if (object3 instanceof EntityInstance) {
                    EntityInstance entityInstance = (EntityInstance)object3;
                    collectionMap.add((Object)entityInstance, (Object)file);
                    continue;
                }
                hashSet.add(file);
                continue;
            }
            if (!(object2 instanceof EntityInstance) || !this.supportsEntityAddAndRemove()) continue;
            hashSet2.add((EntityInstance)object2);
        }
        this.fSet.remove(new ArrayList<File>(hashSet));
        for (EntityInstance entityInstance : hashSet2) {
            this.fSet.removeEntity((ReadableEntityInstance)this.fSet.getRootEntities().get(0), (ReadableEntityInstance)entityInstance);
        }
        for (Map.Entry entry : collectionMap.entrySet()) {
            if (hashSet2.contains(entry.getKey())) continue;
            this.fSet.remove((ReadableEntityInstance)entry.getKey(), new ArrayList<File>((Collection)entry.getValue()));
        }
    }

    public List<EntityInstance> getSelectedEntities() {
        ArrayList<EntityInstance> arrayList = new ArrayList<EntityInstance>();
        TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                if (!(treePath.getLastPathComponent() instanceof EntityInstance)) continue;
                arrayList.add((EntityInstance)treePath.getLastPathComponent());
            }
        }
        return arrayList;
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                if (!(treePath.getLastPathComponent() instanceof File)) continue;
                arrayList.add((File)treePath.getLastPathComponent());
            }
        }
        return arrayList;
    }

    public void addAndSelect(File file, boolean bl) {
        File[] fileArray = new File[]{file};
        this.addAndSelect(fileArray, bl);
    }

    public void addAndSelect(List<File> list, boolean bl) {
        File[] fileArray = list.toArray(new File[list.size()]);
        this.addAndSelect(fileArray, bl);
    }

    public void addAndSelect(final File[] fileArray, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final TreeSet<File> treeSet = new TreeSet<File>();
                treeSet.addAll(Arrays.asList(fileArray));
                String string = FileSetEditor.this.fSet.validateAdd(treeSet);
                if (string != null) {
                    MJOptionPane.showMessageDialog((Component)FileSetEditor.this.fComponent, (Object)string, (String)BuiltInResources.getString("error.addfiles.title"), (int)0);
                } else {
                    FileSetEditor.this.fSet.add(treeSet);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (bl) {
                                FileSetEditor.this.fGroup.toggleSelectionInto(FileSetEditor.this);
                            }
                            FileSetEditor.this.getSelectionModel().clearSelection();
                            for (File file : treeSet) {
                                TreePath treePath = new TreePath(new Object[]{FileSetEditor.this.fTree.getRoot(), file});
                                FileSetEditor.this.getSelectionModel().addSelectionPath(treePath);
                                if (treeSet.size() != 1) continue;
                                FileSetEditor.this.fTree.collapseAll();
                                FileSetEditor.this.fTree.expandPath(treePath);
                            }
                            FileSetEditor.this.fTree.getComponent().requestFocus();
                        }
                    });
                }
            }
        });
    }

    public void addAndSelect(final EntityInstance entityInstance, final File[] fileArray, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final TreeSet<File> treeSet = new TreeSet<File>();
                treeSet.addAll(Arrays.asList(fileArray));
                String string = FileSetEditor.this.fSet.validateAdd((ReadableEntityInstance)entityInstance, treeSet);
                if (string != null) {
                    MJOptionPane.showMessageDialog((Component)FileSetEditor.this.fComponent, (Object)string, (String)BuiltInResources.getString("error.addfiles.title"), (int)0);
                } else {
                    FileSetEditor.this.fSet.add((ReadableEntityInstance)entityInstance, treeSet);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (bl) {
                                FileSetEditor.this.fGroup.toggleSelectionInto(FileSetEditor.this);
                            }
                            FileSetEditor.this.getSelectionModel().clearSelection();
                            for (File file : treeSet) {
                                TreePath treePath = new TreePath(new Object[]{FileSetEditor.this.fTree.getRoot(), entityInstance, file});
                                FileSetEditor.this.getSelectionModel().addSelectionPath(treePath);
                            }
                            FileSetEditor.this.fTree.getComponent().requestFocus();
                        }
                    });
                }
            }
        });
    }

    public boolean hasFocus() {
        if (this.fPopupMenu != null && this.fPopupMenu.isShowing()) {
            return true;
        }
        for (Component component : TreeUtils.findComponents((Component)this.fComponent, Component.class)) {
            if (!component.hasFocus()) continue;
            return true;
        }
        return false;
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public TreeSelectionModel getSelectionModel() {
        return this.fTree.getSelectionModel();
    }

    private void restoreSelection() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FileSetEditor.this.fLastSelectionPaths != null && FileSetEditor.this.fLastSelectionPaths.length > 0) {
                    TreePath[] treePathArray = (TreePath[])FileSetEditor.this.fLastSelectionPaths.clone();
                    int[] nArray = (int[])FileSetEditor.this.fLastSelectionRows.clone();
                    boolean bl = false;
                    for (TreePath treePath : treePathArray) {
                        if (FileSetEditor.this.fTree.getRowForPath(treePath) == -1) continue;
                        FileSetEditor.this.fTree.getSelectionModel().addSelectionPath(treePath);
                        bl = true;
                    }
                    if (!bl) {
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            if (nArray[i] >= FileSetEditor.this.fTree.getRowCount()) continue;
                            FileSetEditor.this.fTree.getSelectionModel().setSelectionPath(FileSetEditor.this.fTree.getPathForRow(nArray[i]));
                            return;
                        }
                        if (FileSetEditor.this.fTree.getRowCount() > 0) {
                            FileSetEditor.this.fTree.getSelectionModel().setSelectionPath(FileSetEditor.this.fTree.getPathForRow(FileSetEditor.this.fTree.getRowCount() - 1));
                        }
                    }
                }
            }
        });
    }

    void addLink(HyperlinkMJLabel hyperlinkMJLabel) {
        this.addLink(false, hyperlinkMJLabel);
    }

    private void addLink(final boolean bl, final HyperlinkMJLabel hyperlinkMJLabel) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FileSetEditor.this.fLinks.add(hyperlinkMJLabel);
                if (bl) {
                    FileSetEditor.this.fControls.addLink(hyperlinkMJLabel);
                    FileSetEditor.this.fControls.getComponent().revalidate();
                    FileSetEditor.this.fControls.getComponent().repaint();
                }
            }
        });
    }

    void updateControls() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object object;
                FileSetEditor.this.fControls.removeAll();
                FileSetEditor.this.fLinks.clear();
                if (FileSetEditor.this.fShowLinks) {
                    if (FileSetEditor.this.fSet.getDefinition().getMaxCount() == 1 && FileSetEditor.this.fSet.getCurrentCount() == 1) {
                        FileSetEditor.this.addLink(true, FileSetLinkUtils.createRootLevelRemoveLink(FileSetEditor.this));
                    } else {
                        object = FileSetEditor.this.fProject.getXslInput();
                        FileSetEditor.this.fAddLink = FileSetLinkUtils.createRootLevelAddLink(FileSetEditor.this);
                        if (FileSetEditor.this.fAddLink != null) {
                            FileSetEditor.this.addLink(true, FileSetEditor.this.fAddLink);
                        }
                        for (SpecialFile specialFile : FileSetEditor.this.fSet.getDefinition().getSpecialFiles()) {
                            File file = specialFile.getLocation(FileSetEditor.this.fProject.getConfiguration(), FileSetEditor.this.fProject.getConfiguration().getVariableGraph(), (XmlReader)object);
                            if (FileSetEditor.this.fSet.getFiles().contains(file)) {
                                FileSetEditor.this.addLink(true, FileSetLinkUtils.createSpecialFileRemoveLink(FileSetEditor.this, specialFile, file));
                                continue;
                            }
                            FileSetEditor.this.addLink(true, FileSetLinkUtils.createSpecialFileAddLink(FileSetEditor.this, specialFile, FileSetEditor.this.fProject.getConfiguration()));
                        }
                    }
                }
                if (FileSetEditor.this.fCustomFileSetAction != null && FileSetEditor.this.fCustomFileSetAction.isVisible((ReadableConfiguration)FileSetEditor.this.fProject.getConfiguration())) {
                    object = new HyperlinkMJLabel(FileSetEditor.this.fCustomFileSetAction.getLabel(), new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            FileSetEditor.this.fCustomFileSetAction.run((WritableConfiguration)FileSetEditor.this.fProject.getConfiguration());
                        }
                    }, FileSetEditor.this.fCustomFileSetAction.getQeName());
                    object.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                    if (object != null) {
                        FileSetEditor.this.addLink(true, (HyperlinkMJLabel)((Object)object));
                    }
                }
                FileSetEditor.this.fTree.setVisibleRowCount(FileSetEditor.this.fTree.getRowCount());
            }
        });
    }

    public Project getProject() {
        return this.fProject;
    }

    public void updateSizeEstimate() {
        if (this.fSet.getDefinition().isSizeEstimateExpected()) {
            this.updateDisplay(true);
        }
    }

    private void updateDisplay(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object object;
                int n = FileSetEditor.this.getVisibleItemCount();
                if (bl || FileSetEditor.this.fLastCount != n) {
                    if (FileSetEditor.this.fSet.getDefinition().isSizeEstimateExpected()) {
                        if (FileSetEditor.this.fSet.getFiles().isEmpty()) {
                            FileSetEditor.this.setHeaderText(FileSetEditor.this.fSet.getDefinition().getName());
                        } else {
                            String string;
                            long l = FileSetEditor.this.fSet.getSizeEstimate();
                            if (l < 0x100000L) {
                                string = BuiltInResources.getString("fileset.header.withsize.kb");
                                l = Math.max(1L, l / 1024L);
                            } else if (l < 0x40000000L) {
                                string = BuiltInResources.getString("fileset.header.withsize.mb");
                                l = Math.max(1L, l / 0x100000L);
                            } else {
                                string = BuiltInResources.getString("fileset.header.withsize.gb");
                                l = Math.max(1L, l / 0x40000000L);
                            }
                            FileSetEditor.this.setHeaderText(MessageFormat.format(string, FileSetEditor.this.fSet.getDefinition().getName(), l));
                        }
                    }
                    Object object2 = object = n == 0 ? FileSetEditor.this.fDescriptionLabel.getComponent() : FileSetEditor.this.fTree.getComponent();
                    if (!((Component)object).isShowing()) {
                        FileSetEditor.this.fComponent.removeAll();
                        CellConstraints cellConstraints = new CellConstraints();
                        FileSetEditor.this.fComponent.add((Component)object, (Object)cellConstraints.xy(1, 1));
                        FileSetEditor.this.fComponent.add((Component)FileSetEditor.this.fControls.getComponent(), (Object)cellConstraints.xy(1, 3));
                    }
                    if (!object.equals(FileSetEditor.this.fDescriptionLabel.getComponent())) {
                        FileSetEditor.this.setHeaderToolTipText(FileSetEditor.this.fSet.getDefinition().getDescription());
                    } else {
                        FileSetEditor.this.setHeaderToolTipText(null);
                    }
                }
                object = FileSetEditor.this.fTree.getRoot();
                FileSetEditor.this.fTree.expandPath(new TreePath(object));
                if (FileSetEditor.this.fSet.getDefinition().getHierarchyLevels() > 1) {
                    for (int i = 0; i < FileSetEditor.this.fTree.getChildCount(object); ++i) {
                        FileSetEditor.this.fTree.expandPath(new TreePath(new Object[]{object, FileSetEditor.this.fTree.getChild(object, i)}));
                    }
                }
                FileSetEditor.this.fLastCount = n;
                FileSetEditor.this.fComponent.revalidate();
                FileSetEditor.this.fComponent.repaint();
            }
        });
    }

    private void updateRenameEntityAction() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FileSetEditor.this.fRenameEntityAction != null) {
                    FileSetEditor.this.fRenameEntityAction.setEnabled(FileSetEditor.this.getSelectedEntities().size() == 1);
                }
            }
        });
    }

    public Action getRenameEntityAction() {
        return this.fRenameEntityAction;
    }

    private int getVisibleItemCount() {
        int n = this.fSet.getDefinition().getHierarchyLevels();
        assert (n == 1 || n == 2);
        if (n == 1) {
            return this.fSet.getCurrentCount();
        }
        if (this.fSet.getRootEntities().isEmpty()) {
            return 0;
        }
        return this.fSet.getChildren((ReadableEntityInstance)this.fSet.getRootEntities().get(0)).size() + this.fSet.getCurrentCount();
    }

    static /* synthetic */ TreePath[] access$802(FileSetEditor fileSetEditor, TreePath[] treePathArray) {
        fileSetEditor.fLastSelectionPaths = treePathArray;
        return treePathArray;
    }

    static /* synthetic */ int[] access$902(FileSetEditor fileSetEditor, int[] nArray) {
        fileSetEditor.fLastSelectionRows = nArray;
        return nArray;
    }

    private class ReferenceModeChangeAction
    extends MJAbstractAction {
        private final FileReferenceMode iMode;
        private final File iFile;

        ReferenceModeChangeAction(File file, FileReferenceMode fileReferenceMode) {
            super(MessageFormat.format(BuiltInResources.getString("referencemode.change"), fileReferenceMode.getShortLabel()));
            this.iFile = file;
            this.iMode = fileReferenceMode;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileSetEditor.this.fSet.remove(Arrays.asList(this.iFile));
            FileSetEditor.this.fSet.setReferenceMode(this.iFile, this.iMode);
            FileSetEditor.this.addAndSelect(new File[]{this.iFile}, false);
        }
    }
}

