/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.ProjectVersionSupport;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.Converter;
import com.mathworks.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultProjectVersionSupport
implements ProjectVersionSupport {
    private final Map<Identifier, Map<Identifier, Converter<String, String>>> fTable = new HashMap<Identifier, Map<Identifier, Converter<String, String>>>();
    private final Set<Identifier> fPrivateVersions = new HashSet<Identifier>();
    private final String fTransformerFactory;

    public DefaultProjectVersionSupport() {
        this(null);
    }

    public DefaultProjectVersionSupport(String string) {
        this.fTransformerFactory = string != null && !string.isEmpty() ? string : null;
    }

    public void markTranslationAsPrivate(String string, String string2) {
        this.fPrivateVersions.add(new Identifier(string, string2));
    }

    public void addTranslationResources(File file, Collection<String> collection) {
        File file2 = new File(file, "resources");
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            for (File file3 : fileArray) {
                if (!file3.getName().startsWith("translate_") || !file3.getName().endsWith(".xsl") || file3.isDirectory()) continue;
                int n = file3.getName().indexOf("_to_");
                int n2 = file3.getName().indexOf(".xsl");
                if (n <= -1 || n2 <= n) continue;
                String string = file3.getName().substring("translate_".length(), n);
                String string2 = file3.getName().substring(n + "_to_".length(), n2);
                for (String string3 : collection) {
                    this.addTranslationResource(string3, string, string2, file3);
                }
            }
        }
    }

    public void addTranslationResource(String string, String string2, String string3, final File file) {
        this.addTranslation(new Identifier(string, string2), new Identifier(string, string3), new Converter<String, String>(){

            public String convert(String string) {
                try {
                    String string2 = FileSystemUtils.readText((FileSystemEntry)RealFileSystem.getInstance().getEntry(new FileLocation(file)));
                    return XMLUtils.transform((String)string, (String)string2);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Error loading translation resource: " + file);
                }
            }
        });
    }

    public void addTranslationResource(String string, String string2, String string3, String string4, String string5) {
        this.addTranslationResource(string, string2, string, string3, string4, string5);
    }

    public void addTranslationResource(String string, String string2, String string3, String string4, final String string5, final String string6) {
        this.addTranslation(new Identifier(string, string2), new Identifier(string3, string4), new Converter<String, String>(){

            public String convert(String string) {
                String string2 = string5 + "/" + string6;
                try {
                    InputStream inputStream = this.getClass().getResourceAsStream(string2);
                    if (inputStream == null) {
                        throw new IllegalStateException("Missing translation resource " + string2);
                    }
                    String string3 = StringUtils.read(inputStream);
                    return StringUtils.transformXML(string, string3, DefaultProjectVersionSupport.this.fTransformerFactory);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Error loading translation resource " + string2);
                }
            }
        });
    }

    private void addTranslation(Identifier identifier, Identifier identifier2, Converter<String, String> converter) {
        Map<Identifier, Converter<String, String>> map = this.fTable.get(identifier);
        if (map == null) {
            map = new HashMap<Identifier, Converter<String, String>>();
            this.fTable.put(identifier, map);
        }
        map.put(identifier2, converter);
    }

    @Override
    public boolean canConvert(String string, String string2, String string3, String string4) {
        return this.canConvert(string, string2, string3, string4, false);
    }

    @Override
    public boolean canConvert(String string, String string2, String string3, String string4, boolean bl) {
        Identifier identifier = new Identifier(string3, string4);
        return (bl || !this.fPrivateVersions.contains(identifier)) && this.findPath(new Identifier(string, string2), identifier, this.fTable) != null;
    }

    @Override
    public XmlReader convert(XmlReader xmlReader, String string, String string2) {
        Identifier identifier = DefaultProjectVersionSupport.getIdentifier(xmlReader);
        return DefaultProjectVersionSupport.execute(xmlReader, this.findPath(identifier, new Identifier(string, string2), this.fTable));
    }

    private static Identifier getIdentifier(XmlReader xmlReader) {
        String string = xmlReader.readAttribute("plugin-version");
        if (string == null) {
            string = "1.0";
        }
        String string2 = xmlReader.getChild(new String[]{"configuration"}).readAttribute("target");
        return new Identifier(string2, string);
    }

    private static XmlReader execute(XmlReader xmlReader, List<Converter<String, String>> list) {
        String string = xmlReader.getXML();
        for (Converter<String, String> converter : list) {
            string = (String)converter.convert((Object)string);
        }
        try {
            return XmlApi.getInstance().read(string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Invalid XML produced during translation: " + string, iOException);
        }
    }

    private List<Converter<String, String>> findPath(Identifier identifier, Identifier identifier2, Map<Identifier, Map<Identifier, Converter<String, String>>> map) {
        if (identifier.equals(identifier2)) {
            return new ArrayList<Converter<String, String>>(0);
        }
        Map<Identifier, Converter<String, String>> map2 = map.get(identifier);
        if (map2 == null) {
            return null;
        }
        Converter<String, String> converter = map2.get(identifier2);
        if (converter != null) {
            return Arrays.asList(converter);
        }
        ArrayList arrayList = new ArrayList();
        for (Identifier identifier3 : map2.keySet()) {
            HashMap<Identifier, Map<Identifier, Converter<String, String>>> hashMap = new HashMap<Identifier, Map<Identifier, Converter<String, String>>>(map);
            hashMap.remove(identifier);
            List<Converter<String, String>> list = this.findPath(identifier3, identifier2, hashMap);
            if (list == null) continue;
            ArrayList<Converter<String, String>> arrayList2 = new ArrayList<Converter<String, String>>();
            arrayList2.add(map2.get(identifier3));
            arrayList2.addAll(list);
            arrayList.add(arrayList2);
        }
        Collections.sort(arrayList, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> list, List<?> list2) {
                return list.size() - list2.size();
            }
        });
        return arrayList.isEmpty() ? null : (List)arrayList.get(0);
    }

    private static class Identifier {
        private final String fTargetKey;
        private final String fVersion;

        Identifier(String string, String string2) {
            this.fTargetKey = string;
            this.fVersion = string2;
        }

        public int hashCode() {
            return this.fTargetKey.hashCode() + this.fVersion.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Identifier && this.fTargetKey.equals(((Identifier)object).fTargetKey) && this.fVersion.equals(((Identifier)object).fVersion);
        }
    }
}

