/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.model.EnumOptionExpression;
import com.mathworks.project.impl.model.Logger;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.OptionListWithDefault;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.project.impl.plugin.DefaultXpathEvaluator;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class MatlabEnumOptionExpression
implements EnumOptionExpression {
    private final String fParamKey;
    private final MatlabExpression fExpression;
    private final Converter<String, String> fDisplayValueConverter;
    private static final Matlab sMatlab = new Matlab();

    public MatlabEnumOptionExpression(String string, MatlabExpression matlabExpression, Converter<String, String> converter) {
        this.fParamKey = string;
        this.fExpression = matlabExpression;
        this.fDisplayValueConverter = converter != null ? converter : new Converter<String, String>(){

            public String convert(String string) {
                return string;
            }
        };
    }

    @Override
    public boolean hasReference(String string) {
        return this.fExpression.hasReference(string);
    }

    @Override
    public void evaluate(Target target, XslInput xslInput, Converter<String, String> converter, final ParameterRunnable<OptionListWithDefault> parameterRunnable) {
        final String string = this.fExpression.getCode(target, xslInput.getDocument(), new DefaultXpathEvaluator("configuration"), converter);
        final boolean bl = NativeMatlab.nativeIsMatlabThread();
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                if (bl || Matlab.getExecutionStatus((int)n) == 0) {
                    Object[] objectArray = (Object[])object;
                    if (objectArray[0] instanceof double[] && ((double[])objectArray[0]).length == 0) {
                        throw new IllegalStateException("The following MATLAB code for populating the options for '" + MatlabEnumOptionExpression.this.fParamKey + "' returned nothing. An enum option callback must always return at least one option. " + string);
                    }
                    String[] stringArray = (String[])objectArray[0];
                    if (stringArray.length == 0) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("", "");
                        final OptionListWithDefault optionListWithDefault = new OptionListWithDefault(hashMap, "");
                        if (bl) {
                            parameterRunnable.run((Object)optionListWithDefault);
                        } else {
                            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    parameterRunnable.run((Object)optionListWithDefault);
                                }
                            });
                        }
                    } else {
                        final String string4 = (String)objectArray[1];
                        final LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        for (String string2 : stringArray) {
                            String string3 = (String)MatlabEnumOptionExpression.this.fDisplayValueConverter.convert((Object)string2);
                            linkedHashMap.put(string2, string3 != null && !string3.isEmpty() ? string3 : string2);
                        }
                        if (!linkedHashMap.containsKey(string4)) {
                            throw new IllegalStateException("MATLAB code '" + string + "' returned default option '" + string4 + "' not in the list of options: " + linkedHashMap.values());
                        }
                        if (bl) {
                            parameterRunnable.run((Object)new OptionListWithDefault(linkedHashMap, string4));
                        } else {
                            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    parameterRunnable.run((Object)new OptionListWithDefault(linkedHashMap, string4));
                                }
                            });
                        }
                    }
                } else {
                    throw new IllegalStateException("Unable to execute MATLAB code: '" + string + "'");
                }
            }
        };
        if (bl) {
            try {
                Logger.log(this, "evaluate", "Running %s synchronously", string);
                Object object = Matlab.mtFevalConsoleOutput((String)"eval", (Object[])new Object[]{string}, (int)2);
                Matlab.whenMatlabReady((Runnable)new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                completionObserver.completed(Integer.MAX_VALUE, object);
                Logger.log(this, "evaluate", "%s returned synchronously", string);
            }
            catch (Exception exception) {
                Logger.log(this, "evaluate", "Failed to run %s synchronously", string);
                exception.printStackTrace();
                throw new IllegalStateException("Failed to run \"" + string + "\"", exception);
            }
        } else {
            Logger.log(this, "evaluate", "Running %s asynchronously", string);
            sMatlab.fevalConsoleOutput("eval", new Object[]{string}, 2, completionObserver);
        }
    }
}

