/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.ResourceStringProvider;
import com.mathworks.project.impl.plugin.LazyIcon;
import com.mathworks.project.impl.plugin.XmlReaderImpl;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class PluginReaderStack
implements ResourceStringProvider {
    private static final String NO_TRANSLATION_SUFFIX = "_notranslation";
    private final List<XmlReader> fReaders;
    private final List<ResourceBundle> fResources;
    private final List<ResourceBundle> fEnglishResources;
    private final Map<String, File> fExternalProductLocations;
    private final Map<String, File> fTargetLocations;
    private final File fPluginRoot;
    private final String fResourcePath;
    private final String fIconResourcePath;
    private static final Locale ROOT_LOCALE = new Locale("", "", "");

    public PluginReaderStack(String string, String string2, XmlReader xmlReader) {
        this(string, string + "/icons", string2, xmlReader);
    }

    public PluginReaderStack(String string, String string2, String string3, XmlReader xmlReader) {
        this.fPluginRoot = null;
        this.fResourcePath = string;
        this.fIconResourcePath = string2;
        this.fReaders = new ArrayList<XmlReader>();
        this.fResources = new ArrayList<ResourceBundle>();
        this.fEnglishResources = new ArrayList<ResourceBundle>();
        this.fReaders.add(xmlReader);
        String string4 = string.replace('/', '.').substring(1) + ".RES_" + string3;
        PluginReaderStack.findAndAddBaseBundles(string4, null, this.fResources);
        PluginReaderStack.findAndAddBaseBundles(string4, ROOT_LOCALE, this.fEnglishResources);
        this.fExternalProductLocations = new HashMap<String, File>();
        this.fTargetLocations = new HashMap<String, File>();
    }

    public PluginReaderStack(File file, XmlReader xmlReader) {
        this.fPluginRoot = file;
        this.fResourcePath = null;
        this.fIconResourcePath = null;
        this.fReaders = new ArrayList<XmlReader>();
        this.fResources = new ArrayList<ResourceBundle>();
        this.fEnglishResources = new ArrayList<ResourceBundle>();
        this.fReaders.add(xmlReader);
        File file2 = new File(file, "resources");
        PluginReaderStack.findAndAddBundle(file2, Locale.getDefault(), "RES_plugin", this.fResources);
        PluginReaderStack.findAndAddBundle(file2, ROOT_LOCALE, "RES_plugin_notranslation", this.fResources);
        PluginReaderStack.findAndAddBundle(file2, ROOT_LOCALE, "RES_plugin", this.fEnglishResources);
        PluginReaderStack.findAndAddBundle(file2, ROOT_LOCALE, "RES_plugin_notranslation", this.fEnglishResources);
        this.fExternalProductLocations = new HashMap<String, File>();
        this.fTargetLocations = new HashMap<String, File>();
        if (this.fResources.get(0) == null) {
            throw new IllegalStateException("There should be a resource bundle called RES_plugin in " + file2);
        }
    }

    private PluginReaderStack(PluginReaderStack pluginReaderStack, XmlReader xmlReader) {
        this.fResourcePath = pluginReaderStack.fResourcePath;
        this.fIconResourcePath = pluginReaderStack.fIconResourcePath;
        this.fReaders = new ArrayList<XmlReader>();
        this.fResources = new ArrayList<ResourceBundle>();
        this.fEnglishResources = new ArrayList<ResourceBundle>();
        this.fReaders.add(xmlReader);
        this.fReaders.addAll(pluginReaderStack.fReaders);
        this.fPluginRoot = pluginReaderStack.fPluginRoot;
        this.fExternalProductLocations = new HashMap<String, File>(pluginReaderStack.fExternalProductLocations);
        this.fTargetLocations = new HashMap<String, File>(pluginReaderStack.fTargetLocations);
        String string = xmlReader.readAttribute("key");
        if (string != null && (xmlReader.getCurrentElementName().equals("target") || xmlReader.getCurrentElementName().equals("product"))) {
            this.pushResourceBundle(this.fResources, Locale.getDefault(), string);
            this.pushResourceBundle(this.fResources, ROOT_LOCALE, string + NO_TRANSLATION_SUFFIX);
            this.pushResourceBundle(this.fEnglishResources, ROOT_LOCALE, string);
            this.pushResourceBundle(this.fEnglishResources, ROOT_LOCALE, string + NO_TRANSLATION_SUFFIX);
        }
        this.fResources.addAll(pluginReaderStack.fResources);
        this.fEnglishResources.addAll(pluginReaderStack.fEnglishResources);
    }

    private void pushResourceBundle(List<ResourceBundle> list, Locale locale, String string) {
        ResourceBundle resourceBundle = null;
        String string2 = this.getProductKey();
        if (string2 != null) {
            File file = this.getExternalProductLocation();
            if (file != null) {
                resourceBundle = PluginReaderStack.findResourceBundle(new File(file, "resources"), locale, "RES_" + string);
            }
            if (resourceBundle == null) {
                resourceBundle = PluginReaderStack.findResourceBundle(new File(new File(this.fPluginRoot, string2), "resources"), locale, "RES_" + string);
            }
        }
        if (resourceBundle == null) {
            resourceBundle = PluginReaderStack.findResourceBundle(new File(this.fPluginRoot, "resources"), locale, "RES_" + string);
        }
        if (resourceBundle == null) {
            resourceBundle = PluginReaderStack.findJARResourceBundle(this.fResourcePath, locale, "RES_" + string);
        }
        if (resourceBundle != null) {
            list.add(resourceBundle);
        }
    }

    private static void findAndAddBaseBundles(String string, Locale locale, List<ResourceBundle> list) {
        list.add(locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string));
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string + NO_TRANSLATION_SUFFIX, ROOT_LOCALE);
            if (resourceBundle != null) {
                list.add(resourceBundle);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static void findAndAddBundle(File file, Locale locale, String string, List<ResourceBundle> list) {
        ResourceBundle resourceBundle = PluginReaderStack.findResourceBundle(file, locale, string);
        if (resourceBundle != null) {
            list.add(resourceBundle);
        }
    }

    public void setTargetLocation(String string, File file) {
        this.fTargetLocations.put(string, file);
    }

    public void setExternalProductLocation(String string, File file) {
        this.fExternalProductLocations.put(string, file);
    }

    public File getTargetLocation() {
        for (XmlReader xmlReader : this.fReaders) {
            if (!xmlReader.getCurrentElementName().equals("target") || xmlReader.readAttribute("key") == null) continue;
            return this.fTargetLocations.get(xmlReader.readAttribute("key"));
        }
        return null;
    }

    public File getExternalProductLocation() {
        for (XmlReader xmlReader : this.fReaders) {
            if (!xmlReader.getCurrentElementName().equals("product") || xmlReader.readAttribute("key") == null) continue;
            return this.fExternalProductLocations.get(xmlReader.readAttribute("key"));
        }
        return null;
    }

    public XmlReader getTopReader() {
        return this.fReaders.get(0);
    }

    public PluginReaderStack push(XmlReader xmlReader) {
        return new PluginReaderStack(this, xmlReader);
    }

    public String getProductKey() {
        for (int i = this.fReaders.size() - 1; i >= 0; --i) {
            XmlReader xmlReader = this.fReaders.get(i);
            if (!xmlReader.getCurrentElementName().equals("product")) continue;
            return xmlReader.readAttribute("key");
        }
        return null;
    }

    public Icon getIcon(String string) {
        File file;
        if (string == null) {
            return null;
        }
        if (this.fPluginRoot == null) {
            String string2 = this.fIconResourcePath + "/" + string;
            URL uRL = this.getClass().getResource(string2);
            if (uRL == null) {
                throw new IllegalArgumentException(string2);
            }
            return new ImageIcon(uRL);
        }
        String string3 = this.getProductKey();
        if (string3 != null && (file = new File(new File(new File(this.fPluginRoot, string3), "resources"), string)).exists()) {
            return new LazyIcon(file.getAbsolutePath().replace(File.separatorChar, '/'));
        }
        file = new File(new File(this.fPluginRoot, "resources"), string);
        if (file.exists()) {
            return new LazyIcon(file.getAbsolutePath().replace(File.separatorChar, '/'));
        }
        return null;
    }

    @Override
    public String getResource(String string) {
        return this.getResource(string, true);
    }

    @Override
    public String getResource(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        for (ResourceBundle resourceBundle : bl ? this.fResources : this.fEnglishResources) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    public XmlReader findChild(String ... stringArray) {
        XmlReader xmlReader = null;
        for (XmlReader xmlReader2 : this.fReaders) {
            xmlReader = xmlReader2.getChild(stringArray);
            if (!xmlReader.isPresent()) continue;
            return xmlReader;
        }
        return xmlReader;
    }

    public XmlReader findChildWithAttribute(String string, String string2, String string3) {
        List<XmlReader> list = this.findChildrenWithAttribute(string, string2, string3);
        return !list.isEmpty() ? list.get(0) : new XmlReaderImpl((XmlReaderImpl)this.fReaders.get(0), null);
    }

    public boolean findNearestAttributeFlag(String string) {
        String string2 = this.findNearestAttribute(string);
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    public String findNearestAttribute(String string) {
        for (XmlReader xmlReader : this.fReaders) {
            String string2 = xmlReader.readAttribute(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public XmlReader findBottomChildWithAttribute(String string, String string2, String string3) {
        List<XmlReader> list = this.findChildrenWithAttribute(string, string2, string3);
        return !list.isEmpty() ? list.get(list.size() - 1) : new XmlReaderImpl((XmlReaderImpl)this.fReaders.get(0), null);
    }

    public XmlReader findTopNonEmptyChildWithAttribute(String string, String string2, String string3) {
        List<XmlReader> list = this.findChildrenWithAttribute(string, string2, string3);
        for (XmlReader xmlReader : list) {
            if (!xmlReader.getChild(new String[0]).isPresent()) continue;
            return xmlReader;
        }
        return new XmlReaderImpl((XmlReaderImpl)this.fReaders.get(0), null);
    }

    public List<XmlReader> findChildrenWithAttribute(String string, final String string2, final String string3) {
        final ArrayList<XmlReader> arrayList = new ArrayList<XmlReader>();
        for (XmlReader xmlReader : this.fReaders) {
            xmlReader.loop(new XmlLooper(){

                public void iterate(XmlReader xmlReader) {
                    if (xmlReader.readAttribute(string2) != null && xmlReader.readAttribute(string2).equals(string3)) {
                        arrayList.add(xmlReader);
                    }
                }
            }, new String[]{string});
        }
        return arrayList;
    }

    private static ResourceBundle findJARResourceBundle(final String string, Locale locale, String string2) {
        try {
            return ResourceBundle.getBundle(string2, locale, new ClassLoader(){

                @Override
                protected URL findResource(String string2) {
                    URL uRL = BuiltInResources.class.getResource(string + '/' + string2.replace('/', '_'));
                    return uRL;
                }
            });
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static ResourceBundle findResourceBundle(final File file, Locale locale, String string) {
        try {
            return ResourceBundle.getBundle(string, locale, new ClassLoader(){

                @Override
                protected URL findResource(String string) {
                    try {
                        File file2 = new File(file, string.replace('/', '.'));
                        return file2.exists() ? new URL("file", "localhost", file2.getAbsolutePath().replace(File.separatorChar, '/')) : null;
                    }
                    catch (IOException iOException) {
                        Log.logException((Exception)iOException);
                        return null;
                    }
                }
            });
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String[] findAllKeys(String string) {
        final ArrayList arrayList = new ArrayList();
        for (XmlReader xmlReader : this.fReaders) {
            xmlReader.loop(new XmlLooper(){

                public void iterate(XmlReader xmlReader) {
                    if (xmlReader.readAttribute("key") != null) {
                        arrayList.add(xmlReader.readAttribute("key"));
                    }
                }
            }, new String[]{string});
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public List<XmlReader> getReaders() {
        return new ArrayList<XmlReader>(this.fReaders);
    }

    public List<ResourceBundle> getResources() {
        return new ArrayList<ResourceBundle>(this.fResources);
    }

    public String readResourceFile(String string) {
        try {
            InputStream inputStream;
            if (this.fPluginRoot != null) {
                File file = new File(new File(this.fPluginRoot, "resources"), string);
                if (!file.exists()) {
                    return null;
                }
                inputStream = new FileInputStream(file);
            } else {
                inputStream = this.getClass().getResourceAsStream(this.fResourcePath + "/" + string);
                if (inputStream == null) {
                    return null;
                }
            }
            return StringUtils.read(inputStream);
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
            return null;
        }
    }
}

