/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;

public final class BrowseUtils {
    private BrowseUtils() {
    }

    public static File[] browseFile(Component component, boolean bl, File file, List<FileSetFilter> list) {
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            return DeployToolTestUtils.showSimpleFileChooser();
        }
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
        Object object = list.iterator();
        while (object.hasNext()) {
            FileSetFilter fileSetFilter = object.next();
            mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)fileSetFilter);
        }
        if (!list.isEmpty()) {
            mJFileChooserPerPlatform.setFileFilterIndex(0);
        }
        Object object2 = object = file == null ? null : file.getParentFile();
        if (object != null && ((File)object).exists()) {
            mJFileChooserPerPlatform.setCurrentDirectory((File)object);
        } else {
            mJFileChooserPerPlatform.setCurrentDirectory(MatlabPath.getCurrentDirectory());
        }
        mJFileChooserPerPlatform.setSelectedFile(file);
        mJFileChooserPerPlatform.setMultiSelectionEnabled(bl);
        mJFileChooserPerPlatform.showOpenDialog((Component)SwingUtilities.windowForComponent(component));
        if (mJFileChooserPerPlatform.getState() != 1) {
            File[] fileArray;
            if (bl) {
                fileArray = mJFileChooserPerPlatform.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = mJFileChooserPerPlatform.getSelectedFile();
            }
            return fileArray;
        }
        return null;
    }

    public static void browseFolder(Component component, File file, ParameterRunnable<File> parameterRunnable) {
        BrowseUtils.browseFolder(component, file, parameterRunnable, null);
    }

    public static void browseFolder(Component component, File file, ParameterRunnable<File> parameterRunnable, Runnable runnable) {
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
            if (fileArray != null) {
                if (fileArray.length != 1) {
                    throw new IllegalStateException("Only one directory can be selected at once here");
                }
                parameterRunnable.run((Object)fileArray[0]);
            }
            if (runnable != null) {
                runnable.run();
            }
        } else {
            File file2 = file;
            if (file == null || !file.exists() || !file.isDirectory()) {
                file2 = MatlabPath.getCurrentDirectory();
            }
            String string = BuiltInResources.getString("settings.folderbrowse.prompt");
            if (!PlatformInfo.isWindows()) {
                string = MJUtilities.intlString((String)"dialog.MJFolderChooser.Title");
            }
            MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
            mJFileChooserPerPlatform.setDialogTitle(string);
            if (file2.exists() && file2.isDirectory()) {
                mJFileChooserPerPlatform.setCurrentDirectory(file2);
            }
            mJFileChooserPerPlatform.setFileSelectionMode(1);
            mJFileChooserPerPlatform.showOpenDialog((Component)SwingUtilities.windowForComponent(component));
            if (mJFileChooserPerPlatform.getState() == 0) {
                parameterRunnable.run((Object)mJFileChooserPerPlatform.getSelectedFile());
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }
}

