/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTable;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.desktop.DocumentHeaderPanel;
import com.mathworks.project.impl.desktop.RoundedCornerPanel;
import com.mathworks.project.impl.desktop.TwistOpenPanel;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.SupportPackageData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.RoundRectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SupportPackageWidget
extends AbstractParamWidget<List<String>> {
    private Map<String, SupportPackageData> fSupportPackageMap;
    private MJPanel fPanel;
    private MJTable fTable;
    private SupportPackageTableModel fModel;
    private ParamWidget fInstallNotes;
    private String fInstallNotesHeader = BuiltInResources.getString("thirdparty.info.header");
    private String fInstallNotesTooltip = null;
    private TwistOpenPanel fAdditionalInstallOptsPanel = null;
    ImageIcon fNotesIcon;

    public SupportPackageWidget(Param param, Project project, ParamWidget paramWidget, TwistOpenPanel twistOpenPanel) {
        this.fNotesIcon = new ImageIcon(this.getClass().getResource("/com/mathworks/project/impl/resources/notes_16.png"));
        this.fInstallNotesTooltip = BuiltInResources.getString("thirdparty.notes.tooltip");
        this.fSupportPackageMap = new HashMap<String, SupportPackageData>();
        this.fInstallNotes = paramWidget;
        this.fAdditionalInstallOptsPanel = twistOpenPanel;
        this.initializeAndLayoutTable();
        DetailedToolTip.install(this.getComponent(), project.getConfiguration(), param);
        if (project.getConfiguration().getParamAsStringList(param.getKey()) != null && !project.getConfiguration().getParamAsStringList(param.getKey()).isEmpty()) {
            this.setData(project.getConfiguration().getParamAsStringList(param.getKey()));
        } else {
            this.fPanel.setVisible(false);
        }
    }

    public SupportPackageWidget(Param param, Project project) {
        this.fSupportPackageMap = new HashMap<String, SupportPackageData>();
        this.fInstallNotes = null;
        this.fAdditionalInstallOptsPanel = null;
        this.fInstallNotesTooltip = BuiltInResources.getString("mps.thirdparty.notes.tooltip");
        this.fNotesIcon = new ImageIcon(this.getClass().getResource("/com/mathworks/project/impl/resources/notes_16.png"));
        this.initializeAndLayoutTable();
        DetailedToolTip.install(this.getComponent(), project.getConfiguration(), param);
        if (project.getConfiguration().getParamAsStringList(param.getKey()) != null && !project.getConfiguration().getParamAsStringList(param.getKey()).isEmpty()) {
            this.setData(project.getConfiguration().getParamAsStringList(param.getKey()));
        } else {
            this.fPanel.setVisible(false);
        }
    }

    public void setData(List<String> list) {
        for (String string : list) {
            try {
                SupportPackageData supportPackageData = new SupportPackageData(string);
                if (this.fSupportPackageMap.containsKey(supportPackageData.getName())) continue;
                this.addPackageEntry(supportPackageData.getName(), supportPackageData);
            }
            catch (DataFormatException dataFormatException) {}
        }
        this.setInstallNotes();
        this.fPanel.setVisible(!this.fSupportPackageMap.isEmpty());
    }

    private void initializeAndLayoutTable() {
        this.fPanel = new MJPanel((LayoutManager)new BorderLayout());
        Object[] objectArray = new String[]{"", BuiltInResources.getString("support.package.column.package"), BuiltInResources.getString("support.package.column.product"), BuiltInResources.getString("support.package.column.notes")};
        this.fModel = new SupportPackageTableModel(objectArray);
        this.fTable = new MJTable((TableModel)this.fModel);
        this.fTable.setRowSelectionAllowed(false);
        this.fTable.setRowHeight(24);
        this.fTable.setColumnSelectionAllowed(false);
        this.fTable.setShowHorizontalLines(false);
        this.fTable.setShowVerticalLines(false);
        this.fTable.getColumnModel().setColumnMargin(10);
        this.fTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.fTable.enableDragHandling(false);
        this.fTable.setBackground(Color.WHITE);
        this.fTable.getColumnModel().getColumn(3).setMaxWidth(100);
        this.fTable.getColumnModel().getColumn(3).setCellRenderer(new MJTableImageRenderer());
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = SupportPackageWidget.this.fTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = SupportPackageWidget.this.fTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 == 3) {
                    SupportPackageWidget.this.showThirdPartyNotes(n);
                }
            }
        });
        JTableHeader jTableHeader = this.fTable.getTableHeader();
        jTableHeader.getColumnModel().setColumnMargin(10);
        jTableHeader.getColumnModel().getColumn(0).setMaxWidth(30);
        jTableHeader.setFont(new Font("Arial", 0, 12));
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setEnabled(false);
        this.fPanel.add((Component)((Object)new DocumentHeaderPanel(BuiltInResources.getString("support.package.suggested"))), (Object)"North");
        this.fPanel.add((Component)jTableHeader, (Object)"Center");
        this.fPanel.add((Component)this.fTable, (Object)"South");
        this.fPanel.setBorder(BorderFactory.createLineBorder(new Color(223, 224, 222)));
    }

    public void showThirdPartyNotes(int n) {
        String string = (String)this.fModel.getValueAt(n, 3);
        if (string != null) {
            String string2 = MessageFormat.format(BuiltInResources.getString("thirdparty.notes.summary.archive"), this.fSupportPackageMap.get(this.fModel.fData.get(n)).getDisplayName());
            if (this.fAdditionalInstallOptsPanel != null) {
                this.fAdditionalInstallOptsPanel.toggle(true);
                string2 = MessageFormat.format(BuiltInResources.getString("thirdparty.notes.summary"), this.fSupportPackageMap.get(this.fModel.fData.get(n)).getDisplayName());
            }
            final RoundedCornerFrame roundedCornerFrame = new RoundedCornerFrame();
            roundedCornerFrame.setName("thirdparty.info.frame");
            roundedCornerFrame.setUndecorated(true);
            roundedCornerFrame.setBackground(SectionPanel.APP_INNER_BACKGROUND);
            roundedCornerFrame.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent windowEvent) {
                    roundedCornerFrame.hide();
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
            roundedCornerFrame.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
            roundedCornerFrame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    roundedCornerFrame.hide();
                }
            });
            int n2 = 250;
            int n3 = 80;
            Font font = this.fPanel.getFont();
            JTextArea jTextArea = new JTextArea(string2);
            jTextArea.setSize(n2, n3);
            jTextArea.setEditable(false);
            jTextArea.setFont(font);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setOpaque(false);
            FontMetrics fontMetrics = jTextArea.getFontMetrics(font);
            int n4 = fontMetrics.getHeight();
            int n5 = font.getSize();
            int n6 = n4 + (n4 - n5);
            Dimension dimension = jTextArea.getPreferredSize();
            while (dimension.height > n6 + n4) {
                jTextArea.setSize(n2 += 10, n3);
                dimension = jTextArea.getPreferredSize();
            }
            JTextArea jTextArea2 = new JTextArea(this.fSupportPackageMap.get(this.fModel.fData.get(n)).getThirdPartyInfoSummary());
            jTextArea2.setSize(n2, n3);
            jTextArea2.setFont(font);
            jTextArea2.setLineWrap(true);
            jTextArea2.setWrapStyleWord(true);
            jTextArea2.setOpaque(false);
            int n7 = this.fSupportPackageMap.get(this.fModel.fData.get(n)).getThirdPartyCount();
            int n8 = n6 + (n7 - 1) * n4;
            Dimension dimension2 = jTextArea2.getPreferredSize();
            while (dimension2.height > n8) {
                jTextArea2.setSize(n2 += 10, n3);
                dimension2 = jTextArea2.getPreferredSize();
            }
            jTextArea2.setSize(n2, dimension2.height);
            jTextArea.setSize(n2, dimension.height);
            dimension = jTextArea.getPreferredSize();
            jTextArea.setSize(n2, dimension.height);
            RoundedCornerPanel roundedCornerPanel = new RoundedCornerPanel();
            FormLayout formLayout = new FormLayout("10px, left:pref:grow, 10px", "8px, pref, 2px, pref, 8px");
            CellConstraints cellConstraints = new CellConstraints();
            roundedCornerPanel.setLayout((LayoutManager)formLayout);
            roundedCornerPanel.add(jTextArea, cellConstraints.xy(2, 2));
            roundedCornerPanel.add(jTextArea2, cellConstraints.xy(2, 4));
            Dimension dimension3 = roundedCornerPanel.getPreferredSize();
            roundedCornerFrame.setSize(dimension3);
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point point = pointerInfo.getLocation();
            roundedCornerFrame.setLocation((int)point.getX() - dimension3.width, (int)point.getY() - dimension3.height);
            roundedCornerFrame.add((Component)((Object)roundedCornerPanel));
            roundedCornerFrame.setVisible(true);
        }
    }

    public void updatePackageList(Map<String, SupportPackageData> map) {
        String string2;
        for (String object2 : map.keySet()) {
            if (this.fSupportPackageMap.containsKey(object2)) continue;
            this.addPackageEntry(object2, map.get(object2));
        }
        Set<String> set = this.fSupportPackageMap.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (map.containsKey(string2)) continue;
            arrayList.add(string2);
        }
        for (String string2 : arrayList) {
            this.fSupportPackageMap.remove(string2);
        }
        this.fModel.clearAll();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            this.fModel.addRow(string2);
        }
        this.setInstallNotes();
        this.fModel.fireTableDataChanged();
        this.fireListeners();
        if (this.fSupportPackageMap.isEmpty()) {
            this.fPanel.setVisible(false);
        } else {
            this.fPanel.setVisible(true);
        }
    }

    private void addPackageEntry(String string, SupportPackageData supportPackageData) {
        this.fSupportPackageMap.put(string, supportPackageData);
        this.fModel.addRow(string);
    }

    public void enableSupportPackage(String string, boolean bl) {
        if (this.fSupportPackageMap.containsKey(string)) {
            this.fSupportPackageMap.get(string).setEnabled(bl);
            this.setInstallNotes();
            this.fireListeners();
        }
    }

    private void setInstallNotes() {
        if (this.fInstallNotes != null) {
            String string = "";
            boolean bl = false;
            for (String string2 : this.fSupportPackageMap.keySet()) {
                if (!this.fSupportPackageMap.get(string2).getEnabled() || !this.fSupportPackageMap.get(string2).hasThirdPartyDependencies()) continue;
                string = string + this.fSupportPackageMap.get(string2).getThirdPartyInfo();
            }
            Object object = (String)this.fInstallNotes.getData();
            int n = ((String)object).indexOf(this.fInstallNotesHeader);
            if (n != -1) {
                object = ((String)object).substring(0, n);
                bl = true;
            }
            if (!string.isEmpty()) {
                bl = true;
                object = (String)object + this.fInstallNotesHeader + "\n" + string;
            }
            if (bl) {
                this.fInstallNotes.setData(object);
            }
        }
    }

    public List<String> getSupportPackageKeys() {
        return new ArrayList<String>(this.fSupportPackageMap.keySet());
    }

    public boolean getEnabledofSupportPackage(String string) {
        return this.fSupportPackageMap.get(string).getEnabled();
    }

    public String getProductofSupportPackage(String string) {
        return this.fSupportPackageMap.get(string).getProduct();
    }

    public String getNameofSupportPackage(String string) {
        return this.fSupportPackageMap.get(string).getName();
    }

    public String getDisplayNameofSupportPackage(String string) {
        return this.fSupportPackageMap.get(string).getDisplayName();
    }

    public List<String> getModelData() {
        return this.fModel.fData;
    }

    public void setEnabled(boolean bl) {
    }

    public List<String> getData() {
        ArrayList<String> arrayList = new ArrayList<String>(this.fSupportPackageMap.size());
        for (String string : this.fSupportPackageMap.keySet()) {
            arrayList.add(this.fSupportPackageMap.get(string).toString());
        }
        return arrayList;
    }

    public Component getComponent() {
        return this.fPanel;
    }

    class RoundedCornerFrame
    extends MJFrame {
        RoundedCornerFrame() {
            super(BuiltInResources.getString("thirdparty.info.frame"));
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    RoundedCornerFrame.this.setShape(new RoundRectangle2D.Double(0.0, 0.0, RoundedCornerFrame.this.getWidth(), RoundedCornerFrame.this.getHeight(), 20.0, 20.0));
                }
            });
        }
    }

    private class SupportPackageTableModel
    extends DefaultTableModel {
        List<String> fData;
        int fColumnCnt;

        SupportPackageTableModel(Object[] objectArray) {
            super((Object[][])null, objectArray);
            this.fColumnCnt = objectArray.length;
            this.clearAll();
        }

        void addRow(String string) {
            this.fData.add(string);
        }

        void clearAll() {
            this.fData = new ArrayList<String>();
        }

        @Override
        public int getRowCount() {
            return this.fData == null ? 0 : this.fData.size();
        }

        @Override
        public int getColumnCount() {
            return this.fColumnCnt;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ((SupportPackageData)SupportPackageWidget.this.fSupportPackageMap.get(this.fData.get(n))).getEnabled();
                }
                case 1: {
                    return ((SupportPackageData)SupportPackageWidget.this.fSupportPackageMap.get(this.fData.get(n))).getDisplayName();
                }
                case 2: {
                    return ((SupportPackageData)SupportPackageWidget.this.fSupportPackageMap.get(this.fData.get(n))).getProduct();
                }
                case 3: {
                    if (((SupportPackageData)SupportPackageWidget.this.fSupportPackageMap.get(this.fData.get(n))).hasThirdPartyDependencies()) {
                        return SupportPackageWidget.this.fInstallNotesTooltip;
                    }
                    return null;
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            assert (n2 == 0 && object instanceof Boolean);
            SupportPackageWidget.this.enableSupportPackage(this.fData.get(n), (Boolean)object);
        }
    }

    private class MJTableImageRenderer
    extends JLabel
    implements TableCellRenderer {
        private MJTableImageRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setToolTipText((String)object);
                this.setIcon(SupportPackageWidget.this.fNotesIcon);
            } else {
                this.setIcon(null);
                this.setToolTipText(null);
            }
            this.setOpaque(false);
            return this;
        }
    }
}

