/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.ParamUtils;
import com.mathworks.project.impl.settingsui.table.ComboBoxCellEditor;
import com.mathworks.project.impl.settingsui.table.ListCellEditor;
import com.mathworks.project.impl.settingsui.table.MultilineTextCellEditor;
import com.mathworks.project.impl.settingsui.table.SimpleCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;

public class DefaultSettingsTableCellEditorFactory
implements PropertyTableCellEditorFactory<Param> {
    private final Configuration fConfiguration;

    public DefaultSettingsTableCellEditorFactory(Configuration configuration) {
        this.fConfiguration = configuration;
    }

    @Override
    public PropertyTableCellEditor<Param> createWidget(PropertyTable<Param> propertyTable, int n, int n2, Param param) {
        if (param.getType().isFinite()) {
            return ComboBoxCellEditor.create(propertyTable, this.fConfiguration, param);
        }
        switch (param.getType()) {
            case FILE_LIST: 
            case DIR_LIST: 
            case STRING_LIST: {
                return new ListCellEditor(propertyTable, this.fConfiguration, param);
            }
            case STRING: {
                if (ParamUtils.getStringParamLines(param) > 1) {
                    return new MultilineTextCellEditor(propertyTable, n, n2, this.fConfiguration, param);
                }
            }
            case INT: 
            case DECIMAL: {
                return SimpleCellEditor.create(propertyTable, this.fConfiguration, param);
            }
        }
        throw new IllegalArgumentException("Cannot create editing widget for " + param.getKey() + " because " + (Object)((Object)param.getType()) + " is not supported");
    }
}

