/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class AbstractMacPopupCellEditor<T>
implements PropertyTableCellEditor<T> {
    private final PropertyTable<T> fTable;
    private final int fRow;
    private final int fColumn;

    public AbstractMacPopupCellEditor(PropertyTable<T> propertyTable, int n, int n2) {
        this.fTable = propertyTable;
        this.fRow = n;
        this.fColumn = n2;
    }

    @Override
    public final void loadData(Object object, String string) {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        for (JMenuItem jMenuItem : this.createFiniteValueItems()) {
            mJPopupMenu.add(jMenuItem);
        }
        mJPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                AbstractMacPopupCellEditor.this.fTable.stopEditing(true);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        mJPopupMenu.setName(this.fTable.getComponent().getName() + ".editor");
        this.fTable.showPopupMenu((JPopupMenu)mJPopupMenu, this.fRow, this.fColumn);
    }

    @Override
    public final JComponent getComponent() {
        return null;
    }

    @Override
    public final void activate() {
    }

    @Override
    public void commitData() {
    }

    @Override
    public void dispose() {
    }

    protected void commitBooleanValue(boolean bl) {
    }

    protected boolean loadBooleanValue() {
        return false;
    }

    protected List<JMenuItem> createFiniteValueItems() {
        LinkedList<JMenuItem> linkedList = new LinkedList<JMenuItem>();
        MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(BuiltInResources.getString("param.boolean.true"));
        mJCheckBoxMenuItem.setFont(this.fTable.getFont());
        Boolean bl = this.loadBooleanValue();
        mJCheckBoxMenuItem.setSelected(bl != null && bl != false);
        mJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractMacPopupCellEditor.this.commitBooleanValue(true);
            }
        });
        MJCheckBoxMenuItem mJCheckBoxMenuItem2 = new MJCheckBoxMenuItem(BuiltInResources.getString("param.boolean.false"));
        mJCheckBoxMenuItem2.setFont(this.fTable.getFont());
        mJCheckBoxMenuItem2.setSelected(bl == null || bl == false);
        mJCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractMacPopupCellEditor.this.commitBooleanValue(false);
            }
        });
        linkedList.add((JMenuItem)mJCheckBoxMenuItem);
        linkedList.add((JMenuItem)mJCheckBoxMenuItem2);
        return linkedList;
    }
}

