/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.impl.settingsui.validation.BasicTextValidator;
import com.mathworks.project.impl.settingsui.validation.NumericRule;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.TextFieldUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public abstract class AbstractSimpleCellEditor<T>
implements PropertyTableCellEditor<T> {
    private final MJTextField fComponent = new MJTextField();
    private final PropertyTable<T> fTable;
    private final boolean fIsInteger;
    private final boolean fIsDecimal;
    private Object fOriginalValue;

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable) {
        this(propertyTable, false, false, null);
    }

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable, int n, int n2) {
        this(propertyTable, true, false, new NumericRule(n, n2, new DecimalFormat()));
    }

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable, boolean bl) {
        this(propertyTable, false, bl, null);
    }

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable, ValidationRule validationRule) {
        this(propertyTable, false, false, validationRule);
    }

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable, Class<?> clazz, ValidationRule validationRule) {
        this(propertyTable, clazz == Integer.class || clazz == Integer.TYPE, clazz == BigDecimal.class, validationRule);
    }

    private AbstractSimpleCellEditor(PropertyTable<T> propertyTable, boolean bl, boolean bl2, ValidationRule validationRule) {
        this.fComponent.setName(propertyTable.getName() + ".editor");
        this.fTable = propertyTable;
        this.fIsInteger = bl;
        this.fIsDecimal = bl2;
        this.fComponent.setFont(this.fTable.getFont());
        if (PlatformInfo.isMacintosh()) {
            this.fComponent.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AbstractSimpleCellEditor.this.fTable.stopEditing(false);
                }
            });
        }
        TextFieldUtils.installCommitAndCancelKeystrokes(propertyTable, (JTextField)this.fComponent);
        if (validationRule != null) {
            new BasicTextValidator((JTextComponent)this.fComponent, validationRule);
        }
    }

    public void setAlignment(int n) {
        this.getTextField().setHorizontalAlignment(n);
    }

    protected MJTextField getTextField() {
        return this.fComponent;
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void activate() {
    }

    public void selectAll() {
        this.fComponent.selectAll();
    }

    protected void setData(Object object, String string) {
        this.fOriginalValue = object;
        this.fComponent.setText(string);
    }

    protected Object getData() {
        if (this.fIsDecimal) {
            try {
                return new BigDecimal(this.fComponent.getText());
            }
            catch (RuntimeException runtimeException) {
                return this.fOriginalValue;
            }
        }
        if (!this.fIsInteger) {
            return this.fComponent.getText();
        }
        try {
            return new Integer(this.fComponent.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return this.fOriginalValue;
        }
    }
}

