/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertyTableModel<T> {
    private final List<PropertyTableNode<T>> fRows;
    private final List<PropertyTableColumn<T>> fColumns;
    private final Map<LinkKey<T>, JComponent> fLinks;
    private final MulticastChangeListener fListeners;
    private final Runnable fDisposer;
    private final Predicate<T> fEnabledPredicate;
    private final PropertyTableSearchPredicate<T> fSearchPredicate;
    private List<PropertyTableNode<T>> fBackupRows;
    private String fSearchText;

    public PropertyTableModel(List<? extends PropertyTableColumn<T>> list, List<PropertyTableNode<T>> list2) {
        this(list, new PropertyTableSearchPredicate<T>(){

            @Override
            public boolean accept(T t, String string) {
                return false;
            }
        }, list2);
    }

    public PropertyTableModel(List<? extends PropertyTableColumn<T>> list, PropertyTableSearchPredicate<T> propertyTableSearchPredicate, List<PropertyTableNode<T>> list2) {
        this(list, new Runnable(){

            @Override
            public void run() {
            }
        }, new Predicate<T>(){

            public boolean accept(T t) {
                return true;
            }
        }, propertyTableSearchPredicate, list2);
    }

    public PropertyTableModel(List<? extends PropertyTableColumn<T>> list, Runnable runnable, Predicate<T> predicate, PropertyTableSearchPredicate<T> propertyTableSearchPredicate, List<PropertyTableNode<T>> list2) {
        this.fColumns = new ArrayList<PropertyTableColumn<T>>(list);
        this.fLinks = new HashMap<LinkKey<T>, JComponent>();
        this.fListeners = new MulticastChangeListener();
        this.fDisposer = runnable;
        this.fEnabledPredicate = predicate;
        this.fSearchPredicate = propertyTableSearchPredicate;
        this.fRows = new ArrayList<PropertyTableNode<T>>(list2);
    }

    public void setRootLevelRows(List<PropertyTableNode<T>> list) {
        this.fRows.clear();
        this.fRows.addAll(list);
        this.fBackupRows = null;
        this.fListeners.stateChanged(new ChangeEvent(this));
    }

    public void dispose() {
        this.fDisposer.run();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fListeners.removeChangeListener(changeListener);
    }

    public void fireChange() {
        this.fListeners.stateChanged(new ChangeEvent(this));
    }

    public List<PropertyTableColumn<T>> getColumns() {
        return new ArrayList<PropertyTableColumn<T>>(this.fColumns);
    }

    public PropertyTableColumn<T> getColumn(int n) {
        return this.fColumns.get(n);
    }

    public boolean isColumnEditable(int n) {
        return this.fColumns.get(n).isEditable();
    }

    public int getRowCount() {
        return this.fRows.size();
    }

    public int getColumnCount() {
        return this.fColumns.size();
    }

    public String getColumnText(int n, int n2) {
        if (!this.isValidRow(n)) {
            return "";
        }
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        if (!propertyTableNode.isLeaf()) {
            String string = propertyTableNode.getGroupLabel();
            return n2 == 0 ? string : "";
        }
        return this.fColumns.get(n2).getText(propertyTableNode.getValue(n2));
    }

    public PropertyTableDecorator<T> getColumnDecorator(int n) {
        PropertyTableColumn<T> propertyTableColumn = this.fColumns.get(n);
        return propertyTableColumn.getDecorator();
    }

    public JComponent getColumnLink(int n, int n2) {
        if (!this.isValidRow(n)) {
            return null;
        }
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        if (!propertyTableNode.isLeaf()) {
            return null;
        }
        T t = propertyTableNode.getValue(n2);
        PropertyTableColumn<T> propertyTableColumn = this.fColumns.get(n2);
        LinkKey<T> linkKey = new LinkKey<T>(propertyTableColumn, t);
        if (!this.fLinks.containsKey(linkKey)) {
            JComponent jComponent = propertyTableColumn.createLink(t);
            this.fLinks.put(linkKey, jComponent);
        }
        return this.fLinks.get(linkKey);
    }

    public void sort(int n, boolean bl, boolean bl2) {
        this.sort(null, this.fRows, this.fColumns.get(n), n, bl, bl2);
        this.fireChange();
    }

    private void sort(PropertyTableNode<T> propertyTableNode, List<PropertyTableNode<T>> list, final PropertyTableColumn<T> propertyTableColumn, final int n, final boolean bl, boolean bl2) {
        if (list.isEmpty()) {
            return;
        }
        boolean bl3 = false;
        if (bl2) {
            for (PropertyTableNode<T> propertyTableNode2 : list) {
                if (propertyTableNode2.getChildren().isEmpty()) continue;
                bl3 = true;
                break;
            }
        }
        if (!bl3) {
            Collections.sort(list, new Comparator<PropertyTableNode<T>>(){

                @Override
                public int compare(PropertyTableNode<T> propertyTableNode, PropertyTableNode<T> propertyTableNode2) {
                    Object t = propertyTableNode.getValue(n);
                    Object t2 = propertyTableNode2.getValue(n);
                    int n2 = propertyTableColumn.compareForAscendingSort(t, t2);
                    return bl ? -n2 : n2;
                }
            });
            if (propertyTableNode != null) {
                int n2 = this.fRows.indexOf(propertyTableNode);
                boolean bl4 = false;
                if (n2 >= 0) {
                    bl4 = this.isExpanded(n2);
                    this.setExpanded(n2, false);
                }
                propertyTableNode.setChildren(list);
                if (n2 >= 0 && bl4) {
                    this.setExpanded(n2, true);
                }
            }
        }
        for (PropertyTableNode<T> propertyTableNode2 : new ArrayList<PropertyTableNode<T>>(list)) {
            this.sort(propertyTableNode2, new ArrayList<PropertyTableNode<T>>(propertyTableNode2.getChildren()), propertyTableColumn, n, bl, bl2);
        }
    }

    public void replaceRow(int n, PropertyTableNode<T> propertyTableNode) {
        this.setExpanded(n, false);
        PropertyTableNode<T> propertyTableNode2 = this.fRows.get(n);
        if (propertyTableNode2.getParent() != null) {
            propertyTableNode2.getParent().replaceChild(propertyTableNode2, propertyTableNode);
        }
        this.fRows.set(n, propertyTableNode);
        this.fireChange();
    }

    public int addRootLevel(T t) {
        this.addRootLevel(this.fRows.size(), t);
        return this.fRows.size() - 1;
    }

    public PropertyTableNode<T> addRootLevelGroup(int n, String string) {
        PropertyTableNode propertyTableNode = new PropertyTableNode(null, true, string);
        this.fRows.add(n, propertyTableNode);
        this.fireChange();
        return propertyTableNode;
    }

    public void addRootLevel(int n, T t) {
        this.fRows.add(n, new PropertyTableNode<Object>(null, false, Arrays.asList(t)));
        this.fireChange();
    }

    public int addChild(int n, T t) {
        int n2;
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        for (n2 = n + 1; n2 < this.fRows.size() && this.fRows.get(n2).getParent() == propertyTableNode; ++n2) {
        }
        this.addChild(n, n2 - n - 1, t);
        return n2;
    }

    public void addChild(int n, int n2, T t) {
        PropertyTableNode<Object> propertyTableNode;
        PropertyTableNode<T> propertyTableNode2 = this.fRows.get(n);
        boolean bl = false;
        if ((n2 += n + 1) <= n && !(bl = true) && (propertyTableNode = this.fRows.get(n2 - 1)) != propertyTableNode2 && propertyTableNode.getParent() != propertyTableNode2) {
            bl = true;
        }
        if (bl) {
            throw new IllegalArgumentException(String.format("The specified child index is not contained within the parent row: childIndex=%d, row=%d", n2, n));
        }
        this.setExpanded(n, true);
        propertyTableNode = new PropertyTableNode<Object>(propertyTableNode2, false, Arrays.asList(t));
        this.fRows.add(n2, propertyTableNode);
        this.fireChange();
    }

    public int addChildBelow(int n, T t) {
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        PropertyTableNode<T> propertyTableNode2 = propertyTableNode.getParent();
        this.setExpanded(this.fRows.indexOf(propertyTableNode2), true);
        PropertyTableNode<T> propertyTableNode3 = propertyTableNode2.addBelow(propertyTableNode, t);
        this.fRows.add(n + 1, propertyTableNode3);
        this.fireChange();
        return n + 1;
    }

    public void remove(int n) {
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        this.fRows.remove(n);
        if (propertyTableNode.getParent() != null) {
            propertyTableNode.getParent().removeChild(propertyTableNode);
        }
        this.fireChange();
    }

    public PropertyTableNode<T> getParent(int n) {
        return this.fRows.get(n).getParent();
    }

    public String getColumnName(int n) {
        return this.fColumns.get(n).getName();
    }

    public boolean isPrimaryGroupHeader(int n) {
        if (!this.isValidRow(n)) {
            return false;
        }
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        return propertyTableNode.isPrimaryGroupNode();
    }

    public boolean isLeaf(int n) {
        return this.isValidRow(n) && this.fRows.get(n).isLeaf();
    }

    public List<T> getAllData() {
        LinkedList linkedList = new LinkedList();
        for (PropertyTableNode<T> propertyTableNode : this.fRows) {
            this.getAllData(propertyTableNode, linkedList);
        }
        return linkedList;
    }

    private void getAllData(PropertyTableNode<T> propertyTableNode, List<T> list) {
        for (T object : propertyTableNode.getColumnValues()) {
            list.add(object);
        }
        for (PropertyTableNode propertyTableNode2 : propertyTableNode.getChildren()) {
            this.getAllData(propertyTableNode2, list);
        }
    }

    public T getValue(int n, int n2) {
        if (n < 0 || n >= this.fRows.size()) {
            return null;
        }
        return this.fRows.get(n).getValue(n2);
    }

    public PropertyTableNode<T> getNode(int n) {
        return this.fRows.get(n);
    }

    public boolean isFinite(int n, int n2) {
        return this.isLeaf(n) && (this.fRows.get(n).isFinite() || this.fColumns.get(n2).isFinite());
    }

    public boolean isEnabled(int n, int n2) {
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        if (!propertyTableNode.isLeaf()) {
            return this.hasAnyEnabledDescendants(propertyTableNode);
        }
        T t = this.getValue(n, n2);
        return this.fEnabledPredicate.accept(t);
    }

    public boolean isExpandable(int n) {
        return !this.fRows.get(n).getChildren().isEmpty();
    }

    public boolean isExpanded(int n) {
        return this.isValidRow(n) && this.fRows.get(n).isExpanded();
    }

    public void expandAll() {
        for (int i = 0; i < this.fRows.size(); ++i) {
            if (!this.isExpandable(i)) continue;
            this.setExpanded(i, true);
        }
    }

    public void setExpanded(int n, boolean bl) {
        this.setExpanded(n, bl, true);
    }

    public int getNestLevel(int n) {
        return this.fRows.get(n).getNestLevel();
    }

    public String getSearchText() {
        return this.fSearchText;
    }

    public boolean matchesSearch(int n) {
        return this.fSearchText != null && !this.fSearchText.isEmpty() && this.fRows.get(n).isLeaf() && this.fRows.get(n).hasMatchingText(this.fSearchPredicate, this.fSearchText);
    }

    public void setSearchText(String string) {
        this.fSearchText = string;
        if ((string == null || string.length() == 0) && this.fBackupRows != null) {
            this.fRows.clear();
            this.fRows.addAll(this.fBackupRows);
            this.fBackupRows = null;
            this.fListeners.stateChanged(new ChangeEvent(this));
        } else if (string != null && string.length() > 0) {
            if (this.fBackupRows == null) {
                this.fBackupRows = new ArrayList<PropertyTableNode<T>>(this.fRows);
                this.expandAll();
            }
            this.fRows.clear();
            for (PropertyTableNode<T> propertyTableNode : this.fBackupRows) {
                PropertyTableNode<T> propertyTableNode2;
                if (propertyTableNode.getParent() != null || (propertyTableNode2 = this.copyMatching(null, propertyTableNode, string)) == null) continue;
                this.fRows.add(propertyTableNode2);
            }
            this.expandAll();
            this.fListeners.stateChanged(new ChangeEvent(this));
        }
    }

    private PropertyTableNode<T> copyMatching(PropertyTableNode<T> propertyTableNode, PropertyTableNode<T> propertyTableNode2, String string) {
        PropertyTableNode<T> propertyTableNode3 = new PropertyTableNode<T>(propertyTableNode, propertyTableNode2);
        for (PropertyTableNode<T> propertyTableNode4 : propertyTableNode2.getChildren()) {
            this.copyMatching(propertyTableNode3, propertyTableNode4, string);
        }
        if (propertyTableNode3.hasMatchingText(this.fSearchPredicate, string) || !propertyTableNode3.getChildren().isEmpty()) {
            return propertyTableNode3;
        }
        if (propertyTableNode != null) {
            propertyTableNode.removeChild(propertyTableNode3);
        }
        return null;
    }

    private void setExpanded(int n, boolean bl, boolean bl2) {
        PropertyTableNode<T> propertyTableNode = this.fRows.get(n);
        if (bl != propertyTableNode.isExpanded()) {
            propertyTableNode.setExpanded(bl, bl2);
            if (!bl) {
                for (int i = 0; i < propertyTableNode.getChildren().size(); ++i) {
                    this.setExpanded(n + 1, false, false);
                    this.fRows.remove(n + 1);
                }
            } else {
                int n2 = 0;
                for (PropertyTableNode<T> propertyTableNode2 : propertyTableNode.getChildren()) {
                    this.fRows.add(n + 1 + n2++, propertyTableNode2);
                    if (!propertyTableNode2.isExpandedOnParentExpand()) continue;
                    int n3 = this.fRows.size();
                    this.setExpanded(n + 1 + n2 - 1, true, false);
                    n2 += this.fRows.size() - n3;
                }
            }
        }
        this.fireChange();
    }

    private boolean isValidRow(int n) {
        return n >= 0 && n < this.fRows.size();
    }

    private boolean hasAnyEnabledDescendants(PropertyTableNode<T> propertyTableNode) {
        for (PropertyTableNode<T> propertyTableNode2 : propertyTableNode.getChildren()) {
            if (propertyTableNode2.isLeaf()) {
                for (int i = 1; i < this.fColumns.size(); ++i) {
                    T t = propertyTableNode2.getValue(i);
                    if (!this.fEnabledPredicate.accept(t)) continue;
                    return true;
                }
                continue;
            }
            if (!this.hasAnyEnabledDescendants(propertyTableNode2)) continue;
            return true;
        }
        return false;
    }

    private static class LinkKey<T> {
        private final PropertyTableColumn<T> fColumn;
        private final T fValue;

        LinkKey(PropertyTableColumn<T> propertyTableColumn, T t) {
            this.fColumn = propertyTableColumn;
            this.fValue = t;
        }

        public boolean equals(Object object) {
            return object instanceof LinkKey && this.fValue.equals(((LinkKey)object).fValue) && this.fColumn.equals(((LinkKey)object).fColumn);
        }

        public int hashCode() {
            return this.fValue.hashCode() + this.fColumn.hashCode();
        }
    }
}

