/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PropertyTableNode<T> {
    private final String fGroupLabel;
    private final boolean fPrimaryGroupNode;
    private final boolean fFinite;
    private final List<T> fColumnValues;
    private final List<PropertyTableNode<T>> fChildren;
    private PropertyTableNode<T> fParent;
    private int fNestLevel;
    private boolean fExpanded;
    private boolean fExpandOnParentExpand;

    public PropertyTableNode(PropertyTableNode<T> propertyTableNode, boolean bl, String string) {
        this.fParent = propertyTableNode;
        this.fNestLevel = PropertyTableNode.calculateNestLevel(propertyTableNode, bl);
        this.fPrimaryGroupNode = bl;
        this.fGroupLabel = string;
        this.fColumnValues = new ArrayList<T>(0);
        this.fFinite = false;
        this.fChildren = new ArrayList<PropertyTableNode<T>>();
        if (propertyTableNode != null) {
            super.addChild(this);
        }
    }

    public PropertyTableNode(PropertyTableNode<T> propertyTableNode, boolean bl, List<T> list) {
        this.fParent = propertyTableNode;
        this.fFinite = bl;
        this.fNestLevel = PropertyTableNode.calculateNestLevel(propertyTableNode, false);
        this.fColumnValues = new ArrayList<T>(list);
        this.fChildren = new ArrayList<PropertyTableNode<T>>();
        this.fGroupLabel = null;
        this.fPrimaryGroupNode = false;
        if (propertyTableNode != null) {
            super.addChild(this);
        }
    }

    public PropertyTableNode(PropertyTableNode<T> propertyTableNode, PropertyTableNode<T> propertyTableNode2) {
        this.fParent = propertyTableNode;
        this.fNestLevel = propertyTableNode2.getNestLevel();
        this.fGroupLabel = propertyTableNode2.getGroupLabel();
        this.fPrimaryGroupNode = propertyTableNode2.isPrimaryGroupNode();
        this.fFinite = propertyTableNode2.isFinite();
        this.fColumnValues = new ArrayList<T>(propertyTableNode2.getColumnValues());
        this.fChildren = new ArrayList<PropertyTableNode<T>>();
        if (propertyTableNode != null) {
            super.addChild(this);
        }
    }

    public int getNestLevel() {
        return this.fNestLevel;
    }

    public String getGroupLabel() {
        return this.fGroupLabel;
    }

    public boolean isPrimaryGroupNode() {
        return this.fPrimaryGroupNode;
    }

    public boolean hasMatchingText(PropertyTableSearchPredicate<T> propertyTableSearchPredicate, String string) {
        for (T t : this.fColumnValues) {
            if (!propertyTableSearchPredicate.accept(t, string)) continue;
            return true;
        }
        return false;
    }

    private void addChild(PropertyTableNode<T> propertyTableNode) {
        this.fChildren.add(propertyTableNode);
    }

    public void replaceChild(PropertyTableNode<T> propertyTableNode, PropertyTableNode<T> propertyTableNode2) {
        int n = this.fChildren.indexOf(propertyTableNode);
        this.fChildren.set(n, propertyTableNode2);
        propertyTableNode2.fParent = this;
        propertyTableNode2.fNestLevel = PropertyTableNode.calculateNestLevel(this, false);
    }

    public void removeChild(PropertyTableNode<T> propertyTableNode) {
        this.fChildren.remove(propertyTableNode);
    }

    public PropertyTableNode<T> getParent() {
        return this.fParent;
    }

    public boolean isLeaf() {
        return !this.fColumnValues.isEmpty();
    }

    public List<T> getColumnValues() {
        return new ArrayList<T>(this.fColumnValues);
    }

    public boolean isFinite() {
        return this.fFinite;
    }

    public T getValue(int n) {
        if (this.fColumnValues.isEmpty()) {
            return null;
        }
        return this.fColumnValues.get(Math.min(this.fColumnValues.size() - 1, Math.max(0, n - 1)));
    }

    public boolean isExpanded() {
        return this.fExpanded;
    }

    public void setExpanded(boolean bl, boolean bl2) {
        this.fExpandOnParentExpand = !bl2 && this.fExpanded && !bl;
        this.fExpanded = bl;
    }

    public boolean isExpandedOnParentExpand() {
        return this.fExpandOnParentExpand;
    }

    public List<PropertyTableNode<T>> getChildren() {
        return Collections.unmodifiableList(this.fChildren);
    }

    public void setChildren(List<PropertyTableNode<T>> list) {
        this.fChildren.clear();
        this.fChildren.addAll(list);
    }

    public PropertyTableNode<T> addBelow(PropertyTableNode<T> propertyTableNode, T t) {
        PropertyTableNode<Object> propertyTableNode2 = new PropertyTableNode<Object>(this, false, Arrays.asList(t));
        this.fChildren.remove(propertyTableNode2);
        this.fChildren.add(this.fChildren.indexOf(propertyTableNode) + 1, propertyTableNode2);
        return propertyTableNode2;
    }

    private static <T> int calculateNestLevel(PropertyTableNode<T> propertyTableNode, boolean bl) {
        if (propertyTableNode == null) {
            return bl ? 0 : 1;
        }
        return propertyTableNode.getNestLevel() + 1;
    }
}

