/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectionModel {
    private final Predicate<Integer> fSelectable;
    private final Set<Integer> fSelectedRows;
    private final MulticastChangeListener fChangeListeners;
    private boolean fAllowSelect;
    private boolean fAllowMultiselect;
    private Expansion fExpansion;
    private int fFocusedRow;

    public SelectionModel(Predicate<Integer> predicate) {
        this.fSelectable = predicate;
        this.fSelectedRows = new HashSet<Integer>();
        this.fChangeListeners = new MulticastChangeListener();
        this.fFocusedRow = -1;
        this.fAllowSelect = true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public int getFocusedRow() {
        return this.fFocusedRow;
    }

    public int getSelectedRow() {
        if (this.fSelectedRows.isEmpty()) {
            return -1;
        }
        if (this.fSelectedRows.contains(this.fFocusedRow)) {
            return this.fFocusedRow;
        }
        return this.fSelectedRows.iterator().next();
    }

    public Set<Integer> getSelectedRows() {
        return new TreeSet<Integer>(this.fSelectedRows);
    }

    public int getSelectedRowCount() {
        return this.fSelectedRows.size();
    }

    public void setAllowSelect(boolean bl) {
        this.fAllowSelect = bl;
        if (!this.fAllowSelect) {
            this.fFocusedRow = -1;
            this.fSelectedRows.clear();
        }
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void setAllowMultiselect(boolean bl) {
        this.fAllowMultiselect = bl;
    }

    public boolean isSelected(int n) {
        return this.fSelectedRows.contains(n);
    }

    public boolean isFocused(int n) {
        return n == this.fFocusedRow;
    }

    public void clearSelection() {
        if (!this.fAllowSelect) {
            return;
        }
        this.fSelectedRows.clear();
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void selectAll(int n) {
        if (this.fAllowSelect && this.fAllowMultiselect) {
            for (int i = 0; i < n; ++i) {
                if (!this.fSelectable.accept((Object)i)) continue;
                this.fSelectedRows.add(i);
                this.fFocusedRow = i;
            }
            this.fChangeListeners.stateChanged(new ChangeEvent(this));
        }
    }

    public void select(int n) {
        if (this.fAllowSelect && n >= 0 && this.fSelectable.accept((Object)n)) {
            this.fSelectedRows.clear();
            this.fSelectedRows.add(n);
            this.fFocusedRow = n;
            this.fChangeListeners.stateChanged(new ChangeEvent(this));
        }
    }

    public void structureChanged(int n) {
        if (!this.fAllowSelect) {
            return;
        }
        Iterator<Integer> iterator = this.fSelectedRows.iterator();
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            if (n2 < n && this.fSelectable.accept((Object)n2)) continue;
            iterator.remove();
        }
        while (this.fFocusedRow > n || !this.fSelectable.accept((Object)this.fFocusedRow)) {
            this.fFocusedRow = Math.min(this.fFocusedRow - 1, n - 1);
        }
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void mousePressed(int n, boolean bl, boolean bl2) {
        if (!bl2) {
            this.fExpansion = null;
        }
        if (!this.fAllowSelect) {
            return;
        }
        if (!bl && !bl2) {
            this.fSelectedRows.clear();
        }
        if (bl && this.fSelectedRows.contains(n)) {
            this.fSelectedRows.remove(n);
        } else if (bl2 && this.fAllowMultiselect) {
            if (this.fExpansion == null) {
                this.fExpansion = new Expansion();
            }
            int n2 = n < this.fFocusedRow ? -1 : 1;
            int n3 = this.fExpansion.getDistance();
            for (int i = this.fFocusedRow; i != n || Math.abs(i - this.fExpansion.getAnchorRow()) >= n3; i += n2) {
                if (i >= 0) {
                    this.fExpansion.toggle(n2, i);
                }
                if (i != n) {
                    continue;
                }
                break;
            }
        } else {
            if (!this.fAllowMultiselect) {
                this.fSelectedRows.clear();
            }
            if (this.fSelectable.accept((Object)n)) {
                this.fSelectedRows.add(n);
            }
        }
        if (this.fSelectable.accept((Object)n)) {
            this.fFocusedRow = n;
        }
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void navigationKeyPressed(int n, int n2, boolean bl, boolean bl2) {
        if (!bl2) {
            this.fExpansion = null;
        }
        if (!this.fAllowSelect || n2 == 0) {
            return;
        }
        int n3 = this.fFocusedRow + n2;
        while (!this.fSelectable.accept((Object)n3) && n3 >= 0 && n3 < n) {
            n3 = this.fFocusedRow + (n2 += n2 < 0 ? -1 : 1);
        }
        n3 = Math.min(Math.max(0, this.fFocusedRow + n2), n);
        while (!this.fSelectable.accept((Object)n3) && n3 != this.fFocusedRow) {
            n3 = this.fFocusedRow + (n2 += n2 < 0 ? 1 : -1);
        }
        if (bl2 && this.fAllowMultiselect) {
            if (this.fExpansion == null) {
                this.fExpansion = new Expansion();
            }
            int n4 = n2 < 0 ? -1 : 1;
            int n5 = this.fExpansion.getDistance();
            while (this.fFocusedRow != n3 || Math.abs(this.fFocusedRow - this.fExpansion.getAnchorRow()) >= n5) {
                this.fExpansion.toggle(n4, this.fFocusedRow);
                if (this.fFocusedRow != n3) {
                    this.fFocusedRow += n4;
                    continue;
                }
                break;
            }
        } else if (n3 >= 0 && n3 < n) {
            this.fFocusedRow = n3;
            if (!bl || PlatformInfo.isMacintosh()) {
                this.fSelectedRows.clear();
                this.fSelectedRows.add(this.fFocusedRow);
            }
        }
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    private class Expansion {
        private final Set<Integer> fAddedRows = new HashSet<Integer>();
        private final int fAnchorRow;
        private int fTail = -1;
        private int fDirection;

        Expansion() {
            this.fAnchorRow = SelectionModel.this.fFocusedRow;
        }

        public int getAnchorRow() {
            return this.fAnchorRow;
        }

        public int getDistance() {
            return Math.abs(SelectionModel.this.fFocusedRow - this.fAnchorRow);
        }

        public boolean toggle(int n, Integer n2) {
            if (n != this.fDirection) {
                this.fTail = -1;
            }
            if (n2 == this.fTail) {
                this.fTail = -1;
                return true;
            }
            if (SelectionModel.this.fSelectable.accept((Object)n2)) {
                this.fTail = n2;
                this.fDirection = n;
                if (n2 == this.fAnchorRow) {
                    return true;
                }
                if (this.fAddedRows.add(n2)) {
                    SelectionModel.this.fSelectedRows.add(n2);
                    return true;
                }
                this.fAddedRows.remove(n2);
                SelectionModel.this.fSelectedRows.remove(n2);
            }
            return false;
        }
    }
}

