/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DebuggingIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.HelpAction;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import com.mathworks.project.impl.settingsui.TabbedParamSetPanel;
import com.mathworks.project.impl.workflowui.OutputArea;
import com.mathworks.project.impl.workflowui.OutputAreaModel;
import com.mathworks.project.impl.workflowui.OutputTabDefinition;
import com.mathworks.project.impl.workflowui.WorkflowModel;
import com.mathworks.project.impl.workflowui.WorkflowSplitPane;
import com.mathworks.project.impl.workflowui.WorkflowStepWidget;
import com.mathworks.project.impl.workflowui.WorkflowTree;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class WorkflowDialog {
    private final MJFrame fDialog;
    private final WorkflowModel fModel;
    private final MJPanel fOptionsContainer;
    private final MJPanel fRightSide;
    private final MJPanel fButtons;
    private final MJPanel fComponent = new MJPanel();
    private final Project fProject;
    private final Configuration fConfiguration;
    private final MJButton fRunButton;
    private final Component fHelpComponent;
    private final MJCheckBox fSkipCheckBox;
    private final Map<String, ProjectComponent> fOptionPanels;
    private final WorkflowTree fTree;
    private final BusyAffordance fBusyAffordance;
    private final Map<String, OutputAreaModel> fOutputModelByStepKey;
    private final Map<String, ProjectComponent> fControlBars;
    private final Map<String, WorkflowStepWidget> fCustomWidgets;
    private final Set<String> fActivatedCustomWidgets;
    private final OutputArea fOutputArea;
    private final WorkflowSplitPane fSplitPane;
    private final MJScrollPane fTreeScrollPane;
    private WorkflowStep fSelectedStep;
    private boolean fIgnoreItemChange = false;
    private static WorkflowDialog sInstance;
    private ActionListener fActionListener;
    private ItemListener fItemListener;
    private MJLabel fStepDescription;
    private ProjectComponent fControlBar;
    private WorkflowStepWidget fCustomWidget;
    static final Icon RUN_STEP_ICON;
    static final Icon RUN_MULTI_STEP_ICON;

    public static WorkflowDialog getInstance() {
        return sInstance;
    }

    public MJFrame getDialog() {
        return this.fDialog;
    }

    public WorkflowStep getSelectedStep() {
        return this.fSelectedStep;
    }

    public Configuration getConfiguration() {
        return this.fConfiguration;
    }

    public static void invoke(final Project project) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sInstance != null && !sInstance.fProject.equals(project)) {
                    WorkflowDialog.close();
                }
                if (sInstance == null) {
                    sInstance = new WorkflowDialog(project);
                }
                sInstance.setVisible(true);
            }
        });
    }

    public static void close() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sInstance != null) {
                    sInstance.dispose();
                    sInstance = null;
                }
            }
        });
    }

    private WorkflowDialog(Project project) {
        this.fProject = project;
        this.fConfiguration = project.getConfiguration();
        this.fModel = new WorkflowModel(this.fConfiguration);
        this.fOutputModelByStepKey = new HashMap<String, OutputAreaModel>();
        this.fControlBars = new HashMap<String, ProjectComponent>();
        this.fCustomWidgets = new HashMap<String, WorkflowStepWidget>();
        this.fActivatedCustomWidgets = new HashSet<String>();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2, 3, 0));
        this.fOutputArea = new OutputArea((Component)mJPanel);
        this.fDialog = new MJFrame(BuiltInResources.getString("title.wfa") + " - " + this.fConfiguration.getFile().getName());
        this.fDialog.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.fDialog.add((Component)this.fComponent);
        this.fComponent.setLayout((LayoutManager)new FormLayout("3dlu, fill:p, 3dlu, fill:d:grow", "3dlu, fill:d:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fOptionsContainer = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fRightSide = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fOptionPanels = new HashMap<String, ProjectComponent>();
        this.fRunButton = new MJButton(BuiltInResources.getString("button.run"), (Icon)DebuggingIcon.PLAY.getIcon());
        this.fRunButton.setName("RunButton");
        if (PlatformInfo.isMacintosh()) {
            this.fRunButton.putClientProperty((Object)"JButton.buttonType", (Object)"roundRect");
        }
        this.fActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WorkflowDialog.this.fModel.getRunningStep() != null && WorkflowDialog.this.fModel.getRunningStep() == WorkflowDialog.this.fSelectedStep) {
                    WorkflowDialog.this.fModel.getCurrentProcess().cancel();
                    WorkflowDialog.this.fRunButton.setEnabled(false);
                } else {
                    WorkflowDialog.this.runCurrentStep();
                }
            }
        };
        this.fRunButton.addActionListener(this.fActionListener);
        this.fHelpComponent = WorkflowDialog.createHelpButton();
        this.fSkipCheckBox = new MJCheckBox(BuiltInResources.getString("checkbox.skip"));
        this.fSkipCheckBox.setName("SkipStepCheckBox");
        this.fItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!WorkflowDialog.this.fIgnoreItemChange) {
                    boolean bl = WorkflowDialog.this.fSkipCheckBox.isSelected();
                    WorkflowDialog.this.fConfiguration.setWorkflowStepSkipped(WorkflowDialog.this.fSelectedStep, bl);
                }
            }
        };
        this.fSkipCheckBox.addItemListener(this.fItemListener);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        mJPanel.add((Component)this.fSkipCheckBox);
        mJPanel.add((Component)this.fBusyAffordance.getComponent());
        this.fButtons = new MJPanel((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu, fill:d", "fill:d"));
        this.fButtons.add(this.fHelpComponent, (Object)cellConstraints.xy(2, 1));
        this.fButtons.add((Component)this.fRunButton, (Object)cellConstraints.xy(4, 1));
        mJPanel.add((Component)this.fButtons);
        this.fStepDescription = new MJLabel(""){

            public Dimension getMinimumSize() {
                return new Dimension(0, (int)super.getMinimumSize().getHeight());
            }
        };
        this.fStepDescription.setBackground(this.fDialog.getBackground());
        this.fStepDescription.setBorder((Border)new EmptyBorder(0, 3, 0, 0));
        Font font = this.fStepDescription.getFont();
        this.fStepDescription.setFont(font.deriveFont(1));
        this.fSplitPane = new WorkflowSplitPane((Component)this.fOptionsContainer, this.fOutputArea.getComponent());
        this.fTree = new WorkflowTree(this.fConfiguration, this.fModel, this.createSelector(), this.createRunner(), this.createResetter(), this.createResizeHandler());
        this.fTreeScrollPane = new MJScrollPane((Component)this.fTree.getComponent());
        this.fTreeScrollPane.setHorizontalScrollBarPolicy(31);
        this.fComponent.add((Component)this.fTreeScrollPane, (Object)cellConstraints.xy(2, 2));
        this.fStepDescription.setBorder((Border)new EmptyBorder(0, 0, 16, 0));
        this.fRightSide.add((Component)this.fStepDescription, (Object)"North");
        this.fRightSide.add((Component)this.fSplitPane.getComponent(), (Object)"Center");
        this.fComponent.add((Component)this.fRightSide, (Object)cellConstraints.xy(4, 2));
        Dimension dimension = this.instantiateOptionPanels(this.fConfiguration.getTarget().getWorkflow().getSteps());
        this.fDialog.setSize((int)Math.min(WindowUtils.getScreenBounds().getWidth(), (double)(dimension.width + this.fTree.getComponent().getPreferredSize().width + 100)), (int)Math.min(WindowUtils.getScreenBounds().getHeight(), (double)(dimension.height + 200)));
        this.fDialog.setMinimumSize(new Dimension((int)Math.min(WindowUtils.getScreenBounds().getWidth(), (double)(dimension.width + this.fTree.getComponent().getPreferredSize().width + 30)), (int)Math.min(WindowUtils.getScreenBounds().getHeight(), (double)(dimension.height + 30))));
        WindowUtils.centerWindowOnScreen((Window)this.fDialog);
        this.fConfiguration.regenerateDefaults();
        this.fModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WorkflowDialog.this.fRunButton.setEnabled(WorkflowDialog.this.fSelectedStep != null && (WorkflowDialog.this.fModel.isRunnable(WorkflowDialog.this.fSelectedStep) || WorkflowDialog.this.fModel.getRunningStep() == WorkflowDialog.this.fSelectedStep));
                if (WorkflowDialog.this.fModel.getRunningStep() == WorkflowDialog.this.fSelectedStep) {
                    WorkflowDialog.this.fRunButton.setText(BuiltInResources.getString("button.cancel"));
                    WorkflowDialog.this.fRunButton.setIcon(null);
                } else {
                    WorkflowDialog.this.fRunButton.setText(BuiltInResources.getString("button.run"));
                    WorkflowDialog.this.fRunButton.setIcon((Icon)DebuggingIcon.PLAY.getIcon());
                }
                if (WorkflowDialog.this.fModel.getCurrentProcess() != null) {
                    WorkflowDialog.this.fBusyAffordance.start();
                } else {
                    WorkflowDialog.this.fBusyAffordance.stop();
                }
            }
        });
    }

    public void runSecondaryProcess(DeploymentProcess deploymentProcess) {
        this.setupProcess(deploymentProcess, this.fSelectedStep);
        deploymentProcess.start();
    }

    public DeploymentProcess getCurrentProcess() {
        return this.fModel.getCurrentProcess();
    }

    public void showStepHelp() {
        if (this.fSelectedStep != null) {
            String string = PluginManager.resolveHelpMapPath(this.fConfiguration.getTarget().getHelpMapPath());
            MLHelpServices.cshDisplayTopic((Object)this.fDialog, (String)string, (String)this.fSelectedStep.getHelpKey());
        }
    }

    private ParameterRunnable<WorkflowStep> createSelector() {
        return new ParameterRunnable<WorkflowStep>(){

            public void run(WorkflowStep workflowStep) {
                WorkflowDialog.this.selectStep(workflowStep);
            }
        };
    }

    private Converter<WorkflowStep, DeploymentProcess> createRunner() {
        return new Converter<WorkflowStep, DeploymentProcess>(){

            public DeploymentProcess convert(WorkflowStep workflowStep) {
                return WorkflowDialog.this.createProcess(workflowStep);
            }
        };
    }

    private ParameterRunnable<WorkflowStep> createResetter() {
        return new ParameterRunnable<WorkflowStep>(){

            public void run(WorkflowStep workflowStep) {
                if (workflowStep.getWidgetClassName() != null) {
                    WorkflowStepWidget workflowStepWidget = WorkflowDialog.this.getCustomWidget(workflowStep, false);
                    workflowStepWidget.reset();
                    WorkflowDialog.this.fActivatedCustomWidgets.remove(workflowStep.getKey());
                }
            }
        };
    }

    private Runnable createResizeHandler() {
        return new Runnable(){

            @Override
            public void run() {
                WorkflowDialog.this.fComponent.revalidate();
                WorkflowDialog.this.fComponent.repaint();
            }
        };
    }

    private void dispose() {
        this.fModel.dispose();
        this.fRunButton.removeActionListener(this.fActionListener);
        this.fSkipCheckBox.removeItemListener(this.fItemListener);
        for (ProjectComponent object : this.fOptionPanels.values()) {
            object.dispose();
        }
        this.fDialog.dispose();
        this.fOutputModelByStepKey.clear();
        this.fOutputArea.dispose();
        this.fOptionsContainer.removeAll();
        this.fTree.dispose();
        this.fOptionPanels.clear();
        for (OutputAreaModel outputAreaModel : this.fOutputModelByStepKey.values()) {
            outputAreaModel.dispose();
        }
        this.fOutputModelByStepKey.clear();
        for (ProjectComponent projectComponent : this.fControlBars.values()) {
            projectComponent.dispose();
        }
        this.fControlBars.clear();
        for (ProjectComponent projectComponent : this.fCustomWidgets.values()) {
            projectComponent.dispose();
        }
        this.fCustomWidget = null;
        this.fCustomWidgets.clear();
        this.fDialog.dispose();
    }

    private void setVisible(boolean bl) {
        if (bl) {
            this.fDialog.show();
        } else {
            this.fDialog.setVisible(bl);
        }
    }

    private void selectStep(WorkflowStep workflowStep) {
        Object object;
        if (this.fSelectedStep != null) {
            this.getOutputModelForStep(this.fSelectedStep).getLogSource().unbind();
        }
        this.fSelectedStep = workflowStep;
        this.fOptionsContainer.removeAll();
        if (this.fControlBar != null) {
            this.fControlBar.dispose();
            this.fControlBar = null;
            this.fButtons.removeAll();
            object = new CellConstraints();
            this.fButtons.setLayout((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu, fill:d", "fill:d"));
            this.fButtons.add(this.fHelpComponent, (Object)object.xy(2, 1));
            this.fButtons.add((Component)this.fRunButton, (Object)object.xy(4, 1));
        }
        if (workflowStep.getControlWidgetClassName() != null) {
            this.loadControlBar(workflowStep);
        }
        if (workflowStep.getWidgetClassName() != null) {
            this.loadCustomWidget(workflowStep);
        } else {
            if (this.fCustomWidget != null) {
                this.fRightSide.removeAll();
                this.fRightSide.add((Component)this.fStepDescription, (Object)"North");
                this.fRightSide.add((Component)this.fSplitPane.getComponent(), (Object)"Center");
                this.fRightSide.revalidate();
                this.fRightSide.repaint();
                this.fCustomWidget = null;
            }
            this.fStepDescription.setVisible(true);
            object = this.getOptionPanel(workflowStep);
            if (object != null) {
                if (TreeUtils.findComponent((Component)object, JTabbedPane.class) == null && TreeUtils.findComponent((Component)object, JScrollPane.class) == null) {
                    MJScrollPane mJScrollPane = new MJScrollPane((Component)object);
                    mJScrollPane.setBorder(null);
                    mJScrollPane.getViewport().setBorder(null);
                    this.fOptionsContainer.add((Component)mJScrollPane);
                } else {
                    this.fOptionsContainer.add((Component)object);
                }
            }
        }
        this.fSkipCheckBox.setVisible(this.fSelectedStep.isSkippable());
        this.fIgnoreItemChange = true;
        this.fSkipCheckBox.setSelected(this.fConfiguration.isWorkflowStepSkipped(this.fSelectedStep));
        this.fIgnoreItemChange = false;
        this.fOptionsContainer.revalidate();
        this.fOptionsContainer.repaint();
        this.fRunButton.setEnabled(this.fModel.isRunnable(this.fSelectedStep));
        this.fRunButton.setVisible(this.fSelectedStep.isRunnableOrGroup());
        this.fRunButton.setIcon(workflowStep.isRunnable() ? RUN_STEP_ICON : RUN_MULTI_STEP_ICON);
        this.fHelpComponent.setVisible(this.fSelectedStep.getHelpKey() != null);
        object = this.fSelectedStep.getDescription();
        if (object == null) {
            object = "";
        }
        this.fStepDescription.setText("<html>" + (String)object + "</html>");
        this.fOutputArea.setModel(this.getOutputModelForStep(workflowStep));
    }

    private void runCurrentStep() {
        this.fTree.run(this.fSelectedStep, false);
    }

    public WorkflowModel getModel() {
        return this.fModel;
    }

    private DeploymentProcess createProcess(WorkflowStep workflowStep) {
        try {
            if (ProjectGUI.getInstance().getCurrentProject() != this.fProject) {
                return null;
            }
            DeploymentProcess deploymentProcess = workflowStep.getWidgetClassName() != null ? this.getCustomWidget(workflowStep, true).createStepRunProcess() : DeploymentEngine.createWorkflowStepProcess(this.fProject, workflowStep);
            this.setupProcess(deploymentProcess, workflowStep);
            return deploymentProcess;
        }
        catch (InvalidProjectException invalidProjectException) {
            MJOptionPane.showMessageDialog((Component)this.fDialog, (Object)invalidProjectException.getMessage(), (String)BuiltInResources.getString("validation.error.title"), (int)0);
            return null;
        }
    }

    private void setupProcess(DeploymentProcess deploymentProcess, WorkflowStep workflowStep) {
        this.fModel.bind(deploymentProcess, workflowStep);
        ProjectManager.waitForSave(this.fProject);
        ProjectGUI.getInstance().getCurrentClient().disableChangeActionsWhileRunning(deploymentProcess);
        this.getOutputModelForStep(workflowStep).getLogSource().setProcess(deploymentProcess);
    }

    public OutputAreaModel getOutputModelForStep(WorkflowStep workflowStep) {
        OutputAreaModel outputAreaModel = this.fOutputModelByStepKey.get(workflowStep.getKey());
        if (outputAreaModel == null) {
            outputAreaModel = new OutputAreaModel(this.fProject, workflowStep.getScript() != null || workflowStep.getWidgetClassName() != null && !this.getCustomWidget(workflowStep, false).hasIntegratedControlsAndOutput());
            for (OutputTabDefinition outputTabDefinition : workflowStep.getOutputTabs()) {
                outputAreaModel.addExtraTab(outputTabDefinition);
            }
            this.fOutputModelByStepKey.put(workflowStep.getKey(), outputAreaModel);
        }
        return outputAreaModel;
    }

    private Dimension instantiateOptionPanels(List<WorkflowStep> list) {
        Dimension dimension = new Dimension(0, 0);
        for (WorkflowStep workflowStep : list) {
            Component component = this.getOptionPanel(workflowStep);
            if (workflowStep.getWidgetClassName() != null) {
                component = this.getCustomWidget(workflowStep, false).getComponent();
            }
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
            Dimension dimension3 = this.instantiateOptionPanels(workflowStep.getSubSteps());
            dimension.width = Math.max(dimension.width, dimension3.width);
            dimension.height = Math.max(dimension.height, dimension3.height);
        }
        return dimension;
    }

    private Component getOptionPanel(WorkflowStep workflowStep) {
        ProjectComponent projectComponent = this.fOptionPanels.get(workflowStep.getKey());
        if (projectComponent == null) {
            if (workflowStep.getWidgetClassName() != null) {
                return new MJPanel();
            }
            if (workflowStep.getOptionsWidgetClassName() != null) {
                try {
                    Class<?> clazz = Class.forName(workflowStep.getOptionsWidgetClassName());
                    Constructor<?> constructor = clazz.getConstructor(ReadableConfiguration.class);
                    projectComponent = (ProjectComponent)constructor.newInstance(this.fConfiguration);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            } else if (workflowStep.getParamSets().isEmpty()) {
                projectComponent = new ParamSetPanel(this.fProject, new ParamSet("paramset_" + workflowStep.getKey()), false, true, new ArrayList<String>(0));
            } else if (workflowStep.getParamSets().size() == 1) {
                projectComponent = new ParamSetPanel(this.fProject, workflowStep.getParamSets().get(0), false, true, new ArrayList<String>(0));
            } else if (workflowStep.getParamSets().size() > 1) {
                projectComponent = new TabbedParamSetPanel(this.fProject, workflowStep.getParamSets());
            }
            this.fOptionPanels.put(workflowStep.getKey(), projectComponent);
        }
        return projectComponent == null ? null : projectComponent.getComponent();
    }

    private void loadControlBar(WorkflowStep workflowStep) {
        try {
            if (this.fControlBars.containsKey(workflowStep.getKey())) {
                this.fControlBar = this.fControlBars.get(workflowStep.getKey());
            } else {
                Class<?> clazz = Class.forName(workflowStep.getControlWidgetClassName());
                Constructor<?> constructor = clazz.getConstructor(Configuration.class);
                this.fControlBar = (ProjectComponent)constructor.newInstance(this.fConfiguration);
                this.fControlBars.put(workflowStep.getKey(), this.fControlBar);
            }
            this.fButtons.removeAll();
            this.fButtons.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.fButtons.add(this.fControlBar.getComponent());
            this.fButtons.revalidate();
            this.fButtons.repaint();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getTargetException() instanceof IllegalStateException)) {
                throw new IllegalStateException(invocationTargetException);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
    }

    private WorkflowStepWidget getCustomWidget(WorkflowStep workflowStep, boolean bl) {
        try {
            WorkflowStepWidget workflowStepWidget;
            if (this.fCustomWidgets.containsKey(workflowStep.getKey())) {
                workflowStepWidget = this.fCustomWidgets.get(workflowStep.getKey());
            } else {
                Class<?> clazz = Class.forName(workflowStep.getWidgetClassName());
                Constructor<?> constructor = clazz.getConstructor(MJFrame.class, Configuration.class);
                workflowStepWidget = (WorkflowStepWidget)constructor.newInstance(this.fDialog, this.fConfiguration);
                this.fCustomWidgets.put(workflowStep.getKey(), workflowStepWidget);
            }
            if (bl && !this.fActivatedCustomWidgets.contains(workflowStep.getKey()) && this.fModel.isEnabled(workflowStep)) {
                workflowStepWidget.activate();
                this.fActivatedCustomWidgets.add(workflowStep.getKey());
            }
            return workflowStepWidget;
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
    }

    private void loadCustomWidget(WorkflowStep workflowStep) {
        if (this.fCustomWidget != null) {
            this.fRightSide.remove(this.fCustomWidget.getComponent());
        }
        this.fCustomWidget = this.getCustomWidget(workflowStep, true);
        if (this.fCustomWidget.getComponent().getParent() != null) {
            this.fCustomWidget.getComponent().getParent().remove(this.fCustomWidget.getComponent());
        }
        MJPanel mJPanel = this.fOptionsContainer;
        if (this.fCustomWidget.hasIntegratedControlsAndOutput()) {
            mJPanel = this.fRightSide;
            this.fStepDescription.setVisible(false);
        } else {
            this.fRightSide.removeAll();
            this.fRightSide.add((Component)this.fStepDescription, (Object)"North");
            this.fRightSide.add((Component)this.fSplitPane.getComponent(), (Object)"Center");
            this.fRightSide.revalidate();
            this.fRightSide.repaint();
            this.fStepDescription.setVisible(true);
        }
        mJPanel.removeAll();
        mJPanel.add(this.fCustomWidget.getComponent(), "Center");
        mJPanel.revalidate();
        mJPanel.repaint();
    }

    public static JComponent createHelpButton() {
        if (PlatformInfo.isMacintosh()) {
            MJHelpButton mJHelpButton = new MJHelpButton();
            mJHelpButton.setName("step.help");
            return mJHelpButton;
        }
        MJButton mJButton = new MJButton(HelpAction.ICON){

            public Dimension getPreferredSize() {
                return new Dimension(30, (int)super.getPreferredSize().getHeight());
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        mJButton.setName("step.help");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowDialog.getInstance().showStepHelp();
            }
        });
        return mJButton;
    }

    public void resetStep(String string) {
        WorkflowStep workflowStep = this.fConfiguration.getTarget().getWorkflow().getStepByKey(string);
        this.fModel.reset(workflowStep, this.createResetter());
    }

    static {
        RUN_STEP_ICON = BuiltInResources.getIcon("play_12x12.png");
        RUN_MULTI_STEP_ICON = BuiltInResources.getIcon("run_multi_step.png");
    }
}

