/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.PlatformInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WorkflowSplitPane {
    private final MJPanel fComponent;
    private final Component fTop;
    private final Component fBottom;
    private final Component fGripper;
    private final int fDefaultBottomSize;
    private final boolean fVertical;
    private boolean fBottomVisible = true;
    private int fPendingSizeChangeStart;
    private int fPendingSizeChangeEnd;
    private boolean fOutOfRangeUp;
    private boolean fOutOfRangeDown;
    private boolean fAncestorResized;
    private static final int MIN_COMPONENT_SIZE = 100;
    private static final int DIVIDER_SIZE = 8;

    public WorkflowSplitPane(Component component, Component component2) {
        this(component, component2, 350);
    }

    public WorkflowSplitPane(Component component, Component component2, int n) {
        this(component, component2, n, false);
    }

    public WorkflowSplitPane(Component component, Component component2, int n, boolean bl) {
        this.fDefaultBottomSize = n;
        this.fVertical = bl;
        this.fComponent = new MJPanel(){

            public void doLayout() {
                if (!WorkflowSplitPane.this.fBottomVisible) {
                    WorkflowSplitPane.this.fTop.setBounds(0, 0, this.getWidth(), this.getHeight());
                    WorkflowSplitPane.this.fBottom.setBounds(0, 0, 0, 0);
                    WorkflowSplitPane.this.fTop.revalidate();
                } else {
                    int n;
                    int n2 = this.getWidth();
                    int n3 = this.getHeight();
                    int n4 = n = WorkflowSplitPane.this.fVertical ? WorkflowSplitPane.this.fBottom.getWidth() : WorkflowSplitPane.this.fBottom.getHeight();
                    if (n == 0) {
                        n = WorkflowSplitPane.this.fVertical ? Math.min(n2 - 100 - 8, WorkflowSplitPane.this.fDefaultBottomSize) : Math.min(n3 - 100 - 8, WorkflowSplitPane.this.fDefaultBottomSize);
                    } else if (WorkflowSplitPane.this.fPendingSizeChangeStart != 0 || WorkflowSplitPane.this.fAncestorResized) {
                        int n5 = n -= (WorkflowSplitPane.this.fVertical ? -1 : 1) * (WorkflowSplitPane.this.fPendingSizeChangeEnd - WorkflowSplitPane.this.fPendingSizeChangeStart);
                        if (n5 != (n = Math.max(n, 100))) {
                            WorkflowSplitPane.this.fOutOfRangeDown = true;
                        }
                        n = Math.min(n, (WorkflowSplitPane.this.fVertical ? this.getWidth() : this.getHeight()) - 100 - 8);
                        if (!WorkflowSplitPane.this.fOutOfRangeDown && n5 != n) {
                            WorkflowSplitPane.this.fOutOfRangeUp = true;
                        }
                        WorkflowSplitPane.this.fPendingSizeChangeStart = WorkflowSplitPane.this.fPendingSizeChangeEnd;
                        WorkflowSplitPane.this.fAncestorResized = false;
                    }
                    if (WorkflowSplitPane.this.fVertical) {
                        WorkflowSplitPane.this.fBottom.setBounds(0, 0, n, n3);
                        WorkflowSplitPane.this.fGripper.setBounds(n, 0, 8, n3);
                        WorkflowSplitPane.this.fTop.setBounds(n + 8, 0, n2 - n - 8, n3);
                    } else {
                        WorkflowSplitPane.this.fBottom.setBounds(0, n3 - n, n2, n);
                        WorkflowSplitPane.this.fGripper.setBounds(0, n3 - n - 8, n2, 8);
                        WorkflowSplitPane.this.fTop.setBounds(0, 0, n2, n3 - n - 8);
                    }
                }
            }
        };
        this.fComponent.addHierarchyBoundsListener((HierarchyBoundsListener)new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                WorkflowSplitPane.this.fAncestorResized = true;
            }
        });
        this.fComponent.setLayout(null);
        this.fGripper = new MJPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(WorkflowSplitPane.this.fTop.getBackground());
                if (WorkflowSplitPane.this.fVertical) {
                    graphics2D.fillRect(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
                } else {
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight() / 2);
                }
                graphics2D.setColor(WorkflowSplitPane.this.fBottom.getBackground());
                if (WorkflowSplitPane.this.fVertical) {
                    graphics2D.fillRect(0, 0, this.getWidth() / 2, this.getHeight());
                } else {
                    graphics2D.fillRect(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                }
                graphics2D.setColor(new Color(210, 210, 210));
                if (!PlatformInfo.isMacintosh()) {
                    graphics2D.setStroke(new BasicStroke(1.5f));
                }
                if (WorkflowSplitPane.this.fVertical) {
                    graphics2D.draw(new Line2D.Double(this.getWidth() / 2, 0.0, this.getWidth() / 2, this.getHeight()));
                } else {
                    graphics2D.draw(new Line2D.Double(0.0, WorkflowSplitPane.this.fGripper.getHeight() / 2, WorkflowSplitPane.this.fGripper.getWidth(), WorkflowSplitPane.this.fGripper.getHeight() / 2));
                }
            }
        };
        if (this.fVertical) {
            this.fGripper.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.fGripper.setCursor(Cursor.getPredefinedCursor(9));
        }
        this.fGripper.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WorkflowSplitPane.this.fOutOfRangeUp = false;
                WorkflowSplitPane.this.fOutOfRangeDown = false;
                Point point = mouseEvent.getPoint();
                point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, (Component)WorkflowSplitPane.this.fComponent);
                if (!WorkflowSplitPane.this.fVertical && point.getY() > (double)(WorkflowSplitPane.this.fTop.getHeight() - 4) && point.getY() <= (double)(WorkflowSplitPane.this.fBottom.getY() + 4)) {
                    WorkflowSplitPane.this.fPendingSizeChangeStart = (int)point.getY();
                    WorkflowSplitPane.this.fPendingSizeChangeEnd = WorkflowSplitPane.this.fPendingSizeChangeStart;
                } else if (WorkflowSplitPane.this.fVertical && point.getX() > (double)(WorkflowSplitPane.this.fBottom.getWidth() - 4) && point.getX() <= (double)(WorkflowSplitPane.this.fBottom.getWidth() + 4)) {
                    WorkflowSplitPane.this.fPendingSizeChangeStart = (int)point.getX();
                    WorkflowSplitPane.this.fPendingSizeChangeEnd = WorkflowSplitPane.this.fPendingSizeChangeStart;
                } else {
                    WorkflowSplitPane.this.fPendingSizeChangeStart = 0;
                }
            }
        });
        this.fGripper.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, (Component)WorkflowSplitPane.this.fComponent);
                if (WorkflowSplitPane.this.fOutOfRangeDown && (WorkflowSplitPane.this.fVertical && point.getX() > (double)WorkflowSplitPane.this.fBottom.getWidth() || !WorkflowSplitPane.this.fVertical && point.getY() < (double)WorkflowSplitPane.this.fBottom.getY()) || WorkflowSplitPane.this.fOutOfRangeUp && (WorkflowSplitPane.this.fVertical && point.getX() > (double)WorkflowSplitPane.this.fBottom.getWidth() || !WorkflowSplitPane.this.fVertical && point.getY() > (double)WorkflowSplitPane.this.fTop.getHeight())) {
                    WorkflowSplitPane.this.fOutOfRangeUp = false;
                    WorkflowSplitPane.this.fOutOfRangeDown = false;
                    WorkflowSplitPane.this.fPendingSizeChangeStart = WorkflowSplitPane.this.fVertical ? (int)point.getX() : (int)point.getY();
                    WorkflowSplitPane.this.fPendingSizeChangeEnd = WorkflowSplitPane.this.fPendingSizeChangeStart;
                } else if (WorkflowSplitPane.this.fOutOfRangeUp || WorkflowSplitPane.this.fOutOfRangeDown) {
                    WorkflowSplitPane.this.fPendingSizeChangeStart = 0;
                    WorkflowSplitPane.this.fPendingSizeChangeEnd = 0;
                } else if (WorkflowSplitPane.this.fPendingSizeChangeStart != 0) {
                    WorkflowSplitPane.this.fPendingSizeChangeEnd = WorkflowSplitPane.this.fVertical ? (int)point.getX() : (int)point.getY();
                    WorkflowSplitPane.this.fComponent.revalidate();
                    WorkflowSplitPane.this.fComponent.repaint();
                }
            }
        });
        this.fTop = component;
        this.fBottom = component2;
        this.fComponent.add(this.fTop);
        this.fComponent.add(this.fBottom);
        this.fComponent.add(this.fGripper);
    }

    public void setBottomVisible(boolean bl) {
        this.fBottomVisible = bl;
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void pack() {
        if (this.fVertical) {
            this.fBottom.setBounds(this.fBottom.getX(), this.fBottom.getY(), (int)this.fBottom.getPreferredSize().getWidth(), this.fBottom.getHeight());
            this.fComponent.revalidate();
            this.fComponent.repaint();
        } else {
            this.fBottom.setBounds(this.fBottom.getX(), (int)((double)this.fComponent.getHeight() - this.fBottom.getPreferredSize().getHeight()), this.fBottom.getWidth(), this.fBottom.getHeight());
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }
}

