/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.plaintext;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementEncoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestDecoder;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.BaseProvider;
import com.sun.jini.discovery.internal.Plaintext;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class Server
extends BaseProvider
implements MulticastRequestDecoder,
MulticastAnnouncementEncoder,
UnicastDiscoveryServer {
    public Server() {
        super("net.jini.discovery.plaintext");
    }

    public MulticastRequest decodeMulticastRequest(ByteBuffer byteBuffer, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker) throws IOException {
        Plaintext.checkConstraints(invocationConstraints);
        if (clientSubjectChecker != null) {
            clientSubjectChecker.checkClientSubject(null);
        }
        return Plaintext.decodeMulticastRequest(byteBuffer);
    }

    public void encodeMulticastAnnouncement(MulticastAnnouncement multicastAnnouncement, DatagramBufferFactory datagramBufferFactory, InvocationConstraints invocationConstraints) throws IOException {
        Plaintext.checkConstraints(invocationConstraints);
        Plaintext.encodeMulticastAnnouncement(multicastAnnouncement, datagramBufferFactory);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        Plaintext.checkConstraints(invocationConstraints);
    }

    public void handleUnicastDiscovery(UnicastResponse unicastResponse, Socket socket, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker, Collection collection, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        Plaintext.checkConstraints(invocationConstraints);
        if (clientSubjectChecker != null) {
            clientSubjectChecker.checkClientSubject(null);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
        Plaintext.writeUnicastResponse(bufferedOutputStream, unicastResponse, collection);
        ((OutputStream)bufferedOutputStream).flush();
    }
}

