/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.MuxClient;
import com.sun.jini.jeri.internal.mux.MuxServer;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.OutboundRequest;

final class Session {
    static final int CLIENT = 0;
    static final int SERVER = 1;
    private static final int IDLE = 0;
    private static final int OPEN = 1;
    private static final int FINISHED = 2;
    private static final int TERMINATED = 3;
    private static final String[] stateNames;
    private static final Executor systemThreadPool;
    private static final Logger logger;
    private final Mux mux;
    private final int sessionID;
    private final int role;
    private final OutputStream out;
    private final InputStream in;
    private final Object sessionLock = new Object();
    private boolean sessionDown = false;
    private String sessionDownMessage;
    private Throwable sessionDownCause;
    private int outState;
    private int outRation;
    private final boolean outRationInfinite;
    private boolean partialDeliveryStatus = false;
    private int inState;
    private int inRation;
    private final boolean inRationInfinite;
    private int inBufRemaining = 0;
    private final LinkedList inBufQueue = new LinkedList();
    private int inBufPos = 0;
    private boolean inEOF = false;
    private boolean inClosed = false;
    private boolean fakeOKtoWrite = false;
    private boolean removeLater = false;
    private boolean receivedAckRequired = false;
    private boolean sentAcknowledgment = false;
    private Collection ackListeners = null;
    private boolean sentAckRequired = false;
    private boolean receivedAcknowledgment = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    Session(Mux mux, int n, int n2) {
        this.mux = mux;
        this.sessionID = n;
        this.role = n2;
        this.out = new MuxOutputStream();
        this.in = new MuxInputStream();
        this.outState = n2 == 0 ? 0 : 1;
        this.outRation = mux.initialOutboundRation;
        this.outRationInfinite = this.outRation == 0;
        this.inState = n2 == 0 ? 0 : 1;
        this.inRation = mux.initialInboundRation;
        this.inRationInfinite = this.inRation == 0;
    }

    OutboundRequest getOutboundRequest() {
        if (!$assertionsDisabled && this.role != 0) {
            throw new AssertionError();
        }
        return new OutboundRequest(){

            public void populateContext(Collection collection) {
                ((MuxClient)Session.this.mux).populateContext(collection);
            }

            public InvocationConstraints getUnfulfilledConstraints() {
                throw new AssertionError();
            }

            public OutputStream getRequestOutputStream() {
                return Session.this.out;
            }

            public InputStream getResponseInputStream() {
                return Session.this.in;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean getDeliveryStatus() {
                Object object = Session.this.sessionLock;
                synchronized (object) {
                    return Session.this.partialDeliveryStatus;
                }
            }

            public void abort() {
                Session.this.abort();
            }
        };
    }

    InboundRequest getInboundRequest() {
        if (!$assertionsDisabled && this.role != 1) {
            throw new AssertionError();
        }
        return new InboundRequest(){

            public void checkPermissions() {
                ((MuxServer)Session.this.mux).checkPermissions();
            }

            public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
                return ((MuxServer)Session.this.mux).checkConstraints(invocationConstraints);
            }

            public void populateContext(Collection collection) {
                collection.add(new AcknowledgmentSource(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean addAcknowledgmentListener(AcknowledgmentSource.Listener listener) {
                        if (listener == null) {
                            throw new NullPointerException();
                        }
                        Object object = Session.this.sessionLock;
                        synchronized (object) {
                            if (Session.this.outState < 2) {
                                if (Session.this.ackListeners == null) {
                                    Session.this.ackListeners = new ArrayList(3);
                                }
                                Session.this.ackListeners.add(listener);
                                return true;
                            }
                            return false;
                        }
                    }
                });
                ((MuxServer)Session.this.mux).populateContext(collection);
            }

            public InputStream getRequestInputStream() {
                return Session.this.in;
            }

            public OutputStream getResponseOutputStream() {
                return Session.this.out;
            }

            public void abort() {
                Session.this.abort();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.sessionDown) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "outState=" + stateNames[this.outState] + ",inState=" + stateNames[this.inState] + ",role=" + (this.role == 0 ? "CLIENT" : "SERVER"));
                }
                if (this.outState == 0) {
                    this.mux.removeSession(this.sessionID);
                } else if (this.outState < 3) {
                    if (this.role == 1 && this.outState == 2) {
                        this.mux.asyncSendClose(this.sessionID);
                    } else {
                        this.mux.asyncSendAbort(0x20 | (this.role == 1 ? 2 : 0), this.sessionID, null);
                    }
                    this.setOutState(3);
                }
                this.setDown("request aborted", null);
            }
            this.fakeOKtoWrite = false;
            if (this.removeLater) {
                if (this.outState < 3) {
                    this.setOutState(3);
                }
                this.mux.removeSession(this.sessionID);
                this.removeLater = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDown(String string, Throwable throwable) {
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.sessionDown) {
                this.sessionDown = true;
                this.sessionDownMessage = string;
                this.sessionDownCause = throwable;
                this.sessionLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIncrementRation(int n) throws ProtocolException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState == 0 || this.inState == 3) {
                throw new ProtocolException("IncrementRation on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            if (!this.outRationInfinite) {
                if (this.outRation + n < this.outRation) {
                    throw new ProtocolException("ration overflow");
                }
                if (this.outState == 1 && n > 0) {
                    if (this.outRation == 0) {
                        this.sessionLock.notifyAll();
                    }
                    this.outRation += n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAbort(boolean bl) throws ProtocolException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState == 0 || this.inState == 3) {
                throw new ProtocolException("Abort on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            this.setInState(3);
            this.partialDeliveryStatus = bl;
            if (this.outState < 3) {
                this.mux.asyncSendAbort(0x20 | (this.role == 1 ? 2 : 0), this.sessionID, null);
                this.setOutState(3);
            }
            this.setDown("request aborted by remote endpoint", null);
            if (this.sentAckRequired && !this.receivedAcknowledgment) {
                this.notifyAcknowledgmentListeners(false);
            }
            this.mux.removeSession(this.sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClose() throws ProtocolException {
        if (this.role != 0) {
            throw new ProtocolException("Close sent by client");
        }
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState != 2) {
                throw new ProtocolException("Close on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            if (this.outState < 2) {
                this.fakeOKtoWrite = true;
                this.mux.asyncSendAbort(32, this.sessionID, null);
                this.setOutState(3);
            }
            this.setInState(3);
            this.setDown("request closed by server", null);
            if (this.outState == 3 || !this.receivedAckRequired || this.sentAcknowledgment) {
                this.mux.removeSession(this.sessionID);
            } else {
                this.removeLater = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAcknowledgment() throws ProtocolException {
        if (this.role != 1) {
            throw new ProtocolException("Acknowledgment sent by server");
        }
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState == 0 || this.inState == 3) {
                throw new ProtocolException("Acknowledgment on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            if (this.outState < 2) {
                throw new ProtocolException("acknowledgment received before EOF sent");
            }
            if (!this.sentAckRequired) {
                throw new ProtocolException("acknowledgment not requested");
            }
            if (this.receivedAcknowledgment) {
                throw new ProtocolException("duplicate acknowledgment");
            }
            this.receivedAcknowledgment = true;
            this.notifyAcknowledgmentListeners(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleData(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3) throws ProtocolException {
        if (!$assertionsDisabled && !bl && (bl2 || bl3)) {
            throw new AssertionError();
        }
        if (bl3 && this.role != 0) {
            throw new ProtocolException("Data/ackRequired sent by client");
        }
        Object object = this.sessionLock;
        synchronized (object) {
            boolean bl4 = bl2;
            if (this.inState != 1) {
                throw new ProtocolException("Data on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            int n = byteBuffer.remaining();
            if (!this.inRationInfinite && n > this.inRation) {
                throw new ProtocolException("input ration exceeded");
            }
            if (!this.inClosed && this.outState < 3 && n > 0) {
                if (this.inBufRemaining == 0) {
                    this.sessionLock.notifyAll();
                    bl4 = true;
                }
                this.inBufQueue.addLast(byteBuffer);
                this.inBufRemaining += n;
                if (!this.inRationInfinite) {
                    this.inRation -= n;
                }
            }
            if (bl) {
                this.inEOF = true;
                this.setInState(2);
                if (!bl4) {
                    this.sessionLock.notifyAll();
                }
                if (bl3) {
                    this.receivedAckRequired = true;
                }
                if (bl2) {
                    this.handleClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOpen() throws ProtocolException {
        if (!$assertionsDisabled && this.role != 1) {
            throw new AssertionError();
        }
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState < 2 || this.outState < 3) {
                throw new ProtocolException(this.inState < 2 ? "Data/open on " + stateNames[this.inState] + " session: " + this.sessionID : "Data/open before previous session terminated");
            }
            this.setInState(3);
            this.setDown("old request", null);
            this.sessionLock.notifyAll();
            this.mux.removeSession(this.sessionID);
        }
    }

    private void setOutState(int n) {
        if (!$assertionsDisabled && n <= this.outState) {
            throw new AssertionError();
        }
        this.outState = n;
    }

    private void setInState(int n) {
        if (!$assertionsDisabled && n <= this.inState) {
            throw new AssertionError();
        }
        this.inState = n;
    }

    private void notifyAcknowledgmentListeners(final boolean bl) {
        if (this.ackListeners != null) {
            systemThreadPool.execute(new Runnable(){

                public void run() {
                    Iterator iterator = Session.this.ackListeners.iterator();
                    while (iterator.hasNext()) {
                        AcknowledgmentSource.Listener listener = (AcknowledgmentSource.Listener)iterator.next();
                        listener.acknowledgmentReceived(bl);
                    }
                }
            }, "Mux ack notifier");
        }
    }

    static {
        $assertionsDisabled = !Session.class.desiredAssertionStatus();
        stateNames = new String[]{"idle", "open", "finished", "terminated"};
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
        logger = Logger.getLogger("net.jini.jeri.connection.mux");
    }

    private class MuxInputStream
    extends InputStream {
        static final /* synthetic */ boolean $assertionsDisabled;

        MuxInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            Object object = Session.this.sessionLock;
            synchronized (object) {
                int n;
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                while (Session.this.inBufRemaining == 0 && !Session.this.sessionDown && Session.this.inState <= 1 && !Session.this.inClosed) {
                    if (Session.this.inState == 0) {
                        if (!$assertionsDisabled && Session.this.outState != 0) {
                            throw new AssertionError();
                        }
                        Session.this.mux.asyncSendData(144, Session.this.sessionID, null);
                        Session.this.setOutState(1);
                        Session.this.setInState(1);
                    }
                    if (!Session.this.inRationInfinite && Session.this.inRation == 0) {
                        n = ((Session)Session.this).mux.initialInboundRation;
                        Session.this.mux.asyncSendIncrementRation(Session.this.sessionID, n);
                        Session.this.inRation += n;
                    }
                    try {
                        Session.this.sessionLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        String string = "request I/O interrupted";
                        Session.this.setDown(string, interruptedException);
                        IOException iOException = new IOException(string);
                        iOException.initCause(interruptedException);
                        throw iOException;
                    }
                }
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                if (Session.this.inBufRemaining == 0) {
                    if (Session.this.inEOF) {
                        return -1;
                    }
                    if (Session.this.inState == 3) {
                        throw new IOException("request aborted by remote endpoint");
                    }
                    if (!$assertionsDisabled && !Session.this.sessionDown) {
                        throw new AssertionError();
                    }
                    IOException iOException = new IOException(Session.this.sessionDownMessage);
                    if (Session.this.sessionDownCause != null) {
                        iOException.initCause(Session.this.sessionDownCause);
                    }
                    throw iOException;
                }
                if (!$assertionsDisabled && Session.this.inBufQueue.size() <= 0) {
                    throw new AssertionError();
                }
                n = -1;
                while (n == -1) {
                    ByteBuffer byteBuffer = (ByteBuffer)Session.this.inBufQueue.getFirst();
                    if (Session.this.inBufPos < byteBuffer.limit()) {
                        n = byteBuffer.get() & 0xFF;
                        Session.this.inBufPos++;
                        Session.this.inBufRemaining--;
                    }
                    if (Session.this.inBufPos != byteBuffer.limit()) continue;
                    Session.this.inBufQueue.removeFirst();
                    Session.this.inBufPos = 0;
                }
                if (!Session.this.inRationInfinite) {
                    this.checkInboundRation();
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            Object object = Session.this.sessionLock;
            synchronized (object) {
                int n3;
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                if (n2 == 0) {
                    return 0;
                }
                while (Session.this.inBufRemaining == 0 && !Session.this.sessionDown && Session.this.inState <= 1 && !Session.this.inClosed) {
                    if (Session.this.inState == 0) {
                        if (!$assertionsDisabled && Session.this.outState != 0) {
                            throw new AssertionError();
                        }
                        Session.this.mux.asyncSendData(144, Session.this.sessionID, null);
                        Session.this.setOutState(1);
                        Session.this.setInState(1);
                    }
                    if (!Session.this.inRationInfinite && Session.this.inRation == 0) {
                        n3 = ((Session)Session.this).mux.initialInboundRation;
                        Session.this.mux.asyncSendIncrementRation(Session.this.sessionID, n3);
                        Session.this.inRation += n3;
                    }
                    try {
                        Session.this.sessionLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        String string = "request I/O interrupted";
                        Session.this.setDown(string, interruptedException);
                        IOException iOException = new IOException(string);
                        iOException.initCause(interruptedException);
                        throw iOException;
                    }
                }
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                if (Session.this.inBufRemaining == 0) {
                    if (Session.this.inEOF) {
                        return -1;
                    }
                    if (Session.this.inState == 3) {
                        throw new IOException("request aborted by remote endpoint");
                    }
                    if (!$assertionsDisabled && !Session.this.sessionDown) {
                        throw new AssertionError();
                    }
                    IOException iOException = new IOException(Session.this.sessionDownMessage);
                    if (Session.this.sessionDownCause != null) {
                        iOException.initCause(Session.this.sessionDownCause);
                    }
                    throw iOException;
                }
                if (!$assertionsDisabled && Session.this.inBufQueue.size() <= 0) {
                    throw new AssertionError();
                }
                n3 = n2;
                while (n3 > 0 && Session.this.inBufRemaining > 0) {
                    ByteBuffer byteBuffer = (ByteBuffer)Session.this.inBufQueue.getFirst();
                    if (Session.this.inBufPos < byteBuffer.limit()) {
                        int n4 = Math.min(byteBuffer.limit() - Session.this.inBufPos, n3);
                        byteBuffer.get(byArray, n, n4);
                        Session.this.inBufPos += n4;
                        Session.this.inBufRemaining -= n4;
                        n += n4;
                        n3 -= n4;
                    }
                    if (Session.this.inBufPos != byteBuffer.limit()) continue;
                    Session.this.inBufQueue.removeFirst();
                    Session.this.inBufPos = 0;
                }
                if (!Session.this.inRationInfinite) {
                    this.checkInboundRation();
                }
                return n2 - n3;
            }
        }

        private void checkInboundRation() {
            if (!$assertionsDisabled && !Thread.holdsLock(Session.this.sessionLock)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && Session.this.inRationInfinite) {
                throw new AssertionError();
            }
            int n = ((Session)Session.this).mux.initialInboundRation / 2;
            int n2 = Session.this.inBufRemaining + Session.this.inRation;
            if (n2 <= n) {
                int n3 = ((Session)Session.this).mux.initialInboundRation - n2;
                Session.this.mux.asyncSendIncrementRation(Session.this.sessionID, n3);
                Session.this.inRation += n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            Object object = Session.this.sessionLock;
            synchronized (object) {
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                return Session.this.inBufRemaining;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = Session.this.sessionLock;
            synchronized (object) {
                if (Session.this.inClosed) {
                    return;
                }
                Session.this.inClosed = true;
                Session.this.inBufQueue.clear();
                if (Session.this.role == 0 && !Session.this.sentAcknowledgment && Session.this.receivedAckRequired && Session.this.outState < 3) {
                    Session.this.mux.asyncSendAcknowledgment(Session.this.sessionID);
                    Session.this.sentAcknowledgment = true;
                    if (Session.this.removeLater) {
                        Session.this.setOutState(3);
                        Session.this.mux.removeSession(Session.this.sessionID);
                        Session.this.removeLater = false;
                    }
                }
                Session.this.sessionLock.notifyAll();
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$Session == null ? (class$com$sun$jini$jeri$internal$mux$Session = Session.class$("com.sun.jini.jeri.internal.mux.Session")) : class$com$sun$jini$jeri$internal$mux$Session).desiredAssertionStatus();
        }
    }

    private class MuxOutputStream
    extends OutputStream {
        private ByteBuffer buffer;
        static final /* synthetic */ boolean $assertionsDisabled;

        MuxOutputStream() {
            this.buffer = ByteBuffer.allocateDirect(((Session)Session.this).mux.maxFragmentSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(int n) throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.writeBuffer(false);
            } else {
                Object object = Session.this.sessionLock;
                synchronized (object) {
                    this.ensureOpen();
                }
            }
            this.buffer.put((byte)n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                Object object = Session.this.sessionLock;
                synchronized (object) {
                    this.ensureOpen();
                }
                return;
            }
            while (n2 > 0) {
                int n3 = this.buffer.remaining();
                if (n2 <= n3) {
                    Object object = Session.this.sessionLock;
                    synchronized (object) {
                        this.ensureOpen();
                    }
                    this.buffer.put(byArray, n, n2);
                    return;
                }
                this.buffer.put(byArray, n, n3);
                n += n3;
                n2 -= n3;
                this.writeBuffer(false);
            }
        }

        public synchronized void flush() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "STACK TRACE", new Throwable("STACK TRACE"));
            }
            Object object = Session.this.sessionLock;
            synchronized (object) {
                this.ensureOpen();
            }
            while (!this.writeBuffer(true)) {
            }
        }

        private void ensureOpen() throws IOException {
            if (!$assertionsDisabled && !Thread.holdsLock(Session.this.sessionLock)) {
                throw new AssertionError();
            }
            if (Session.this.fakeOKtoWrite) {
                return;
            }
            if (Session.this.outState > 1) {
                if (Session.this.outState == 2) {
                    throw new IOException("stream closed");
                }
                throw new IOException("session terminated");
            }
            if (Session.this.sessionDown) {
                IOException iOException = new IOException(Session.this.sessionDownMessage);
                if (Session.this.sessionDownCause != null) {
                    iOException.initCause(Session.this.sessionDownCause);
                }
                throw iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean writeBuffer(boolean bl) throws IOException {
            this.buffer.flip();
            int n = this.buffer.limit();
            IOFuture iOFuture = null;
            boolean bl2 = false;
            Object object = Session.this.sessionLock;
            synchronized (object) {
                boolean bl3;
                int n2;
                while (this.buffer.remaining() > 0 && !Session.this.outRationInfinite && Session.this.outRation < 1 && !Session.this.sessionDown && Session.this.outState == 1) {
                    try {
                        Session.this.sessionLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        String string = "request I/O interrupted";
                        Session.this.setDown(string, interruptedException);
                        IOException iOException = new IOException(string);
                        iOException.initCause(interruptedException);
                        throw iOException;
                    }
                }
                this.ensureOpen();
                if (!($assertionsDisabled || this.buffer.remaining() == 0 || Session.this.outRationInfinite || Session.this.outRation > 0 || Session.this.fakeOKtoWrite)) {
                    throw new AssertionError();
                }
                if (Session.this.fakeOKtoWrite) {
                    if (!($assertionsDisabled || Session.this.role == 0 && Session.this.inState == 3)) {
                        throw new AssertionError();
                    }
                    if (bl) {
                        Session.this.fakeOKtoWrite = false;
                    }
                    this.buffer.position(n);
                    this.buffer.compact();
                    return bl;
                }
                if (Session.this.outRationInfinite || this.buffer.remaining() <= Session.this.outRation) {
                    n2 = this.buffer.remaining();
                    bl3 = true;
                } else {
                    n2 = Session.this.outRation;
                    this.buffer.limit(n2);
                    bl3 = false;
                }
                if (!Session.this.outRationInfinite) {
                    Session.this.outRation -= n2;
                }
                Session.this.partialDeliveryStatus = true;
                boolean bl4 = Session.this.outState == 0;
                boolean bl5 = bl && bl3;
                boolean bl6 = Session.this.role == 1 && bl5 && Session.this.inState > 1;
                boolean bl7 = Session.this.role == 1 && bl5 && Session.this.ackListeners != null && !Session.this.ackListeners.isEmpty();
                int n3 = 0x80 | (bl4 ? 16 : 0) | (bl5 ? 4 : 0) | (bl6 ? 8 : 0) | (bl7 ? 2 : 0);
                if (!bl5 || Session.this.role == 1) {
                    iOFuture = Session.this.mux.futureSendData(n3, Session.this.sessionID, this.buffer);
                } else {
                    Session.this.mux.asyncSendData(n3, Session.this.sessionID, this.buffer);
                }
                if (Session.this.outState == 0) {
                    Session.this.setOutState(1);
                    Session.this.setInState(1);
                }
                if (bl5) {
                    bl2 = true;
                    Session.this.setOutState(bl6 ? 3 : 2);
                    if (bl7) {
                        Session.this.sentAckRequired = true;
                    }
                    Session.this.sessionLock.notifyAll();
                }
            }
            if (iOFuture != null) {
                this.waitForIO(iOFuture);
                this.buffer.limit(n);
                this.buffer.compact();
            }
            return bl2;
        }

        private void waitForIO(IOFuture iOFuture) throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(Session.this.sessionLock)) {
                throw new AssertionError();
            }
            try {
                iOFuture.waitUntilDone();
            }
            catch (InterruptedException interruptedException) {
                String string = "request I/O interrupted";
                Session.this.setDown(string, interruptedException);
                IOException iOException = new IOException(string);
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (IOException iOException) {
                Session.this.setDown(iOException.getMessage(), iOException.getCause());
                throw iOException;
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$Session == null ? (class$com$sun$jini$jeri$internal$mux$Session = Session.class$("com.sun.jini.jeri.internal.mux.Session")) : class$com$sun$jini$jeri$internal$mux$Session).desiredAssertionStatus();
        }
    }
}

