/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.IAccessFlags;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;

public final class Method_info
implements Cloneable,
IAccessFlags {
    public int m_name_index;
    public int m_descriptor_index;
    private int m_access_flags;
    private IAttributeCollection m_attributes;

    public Method_info(int access_flags, int name_index, int descriptor_index, IAttributeCollection attributes) {
        this.m_access_flags = access_flags;
        this.m_name_index = name_index;
        this.m_descriptor_index = descriptor_index;
        this.m_attributes = attributes;
    }

    public Method_info(IConstantCollection constants, UDataInputStream bytes) throws IOException {
        this.m_access_flags = bytes.readU2();
        this.m_name_index = bytes.readU2();
        this.m_descriptor_index = bytes.readU2();
        int attributes_count = bytes.readU2();
        this.m_attributes = ElementFactory.newAttributeCollection(attributes_count);
        for (int i = 0; i < attributes_count; ++i) {
            Attribute_info attribute_info = Attribute_info.new_Attribute_info(constants, bytes);
            this.m_attributes.add(attribute_info);
        }
    }

    public String getName(ClassDef cls) {
        return ((CONSTANT_Utf8_info)cls.getConstants().get((int)this.m_name_index)).m_value;
    }

    public String getDescriptor(ClassDef cls) {
        return ((CONSTANT_Utf8_info)cls.getConstants().get((int)this.m_descriptor_index)).m_value;
    }

    public boolean isNative() {
        return (this.m_access_flags & 0x100) != 0;
    }

    public boolean isAbstract() {
        return (this.m_access_flags & 0x400) != 0;
    }

    public boolean isSynthetic() {
        return this.m_attributes.hasSynthetic() || (this.m_access_flags & 0x1000) != 0;
    }

    public boolean isStatic() {
        return (this.m_access_flags & 8) != 0;
    }

    public boolean isBridge() {
        return (this.m_access_flags & 0x40) != 0 || this.m_attributes.hasBridge();
    }

    public final void setAccessFlags(int flags) {
        this.m_access_flags = flags;
    }

    public final int getAccessFlags() {
        return this.m_access_flags;
    }

    public IAttributeCollection getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("method_info: [modifiers: 0x" + Integer.toHexString(this.m_access_flags) + ", name_index = " + this.m_name_index + ", descriptor_index = " + this.m_descriptor_index + "]\n");
        for (int i = 0; i < this.m_attributes.size(); ++i) {
            Attribute_info attribute_info = this.m_attributes.get(i);
            s.append("\t[" + i + "] attribute: " + attribute_info + "\n");
        }
        return s.toString();
    }

    public Object clone() {
        try {
            Method_info _clone = (Method_info)super.clone();
            _clone.m_attributes = (IAttributeCollection)this.m_attributes.clone();
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        out.writeU2(this.m_access_flags);
        out.writeU2(this.m_name_index);
        out.writeU2(this.m_descriptor_index);
        this.m_attributes.writeInClassFormat(out);
    }
}

