/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.Sender;
import com.teamdev.jxbrowser.chromium.internal.ipc.Server;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.e;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.f;
import com.teamdev.jxbrowser.chromium.internal.ipc.g;
import com.teamdev.jxbrowser.chromium.internal.ipc.h;
import com.teamdev.jxbrowser.chromium.internal.ipc.i;
import com.teamdev.jxbrowser.chromium.internal.ipc.j;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ShutdownMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPC
implements Sender {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private Channel b;
    private final Server c;
    private final ChromiumProcess d;
    private final List<Channel> e;
    private final List<IPCListener> f;
    private final ServerListener g;

    public static IPC create() {
        int n2 = SocketUtil.getNextAvailablePort(1100);
        Server server = new Server(n2);
        String string = BrowserPreferences.getChromiumDir();
        IPC iPC = new IPC(server, new ChromiumProcess(n2, string));
        return iPC;
    }

    public IPC(Server server, ChromiumProcess chromiumProcess) {
        this.c = server;
        this.d = chromiumProcess;
        this.g = new a(this, null);
        this.e = new ArrayList<Channel>();
        this.f = new ArrayList<IPCListener>();
    }

    public Channel getMainChannel() {
        return this.b;
    }

    public boolean isStarted() {
        return this.c.isStarted();
    }

    public void start() {
        a.info("Starting IPC...");
        if (this.c.isStarted()) {
            a.info("IPC is already started.");
            if (!this.d.isStarted()) {
                a.info("Chromium process is dead. Restarting IPC...");
                this.b = this.a(false);
                return;
            }
            return;
        }
        this.b = this.a(true);
        this.c.addServerListener(this.g);
        a.info("IPC is started.");
    }

    private Channel a(boolean bl) {
        Object object;
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicReference3 = new AtomicReference();
        j j2 = new j(this, atomicReference2, countDownLatch);
        this.c.addServerListener(j2);
        if (bl) {
            atomicReference = atomicReference3;
            object = countDownLatch;
            Object object2 = this;
            a.info("Starting IPC Server...");
            object2 = new Thread(new i((IPC)object2, atomicReference, (CountDownLatch)object));
            ((Thread)object2).setName("IPC Server Thread");
            ((Thread)object2).setDaemon(true);
            ((Thread)object2).start();
        }
        atomicReference = atomicReference3;
        object = countDownLatch;
        AtomicReference atomicReference4 = this;
        a.info("Starting IPC Process...");
        atomicReference4 = new Thread(new h((IPC)((Object)atomicReference4), atomicReference, (CountDownLatch)object));
        ((Thread)((Object)atomicReference4)).setName("IPC Process Thread");
        ((Thread)((Object)atomicReference4)).setDaemon(true);
        ((Thread)((Object)atomicReference4)).start();
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to initialize IPC. Remote process doesn't respond."));
        }
        finally {
            this.c.removeServerListener(j2);
        }
        atomicReference4 = atomicReference3;
        object = (IPCException)atomicReference4.get();
        if (object != null) {
            throw object;
        }
        return (Channel)atomicReference2.get();
    }

    public void shutdown() {
        a.info("Shutdown IPC...");
        if (this.c.isStarted()) {
            this.b();
            this.c.removeServerListener(this.g);
            this.c.stop();
            this.c();
        }
    }

    public void stop() {
        a.info("Stopping IPC...");
        if (!this.c.isStarted()) {
            a.info("IPC is already stopped.");
            return;
        }
        this.b();
        this.c.stop();
        IPC iPC = this;
        while (!iPC.e.isEmpty()) {
            a.info("Waiting for channels disconnection...");
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.c.removeServerListener(this.g);
        this.c();
        a.info("IPC is stopped.");
    }

    private void b() {
        if (this.b.isClosed()) {
            return;
        }
        a.info("Stopping main channel...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        f f2 = new f(this, countDownLatch);
        this.c.addServerListener(f2);
        this.send(new ShutdownMessage(MessageUIDGenerator.generate()));
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to execute shutdown post message."));
            return;
        }
        finally {
            this.c.removeServerListener(f2);
        }
    }

    private void c() {
        a.info("Waiting process exit...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        g g2 = new g(this, countDownLatch);
        this.d.addChromiumProcessListener(g2);
        try {
            if (this.d.isStarted()) {
                LatchUtil.await(countDownLatch, new IPCException("Chromium process hasn't been exited because of timeout."));
            }
            return;
        }
        finally {
            this.d.removeChromiumProcessListener(g2);
        }
    }

    public void addIPCListener(IPCListener iPCListener) {
        if (!this.f.contains(iPCListener)) {
            this.f.add(iPCListener);
        }
    }

    public void removeIPCListener(IPCListener iPCListener) {
        this.f.remove(iPCListener);
    }

    public List<IPCListener> getIPCListeners() {
        return new ArrayList<IPCListener>(this.f);
    }

    public Channel getChannel(long l2, ChannelType channelType) {
        for (Channel channel : ((IPC)this).getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == l2;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return channel;
        }
        return null;
    }

    public boolean hasChannel(long l2, ChannelType channelType) {
        for (Channel channel : ((IPC)this).getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == l2;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return true;
        }
        return false;
    }

    public void waitChannel(long l2, ChannelType channelType) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        e e2 = new e(this, l2, channelType, countDownLatch);
        this.addIPCListener(e2);
        if (this.hasChannel(l2, channelType)) {
            return;
        }
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to get Browser channel " + l2));
            return;
        }
        finally {
            this.removeIPCListener(e2);
        }
    }

    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.e);
    }

    @Override
    public void send(Message message) {
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        this.b.send(message);
    }

    @Override
    public <T extends Message> T post(T t2) {
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        return this.b.post(t2);
    }

    static /* synthetic */ ChromiumProcess a(IPC iPC) {
        return iPC.d;
    }

    static /* synthetic */ Server b(IPC iPC) {
        return iPC.c;
    }

    static /* synthetic */ Channel c(IPC iPC) {
        return iPC.b;
    }

    private final class a
    extends ServerAdapter {
        private /* synthetic */ IPC a;

        private a(IPC iPC) {
            this.a = iPC;
        }

        public final void onChannelConnected(Channel channel) {
            if (!((a)this).a.hasChannel(channel.getChannelId(), channel.getType())) {
                ((a)this).a.e.add(channel);
                a.info("Channel is connected: " + channel);
                for (IPCListener iPCListener : ((a)this).a.getIPCListeners()) {
                    iPCListener.onChannelAdded(channel);
                }
            }
        }

        public final void onChannelDisconnected(Channel channel) {
            if (((a)this).a.e.remove(channel)) {
                a.info("Channel is disconnected: " + channel);
                for (IPCListener iPCListener : ((a)this).a.getIPCListeners()) {
                    iPCListener.onChannelRemoved(channel);
                }
            }
        }

        /* synthetic */ a(IPC iPC, j j2) {
            this(iPC);
        }
    }
}

