/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc.message;

import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class CommonMessage
implements Message {
    private int a;

    protected CommonMessage(int n2) {
        this.a = n2;
    }

    public int getUID() {
        return this.a;
    }

    public int getSize() {
        return this.getHeaderSize() + this.getDataSize();
    }

    protected int getHeaderSize() {
        return 12;
    }

    protected int getDataSize() {
        return 0;
    }

    protected void put(ByteBuffer byteBuffer, byte[] byArray) {
        this.put(byteBuffer, byArray != null ? byArray.length : 0);
        if (byArray != null) {
            for (byte by : byArray) {
                this.put(byteBuffer, by);
            }
        }
    }

    protected byte[] get(ByteBuffer byteBuffer, byte[] byArray) {
        int n2 = byteBuffer.getInt();
        byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = byteBuffer.get();
        }
        return byArray;
    }

    protected void put(ByteBuffer byteBuffer, Rectangle rectangle) {
        this.put(byteBuffer, rectangle.x);
        this.put(byteBuffer, rectangle.y);
        this.put(byteBuffer, rectangle.width);
        this.put(byteBuffer, rectangle.height);
    }

    protected Rectangle get(ByteBuffer byteBuffer, Rectangle rectangle) {
        rectangle = new Rectangle();
        new Rectangle().x = this.get(byteBuffer, rectangle.x);
        rectangle.y = this.get(byteBuffer, rectangle.y);
        rectangle.width = this.get(byteBuffer, rectangle.width);
        rectangle.height = this.get(byteBuffer, rectangle.height);
        return rectangle;
    }

    protected void put(ByteBuffer byteBuffer, byte by) {
        byteBuffer.put(by);
    }

    protected byte get(ByteBuffer byteBuffer, byte by) {
        return byteBuffer.get();
    }

    protected void put(ByteBuffer byteBuffer, int n2) {
        byteBuffer.putInt(n2);
    }

    protected void put(ByteBuffer byteBuffer, double d2) {
        byteBuffer.putDouble(d2);
    }

    protected int get(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.getInt();
    }

    protected void put(ByteBuffer byteBuffer, String object) {
        if (object == null) {
            this.put(byteBuffer, 0);
            return;
        }
        object = ((String)object).getBytes(Charset.forName("UTF-8"));
        this.put(byteBuffer, ((Object)object).length);
        for (Object object2 : object) {
            this.put(byteBuffer, (byte)object2);
        }
    }

    protected String get(ByteBuffer byteBuffer, String object) {
        int n2 = byteBuffer.getInt();
        object = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object[i2] = byteBuffer.get();
        }
        return new String((byte[])object, Charset.forName("UTF-8"));
    }

    protected void put(ByteBuffer byteBuffer, boolean bl) {
        byteBuffer.put(bl ? (byte)1 : 0);
    }

    protected boolean get(ByteBuffer byteBuffer, boolean bl) {
        return byteBuffer.get() == 1;
    }

    protected void put(ByteBuffer byteBuffer, char c2) {
        byteBuffer.putChar(c2);
    }

    protected char get(ByteBuffer byteBuffer, char c2) {
        return byteBuffer.getChar();
    }

    protected double get(ByteBuffer byteBuffer, double d2) {
        return byteBuffer.getDouble();
    }

    protected void put(ByteBuffer byteBuffer, long l2) {
        byteBuffer.putLong(l2);
    }

    protected long get(ByteBuffer byteBuffer, long l2) {
        return byteBuffer.getLong();
    }

    public void serialize(byte[] object) {
        if (((byte[])object).length < this.getSize()) {
            throw new IllegalArgumentException("The data.length() must be less than this.getSize();");
        }
        object = ByteBuffer.wrap(object, 0, this.getHeaderSize());
        this.put((ByteBuffer)object, this.getType().getValue());
        this.put((ByteBuffer)object, this.getUID());
        this.put((ByteBuffer)object, this.getDataSize());
    }

    public void deserialize(byte[] object) {
        if (((byte[])object).length < this.getSize()) {
            throw new IllegalArgumentException("The data.length() must be less than this.getSize();");
        }
        object = ByteBuffer.wrap((byte[])object, 0, this.getHeaderSize());
        this.a = ((ByteBuffer)object).getInt(4);
    }

    public MessageType getType() {
        return MessageType.from(this.getClass());
    }
}

