/*
 * Decompiled with CFR 0.152.
 */
package ice.util.alg;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.IThread;

public class ThreadVar {
    private static final ThreadVar OEAB = ThreadVar.OEAB();
    private HashArray Z;

    protected ThreadVar() {
    }

    private static ThreadVar OEAB() {
        ThreadVar threadVar = null;
        String string = Defs.sysProperty("ice.util.alg.ThreadVar");
        if (string != null) {
            threadVar = (ThreadVar)Defs.newClassInstance(string);
        }
        if (threadVar == null) {
            string = "ice.util.alg.jdk12.ThreadVar_jdk12";
            threadVar = (ThreadVar)Defs.newClassInstance(string);
        }
        if (Debug.trace) {
            Debug.trace(threadVar != null ? string : "JDK 1.1 compatible");
        }
        return threadVar;
    }

    public static ThreadVar create() {
        if (OEAB != null) {
            return OEAB.newInstance();
        }
        ThreadVar threadVar = new ThreadVar();
        threadVar.Z = new HashArray();
        return threadVar;
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof IThread) {
            return ((IThread)thread).locals.get(this);
        }
        return this.Z.get(thread);
    }

    public Object push(Object object) {
        Thread thread = Thread.currentThread();
        Object object2 = thread instanceof IThread ? ((IThread)thread).locals.put(this, object) : (object == null ? this.Z.remove(thread) : this.Z.put(thread, object));
        return object2;
    }

    public void restore(Object object) {
        Thread thread = Thread.currentThread();
        if (thread instanceof IThread) {
            ((IThread)thread).locals.put(this, object);
        } else if (object == null) {
            this.Z.remove(thread);
        } else {
            this.Z.put(thread, object);
        }
    }

    protected ThreadVar newInstance() {
        return null;
    }
}

