/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt.jdk14;

import ice.debug.Debug;
import ice.util.alg.Listeners;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class AWTMouseWheelListener
implements MouseWheelListener {
    private Scrollbar OEAB = null;
    private Scrollbar adjustmentValueChanged = null;

    private static void OEAB(Object object, AdjustmentEvent adjustmentEvent) {
        AdjustmentListener adjustmentListener;
        if (adjustmentEvent == null) {
            Debug.bug();
        }
        int n = 0;
        while ((adjustmentListener = (AdjustmentListener)Listeners.get(object, n)) != null) {
            adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            ++n;
        }
    }

    public AWTMouseWheelListener(Scrollbar scrollbar, Scrollbar scrollbar2) {
        this.OEAB = scrollbar;
        this.adjustmentValueChanged = scrollbar2;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollAmount() != 0) {
            int n = 0;
            Scrollbar scrollbar = this.OEAB;
            if (!(this.OEAB != null && this.OEAB.isVisible() || (scrollbar = this.adjustmentValueChanged) != null && scrollbar.isVisible())) {
                return;
            }
            int n2 = n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
            if (mouseWheelEvent.getScrollType() == 0) {
                this.scrollByUnits(scrollbar, n, mouseWheelEvent.getScrollAmount());
            } else if (mouseWheelEvent.getScrollType() == 1) {
                this.scrollByBlock(scrollbar, n);
            }
        }
    }

    protected void scrollByBlock(Scrollbar scrollbar, int n) {
        int n2 = scrollbar.getValue();
        int n3 = scrollbar.getBlockIncrement();
        int n4 = n3 * (n > 0 ? 1 : -1);
        int n5 = n2 + n4;
        scrollbar.setValue(n5);
        this.fireAdjustment(scrollbar, 5, n5);
    }

    protected void scrollByUnits(Scrollbar scrollbar, int n, int n2) {
        int n3 = n2;
        n3 = n > 0 ? (n3 *= scrollbar.getUnitIncrement()) : (n3 *= -scrollbar.getUnitIncrement());
        int n4 = scrollbar.getValue();
        int n5 = n4 + n3;
        if (n3 > 0 && n5 < n4) {
            n5 = scrollbar.getMaximum();
        } else if (n3 < 0 && n5 > n4) {
            n5 = scrollbar.getMinimum();
        }
        scrollbar.setValue(n5);
        this.fireAdjustment(scrollbar, 5, n5);
    }

    protected void fireAdjustment(Scrollbar scrollbar, int n, int n2) {
        Object object = null;
        AdjustmentListener[] adjustmentListenerArray = scrollbar.getAdjustmentListeners();
        object = adjustmentListenerArray.length == 1 ? adjustmentListenerArray[0] : adjustmentListenerArray;
        if (adjustmentListenerArray != null) {
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(scrollbar, 601, n, n2);
            AWTMouseWheelListener.OEAB(object, adjustmentEvent);
        }
    }
}

