/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.EventListModel;
import com.jidesoft.hints.ListDataIntelliHints;
import com.jidesoft.popup.JidePopup;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.SearchTextFieldHint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;

public class SearchTextFieldIntelliHints {
    private final SearchTextField fSearchTextField;
    private final Matcher<SearchTextFieldHint> fMatcher = this.createMatcher();
    private final EventList<SearchTextFieldHint> fRawHints;
    private final FilterList<SearchTextFieldHint> fFilterList;
    private final CustomJideIntelliHints fIntelliHints;
    private JidePopup fPopup;
    private boolean fShowHintsRequested;
    public static final String SELECT_NEXT_ROW_ACTION_NAME = "selectNextRow";
    public static final String SELECT_PREVIOUS_ROW_ACTION_NAME = "selectPreviousRow";
    public static final String PAGE_UP_ACTION_NAME = "scrollUp";
    public static final String PAGE_DOWN_ACTION_NAME = "scrollDown";

    public SearchTextFieldIntelliHints(SearchTextField searchTextField) {
        this(searchTextField, new ArrayList<SearchTextFieldHint>());
    }

    public SearchTextFieldIntelliHints(SearchTextField searchTextField, List<SearchTextFieldHint> list) {
        Validate.notNull((Object)searchTextField, (String)"The search text field cannot be null.");
        Validate.notNull(list, (String)"The hints list cannot be null.");
        this.fSearchTextField = searchTextField;
        this.fSearchTextField.addSearchTextFieldListener(this.createSearchTextFieldListener());
        this.fSearchTextField.getTextComponent().addFocusListener(this.createTextComponentShowHintsFocusListener());
        this.fRawHints = GlazedLists.threadSafeList((EventList)GlazedLists.eventList(list));
        this.fFilterList = new FilterList(this.fRawHints, this.fMatcher);
        this.fIntelliHints = new CustomJideIntelliHints(this.fSearchTextField.getTextComponent());
    }

    private Matcher<SearchTextFieldHint> createMatcher() {
        return new Matcher<SearchTextFieldHint>(){

            public boolean matches(SearchTextFieldHint searchTextFieldHint) {
                String string = SearchTextFieldIntelliHints.this.fSearchTextField.getSearchText().trim();
                return searchTextFieldHint.getCategory().matches(searchTextFieldHint, string);
            }
        };
    }

    private SearchTextField.Listener createSearchTextFieldListener() {
        return new SearchTextField.Listener(){

            @Override
            public void search(String string) {
                SearchTextFieldIntelliHints.this.addCurrentTextAsHint();
            }

            @Override
            public void searchTextChanged(String string) {
                SearchTextFieldIntelliHints.this.doSearchTextChanged();
            }

            @Override
            public void searchCleared() {
            }
        };
    }

    private void doSearchTextChanged() {
        this.fFilterList.setMatcher(this.fMatcher);
        if (this.fSearchTextField.getSearchText().length() == 0) {
            this.hideHintsPopup();
            this.fIntelliHints.setAutoPopup(false);
        } else {
            this.fIntelliHints.setAutoPopup(true);
        }
    }

    private FocusListener createTextComponentShowHintsFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (SearchTextFieldIntelliHints.this.fShowHintsRequested) {
                    SearchTextFieldIntelliHints.this.fIntelliHints.showHintsPopup();
                    SearchTextFieldIntelliHints.this.fShowHintsRequested = false;
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        };
    }

    public void addCurrentTextAsHint() {
        String string = this.fSearchTextField.getSearchText().trim();
        if (string.length() > 0) {
            this.removeHint(new SearchTextFieldHint(string));
            this.addHintToBeginning(new SearchTextFieldHint(string));
        }
    }

    public void addHintToBeginning(SearchTextFieldHint searchTextFieldHint) {
        this.fRawHints.add(0, (Object)searchTextFieldHint);
    }

    public void addHints(List<SearchTextFieldHint> list) {
        this.fRawHints.addAll(list);
    }

    public void removeHint(SearchTextFieldHint searchTextFieldHint) {
        this.fRawHints.remove((Object)searchTextFieldHint);
    }

    public void removeAllHintsInCategory(SearchTextFieldHint.Category category) {
        Validate.notNull((Object)category, (String)"The given Category cannot be null.");
        Iterator iterator = this.fRawHints.iterator();
        while (iterator.hasNext()) {
            SearchTextFieldHint searchTextFieldHint = (SearchTextFieldHint)iterator.next();
            if (!searchTextFieldHint.getCategory().equals(category)) continue;
            iterator.remove();
        }
    }

    public List<SearchTextFieldHint> getHints() {
        return Collections.unmodifiableList(this.fRawHints);
    }

    public void showCategoryHeaders() {
        this.fIntelliHints.showCategoryHeaders();
    }

    public void showHintsPopup() {
        if (this.fSearchTextField.getTextComponent().hasFocus()) {
            this.fIntelliHints.showHintsPopup();
        } else {
            this.fShowHintsRequested = true;
            this.fSearchTextField.getTextComponent().requestFocusInWindow();
        }
    }

    public void hideHintsPopup() {
        this.fIntelliHints.hideHintsPopup();
    }

    private Action createNextAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SearchTextFieldIntelliHints.this.fIntelliHints.getList().getSelectedIndex() + 1;
                SearchTextFieldIntelliHints.this.selectRowFavoringNext(n);
            }
        };
    }

    private Action createPreviousAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SearchTextFieldIntelliHints.this.fIntelliHints.getList().getSelectedIndex() - 1;
                SearchTextFieldIntelliHints.this.selectRowFavoringPrevious(n);
            }
        };
    }

    private Action createPageUpAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JList jList = SearchTextFieldIntelliHints.this.fIntelliHints.getList();
                if (jList.getFirstVisibleIndex() == jList.getLeadSelectionIndex()) {
                    Point point = jList.getVisibleRect().getLocation();
                    point.y = Math.max(0, jList.getVisibleRect().y - jList.getVisibleRect().height);
                    n = jList.locationToIndex(point);
                } else {
                    n = jList.getFirstVisibleIndex();
                }
                if (!SearchTextFieldIntelliHints.this.selectRowFavoringPrevious(n)) {
                    SearchTextFieldIntelliHints.this.selectRowFavoringNext(n);
                }
            }
        };
    }

    private Action createPageDownAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JList jList = SearchTextFieldIntelliHints.this.fIntelliHints.getList();
                if (jList.getLastVisibleIndex() == jList.getLeadSelectionIndex()) {
                    Point point = jList.getVisibleRect().getLocation();
                    point.y += jList.getVisibleRect().height * 2 - 1;
                    n = jList.locationToIndex(point);
                } else {
                    n = jList.getLastVisibleIndex();
                }
                if (!SearchTextFieldIntelliHints.this.selectRowFavoringNext(n)) {
                    SearchTextFieldIntelliHints.this.selectRowFavoringPrevious(n);
                }
            }
        };
    }

    private boolean selectRowFavoringPrevious(int n) {
        int n2;
        for (n2 = n; n2 >= 0; --n2) {
            if (!this.fIntelliHints.canSelect(n2)) continue;
            JList jList = this.fIntelliHints.getList();
            jList.setSelectedIndex(n2);
            jList.ensureIndexIsVisible(n2);
            break;
        }
        return this.fIntelliHints.getList().getSelectedIndex() == n2;
    }

    private boolean selectRowFavoringNext(int n) {
        int n2;
        JList jList = this.fIntelliHints.getList();
        for (n2 = n; n2 < jList.getModel().getSize(); ++n2) {
            if (!this.fIntelliHints.canSelect(n2)) continue;
            jList.setSelectedIndex(n2);
            jList.ensureIndexIsVisible(n2);
            break;
        }
        return this.fIntelliHints.getList().getSelectedIndex() == n2;
    }

    private static Comparator<SearchTextFieldHint> createGroupByCategoryComparator() {
        return new Comparator<SearchTextFieldHint>(){

            @Override
            public int compare(SearchTextFieldHint searchTextFieldHint, SearchTextFieldHint searchTextFieldHint2) {
                return searchTextFieldHint.getCategory().compareTo(searchTextFieldHint2.getCategory());
            }
        };
    }

    private static ListCellRenderer createListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof SeparatorList.Separator) {
                    SeparatorList.Separator separator = (SeparatorList.Separator)object;
                    SearchTextFieldHint.Category category = ((SearchTextFieldHint)separator.getGroup().get(0)).getCategory();
                    SearchTextFieldIntelliHints.prepareSeparatorRenderer(jLabel, category);
                } else {
                    assert (object instanceof SearchTextFieldHint) : "Only SearchTextFieldHints should be in the list.";
                    SearchTextFieldIntelliHints.prepareHintRenderer(jLabel, (SearchTextFieldHint)object);
                }
                return jLabel;
            }
        };
    }

    private static void prepareSeparatorRenderer(JLabel jLabel, SearchTextFieldHint.Category category) {
        jLabel.setText(category.getDisplayString());
        jLabel.setForeground(UIManager.getColor("MenuItem.disabledForeground"));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
    }

    private static void prepareHintRenderer(JLabel jLabel, SearchTextFieldHint searchTextFieldHint) {
        jLabel.setText(searchTextFieldHint.getDisplayString());
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 5));
    }

    private class CustomSelectionModel
    extends DefaultListSelectionModel {
        private CustomSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            assert (n == n2) : "Only a single item can be selected.";
            if (SearchTextFieldIntelliHints.this.fIntelliHints.canSelect(n)) {
                super.setSelectionInterval(n, n2);
            }
        }
    }

    private class CustomJideIntelliHints
    extends ListDataIntelliHints<SearchTextFieldHint> {
        private final SwingThreadProxyEventList<SearchTextFieldHint> iSwingProxyList;
        private EventListModel<SearchTextFieldHint> iListModel;
        private boolean initialized;

        private CustomJideIntelliHints(JTextComponent jTextComponent) {
            super(jTextComponent, new ArrayList());
            this.iSwingProxyList = new SwingThreadProxyEventList((EventList)SearchTextFieldIntelliHints.this.fFilterList);
            this.iSwingProxyList.addListEventListener(this.createListEventListener());
            this.iListModel = new EventListModel(this.iSwingProxyList);
            this.showHints();
            this.getList().setModel(this.iListModel);
            this.initKeyboardActions();
            this.initialized = true;
        }

        private void showCategoryHeaders() {
            this.iListModel.dispose();
            SeparatorList separatorList = new SeparatorList(this.iSwingProxyList, SearchTextFieldIntelliHints.createGroupByCategoryComparator(), 1, 1000);
            this.iListModel = new EventListModel((EventList)separatorList);
            this.getList().setModel(this.iListModel);
        }

        private void initKeyboardActions() {
            JList jList = this.getList();
            jList.getActionMap().put(SearchTextFieldIntelliHints.SELECT_NEXT_ROW_ACTION_NAME, SearchTextFieldIntelliHints.this.createNextAction());
            jList.getActionMap().put(SearchTextFieldIntelliHints.SELECT_PREVIOUS_ROW_ACTION_NAME, SearchTextFieldIntelliHints.this.createPreviousAction());
            jList.getActionMap().put(SearchTextFieldIntelliHints.PAGE_UP_ACTION_NAME, SearchTextFieldIntelliHints.this.createPageUpAction());
            jList.getActionMap().put(SearchTextFieldIntelliHints.PAGE_DOWN_ACTION_NAME, SearchTextFieldIntelliHints.this.createPageDownAction());
        }

        private ListEventListener<SearchTextFieldHint> createListEventListener() {
            return new ListEventListener<SearchTextFieldHint>(){

                public void listChanged(ListEvent<SearchTextFieldHint> listEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SearchTextFieldIntelliHints.this.fFilterList.isEmpty()) {
                                CustomJideIntelliHints.this.hideHintsPopup();
                            } else {
                                SearchTextFieldIntelliHints.this.fPopup.packPopup();
                            }
                        }
                    });
                }
            };
        }

        protected JidePopup createPopup() {
            SearchTextFieldIntelliHints.this.fPopup = super.createPopup();
            SearchTextFieldIntelliHints.this.fPopup.setResizable(false);
            Color color = PlatformInfo.isMacintosh() ? UIManager.getColor("ScrollBar.background") : UIManager.getColor("controlDkShadow");
            SearchTextFieldIntelliHints.this.fPopup.setPopupBorder(BorderFactory.createLineBorder(color));
            return SearchTextFieldIntelliHints.this.fPopup;
        }

        protected JList createList() {
            JList jList = this.doCreateList();
            MJUtilities.addPageKeyBindingsToMacJList((JList)jList);
            jList.setSelectionModel(new CustomSelectionModel());
            jList.setCellRenderer(SearchTextFieldIntelliHints.createListCellRenderer());
            jList.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            return jList;
        }

        private JList doCreateList() {
            return new JList(){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    JTextComponent jTextComponent = CustomJideIntelliHints.this.getTextComponent();
                    Insets insets = jTextComponent.getInsets();
                    int n = CustomJideIntelliHints.this.getTextComponent().getWidth() - insets.left - insets.right / 2;
                    int n2 = Math.max(n, this.getPreferredSize().width);
                    int n3 = this.getViewPortHeight();
                    Rectangle rectangle = WindowUtils.computeTextPopupBounds((Dimension)new Dimension(n2, n3), (Dimension)new Dimension(n2, 0), (JTextComponent)CustomJideIntelliHints.this.getTextComponent(), (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
                    return new Dimension(rectangle.width, rectangle.height);
                }

                private int getViewPortHeight() {
                    Rectangle rectangle = this.getUI().getCellBounds(this, 0, 0);
                    int n = 0;
                    if (rectangle != null) {
                        n = (int)rectangle.getHeight() * 20;
                    }
                    return n == 0 || this.getPreferredSize().getHeight() < (double)n ? (int)this.getPreferredSize().getHeight() : n;
                }
            };
        }

        public boolean updateHints(Object object) {
            return this.initialized && !SearchTextFieldIntelliHints.this.fFilterList.isEmpty();
        }

        public void acceptHint(Object object) {
            super.acceptHint(object);
            SearchTextFieldIntelliHints.this.addCurrentTextAsHint();
            SearchTextFieldIntelliHints.this.fSearchTextField.requestSearch();
        }

        protected JList getList() {
            return super.getList();
        }

        protected void showHintsPopup() {
            this.getList().clearSelection();
            super.showHintsPopup();
        }

        protected void hideHintsPopup() {
            super.hideHintsPopup();
        }

        protected void setListData(Object[] objectArray) {
        }

        public KeyStroke[] getDelegateKeyStrokes() {
            return new KeyStroke[]{KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(33, 0)};
        }

        private boolean canSelect(int n) {
            return this.getList().getModel().getElementAt(n) instanceof SearchTextFieldHint;
        }
    }
}

