/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.FixedIcon;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.ResizableIcon;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTEdgeButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

class DTComponentBar
extends MJLayeredPane
implements Iterable<Component> {
    private static final Color SELECTION_COLOR = new Color(243, 184, 76);
    private static final Color ROLLOVER_COLOR = new Color(255, 216, 128);
    private int fOrientation;
    private List<Component> fLayoutList = new ArrayList<Component>();
    private DragOffListener fDragOffListener;
    private List<LayoutListener> fLayoutListeners;
    private MouseInputListener fDragDetector = new ComponentDragDetector();
    private ComponentDragger fDragger;
    private static final Dimension DRAG_THRESHOLD = new Dimension(10, 6);

    DTComponentBar(int n) {
        this.fOrientation = n;
        this.setOpaque(true);
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                DTComponentBar.this.fLayoutList.add(component);
                component.addMouseListener(DTComponentBar.this.fDragDetector);
                component.addMouseMotionListener(DTComponentBar.this.fDragDetector);
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                DTComponentBar.this.fLayoutList.remove(component);
                component.removeMouseListener(DTComponentBar.this.fDragDetector);
                component.removeMouseMotionListener(DTComponentBar.this.fDragDetector);
            }
        });
    }

    void addToLayout(Component component, int n) {
        this.add(component);
        this.fLayoutList.remove(component);
        this.fLayoutList.add(n, component);
    }

    int layoutIndexOf(Component component) {
        return this.fLayoutList.indexOf(component);
    }

    Component getComponentAtLayoutIndex(int n) {
        return this.fLayoutList.get(n);
    }

    void moveComponent(int n, int n2) {
        Component component = this.fLayoutList.remove(n);
        this.fLayoutList.add(n2, component);
        this.revalidate();
        this.repaint();
        this.fireLayoutListeners(component, n, n2);
    }

    protected void moveComponentNoEvent(int n, int n2) {
        Component component = this.fLayoutList.remove(n);
        this.fLayoutList.add(n2, component);
        this.revalidate();
        this.repaint();
    }

    void addLayoutListener(LayoutListener layoutListener) {
        if (this.fLayoutListeners == null) {
            this.fLayoutListeners = new ArrayList<LayoutListener>();
        }
        if (!this.fLayoutListeners.contains(layoutListener)) {
            this.fLayoutListeners.add(layoutListener);
        }
    }

    void removeLayoutListener(LayoutListener layoutListener) {
        if (this.fLayoutListeners != null) {
            this.fLayoutListeners.remove(layoutListener);
        }
    }

    void setDragOffListener(DragOffListener dragOffListener) {
        this.fDragOffListener = dragOffListener;
    }

    int getNextComponentLocation(int n) {
        int n2 = 1;
        if (this.fLayoutList.size() >= 0) {
            Rectangle rectangle = this.fLayoutList.get(this.fLayoutList.size() - 1).getBounds();
            if (this.fOrientation == 0) {
                n2 = rectangle.x + rectangle.width + 1;
                if (n2 + n > this.getWidth()) {
                    n2 = Math.max(0, this.getWidth() - n);
                }
            } else {
                n2 = rectangle.y + rectangle.height + 1;
                if (n2 + n > this.getHeight()) {
                    n2 = Math.max(0, this.getHeight() - n);
                }
            }
        }
        return n2;
    }

    @Override
    public Iterator<Component> iterator() {
        return this.fLayoutList.iterator();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        if (this.fLayoutList.size() > 0) {
            if (this.fOrientation == 0) {
                for (Component component : this.fLayoutList) {
                    Dimension dimension2 = component.getPreferredSize();
                    if (dimension2.height > dimension.height) {
                        dimension.height = dimension2.height;
                    }
                    dimension.width += dimension2.width;
                }
            } else {
                for (Component component : this.fLayoutList) {
                    Dimension dimension3 = component.getPreferredSize();
                    if (dimension3.width > dimension.width) {
                        dimension.width = dimension3.width;
                    }
                    dimension.height += dimension3.height;
                }
            }
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    boolean isDraggingComponent() {
        return this.fDragger != null;
    }

    public void doLayout() {
        int n = this.fLayoutList.size();
        if (n == 0) {
            return;
        }
        Insets insets = this.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        int n4 = this.getWidth() - insets.left - insets.right;
        int n5 = this.getHeight() - insets.top - insets.bottom;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.fOrientation == 0) {
            int n9;
            int n10 = n4 / n;
            int[] nArray = new int[n];
            for (n9 = 0; n9 < n; ++n9) {
                Component component = this.fLayoutList.get(n9);
                nArray[n9] = component.isVisible() ? component.getPreferredSize().width : 0;
                n7 += nArray[n9];
                if (nArray[n9] > n10) {
                    ++n6;
                    continue;
                }
                n8 += n10 - nArray[n9];
            }
            n9 = n10;
            if (n6 > 0) {
                n9 += n8 / n6;
            }
            for (int i = 0; i < n; ++i) {
                int n11 = nArray[i];
                if (n7 > n4) {
                    if (i == n - 1) {
                        n11 = n4 - insets.right - n2;
                    } else if (n11 > n9) {
                        n11 = n9;
                    }
                }
                Component component = this.fLayoutList.get(i);
                if (this.fDragger == null || this.fDragger.iDragComponent != component) {
                    component.setBounds(n2, n3, n11, n5);
                }
                n2 += n11;
            }
        } else {
            int n12;
            int n13 = n5 / n;
            int[] nArray = new int[n];
            for (n12 = 0; n12 < n; ++n12) {
                Component component = this.fLayoutList.get(n12);
                nArray[n12] = component.isVisible() ? component.getPreferredSize().height : 0;
                n7 += nArray[n12];
                if (nArray[n12] > n13) {
                    ++n6;
                    continue;
                }
                n8 += n13 - nArray[n12];
            }
            n12 = n13;
            if (n6 > 0) {
                n12 += n8 / n6;
            }
            for (int i = 0; i < n; ++i) {
                int n14 = nArray[i];
                if (n7 > n5) {
                    if (i == n - 1) {
                        n14 = n5 - insets.bottom - n3;
                    } else if (n14 > n12) {
                        n14 = n12;
                    }
                }
                Component component = this.fLayoutList.get(i);
                if (this.fDragger == null || this.fDragger.iDragComponent != component) {
                    component.setBounds(n2, n3, n4, n14);
                }
                n3 += n14;
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(UIManager.getColor("control"));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(graphics);
    }

    private void fireLayoutListeners(Component component, int n, int n2) {
        if (this.fLayoutListeners != null) {
            for (LayoutListener layoutListener : this.fLayoutListeners) {
                layoutListener.componentMoved(this, component, n, n2);
            }
        }
    }

    protected class ItemProxy
    extends MJLabel
    implements MouseListener {
        private boolean iIsMouseOver;
        private ItemAccess iItemAccess;

        ItemProxy(String string, Icon icon, ItemAccess itemAccess) {
            super(string, 0);
            if (icon instanceof ResizableIcon) {
                this.handleResizableIcon((ResizableIcon)icon);
            } else {
                this.setIcon(icon);
            }
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(2);
            this.iItemAccess = itemAccess;
            this.init();
        }

        ItemProxy(Icon icon, String string, ItemAccess itemAccess) {
            super(string, 0);
            if (icon instanceof ResizableIcon) {
                this.handleResizableIcon((ResizableIcon)icon);
            } else {
                this.setIcon(icon);
            }
            this.setIconTextGap(2);
            this.iItemAccess = itemAccess;
            this.init();
        }

        ItemProxy(Icon icon, ItemAccess itemAccess) {
            if (icon instanceof ResizableIcon) {
                this.handleResizableIcon((ResizableIcon)icon);
            } else {
                this.setIcon(icon);
            }
            this.iItemAccess = itemAccess;
            this.init();
        }

        private void init() {
            this.setCursor(Cursor.getPredefinedCursor(11));
            this.addMouseListener(this);
        }

        private void handleResizableIcon(ResizableIcon resizableIcon) {
            int n = resizableIcon.getSmallestIconWidth();
            if (n <= 0) {
                n = 16;
            }
            this.setIcon((Icon)new FixedIcon(resizableIcon, n, 16));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.iItemAccess.setSelectedItem((JComponent)((Object)this));
            if (this.iItemAccess instanceof DTComponentBar) {
                ((Component)((Object)this.iItemAccess)).requestFocusInWindow();
                this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiersEx() & 0xC00) == 0) {
                this.iIsMouseOver = true;
                this.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.iIsMouseOver = false;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            if (this.iIsMouseOver) {
                graphics.setColor(ROLLOVER_COLOR);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else if (this.iItemAccess.getSelectedItem() == this) {
                graphics.setColor(SELECTION_COLOR);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(graphics);
        }
    }

    static interface ItemAccess {
        public void setSelectedItem(JComponent var1);

        public JComponent getSelectedItem();

        public void selectFirst();

        public void selectPrevious();

        public void selectNext();

        public void selectLast();

        public void moveSelectedItemToLeft();

        public void moveSelectedItemToRight();

        public void moveSelectedItemToBegin();

        public void moveSelectedItemToEnd();

        public void addSeparator();

        public void removeSelectedItem();

        public void restoreDefault();

        public boolean toggleLabelVisibility();
    }

    private class ComponentDragger
    extends MouseInputAdapter {
        Component iDragComponent;
        int iInitialIndex;
        int iCurrentIndex;
        boolean iLockToBar;
        int iInitialCoord;
        Rectangle iInitialBounds;
        int iUpperLimit;

        ComponentDragger(Component component, MouseEvent mouseEvent, MouseEvent mouseEvent2) {
            this.iDragComponent = component;
            this.iCurrentIndex = this.iInitialIndex = DTComponentBar.this.fLayoutList.indexOf(component);
            Component component2 = (Component)mouseEvent.getSource();
            Point point = SwingUtilities.convertPoint(component2, mouseEvent.getPoint(), (Component)((Object)DTComponentBar.this));
            this.iInitialCoord = DTComponentBar.this.fOrientation == 1 ? point.y : point.x;
            this.iInitialBounds = component.getBounds();
            Rectangle rectangle = ((Component)DTComponentBar.this.fLayoutList.get(DTComponentBar.this.fLayoutList.size() - 1)).getBounds();
            this.iUpperLimit = DTComponentBar.this.fOrientation == 1 ? rectangle.y + rectangle.height - this.iInitialBounds.height - 2 : rectangle.x + rectangle.width - this.iInitialBounds.width - 2;
            DTComponentBar.this.setLayer(this.iDragComponent, JLayeredPane.DRAG_LAYER);
            this.iDragComponent.addMouseListener(this);
            this.iDragComponent.addMouseMotionListener(this);
            this.mouseDragged(mouseEvent2);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), (Component)((Object)DTComponentBar.this));
            if (!(this.iLockToBar || DTComponentBar.this.fDragOffListener == null || (DTComponentBar.this.fOrientation != 1 || point.x >= 0 && point.x <= DTComponentBar.this.getWidth()) && (DTComponentBar.this.fOrientation != 0 || point.y >= 0 && point.y <= DTComponentBar.this.getHeight()))) {
                this.abortDrag();
                DTComponentBar.this.fDragOffListener.startDragOff(DTComponentBar.this, this.iDragComponent);
            } else {
                this.dragComponent(point.x, point.y);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupSuccesor((MouseEvent)mouseEvent)) {
                return;
            }
            if (this.iCurrentIndex != this.iInitialIndex) {
                DTComponentBar.this.fireLayoutListeners(this.iDragComponent, this.iInitialIndex, this.iCurrentIndex);
            }
            this.endDrag();
        }

        void abortDrag() {
            if (this.iCurrentIndex != this.iInitialIndex) {
                Collections.swap(DTComponentBar.this.fLayoutList, this.iCurrentIndex, this.iInitialIndex);
                DTComponentBar.this.revalidate();
                DTComponentBar.this.repaint();
            }
            this.endDrag();
        }

        void endDrag() {
            DTComponentBar.this.fDragger = null;
            DTComponentBar.this.setLayer(this.iDragComponent, JLayeredPane.DEFAULT_LAYER);
            this.iDragComponent.removeMouseMotionListener(this);
            this.iDragComponent.removeMouseListener(this);
        }

        void dragComponent(int n, int n2) {
            int n3;
            int n4 = this.iInitialBounds.x;
            int n5 = this.iInitialBounds.y;
            if (DTComponentBar.this.fOrientation == 1) {
                int n6 = n2 - this.iInitialCoord;
                n5 += n6;
                if (n6 > 0) {
                    if (n5 > this.iUpperLimit) {
                        n5 = this.iUpperLimit;
                    }
                } else if (n5 < 0) {
                    n5 = 0;
                }
                n3 = n5 >= this.iDragComponent.getY() ? 1 : -1;
            } else {
                int n7 = n - this.iInitialCoord;
                n4 += n7;
                if (n7 > 0) {
                    if (n4 > this.iUpperLimit) {
                        n4 = this.iUpperLimit;
                    }
                } else if (n4 < 0) {
                    n4 = 0;
                }
                n3 = n4 >= this.iDragComponent.getX() ? 1 : -1;
            }
            this.iDragComponent.setLocation(n4, n5);
            if (n3 > 0) {
                int n8 = this.iCurrentIndex + 1;
                if (n8 < DTComponentBar.this.fLayoutList.size()) {
                    Component component = (Component)DTComponentBar.this.fLayoutList.get(n8);
                    if (DTComponentBar.this.fOrientation == 1) {
                        int n9 = component.getY();
                        int n10 = n9 + component.getHeight() / 2;
                        if (n5 + this.iInitialBounds.height > n10) {
                            component.setLocation(component.getX(), n9 -= this.iInitialBounds.height);
                            Collections.swap(DTComponentBar.this.fLayoutList, this.iCurrentIndex, n8);
                            this.iCurrentIndex = n8;
                            this.iLockToBar = true;
                            DTComponentBar.this.repaint(0L, n4, n9, this.iInitialBounds.width, this.iInitialBounds.height + component.getHeight());
                        }
                    } else {
                        int n11 = component.getX();
                        int n12 = n11 + component.getWidth() / 2;
                        if (n4 + this.iInitialBounds.width > n12) {
                            component.setLocation(n11 -= this.iInitialBounds.width, component.getY());
                            Collections.swap(DTComponentBar.this.fLayoutList, this.iCurrentIndex, n8);
                            this.iCurrentIndex = n8;
                            this.iLockToBar = true;
                            DTComponentBar.this.repaint(0L, n11, n5, this.iInitialBounds.width + component.getWidth(), this.iInitialBounds.height);
                        }
                    }
                }
            } else {
                int n13 = this.iCurrentIndex - 1;
                if (n13 >= 0) {
                    Component component = (Component)DTComponentBar.this.fLayoutList.get(n13);
                    if (DTComponentBar.this.fOrientation == 1) {
                        int n14 = component.getY();
                        int n15 = n14 + component.getHeight() / 2;
                        if (n5 < n15) {
                            component.setLocation(component.getX(), n14 += this.iInitialBounds.height);
                            Collections.swap(DTComponentBar.this.fLayoutList, n13, this.iCurrentIndex);
                            this.iCurrentIndex = n13;
                            this.iLockToBar = true;
                            DTComponentBar.this.repaint(0L, n4, n14 - this.iInitialBounds.height, this.iInitialBounds.width, this.iInitialBounds.height + component.getHeight());
                        }
                    } else {
                        int n16 = component.getX();
                        int n17 = n16 + component.getWidth() / 2;
                        if (n4 < n17) {
                            component.setLocation(n16 += this.iInitialBounds.width, component.getY());
                            Collections.swap(DTComponentBar.this.fLayoutList, n13, this.iCurrentIndex);
                            this.iCurrentIndex = n13;
                            this.iLockToBar = true;
                            DTComponentBar.this.repaint(0L, n16 - this.iInitialBounds.width, n5, this.iInitialBounds.width + component.getWidth(), this.iInitialBounds.height);
                        }
                    }
                }
            }
        }
    }

    private class ComponentDragDetector
    extends DTDragDetector {
        ComponentDragDetector() {
            this.fDragThreshold = DRAG_THRESHOLD;
        }

        @Override
        protected Object getLoad(MouseEvent mouseEvent) {
            return mouseEvent.getSource();
        }

        @Override
        protected void startDrag(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (this.fLoad != component) {
                return;
            }
            super.startDrag(mouseEvent);
            if (component instanceof DTEdgeButton) {
                ((DTEdgeButton)((Object)component)).lock();
            }
            Point point = mouseEvent.getPoint();
            if (DTComponentBar.this.contains(point = SwingUtilities.convertPoint(component, point, (Component)((Object)DTComponentBar.this)))) {
                DTComponentBar.this.fDragger = new ComponentDragger(component, this.fPressedEvent, mouseEvent);
            } else if (DTComponentBar.this.fDragOffListener != null) {
                DTComponentBar.this.fDragOffListener.startDragOff(DTComponentBar.this, component);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            final Component component = mouseEvent.getComponent();
            if (component instanceof DTEdgeButton) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((DTEdgeButton)((Object)component)).unlock();
                    }
                });
            }
        }

        @Override
        protected String getHint(MouseEvent mouseEvent) {
            if (DTComponentBar.this.fDragOffListener != null) {
                return DTComponentBar.this.fDragOffListener.getDragHint(DTComponentBar.this, mouseEvent.getComponent());
            }
            return super.getHint(mouseEvent);
        }
    }

    static interface DragOffListener {
        public String getDragHint(DTComponentBar var1, Component var2);

        public void startDragOff(DTComponentBar var1, Component var2);
    }

    static interface LayoutListener {
        public void componentMoved(DTComponentBar var1, Component var2, int var3, int var4);
    }
}

