/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.ControlKeyOverride;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJDimensionPicker;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTiledPane;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTCloseDialog;
import com.mathworks.widgets.desk.DTCloseTransaction;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentArranger;
import com.mathworks.widgets.desk.DTDocumentTabsProperties;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDragger;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTExternalTarget;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFloatingPane;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMaximizedPane;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTabbedPane;
import com.mathworks.widgets.desk.DTTileDialog;
import com.mathworks.widgets.desk.DTTiledPane;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.TargetedAction;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTDocumentContainer
extends MJPanel
implements DTContainer,
ItemSelectable,
PropertyChangeListener,
ActionListener,
MJTiledPane.GridListener,
ControlKeyOverride {
    private Desktop fDesktop;
    private DTFrame fFrame;
    private DTGroup fGroup;
    private boolean fShowTitleWhenMaximized;
    private List<DTClient> fDocuments = new ArrayList<DTClient>();
    private Panel fHeavyPanel;
    private DTFloatingPane fFloatingPane;
    private DTTiledPane fTiledPane;
    private DTMaximizedPane fMaximizedPane;
    private int fArrangement = -1;
    private ItemListener fSelectionListener;
    private List<ArrangementListener> fArrangementListeners;
    private MouseListener fBackgroundListener;
    private JToolBar fTopRightToolBar;
    private JToolBar fTopLeftToolBar;
    private JComponent fBlankPanel;
    private DTDocumentTabsProperties fTabProperties;
    private DTClient fLastSelectedDocument;
    private boolean fIsSelected;
    private boolean fRestoringDocuments;
    private boolean fIsChangingArrangement;
    private boolean fWasEmpty;
    private boolean fWasShowing;
    private Component fFocusOwnerBeforePicker;
    private int fHeavyDocumentCount;
    private int fLastTabsEdge;
    private TileAction fTileAction;
    private MJAbstractAction fTileSelectAction;
    private MJAbstractAction fSplitEastWestAction;
    private MJAbstractAction fSplitNorthSouthAction;
    private MJAbstractAction fFloatAction;
    private MJAbstractAction fMaximizeAction;
    private ActionListener fMaximizeListener;
    private MJAbstractAction[] fArrangementActions = new MJAbstractAction[5];
    private MJAbstractAction fCloseAllAction;
    private MJAbstractAction fCascadeAction;
    private MJAbstractAction fMinimizeAllAction;
    private DropTargetListener fDropTargetListener;
    private KeyListener fEmptyKeyListener;
    public static final int HIDE_TABS = -1;
    public static final int DEFAULT_TABS_EDGE = 1;
    public static final int NEVER_HEAVY = 0;
    public static final int ALWAYS_HEAVY = 1;
    public static final int CONDITIONALLY_HEAVY = 2;
    public static final int WHEN_HEAVY = 2;
    public static final int MAXIMIZED = 1;
    public static final int TILED = 2;
    public static final int FLOATING = 3;
    private static final int MINIMUM_CONTAINER_SIZE = 100;
    static final String DOCUMENT_AREA_TAG = "DocumentArea";
    private static final String SHOWING_ATTRIBUTE = "Showing";
    private static final String YES_VALUE = "yes";
    private static final String NO_VALUE = "no";
    private static final String EMPTY_ATTRIBUTE = "Empty";
    private static final String ARRANGEMENT_ATTRIBUTE = "Arrangement";
    private static final String MAXIMIZED_VALUE = "maximized";
    private static final String TILED_VALUE = "tiled";
    private static final String FLOATING_VALUE = "floating";
    private static final String BAR_ATTRIBUTE = "Bar";
    private static final String SHRINK_TABS_ATTRIBUTE = "ShrinkTabs";
    private static final String LEFT_VALUE = "left";
    private static final String RIGHT_VALUE = "right";
    private static final String TOP_VALUE = "top";
    private static final String BOTTOM_VALUE = "bottom";
    private static final String HIDE_VALUE = "hide";
    private static final String MAX_BAR_WIDTH_ATTRIBUTE = "MaxBarWidth";

    DTDocumentContainer(Desktop desktop, DTFrame dTFrame, DTGroup dTGroup) {
        this(desktop, dTFrame, dTGroup, null);
    }

    DTDocumentContainer(Desktop desktop, DTFrame dTFrame, DTGroup dTGroup, Object object) {
        this.setName("DesktopDocumentContainer");
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.fGroup = dTGroup;
        if (this.fGroup != null) {
            this.fGroup.addPropertyListener(this);
        }
        this.fTabProperties = new DTDocumentTabsProperties(desktop);
        this.fTabProperties.addListener(new DTDocumentTabsProperties.Listener(){

            @Override
            public void tabPropertyChanged(DTDocumentTabsProperties dTDocumentTabsProperties, DTDocumentTabsProperties.Type type) {
                if (type == DTDocumentTabsProperties.Type.EDGE) {
                    DTDocumentContainer.this.fLastTabsEdge = DTDocumentContainer.this.fTabProperties.getEdge();
                }
            }
        });
        this.fShowTitleWhenMaximized = dTGroup == null;
        State state = (State)object;
        if (state != null) {
            this.fWasEmpty = state.fWasEmpty;
            this.fWasShowing = state.fWasShowing;
        }
        this.setLayout(null);
        this.fBackgroundListener = new BackgroundMouseListener();
        this.fTileAction = new TileAction();
        this.fArrangementActions[0] = this.fTileAction;
        this.fArrangementActions[1] = this.fSplitEastWestAction = new SplitEastWestAction();
        this.fArrangementActions[2] = this.fSplitNorthSouthAction = new SplitNorthSouthAction();
        this.fArrangementActions[3] = this.fFloatAction = new FloatAction();
        this.fArrangementActions[4] = this.fMaximizeAction = new MaximizeAction();
        int n = 1;
        if (state != null && state.fTabsEdge != 1) {
            n = state.fTabsEdge;
        }
        this.fLastTabsEdge = n;
        this.setTabsEdge(n);
        this.updateTabVisibility();
        int n2 = state != null && state.fMaxTabsWidth > 0 ? state.fMaxTabsWidth : Toolkit.getDefaultToolkit().getScreenSize().width >> 3;
        this.fTabProperties.setMaxWidth(n2);
        if (state != null) {
            this.fTabProperties.setShrinkToFit(state.fShrinkTabsToFit);
        }
        int n3 = 1;
        Dimension dimension = null;
        if (state != null && (n3 = state.fArrangement) == 2) {
            try {
                this.fTiledPane = new DTTiledPane(this, state.fTiledState);
                this.fTiledPane.addGridListener(this);
                this.fTiledPane.addMouseListener(this.fBackgroundListener);
                this.addArrangerListeners(this.fTiledPane);
                dimension = this.fTiledPane.getGridSize();
            }
            catch (Exception exception) {
                this.fTiledPane = null;
                n3 = 1;
            }
        }
        this.setArrangement(n3, dimension);
        this.setKeyBindings();
    }

    void cleanup() {
        if (this.fGroup != null) {
            this.fGroup.removePropertyListener(this);
        }
    }

    protected void setKeyBindings() {
        this.setInputMap(1, DTKeyBindings.getInstance().getInputMap());
        ActionMap actionMap = this.getActionMap();
        actionMap.put("select-next-tab", (Action)((Object)new NextDocumentAction()));
        actionMap.put("select-previous-tab", (Action)((Object)new PreviousDocumentAction()));
    }

    Action getNextDocumentAction() {
        return this.getActionByName("select-next-tab");
    }

    Action getPrevDocumentAction() {
        return this.getActionByName("select-previous-tab");
    }

    private Action getActionByName(String string) {
        return this.getActionMap().get(string);
    }

    public boolean wantKey(KeyStroke keyStroke, Component component) {
        DTClientFrame dTClientFrame = (DTClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTClientFrame.class, component));
        return dTClientFrame == null || !dTClientFrame.getClient().wantsControlKeys();
    }

    private void setHeavy(boolean bl) {
        if (bl != this.isHeavy()) {
            if (bl) {
                Component component = this.getComponent(0);
                this.fHeavyPanel = new Panel();
                this.fHeavyPanel.setFocusable(false);
                this.fHeavyPanel.setLayout(new BorderLayout());
                this.remove(component);
                this.fHeavyPanel.add(component, "Center");
                this.add(this.fHeavyPanel);
            } else {
                Component component = this.fHeavyPanel.getComponent(0);
                this.remove(this.fHeavyPanel);
                this.add(component);
                this.fHeavyPanel = null;
            }
        }
    }

    boolean isHeavy() {
        return this.fHeavyPanel != null;
    }

    private JComponent getArrangerComponent() {
        switch (this.fArrangement) {
            case 1: {
                return this.fMaximizedPane;
            }
            case 3: {
                return this.fFloatingPane;
            }
            case 2: {
                return this.fTiledPane;
            }
        }
        return this.fMaximizedPane;
    }

    DTDocumentArranger getArranger() {
        switch (this.fArrangement) {
            case 1: {
                return this.fMaximizedPane;
            }
            case 3: {
                return this.fFloatingPane;
            }
            case 2: {
                return this.fTiledPane;
            }
        }
        return this.fMaximizedPane;
    }

    DTFrame getFrame() {
        return this.fFrame;
    }

    void setFrame(DTFrame dTFrame) {
        this.fFrame = dTFrame;
    }

    DTGroup getGroup() {
        return this.fGroup;
    }

    Desktop getDesktop() {
        return this.fDesktop;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        this.fDocuments.add(dTClient);
        dTClient.addPropertyListener(this);
        dTClient.addPreSelectionListener(this);
        dTClient.getInternalFrame().setBorderVisible(false);
        Container container = dTClient.getInternalFrame().getParent();
        if (container != null) {
            container.remove((Component)((Object)dTClient.getInternalFrame()));
        }
        if (dTClient.treatAsHeavyweight()) {
            ++this.fHeavyDocumentCount;
            if (this.fHeavyDocumentCount == 1) {
                this.setHeavy(true);
            }
        }
        switch (this.fArrangement) {
            case 1: {
                this.fMaximizedPane.add(dTClient, dTLocation);
                if (this.isRestoringDocuments() || this.fMaximizedPane.getVisibleDocument() != dTClient) break;
                this.fLastSelectedDocument = dTClient;
                break;
            }
            case 2: {
                dTClient.getInternalFrame().setTitleBarVisible(true);
                this.fTiledPane.add(dTClient, dTLocation);
                break;
            }
            case 3: {
                dTClient.getInternalFrame().setTitleBarVisible(true);
                this.fFloatingPane.add(dTClient, dTLocation);
                if (this.isRestoringDocuments() || this.fFloatingPane.getTopMost() != dTClient) break;
                this.fLastSelectedDocument = dTClient;
            }
        }
        if (dTClient.isSelected()) {
            this.fLastSelectedDocument = dTClient;
            this.setSelected(true, false);
        }
        if (this.fDocuments.size() == 1) {
            if (this.fCloseAllAction != null) {
                this.fCloseAllAction.setEnabled(true);
            }
            if (this.fCascadeAction != null) {
                this.fCascadeAction.setEnabled(true);
            }
            if (this.fMinimizeAllAction != null) {
                this.fMinimizeAllAction.setEnabled(true);
            }
        }
        this.updateTabVisibility();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl = dTClient.isSelected();
        this.fDocuments.remove(dTClient);
        if (this.fLastSelectedDocument == dTClient) {
            this.fLastSelectedDocument = null;
            this.fLastSelectedDocument = this.getMostRecentlySelected();
        }
        this.getArranger().remove(dTClient);
        if (dTClient.treatAsHeavyweight()) {
            --this.fHeavyDocumentCount;
        }
        DTGroup dTGroup = dTClient.getGroup();
        if (bl && this.isEmpty() && !this.isHeavy()) {
            if (dTGroup == null || !dTGroup.isClosing()) {
                this.requestFocus();
            }
        } else if (this.fHeavyDocumentCount == 0) {
            this.getDesktop().getSelectionManager().lock();
            this.setHeavy(false);
            if (bl && this.isEmpty() && (dTGroup == null || !dTGroup.isClosing())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DTDocumentContainer.this.fFrame != null) {
                            DTDocumentContainer.this.requestFocusInWindow();
                        }
                        DTDocumentContainer.this.getDesktop().getSelectionManager().unlock();
                    }
                });
            } else {
                this.getDesktop().getSelectionManager().unlock();
            }
        }
        dTClient.removePropertyListener(this);
        dTClient.removePreSelectionListener(this);
        dTClient.getLocation().setContainer(null);
        dTClient.setLocation(null);
        if (this.fDocuments.isEmpty()) {
            if (this.fCloseAllAction != null) {
                this.fCloseAllAction.setEnabled(false);
            }
            if (this.fCascadeAction != null) {
                this.fCascadeAction.setEnabled(false);
            }
            if (this.fMinimizeAllAction != null) {
                this.fMinimizeAllAction.setEnabled(false);
            }
        }
        this.updateTabVisibility();
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        if (this.isEmpty() && dTSelectable != null && !(dTSelectable instanceof DTClient)) {
            return null;
        }
        return this.getArranger().getNext(dTSelectable, bl);
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        if (this.isEmpty() || dTSelectable != null && !(dTSelectable instanceof DTClient)) {
            return null;
        }
        return this.getArranger().getPrevious(dTSelectable, bl);
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        if (dTOccupant == null) {
            return;
        }
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl = scope == DTContainer.Scope.GROUP && this.fLastSelectedDocument != null && this.fLastSelectedDocument.isSelected() && this.fLastSelectedDocument.getGroup() == dTClient.getGroup();
        this.getArranger().toFront(dTClient, scope);
        if (this.fArrangement == 1) {
            this.fLastSelectedDocument = dTClient;
            dTClient.setSelectionOrder(this.getDesktop().getSelectionManager().getNextSelectionOrder());
        }
        if (bl) {
            dTClient.setSelected(true);
        }
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return this.getArranger().canMoveWithKeys(dTOccupant);
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
        this.getArranger().startKeyMove(dTOccupant);
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return this.getArranger().canResizeWithKeys(dTOccupant);
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        this.getArranger().startKeyResize(dTOccupant);
    }

    boolean isEmpty() {
        return this.fDocuments.isEmpty();
    }

    boolean isShowingInDesktop() {
        return this.isVisible() && SwingUtilities.windowForComponent((Component)((Object)this)) != null;
    }

    boolean wasEmpty() {
        return this.fWasEmpty;
    }

    boolean wasShowing() {
        return this.fWasShowing;
    }

    void saveShowingAndEmpty() {
        this.fWasShowing = this.isShowingInDesktop();
        this.fWasEmpty = this.isEmpty();
    }

    int getDocumentCount() {
        return this.fDocuments.size();
    }

    int getGroupCount() {
        return 1;
    }

    List<DTClient> getDocuments() {
        return Collections.unmodifiableList(this.fDocuments);
    }

    List<DTClient> getDocumentsInTabOrder() {
        return this.getArranger().getOrderedDocuments();
    }

    DTClient getMaximizedDocument() {
        return this.fMaximizedPane == null ? null : this.fMaximizedPane.getVisibleDocument();
    }

    boolean showTitleWhenMaximized() {
        return this.fShowTitleWhenMaximized;
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.add(this.fSelectionListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fSelectionListener = AWTEventMulticaster.remove(this.fSelectionListener, itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this};
        return objectArray;
    }

    final int getArrangement() {
        return this.fArrangement;
    }

    final Dimension getTiledDimension() {
        return this.fArrangement == 2 ? this.fTiledPane.getGridSize() : null;
    }

    boolean isChangingArrangement() {
        return this.fIsChangingArrangement;
    }

    public void setArrangement(int n, Dimension dimension) {
        this.setArrangement(n, dimension, true, true);
    }

    void setArrangement(int n, Dimension dimension, boolean bl) {
        this.setArrangement(n, dimension, bl, true);
    }

    private void setArrangement(int n, Dimension dimension, boolean bl, boolean bl2) {
        this.setArrangement(n, dimension, bl, bl2, null);
    }

    void setArrangement(int n, Dimension dimension, boolean bl, boolean bl2, List<DTClient> list) {
        DTClient dTClient = null;
        List<Object> list2 = Collections.emptyList();
        if (n == 2 && (dimension == null || dimension.width == 1 && dimension.height == 1)) {
            n = 1;
        }
        if (n != this.fArrangement) {
            Object object;
            this.fIsChangingArrangement = true;
            Object object2 = object = this.isHeavy() ? this.fHeavyPanel : this;
            if (this.fArrangement != -1) {
                dTClient = this.getArranger().getFrontDocument();
                list2 = this.getArranger().removeAllDocuments();
                ((Container)object).remove(this.getArrangerComponent());
            }
            JToolBar jToolBar = this.fTopLeftToolBar;
            JToolBar jToolBar2 = this.fTopRightToolBar;
            if (this.fTopLeftToolBar != null) {
                this.setTopLeftToolBar(null);
            }
            if (this.fTopRightToolBar != null) {
                this.setTopRightToolBar(null);
            }
            int n2 = this.fArrangement;
            switch (n) {
                case 1: {
                    if (this.fMaximizedPane == null) {
                        this.fMaximizedPane = new DTMaximizedPane(this);
                        this.fMaximizedPane.addMouseListener(this.fBackgroundListener);
                        this.addArrangerListeners(this.fMaximizedPane);
                    }
                    this.fArrangement = n;
                    ((Container)object).add((Component)((Object)this.fMaximizedPane), "Center");
                    break;
                }
                case 2: {
                    if (this.fTiledPane == null) {
                        this.fTiledPane = new DTTiledPane(this, dimension);
                        this.fTiledPane.addGridListener(this);
                        this.fTiledPane.addMouseListener(this.fBackgroundListener);
                        this.addArrangerListeners(this.fTiledPane);
                    } else if (dimension != null) {
                        this.fTiledPane.setSelectedTile(-1);
                        if (!dimension.equals(this.fTiledPane.getGridSize())) {
                            this.fTiledPane.setGridSize(dimension);
                        }
                        this.fTiledPane.syncTabProperties();
                    }
                    this.fArrangement = n;
                    ((Container)object).add((Component)((Object)this.fTiledPane), "Center");
                    break;
                }
                case 3: {
                    if (this.fFloatingPane == null) {
                        this.fFloatingPane = new DTFloatingPane(this);
                        this.addArrangerListeners(this.fFloatingPane);
                    }
                    this.fArrangement = n;
                    ((Container)object).add((Component)((Object)this.fFloatingPane), "Center");
                    if (!this.isShowing()) break;
                    ((Container)object).doLayout();
                }
            }
            this.fTabProperties.updateMoveActions();
            if (jToolBar != null) {
                this.setTopLeftToolBar(jToolBar);
            }
            if (jToolBar2 != null) {
                this.setTopRightToolBar(jToolBar2);
            }
            if (this.fBlankPanel != null) {
                this.fBlankPanel.setVisible(this.fArrangement != 1);
            }
            if (bl) {
                if (list != null && !list.isEmpty()) {
                    list2.removeAll(list);
                }
                if (dTClient == null) {
                    dTClient = this.getMostRecentlySelected();
                }
                this.getArranger().addAllDocuments(list2, dTClient);
                if (list != null && !list.isEmpty()) {
                    this.getArranger().addAllDocuments(list, dTClient);
                }
            }
            this.fIsChangingArrangement = false;
            this.fireArrangementChange(n2, this.fArrangement);
            this.revalidate();
            this.repaint();
            if (this.isHeavy()) {
                this.fHeavyPanel.invalidate();
                this.fHeavyPanel.validate();
                this.fHeavyPanel.repaint();
            }
        } else if (this.fArrangement == 2 && dimension != null) {
            this.fTiledPane.setGridSize(dimension);
            if (this.isShowing() && this.isHeavy()) {
                this.fTiledPane.doLayout();
            }
        }
        if (bl) {
            this.updateSelectionFollowingArrangement();
        }
        this.updateArrangementActions();
    }

    private void updateSelectionFollowingArrangement() {
        if (this.fLastSelectedDocument != null) {
            if (this.fArrangement == 1 && this.fLastSelectedDocument != this.fMaximizedPane.getVisibleDocument() || this.fArrangement == 2 && (this.fLastSelectedDocument.getLocation() == null || this.fLastSelectedDocument.getLocation().getTile() == -1)) {
                DTClient dTClient;
                this.fLastSelectedDocument.getSelectAction().setSelected(false);
                DTClient dTClient2 = dTClient = this.fArrangement == 1 ? this.fMaximizedPane.getVisibleDocument() : this.fTiledPane.getFrontDocument();
                if (dTClient != null) {
                    dTClient.setSelected(true);
                } else {
                    this.fLastSelectedDocument.setSelected(false);
                    this.fLastSelectedDocument = null;
                    this.requestFocusInWindow();
                }
            } else if (this.fLastSelectedDocument.isSelected()) {
                this.fLastSelectedDocument.requestFocus();
            } else if (this.fIsSelected) {
                this.fLastSelectedDocument.setSelected(true);
            }
        } else if (this.fIsSelected) {
            this.requestFocusInWindow();
        }
    }

    void continueArrangementChange() {
        this.fIsChangingArrangement = true;
    }

    void endArrangementChange() {
        this.fIsChangingArrangement = false;
        this.updateSelectionFollowingArrangement();
    }

    private void addArrangerListeners(DTDocumentArranger dTDocumentArranger) {
        if (this.fDropTargetListener != null) {
            try {
                dTDocumentArranger.addDropTargetListener(this.fDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace();
            }
        }
        if (this.fEmptyKeyListener != null) {
            ((Component)((Object)dTDocumentArranger)).addKeyListener(this.fEmptyKeyListener);
        }
    }

    public void setColumnWidths(float[] fArray) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify column widths when not TILED");
        }
        this.fTiledPane.setColumnWidths(fArray);
    }

    public void setRowHeights(float[] fArray) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify row heights when not TILED");
        }
        this.fTiledPane.setRowHeights(fArray);
    }

    public void setColumnSpan(int n, int n2, int n3) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify column span when not TILED");
        }
        this.fTiledPane.setColumnSpan(n, n2, n3);
    }

    public void setRowSpan(int n, int n2, int n3) {
        if (this.fTiledPane == null) {
            throw new IllegalStateException("Attempt to specify column span when not TILED");
        }
        this.fTiledPane.setRowSpan(n, n2, n3);
    }

    public void setSelected(boolean bl) {
        this.setSelected(bl, true);
    }

    void setSelected(boolean bl, boolean bl2) {
        this.setSelected(bl, bl2, true);
    }

    void setSelected(boolean bl, boolean bl2, boolean bl3) {
        if (bl != this.fIsSelected) {
            this.fIsSelected = bl;
            if (bl) {
                int n;
                if (this.fArrangement == 2 && (n = this.fTiledPane.getSelectedTile()) != -1 && this.fTiledPane.getComponentInTile(n) == null) {
                    if (bl2) {
                        this.fTiledPane.requestFocus();
                    }
                    bl3 = false;
                }
                if (this.fLastSelectedDocument == null || !this.fLastSelectedDocument.isSelected()) {
                    DTClient dTClient;
                    DTClient dTClient2 = dTClient = bl3 ? this.getMostRecentlySelected() : null;
                    if (dTClient != null && dTClient.getLocation() != null && !dTClient.getLocation().isMinimized()) {
                        dTClient.setSelected(true, bl2);
                    } else {
                        DTClient dTClient3 = this.getDesktop().getSelectionManager().getSelectedClient();
                        if (dTClient3 != null && dTClient3.getGroup() != this.fGroup) {
                            this.getDesktop().getSelectionManager().clearSelection();
                            if (bl2) {
                                new FocusRequestor().run();
                            }
                        }
                    }
                }
            } else if (bl3 && this.fLastSelectedDocument != null) {
                this.fLastSelectedDocument.setSelected(false);
            }
            if (this.fSelectionListener != null) {
                ItemEvent itemEvent = new ItemEvent(this, 701, this, bl ? 1 : 2);
                this.fSelectionListener.itemStateChanged(itemEvent);
            }
        }
    }

    public void requestFocus() {
        if (this.fLastSelectedDocument != null && this.fLastSelectedDocument.isSelected()) {
            this.fLastSelectedDocument.requestFocus();
        } else {
            this.getArrangerComponent().requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.fLastSelectedDocument != null && this.fLastSelectedDocument.isSelected()) {
            return this.fLastSelectedDocument.requestFocusInWindow();
        }
        return this.getArrangerComponent().requestFocusInWindow();
    }

    void beginRestore() {
        this.fRestoringDocuments = true;
    }

    boolean isRestoringDocuments() {
        return this.fRestoringDocuments;
    }

    void endRestore() {
        if (!this.fRestoringDocuments) {
            return;
        }
        this.fRestoringDocuments = false;
        if (this.fArrangement == 1) {
            this.fMaximizedPane.endRestore();
        } else if (this.fArrangement == 2) {
            this.fTiledPane.endRestore();
        }
    }

    synchronized void addArrangementListener(ArrangementListener arrangementListener) {
        if (this.fArrangementListeners == null) {
            this.fArrangementListeners = new ArrayList<ArrangementListener>();
        }
        if (!this.fArrangementListeners.contains(arrangementListener)) {
            this.fArrangementListeners.add(arrangementListener);
        }
    }

    synchronized void removeArrangementListener(ArrangementListener arrangementListener) {
        if (this.fArrangementListeners != null) {
            this.fArrangementListeners.remove(arrangementListener);
        }
    }

    private synchronized void fireArrangementChange(int n, int n2) {
        if (this.fArrangementListeners == null) {
            return;
        }
        int n3 = this.fArrangementListeners.size();
        for (int i = 0; i < n3; ++i) {
            ArrangementListener arrangementListener = this.fArrangementListeners.get(i);
            arrangementListener.arrangementChanged(this, n, n2);
        }
    }

    public void gridSizeChanged(MJTiledPane mJTiledPane, Dimension dimension, Dimension dimension2) {
        if (dimension2.width == 1 && dimension2.height == 1) {
            this.setArrangement(1, null);
        } else {
            this.updateArrangementActions();
            this.fireArrangementChange(this.fArrangement, this.fArrangement);
        }
    }

    public void tilesMerged(MJTiledPane mJTiledPane, int n, int n2) {
    }

    public void tileSplit(MJTiledPane mJTiledPane, int n, int n2) {
        this.updateArrangementActions();
        this.fireArrangementChange(this.fArrangement, this.fArrangement);
    }

    public void updateArrangementActions() {
        MJAbstractAction mJAbstractAction = null;
        switch (this.fArrangement) {
            case 1: {
                mJAbstractAction = this.fMaximizeAction;
                break;
            }
            case 2: {
                Dimension object = this.fTiledPane.getGridSize();
                if (object.width == 2 && object.height == 1) {
                    mJAbstractAction = this.fSplitEastWestAction;
                    break;
                }
                if (object.width == 1 && object.height == 2) {
                    mJAbstractAction = this.fSplitNorthSouthAction;
                    break;
                }
                mJAbstractAction = this.fTileAction;
                break;
            }
            case 3: {
                mJAbstractAction = this.fFloatAction;
            }
        }
        for (MJAbstractAction mJAbstractAction2 : this.fArrangementActions) {
            if (mJAbstractAction2 == null) continue;
            mJAbstractAction2.setSelected(mJAbstractAction == mJAbstractAction2);
        }
    }

    JMenu createTileMenu() {
        MJMenu mJMenu = new MJMenu((Action)((Object)this.fTileAction));
        mJMenu.addMenuListener((MenuListener)new TileMenuListener());
        mJMenu.setName("TileDocuments");
        return mJMenu;
    }

    final TileAction getTileAction() {
        return this.fTileAction;
    }

    final MJAbstractAction getSplitEastWestAction() {
        return this.fSplitEastWestAction;
    }

    final MJAbstractAction getSplitNorthSouthAction() {
        return this.fSplitNorthSouthAction;
    }

    final MJAbstractAction getFloatAction() {
        return this.fFloatAction;
    }

    final MJAbstractAction getMaximizeAction() {
        return this.fMaximizeAction;
    }

    final ActionListener getMaximizeListener() {
        if (this.fMaximizeListener == null) {
            this.fMaximizeListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DTDocumentContainer.this.getMaximizeAction().actionPerformed(actionEvent);
                }
            };
        }
        return this.fMaximizeListener;
    }

    final Action getTileSelectAction() {
        if (this.fTileSelectAction == null) {
            this.fTileSelectAction = new TileSelectAction();
        }
        return this.fTileSelectAction;
    }

    final Action getCloseAllAction() {
        if (this.fCloseAllAction == null) {
            this.fCloseAllAction = new CloseAllAction();
        }
        return this.fCloseAllAction;
    }

    final Action getCloseAllExceptAction(DTClient dTClient) {
        return new CloseAllExceptAction(dTClient);
    }

    final Action getCloseSelectAction(DTClient dTClient) {
        return new CloseSelectAction(dTClient);
    }

    final Action getCloseSelectAction() {
        return new CloseSelectAction(null);
    }

    final Action getCascadeAction() {
        if (this.fCascadeAction == null) {
            this.fCascadeAction = new CascadeAction();
        }
        return this.fCascadeAction;
    }

    final Action getMinimizeAllAction() {
        if (this.fMinimizeAllAction == null) {
            this.fMinimizeAllAction = new MinimizeAllAction();
        }
        return this.fMinimizeAllAction;
    }

    DTCloseTransaction getCloseAllTransaction() {
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>(this.getCloseableDocuments());
        DTCloseTransaction dTCloseTransaction = new DTCloseTransaction(arrayList);
        dTCloseTransaction.setDoneListener(new RepaintWhenDoneListener());
        return dTCloseTransaction;
    }

    private List<DTClient> getCloseableDocuments() {
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>(this.fDocuments.size());
        for (DTClient dTClient : this.getArranger().getOrderedDocuments()) {
            if (!dTClient.permitUserClose()) continue;
            arrayList.add(dTClient);
        }
        return arrayList;
    }

    DTCloseTransaction getCloseAllExceptTransaction(DTClient dTClient) {
        ArrayList<DTWindowCloser> arrayList = new ArrayList<DTWindowCloser>(this.fDocuments.size());
        for (DTClient dTClient2 : this.getArranger().getOrderedDocuments()) {
            if (dTClient2 == dTClient || !dTClient2.permitUserClose()) continue;
            arrayList.add(dTClient2);
        }
        DTCloseTransaction dTCloseTransaction = new DTCloseTransaction(arrayList);
        dTCloseTransaction.setDoneListener(new RepaintWhenDoneListener());
        return dTCloseTransaction;
    }

    void undockAll() {
        if (this.fGroup != null) {
            this.fGroup.getUndockAction().actionPerformed(null);
        }
    }

    void cascadeDocuments() {
        if (this.fArrangement != 3) {
            this.setArrangement(3, null);
        }
        this.fFloatingPane.resetCascade();
        DTClient dTClient = null;
        for (DTClient dTClient2 : this.getArranger().getOrderedDocuments()) {
            this.fFloatingPane.setLocation(dTClient2, null);
            if (!dTClient2.isSelected()) continue;
            dTClient = dTClient2;
        }
        if (dTClient != null) {
            this.fFloatingPane.toFront(dTClient, DTContainer.Scope.GROUP);
        }
        this.fFloatingPane.revalidate();
        this.fFloatingPane.repaint();
    }

    void minimizeDocuments() {
        if (this.fArrangement == 3) {
            this.fFloatingPane.minimizeAll();
        } else {
            this.setArrangement(3, null, false);
            int n = this.fDocuments.size();
            for (int i = 0; i < n; ++i) {
                DTClient dTClient = this.fDocuments.get(i);
                DTFloatingLocation dTFloatingLocation = dTClient.getLastFloatingInLocation();
                if (dTFloatingLocation == null) {
                    dTFloatingLocation = (DTFloatingLocation)DTLocation.createMinimized(false);
                } else {
                    dTFloatingLocation.setMinimized(true);
                }
                this.fFloatingPane.add(dTClient, dTFloatingLocation);
            }
        }
    }

    DTDocumentTabsProperties getTabProperties() {
        return this.fTabProperties;
    }

    void setTabsEdge(int n) {
        this.fTabProperties.setEdge(n);
    }

    int getTabsEdge() {
        return this.fTabProperties.getEdge();
    }

    private void updateTabVisibility() {
        boolean bl;
        boolean bl2 = this.getTabsEdge() != -1;
        if (bl2 != (bl = this.shouldTabsBeVisible())) {
            int n = this.fLastTabsEdge;
            this.setTabsEdge(bl ? this.fLastTabsEdge : -1);
            this.fLastTabsEdge = n;
        }
    }

    private boolean shouldTabsBeVisible() {
        return this.fGroup == null || this.fGroup.showSingleEntryDocumentBar() || this.fArrangement != 1 || this.fDocuments.size() > 1 || this.fGroup.getNewAction() != null;
    }

    void setTopLeftToolBar(JToolBar jToolBar) {
        if (this.fArrangement == 1) {
            this.fMaximizedPane.setTopLeftToolBar(jToolBar);
            this.fTopLeftToolBar = jToolBar;
        } else {
            if (this.fTopLeftToolBar != null) {
                this.remove(this.fTopLeftToolBar);
            }
            if (jToolBar != null) {
                this.addToolBar(jToolBar);
            }
            this.fTopLeftToolBar = jToolBar;
            this.updateBlankPanel();
            this.revalidate();
            this.repaint();
        }
    }

    void setTopRightToolBar(JToolBar jToolBar) {
        if (this.fArrangement == 1) {
            this.fMaximizedPane.setTopRightToolBar(jToolBar);
            this.fTopRightToolBar = jToolBar;
        } else {
            if (this.fTopRightToolBar != null) {
                this.remove(this.fTopRightToolBar);
            }
            if (jToolBar != null) {
                this.addToolBar(jToolBar);
            }
            this.fTopRightToolBar = jToolBar;
            this.updateBlankPanel();
            this.revalidate();
            this.repaint();
        }
    }

    private void addToolBar(JToolBar jToolBar) {
        jToolBar.setBorder(new TopToolBarBorder());
        jToolBar.setFloatable(false);
        this.add(jToolBar);
    }

    private void updateBlankPanel() {
        if (this.fTopLeftToolBar != null || this.fTopRightToolBar != null) {
            if (this.fBlankPanel == null) {
                this.fBlankPanel = new MJPanel();
                this.fBlankPanel.setBorder(new TopToolBarBorder());
                this.add(this.fBlankPanel);
            }
        } else if (this.fBlankPanel != null) {
            this.remove(this.fBlankPanel);
            this.fBlankPanel = null;
        }
    }

    public void doLayout() {
        Serializable serializable;
        Insets insets = this.getInsets();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        if (this.fArrangement != 1) {
            if (this.fTopLeftToolBar != null) {
                serializable = this.fTopLeftToolBar.getPreferredSize();
                this.fTopLeftToolBar.setBounds(insets.left, insets.top, ((Dimension)serializable).width, ((Dimension)serializable).height);
                n3 = ((Dimension)serializable).width;
                n5 = ((Dimension)serializable).height;
            }
            if (this.fTopRightToolBar != null) {
                serializable = this.fTopRightToolBar.getPreferredSize();
                if (((Dimension)serializable).height > n5) {
                    n5 = ((Dimension)serializable).height;
                    if (this.fTopLeftToolBar != null) {
                        this.fTopLeftToolBar.setSize(new Dimension(this.fTopLeftToolBar.getWidth(), n5));
                    }
                }
                this.fTopRightToolBar.setBounds(n - insets.right - ((Dimension)serializable).width, insets.top, ((Dimension)serializable).width, n5);
                n4 = ((Dimension)serializable).width;
            }
            if (this.fBlankPanel != null) {
                this.fBlankPanel.setBounds(insets.left + n3, insets.top, rectangle.width - n3 - n4, n5);
                rectangle.y += n5;
                rectangle.height -= n5;
            }
        }
        serializable = this.isHeavy() ? this.fHeavyPanel : this.getArrangerComponent();
        ((Component)serializable).setBounds(rectangle);
    }

    Rectangle getTabsBounds() {
        return this.getArranger().getTabsBounds();
    }

    Insets getTabsInsets() {
        return this.getArranger().getTabsInsets();
    }

    Action getTabsToNorthAction() {
        return this.fTabProperties.getMoveAction(1);
    }

    Action getTabsToSouthAction() {
        return this.fTabProperties.getMoveAction(5);
    }

    Action getTabsToEastAction() {
        return this.fTabProperties.getMoveAction(3);
    }

    Action getTabsToWestAction() {
        return this.fTabProperties.getMoveAction(7);
    }

    Action getHideTabsAction() {
        return this.fTabProperties.getMoveAction(-1);
    }

    Action getToggleShrinkTabsToFitAction() {
        return this.fTabProperties.getToggleShrinkToFitAction();
    }

    private boolean needTopSeparator() {
        return false;
    }

    void addDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener == null) {
            this.fDropTargetListener = dropTargetListener;
            if (this.fMaximizedPane != null) {
                try {
                    this.fMaximizedPane.addDropTargetListener(dropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            }
            if (this.fTiledPane != null) {
                try {
                    this.fTiledPane.addDropTargetListener(dropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            }
            if (this.fFloatingPane != null) {
                try {
                    this.fFloatingPane.addDropTargetListener(dropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    tooManyListenersException.printStackTrace();
                }
            }
        }
    }

    void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener != null) {
            if (this.fMaximizedPane != null) {
                this.fMaximizedPane.removeDropTargetListener(dropTargetListener);
            }
            if (this.fTiledPane != null) {
                this.fTiledPane.removeDropTargetListener(dropTargetListener);
            }
            if (this.fFloatingPane != null) {
                this.fFloatingPane.removeDropTargetListener(dropTargetListener);
            }
            this.fDropTargetListener = null;
        }
    }

    void addEmptyKeyListener(KeyListener keyListener) {
        this.fEmptyKeyListener = keyListener;
        if (this.fMaximizedPane != null) {
            this.fMaximizedPane.addKeyListener(this.fEmptyKeyListener);
        }
        if (this.fTiledPane != null) {
            this.fTiledPane.addKeyListener(this.fEmptyKeyListener);
        }
        if (this.fFloatingPane != null) {
            this.fFloatingPane.addKeyListener(this.fEmptyKeyListener);
        }
    }

    void removeEmptyKeyListener(KeyListener keyListener) {
        if (this.fMaximizedPane != null) {
            this.fMaximizedPane.removeKeyListener(keyListener);
        }
        if (this.fTiledPane != null) {
            this.fTiledPane.removeKeyListener(keyListener);
        }
        if (this.fFloatingPane != null) {
            this.fFloatingPane.removeKeyListener(keyListener);
        }
        if (keyListener == this.fEmptyKeyListener) {
            this.fEmptyKeyListener = null;
        }
    }

    public DropTarget getDropTarget() {
        return this.getArrangerComponent().getDropTarget();
    }

    void startClientDrag(DTClient dTClient, Component component) {
        new DocumentDragger(dTClient, component);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof DTClient) {
            DTClient dTClient = (DTClient)propertyChangeEvent.getSource();
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (this.fDocuments.contains(dTClient) && bl) {
                this.toFront(dTClient, DTContainer.Scope.FRAME);
                this.fLastSelectedDocument = dTClient;
                this.setSelected(true, false);
            }
        } else if (DTGroupProperty.SHOW_SINGLE_ENTRY_DOCUMENT_BAR.toString().equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() == this.fGroup) {
            this.updateTabVisibility();
        }
    }

    DTClient getTopDocument() {
        return this.getArranger().getFrontDocument();
    }

    DTClient getMostRecentlySelected() {
        if (this.fLastSelectedDocument != null) {
            return this.fLastSelectedDocument;
        }
        return DTUtilities.getMostRecentlySelected(this.fDocuments);
    }

    Iterator<DTGroup> getGroupIterator() {
        return Collections.singletonList(this.fGroup).iterator();
    }

    private MJDimensionPicker createDimensionPicker() {
        MJDimensionPicker mJDimensionPicker = new MJDimensionPicker();
        mJDimensionPicker.setOccupancy(this.fDocuments.size());
        mJDimensionPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJDimensionPicker mJDimensionPicker = (MJDimensionPicker)actionEvent.getSource();
                Dimension dimension = mJDimensionPicker.getSelectedSize();
                if (dimension.width == 1 && dimension.height == 1) {
                    DTDocumentContainer.this.setArrangement(1, null);
                } else {
                    DTDocumentContainer.this.setArrangement(2, dimension);
                }
                if (DTDocumentContainer.this.fFocusOwnerBeforePicker != null) {
                    DTDocumentContainer.this.fFocusOwnerBeforePicker.requestFocus();
                    DTDocumentContainer.this.fFocusOwnerBeforePicker = null;
                }
            }
        });
        return mJDimensionPicker;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fArrangement == 2) {
            DTClient dTClient = (DTClient)actionEvent.getSource();
            this.fTiledPane.toFront(dTClient, DTContainer.Scope.FRAME);
        }
    }

    Object getState() {
        return new State(this);
    }

    static Element stateToXML(Object object, Document document) {
        return ((State)object).toXML(document);
    }

    static Object stateFromXML(SimpleElement simpleElement) throws DataFormatException {
        return new State(simpleElement);
    }

    private static class State {
        boolean fWasShowing;
        boolean fWasEmpty;
        int fArrangement;
        int fTabsEdge;
        int fMaxTabsWidth;
        boolean fShrinkTabsToFit;
        Object fTiledState;

        State(DTDocumentContainer dTDocumentContainer) {
            this.fArrangement = dTDocumentContainer.fArrangement;
            this.fWasEmpty = dTDocumentContainer.fWasEmpty;
            this.fWasShowing = dTDocumentContainer.fWasShowing;
            this.fTabsEdge = dTDocumentContainer.fLastTabsEdge;
            this.fMaxTabsWidth = dTDocumentContainer.getTabProperties().getMaxWidth();
            this.fShrinkTabsToFit = dTDocumentContainer.getTabProperties().getShrinkToFit();
            if (this.fArrangement == 2) {
                this.fTiledState = dTDocumentContainer.fTiledPane.getState();
            }
        }

        State(SimpleElement simpleElement) throws DataFormatException {
            assert (DTDocumentContainer.DOCUMENT_AREA_TAG.equals(simpleElement.getTagName()));
            String string = simpleElement.getAttribute(DTDocumentContainer.SHOWING_ATTRIBUTE);
            this.fWasShowing = DTDocumentContainer.YES_VALUE.equalsIgnoreCase(string);
            string = simpleElement.getAttribute(DTDocumentContainer.EMPTY_ATTRIBUTE);
            this.fWasEmpty = DTDocumentContainer.YES_VALUE.equalsIgnoreCase(string);
            string = simpleElement.getAttribute(DTDocumentContainer.ARRANGEMENT_ATTRIBUTE);
            if (DTDocumentContainer.MAXIMIZED_VALUE.equalsIgnoreCase(string)) {
                this.fArrangement = 1;
            } else if (DTDocumentContainer.TILED_VALUE.equalsIgnoreCase(string)) {
                this.fArrangement = 2;
            } else if (DTDocumentContainer.FLOATING_VALUE.equalsIgnoreCase(string)) {
                this.fArrangement = 3;
            } else if (string == null || string.length() == 0) {
                this.fArrangement = 1;
            } else {
                throw new DataFormatException("Unrecognized Arrangement: " + string);
            }
            string = simpleElement.getAttribute(DTDocumentContainer.BAR_ATTRIBUTE);
            if (DTDocumentContainer.TOP_VALUE.equalsIgnoreCase(string)) {
                this.fTabsEdge = 1;
            } else if (DTDocumentContainer.BOTTOM_VALUE.equalsIgnoreCase(string)) {
                this.fTabsEdge = 5;
            } else if (DTDocumentContainer.LEFT_VALUE.equalsIgnoreCase(string)) {
                this.fTabsEdge = 7;
            } else if (DTDocumentContainer.RIGHT_VALUE.equalsIgnoreCase(string)) {
                this.fTabsEdge = 3;
            } else if (DTDocumentContainer.HIDE_VALUE.equalsIgnoreCase(string)) {
                this.fTabsEdge = -1;
            } else if (string == null || string.length() == 0) {
                this.fTabsEdge = 1;
            } else {
                throw new DataFormatException("Unrecognized Bar: " + string);
            }
            string = simpleElement.getAttribute(DTDocumentContainer.MAX_BAR_WIDTH_ATTRIBUTE);
            if (string != null && string.length() > 0) {
                try {
                    this.fMaxTabsWidth = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid MaxBarWidth: " + string);
                }
            }
            boolean bl = this.fShrinkTabsToFit = (string = simpleElement.getAttribute(DTDocumentContainer.SHRINK_TABS_ATTRIBUTE)) == null ? false : DTDocumentContainer.YES_VALUE.equalsIgnoreCase(string);
            if (this.fArrangement == 2) {
                SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName("Tiles");
                if (simpleNodeList.getLength() < 1) {
                    throw new DataFormatException("Missing Tiles");
                }
                SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(0);
                this.fTiledState = DTTiledPane.stateFromXML(simpleElement2);
            }
        }

        public Element toXML(Document document) {
            Element element = document.createElement(DTDocumentContainer.DOCUMENT_AREA_TAG);
            element.setAttribute(DTDocumentContainer.SHOWING_ATTRIBUTE, this.fWasShowing ? DTDocumentContainer.YES_VALUE : DTDocumentContainer.NO_VALUE);
            element.setAttribute(DTDocumentContainer.EMPTY_ATTRIBUTE, this.fWasEmpty ? DTDocumentContainer.YES_VALUE : DTDocumentContainer.NO_VALUE);
            String string = null;
            switch (this.fArrangement) {
                case 1: {
                    string = DTDocumentContainer.MAXIMIZED_VALUE;
                    break;
                }
                case 2: {
                    string = DTDocumentContainer.TILED_VALUE;
                    break;
                }
                case 3: {
                    string = DTDocumentContainer.FLOATING_VALUE;
                }
            }
            element.setAttribute(DTDocumentContainer.ARRANGEMENT_ATTRIBUTE, string);
            string = null;
            switch (this.fTabsEdge) {
                case 1: {
                    string = DTDocumentContainer.TOP_VALUE;
                    break;
                }
                case 5: {
                    string = DTDocumentContainer.BOTTOM_VALUE;
                    break;
                }
                case 3: {
                    string = DTDocumentContainer.RIGHT_VALUE;
                    break;
                }
                case 7: {
                    string = DTDocumentContainer.LEFT_VALUE;
                    break;
                }
                case -1: {
                    string = DTDocumentContainer.HIDE_VALUE;
                }
            }
            if (string != null) {
                element.setAttribute(DTDocumentContainer.BAR_ATTRIBUTE, string);
            }
            element.setAttribute(DTDocumentContainer.MAX_BAR_WIDTH_ATTRIBUTE, Integer.toString(this.fMaxTabsWidth));
            element.setAttribute(DTDocumentContainer.SHRINK_TABS_ATTRIBUTE, this.fShrinkTabsToFit ? DTDocumentContainer.YES_VALUE : DTDocumentContainer.NO_VALUE);
            if (this.fTiledState != null) {
                element.appendChild(DTTiledPane.stateToXML((Object)this.fTiledState, (Document)document));
            }
            return element;
        }
    }

    class PreviousDocumentAction
    extends MJAbstractAction {
        PreviousDocumentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ItemListener itemListener;
            DTSelectable dTSelectable = null;
            DTClient dTClient = null;
            Iterator<DTClient> iterator = DTDocumentContainer.this.getArranger().getOrderedDocuments().iterator();
            while (iterator.hasNext()) {
                itemListener = iterator.next();
                dTClient = itemListener;
                if (((DTClient)itemListener).isSelected()) break;
                dTSelectable = itemListener;
            }
            if (dTSelectable == null) {
                while (iterator.hasNext()) {
                    dTClient = iterator.next();
                }
                itemListener = (DTTabbedPane)((Object)SwingUtilities.getAncestorOfClass(DTTabbedPane.class, (Component)((Object)DTDocumentContainer.this)));
                if (itemListener != null) {
                    ((DTTabbedPane)itemListener).selectPreviousTab();
                    DTDocumentContainer.this.toFront(dTClient, DTContainer.Scope.FRAME);
                } else {
                    dTSelectable = dTClient;
                }
            }
            if (dTSelectable != null) {
                dTSelectable.setSelected(true);
            }
        }
    }

    class NextDocumentAction
    extends MJAbstractAction {
        NextDocumentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTSelectable dTSelectable;
            DTClient dTClient = null;
            Iterator<DTClient> iterator = DTDocumentContainer.this.getArranger().getOrderedDocuments().iterator();
            while (iterator.hasNext()) {
                dTSelectable = iterator.next();
                if (dTClient == null) {
                    dTClient = dTSelectable;
                }
                if (!((DTClient)dTSelectable).isSelected()) continue;
                break;
            }
            dTSelectable = null;
            if (iterator.hasNext()) {
                dTSelectable = iterator.next();
            } else {
                DTTabbedPane dTTabbedPane = (DTTabbedPane)((Object)SwingUtilities.getAncestorOfClass(DTTabbedPane.class, (Component)((Object)DTDocumentContainer.this)));
                if (dTTabbedPane != null) {
                    dTTabbedPane.selectNextTab();
                    DTDocumentContainer.this.toFront(dTClient, DTContainer.Scope.FRAME);
                } else {
                    dTSelectable = dTClient;
                }
            }
            if (dTSelectable != null) {
                dTSelectable.setSelected(true);
            }
        }
    }

    class MinimizeAllAction
    extends MJAbstractAction {
        public MinimizeAllAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.MinimizeAll"));
            if (DTDocumentContainer.this.fGroup != null && DTDocumentContainer.this.fGroup.getTitle() != null) {
                String string = DTDocumentContainer.this.fGroup.getTitle();
                Object[] objectArray = new Object[]{string};
                String string2 = string.charAt(string.length() - 1) == 's' ? "action.MinimizeThese" : "action.MinimizeTheseDocuments";
                this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString(string2), objectArray));
            }
            this.setComponentName("MinimizeAll");
            DTMenuMergeTag.MINIMIZE.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.minimizeDocuments();
        }
    }

    class CascadeAction
    extends MJAbstractAction {
        public CascadeAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Cascade"));
            if (DTDocumentContainer.this.fGroup != null && DTDocumentContainer.this.fGroup.getTitle() != null) {
                String string = DTDocumentContainer.this.fGroup.getTitle();
                Object[] objectArray = new Object[]{string};
                String string2 = string.charAt(string.length() - 1) == 's' ? "action.CascadeThese" : "action.CascadeTheseDocuments";
                this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString(string2), objectArray));
            }
            this.setComponentName("Cascade");
            DTMenuMergeTag.CASCADE.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.cascadeDocuments();
        }
    }

    class CloseSelectAction
    extends MJAbstractAction
    implements TargetedAction {
        final DTClient iDefaultDocument;

        public CloseSelectAction(DTClient dTClient) {
            super(DTDocumentContainer.this.getDesktop().getString("action.CloseSelect"));
            this.setComponentName("CloseSelect");
            DTMenuMergeTag.CLOSE_SELECT.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
            this.iDefaultDocument = dTClient;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List list = DTDocumentContainer.this.getCloseableDocuments();
            DTClient dTClient = null;
            if (this.iDefaultDocument != null) {
                dTClient = this.iDefaultDocument;
            } else {
                for (DTClient dTClient2 : list) {
                    if (dTClient != null || !dTClient2.isSelected()) continue;
                    dTClient = dTClient2;
                }
            }
            List<DTClient> list2 = dTClient == null ? Collections.EMPTY_LIST : Collections.singletonList(dTClient);
            DTCloseDialog.show(DTDocumentContainer.this.getDesktop(), (Component)((Object)DTDocumentContainer.this), list, list2);
        }

        @Override
        public boolean hasAnyTargets() {
            return DTDocumentContainer.this.getCloseableDocuments().size() > 0;
        }
    }

    class CloseAllExceptAction
    extends MJAbstractAction
    implements TargetedAction {
        private DTClient iDocumentToKeep;

        public CloseAllExceptAction(DTClient dTClient) {
            this.iDocumentToKeep = dTClient;
            Object[] objectArray = new Object[]{dTClient.getShortTitle()};
            this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString("action.CloseAllExcept"), objectArray));
            this.setComponentName("CloseAllExcept");
            DTMenuMergeTag.CLOSE_ALL_EXCEPT.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.getCloseAllExceptTransaction(this.iDocumentToKeep).start();
        }

        @Override
        public boolean hasAnyTargets() {
            return DTDocumentContainer.this.getCloseAllExceptTransaction((DTClient)this.iDocumentToKeep).fClosers.size() > 0;
        }
    }

    class CloseAllAction
    extends MJAbstractAction
    implements TargetedAction {
        public CloseAllAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.CloseDocuments"));
            if (DTDocumentContainer.this.fGroup != null && DTDocumentContainer.this.fGroup.getTitle() != null) {
                String string = DTDocumentContainer.this.fGroup.getTitle();
                Object[] objectArray = new Object[]{string};
                String string2 = string.charAt(string.length() - 1) == 's' ? "action.CloseThese" : "action.CloseTheseDocuments";
                this.setName(MessageFormat.format(DTDocumentContainer.this.getDesktop().getString(string2), objectArray));
            }
            this.setComponentName("CloseDocuments");
            DTMenuMergeTag.CLOSE_ALL.setTag((Action)((Object)this));
            this.setEnabled(!DTDocumentContainer.this.isEmpty());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.getCloseAllTransaction().start();
        }

        @Override
        public boolean hasAnyTargets() {
            return DTDocumentContainer.this.getCloseAllTransaction().fClosers.size() > 0;
        }
    }

    class MaximizeAction
    extends MJAbstractAction {
        public MaximizeAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Maximize"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/mdimax.gif")));
            this.setComponentName("Maximize");
            DTMenuMergeTag.MAXIMIZE.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(1, null);
        }
    }

    class FloatAction
    extends MJAbstractAction {
        public FloatAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Float"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/float.gif")));
            this.setComponentName("Float");
            DTMenuMergeTag.FLOAT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(3, null);
        }
    }

    class SplitNorthSouthAction
    extends MJAbstractAction {
        public SplitNorthSouthAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.SplitNorthSouth"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/splitnorthsouth.gif")));
            this.setComponentName("SplitTopBottom");
            DTMenuMergeTag.TOP_BOTTOM_SPLIT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(2, new Dimension(1, 2), true, false);
        }
    }

    class SplitEastWestAction
    extends MJAbstractAction {
        public SplitEastWestAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.SplitEastWest"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/spliteastwest.gif")));
            this.setComponentName("SplitLeftRight");
            DTMenuMergeTag.LEFT_RIGHT_SPLIT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentContainer.this.setArrangement(2, new Dimension(2, 1), true, false);
        }
    }

    class TileSelectAction
    extends MJAbstractAction {
        public TileSelectAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.TileSelect"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/tile.gif")));
            this.setComponentName("TileSelect");
            DTMenuMergeTag.TILE_SELECT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<DTClient> list = DTDocumentContainer.this.getArranger().getOrderedDocuments();
            ArrayList<DTClient> arrayList = new ArrayList<DTClient>();
            switch (DTDocumentContainer.this.fArrangement) {
                case 1: {
                    if (DTDocumentContainer.this.fMaximizedPane.getVisibleDocument() == null) break;
                    arrayList.add(DTDocumentContainer.this.fMaximizedPane.getVisibleDocument());
                    break;
                }
                case 3: {
                    if (DTDocumentContainer.this.fFloatingPane.getTopMost() == null) break;
                    arrayList.add(DTDocumentContainer.this.fFloatingPane.getTopMost());
                    break;
                }
                case 2: {
                    for (int i = 0; i < DTDocumentContainer.this.fTiledPane.getTileCount(); ++i) {
                        DTClient dTClient = DTDocumentContainer.this.fTiledPane.getFrontDocumentInTile(i);
                        if (dTClient == null) continue;
                        arrayList.add(dTClient);
                    }
                    break;
                }
            }
            DTTileDialog.show(DTDocumentContainer.this, list, arrayList);
        }
    }

    class TileAction
    extends MJAbstractAction {
        boolean iIsPickerShowing;

        public TileAction() {
            super(DTDocumentContainer.this.getDesktop().getString("action.Tile"), (Icon)new ImageIcon(DTDocumentContainer.class.getResource("resources/tile.gif")));
            this.setComponentName("TileDocuments");
            DTMenuMergeTag.TILE.setTag((Action)((Object)this));
            this.putValue("PopupListener", new PopupListener(){

                public void onPopupEvent(final JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                    MJDimensionPicker mJDimensionPicker = DTDocumentContainer.this.createDimensionPicker();
                    mJDimensionPicker.setAutoGrowEnabled(false);
                    ActionListener actionListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            OverlayManagers.get((Component)jComponent).removePopups();
                        }
                    };
                    mJDimensionPicker.addActionListener(actionListener);
                    mJDimensionPicker.addCancelationListener(actionListener);
                    popupCallback.show((JComponent)mJDimensionPicker);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JComboBox && !this.iIsPickerShowing) {
                this.showPicker((Component)actionEvent.getSource());
            }
        }

        void buttonPressed(Component component) {
            this.showPicker(component);
        }

        void showPicker(Component component) {
            this.iIsPickerShowing = true;
            Window window = SwingUtilities.windowForComponent(component);
            DTDocumentContainer.this.fFocusOwnerBeforePicker = window.getFocusOwner();
            MJDimensionPicker mJDimensionPicker = DTDocumentContainer.this.createDimensionPicker();
            mJDimensionPicker.setAutoGrowEnabled(true);
            mJDimensionPicker.show(component, 0, component.getHeight());
            mJDimensionPicker.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    DTDocumentContainer.this.updateArrangementActions();
                    TileAction.this.iIsPickerShowing = false;
                    if (DTDocumentContainer.this.fFocusOwnerBeforePicker != null) {
                        DTDocumentContainer.this.fFocusOwnerBeforePicker.requestFocus();
                        DTDocumentContainer.this.fFocusOwnerBeforePicker = null;
                    }
                }
            });
        }
    }

    class BackgroundMouseListener
    extends MouseAdapter {
        BackgroundMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTDocumentContainer.this.setSelected(true, DTDocumentContainer.this.fArrangement != 3);
        }
    }

    class TileMenuListener
    implements MenuListener {
        MJDimensionPicker fPicker;
        Dimension fSize;

        TileMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.fPicker == null) {
                this.fPicker = DTDocumentContainer.this.createDimensionPicker();
                this.fPicker.setAutoGrowEnabled(true);
                this.fSize = this.fPicker.getPreferredSize();
                Insets insets = jMenu.getPopupMenu().getInsets();
                this.fSize.width += insets.left + insets.right;
                this.fSize.height += insets.top + insets.bottom;
                jMenu.add((Component)this.fPicker);
                this.fPicker.setInvokingMenu(jMenu);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.fPicker != null) {
                this.fPicker.setInvokingMenu(null);
                jMenu.remove((Component)this.fPicker);
                jMenu.getPopupMenu().setSize(this.fSize);
                this.fPicker = null;
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }
    }

    class DocumentDragger
    extends DTDragger {
        DTClient fDocument;

        DocumentDragger(DTClient dTClient, Component component) {
            super(dTClient, component);
            this.fDocument = dTClient;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            Container container = DTDocumentContainer.this.getParent();
            point = SwingUtilities.convertPoint(component, point, container);
            DTDropTarget dTDropTarget = this.fTarget;
            this.fTarget = null;
            if (DTDocumentContainer.this.getBounds().contains(point)) {
                if (DTDocumentContainer.this.fArrangement != 1 || DTDocumentContainer.this.fGroup.permitUserTile()) {
                    this.fTarget = (DTDropTarget)((Object)DTDocumentContainer.this.getArrangerComponent());
                }
            } else if (this.fDocument.permitUserUndock() && (point.x < 0 || point.y < 0 || point.x > container.getWidth() || point.y > container.getHeight())) {
                if (this.fExternalTarget == null) {
                    this.fExternalTarget = new DTExternalTarget(DTDocumentContainer.this.getDesktop(), this.fDocument);
                }
                this.fTarget = this.fExternalTarget;
            }
            if (this.fTarget == null) {
                component.setCursor(DragSource.DefaultMoveNoDrop);
                if (dTDropTarget != null && this.fDropLocation != null) {
                    DTDragUtilities.getDropOutlinePainter().hide(false);
                    DTDragUtilities.showHint(this.fFrame, DTDocumentContainer.this.getDesktop().getString("status.MoveDocumentElsewhere"));
                    this.fDropLocation = null;
                }
            } else {
                component.setCursor(this.fSaveCursor);
                if (this.fTarget instanceof Component) {
                    point = SwingUtilities.convertPoint(container, point, (Component)((Object)this.fTarget));
                } else {
                    SwingUtilities.convertPointToScreen(point, container);
                }
                DTLocation dTLocation = this.fPreviousLocation;
                this.fPreviousLocation = this.fDropLocation;
                this.fDropLocation = dTLocation;
                this.fDropLocation = this.fTarget.getDropLocation(this.fDocument, point.x, point.y, this.fDropLocation);
                if (!(this.fPreviousLocation == this.fDropLocation || this.fDropLocation != null && this.fDropLocation.equals(this.fPreviousLocation))) {
                    this.fTarget.drawDropOutline(this.fDropLocation);
                    String string = this.fTarget.getDropHint(this.fDocument, this.fDropLocation);
                    DTDragUtilities.showHint(this.fFrame, string);
                }
            }
        }
    }

    class TopToolBarBorder
    extends DTBorderFactory.TopSeparatorBorder {
        TopToolBarBorder() {
        }

        @Override
        protected boolean needSeparator(Component component) {
            return DTDocumentContainer.this.needTopSeparator();
        }
    }

    private class RepaintWhenDoneListener
    implements DTCloseTransaction.DoneListener {
        private RepaintWhenDoneListener() {
        }

        @Override
        public void closeTransactionDone(boolean bl) {
            if (bl) {
                DTDocumentContainer.this.repaint();
            }
        }
    }

    private class FocusRequestor
    implements Runnable {
        private int iAttemptsRemaining = 3;

        private FocusRequestor() {
        }

        @Override
        public void run() {
            if (!DTDocumentContainer.this.requestFocusInWindow() && --this.iAttemptsRemaining > 0) {
                EventQueue.invokeLater(this);
            }
        }
    }

    static interface ArrangementListener {
        public void arrangementChanged(DTDocumentContainer var1, int var2, int var3);
    }
}

