/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.jidesoft.swing.Gripper;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJScrollBar;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.mwswing.WeakPropertyChangeCoupler;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.plaf.DropDownButtonUI;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocumentList;
import com.mathworks.widgets.desk.DTDocumentTabsProperties;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTTitleChangeHandler;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.DeferredRunnable;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.desk.Range;
import com.mathworks.widgets.desk.TargetedAction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ButtonUI;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;

public class DTDocumentTabs
extends MJLayeredPane {
    private final DTDocumentContainer fDocumentContainer;
    private DTDocumentTabsProperties fProperties;
    private int fEdge = 1;
    private int fMaxWidth = 250;
    private int fMinTabWidth = 120;
    private boolean fShrinkTabsToFit = false;
    private Comparator<DTClient> fComparator;
    private boolean fDrawClosedTabs;
    private Gripper fGrip;
    private OverflowButton fOverflowButton;
    private Tab fNewDocumentTab;
    private Tab fJustAddedTab;
    private List<Tab> fTabList = new ArrayList<Tab>();
    private Range fShowingTabRange;
    private boolean fIsAdjustingWidth;
    private boolean fIsEditingTitle;
    private boolean fAppearFocused;
    private TabDragger fTabDragger;
    private PendingAdditions fPendingAdditions;
    private PendingRemovals fPendingRemovals;
    private final Animator fAnimator = new Animator();
    private DropTarget fDropTarget;
    private int fHorizontalOverlap;
    private int fVerticalOverlap;
    private int fExcessHorizontalOverlap;
    private Tab fSelectingTab;
    private final List<EdgeListener> fEdgeListeners = new ArrayList<EdgeListener>();
    private static boolean sAnimationEnabled;
    static final int HIDDEN = -1;
    static final int DEFAULT_EDGE = 1;
    static final boolean DEFAULT_SHRINK_TO_FIT = false;
    static final int DEFAULT_MAX_WIDTH = 250;
    static final int DEFAULT_MIN_TAB_WIDTH = 120;
    private static final int MIN_WIDTH_WHEN_VERTICAL = 64;
    private static final int VERTICAL_OPEN_MARGIN = 3;
    private static final int HORIZONTAL_OPEN_MARGIN = 0;
    private static final int CLOSED_SIDE_MARGIN = 0;
    private static final int CORNER_RADIUS = 9;
    private static final int HIGHLIGHT_RADIUS = 120;
    private static final int HORIZONTAL_TEXT_MARGIN = 2;
    private static final int VERTICAL_TEXT_MARGIN = 1;
    private static final int OPEN_HORIZONTAL_OVERLAP = 22;
    private static final int OPEN_VERTICAL_OVERLAP = 19;
    private static final int CLOSED_HORIZONTAL_OVERLAP = 1;
    private static final int CLOSED_VERTICAL_OVERLAP = 1;
    private static final int POPUP_SCREEN_MARGIN = 50;
    private static final int POPUP_BELOW_BIAS = 100;
    private static final int MINIMUM_TAB_MARGIN = 3;
    private static final int ICON_TEXT_GAP = 6;
    private static final int PARALLEL_DRAG_THRESHOLD = 5;
    private static final int SMALL_DRAG_OFF_THRESHOLD = 6;
    private static final int LARGE_DRAG_OFF_THRESHOLD = 50;
    private static final Color SELECTED_LIGHT_COLOR;
    private static final Color SELECTED_DARK_COLOR;
    private static final Color FOCUSED_DARK_COLOR;
    private static final Color DESELECTED_LIGHT_COLOR;
    private static final Color DESELECTED_DARK_COLOR;
    private static final Color OUTLINE_COLOR;
    static final Color FOCUSED_OUTLINE_COLOR;
    private static final Color SELECTED_TEXT_COLOR;
    private static final Color DESELECTED_TEXT_COLOR;
    private static final Color HIGHLIGHT_CENTER_COLOR;
    private static final Color HIGHLIGHT_EDGE_COLOR;
    private static final Integer EDIT_LAYER;
    private static final String ANIMATION_PREFERENCE = "AnimateDocumentTabs";
    private static final int HORIZONTAL_MARGIN = 2;
    private static final int VERTICAL_MARGIN = 2;
    private static final int TEXT_ARROW_GAP = 0;
    private static final int ARROW_WIDTH = 7;
    private static final int ARROW_HEIGHT = 4;
    private static final int ANIMATION_INTERVAL = 33;
    private static final float DURATION_PER_PIXEL;
    private static final int MINIMUM_ANIMATION_DURATION = 250;
    private static final int MAXIMUM_ANIMATION_DURATION = 1500;
    private static final int SUCCESSIVE_MOVE_DELAY = 200;

    public static boolean isAnimationEnabled() {
        return sAnimationEnabled;
    }

    public static void setAnimationEnabled(boolean bl) {
        sAnimationEnabled = bl;
    }

    DTDocumentTabs(DTDocumentContainer dTDocumentContainer) {
        this.fDocumentContainer = dTDocumentContainer;
        this.setLayout(null);
        this.setOpaque(true);
        this.setBorder(new CustomBorder());
        this.setBackground(UIManager.getColor("control"));
        this.updateOverlap();
        this.fGrip = new Gripper(DTDocumentTabs.getGripOrientation(this.fEdge));
        this.fGrip.setCursor(Cursor.getPredefinedCursor(13));
        this.add((Component)this.fGrip);
        this.fOverflowButton = new OverflowButton();
        this.fOverflowButton.setVisible(false);
        this.add((Component)((Object)this.fOverflowButton));
        LocalMouseListener localMouseListener = new LocalMouseListener();
        this.addMouseListener(localMouseListener);
        this.addMouseMotionListener(localMouseListener);
        this.addDragDetector((MouseInputListener)((Object)new TabsDragDetector()));
    }

    void addTabForDocument(DTClient dTClient) {
        Tab tab = new Tab(dTClient);
        if (this.fTabList.size() > 0 && this.shouldAnimate()) {
            if (this.fPendingAdditions == null) {
                this.fPendingAdditions = new PendingAdditions();
                this.fPendingAdditions.iTabsToAdd.add(tab);
                EventQueue.invokeLater(this.fPendingAdditions);
            } else if (!this.fAnimator.isRunning()) {
                this.fPendingAdditions.iTabsToAdd.add(tab);
            }
        }
        if (this.fComparator == null) {
            this.fTabList.add(tab);
        } else {
            int n;
            for (n = 0; n < this.fTabList.size(); ++n) {
                Tab tab2 = this.fTabList.get(n);
                if ((this.fPendingRemovals == null || !this.fPendingRemovals.iTabsToRemove.contains(tab2)) && tab.compareTo(tab2) < 0) break;
            }
            this.fTabList.add(n, tab);
        }
        if (dTClient.getSelectAction().isSelected()) {
            this.setLayer(tab, PALETTE_LAYER);
        } else {
            this.setLayer(tab, DEFAULT_LAYER, this.fTabList.size() - 1);
        }
        this.add(tab);
        this.fJustAddedTab = tab;
        if (this.fAnimator.isRunning()) {
            this.computeTabBounds();
            for (Tab tab2 : this.fTabList) {
                if (tab2.iBounds != null) {
                    tab2.setBounds(tab2.iBounds);
                    tab2.setVisible(true);
                }
                this.fAnimator.setupAnimation(tab2);
            }
            if (this.fNewDocumentTab != null) {
                this.fNewDocumentTab.setVisible(false);
                this.fAnimator.setupAnimation(this.fNewDocumentTab);
            }
        }
    }

    void removeTabForDocument(DTClient dTClient) {
        if (this.fTabDragger != null && this.fTabDragger.iHasDraggedOff) {
            this.fTabDragger.endDrag();
        }
        if (this.fAnimator.isRunning()) {
            this.fAnimator.stop();
        }
        this.fPendingAdditions = null;
        Tab tab = null;
        for (Tab tab2 : this.fTabList) {
            if (tab2.iDocument != dTClient) continue;
            tab = tab2;
            break;
        }
        if (tab == null) {
            return;
        }
        if (this.shouldAnimate() && this.fTabList.size() > 1) {
            if (this.fPendingRemovals == null) {
                this.fPendingRemovals = new PendingRemovals();
                this.fPendingRemovals.iTabsToRemove.add(tab);
                EventQueue.invokeLater(this.fPendingRemovals);
            } else {
                this.fPendingRemovals.iTabsToRemove.add(tab);
            }
        } else {
            this.removeTabNow(tab);
        }
    }

    void removeAllTabs() {
        if (this.fAnimator.isRunning()) {
            this.fAnimator.stop();
        }
        this.fPendingAdditions = null;
        for (Tab tab : this.fTabList) {
            this.remove(tab);
            tab.dispose();
        }
        this.fTabList.clear();
    }

    void moveTab(DTClient dTClient, Motion motion) {
        int n;
        for (n = 0; n < this.fTabList.size() && this.fTabList.get(n).iDocument != dTClient; ++n) {
        }
        if (n == this.fTabList.size()) {
            return;
        }
        int n2 = -1;
        switch (motion) {
            case BACK: {
                if (n <= 0) break;
                n2 = n - 1;
                break;
            }
            case FORWARD: {
                if (n >= this.fTabList.size() - 1) break;
                n2 = n + 1;
                break;
            }
            case TO_BEGINING: {
                if (n <= 0) break;
                n2 = 0;
                break;
            }
            case TO_END: {
                if (n >= this.fTabList.size() - 1) break;
                n2 = this.fTabList.size() - 1;
            }
        }
        if (n2 >= 0) {
            this.moveTab(n, n2);
        }
    }

    public void moveTab(int n, int n2) {
        Tab tab = this.fTabList.get(n);
        this.fTabList.set(n, this.fTabList.get(n2));
        this.fTabList.set(n2, tab);
        this.revalidate();
        this.repaint();
    }

    List<DTClient> getDocuments() {
        List<Tab> list = this.fTabList;
        if (this.fPendingRemovals != null) {
            list = new ArrayList<Tab>(this.fTabList);
            list.removeAll(this.fPendingRemovals.iTabsToRemove);
        }
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>(list.size());
        for (Tab tab : list) {
            arrayList.add(tab.iDocument);
        }
        return arrayList;
    }

    void setNewAction(Action action) {
        if (action != null) {
            action = new ChildAction(action);
            ImageIcon imageIcon = IconUtils.changeIconColor((ImageIcon)MiscellaneousIcon.ADD_ENTRY.getIcon(), (Color)DESELECTED_TEXT_COLOR);
            action.putValue("SmallIcon", imageIcon);
        }
        if (this.fNewDocumentTab != null) {
            if (action != null) {
                this.fNewDocumentTab.setAction((MJAbstractAction)action);
            } else {
                this.remove(this.fNewDocumentTab);
                this.fNewDocumentTab = null;
            }
        } else if (action != null) {
            this.fNewDocumentTab = new Tab((MJAbstractAction)action);
            this.setLayer(this.fNewDocumentTab, DEFAULT_LAYER, 1000);
            this.add(this.fNewDocumentTab);
        }
    }

    boolean isGripVisible() {
        return this.fGrip.isVisible();
    }

    void setGripVisible(boolean bl) {
        if (bl != this.fGrip.isVisible()) {
            this.fGrip.setVisible(bl);
            this.revalidate();
            this.repaint();
        }
    }

    void setDrawClosedTabs(boolean bl) {
        if (bl != this.fDrawClosedTabs) {
            this.fDrawClosedTabs = bl;
            this.updateOverlap();
            this.revalidate();
            this.repaint();
        }
    }

    int getEdge() {
        return this.isVisible() ? this.fEdge : -1;
    }

    void setEdge(int n) {
        if (n != this.getEdge()) {
            this.setVisible(n != -1);
            if (n != -1) {
                this.fEdge = n;
                this.fGrip.setOrientation(DTDocumentTabs.getGripOrientation(n));
            }
            for (EdgeListener object : this.fEdgeListeners) {
                object.tabsMoved(this, this.getEdge());
            }
            this.revalidate();
            for (Tab tab : this.fTabList) {
                tab.revalidate();
                tab.repaint();
            }
            if (this.fNewDocumentTab != null) {
                this.fNewDocumentTab.revalidate();
                this.fNewDocumentTab.repaint();
            }
            this.repaint();
            if (this.fProperties != null) {
                this.fProperties.setEdge(n);
            }
        }
    }

    void addEdgeListener(EdgeListener edgeListener) {
        this.fEdgeListeners.add(edgeListener);
    }

    void removeEdgeListener(EdgeListener edgeListener) {
        this.fEdgeListeners.remove(edgeListener);
    }

    int getMinTabWidth() {
        return this.fMinTabWidth;
    }

    void setMinTabWidth(int n) {
        if (n != this.fMinTabWidth) {
            this.fMinTabWidth = n;
            this.revalidate();
            this.repaint();
            if (this.fProperties != null) {
                this.fProperties.setMinWidth(n);
            }
        }
    }

    int getMaxWidth() {
        return this.fMaxWidth;
    }

    void setMaxWidth(int n) {
        if (n != this.fMaxWidth) {
            this.fMaxWidth = n;
            this.revalidate();
            this.repaint();
            if (this.fProperties != null) {
                this.fProperties.setMaxWidth(n);
            }
        }
    }

    boolean shrinkTabsToFit() {
        return this.fShrinkTabsToFit;
    }

    void setShrinkTabsToFit(boolean bl) {
        if (bl != this.fShrinkTabsToFit) {
            this.fShrinkTabsToFit = bl;
            this.revalidate();
            this.repaint();
            if (this.fProperties != null) {
                this.fProperties.setShrinkToFit(bl);
            }
        }
    }

    Comparator<DTClient> getComparator() {
        return this.fComparator;
    }

    void setComparator(Comparator<DTClient> comparator) {
        if (this.fComparator != comparator) {
            this.fComparator = comparator;
            if (comparator != null) {
                Collections.sort(this.fTabList);
                this.revalidate();
                this.repaint();
            }
            if (this.fProperties != null) {
                this.fProperties.setComparator(comparator);
            }
        }
    }

    void setProperties(DTDocumentTabsProperties dTDocumentTabsProperties) {
        this.fProperties = dTDocumentTabsProperties;
        this.setEdge(dTDocumentTabsProperties.getEdge());
        this.setShrinkTabsToFit(dTDocumentTabsProperties.getShrinkToFit());
        this.setMaxWidth(dTDocumentTabsProperties.getMaxWidth());
        this.setMinTabWidth(dTDocumentTabsProperties.getMinWidth());
        this.setComparator(dTDocumentTabsProperties.getComparator());
    }

    DTDocumentTabsProperties getProperties() {
        return this.fProperties;
    }

    void setAppearFocused(boolean bl) {
        if (this.fAppearFocused != bl) {
            this.fAppearFocused = bl;
            this.repaint();
        }
    }

    boolean isAdjustingWidth() {
        return this.fIsAdjustingWidth;
    }

    void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.fDropTarget == null) {
            this.fDropTarget = new DropTarget();
            this.fDropTarget.setComponent((Component)((Object)this));
        }
        this.fDropTarget.addDropTargetListener(dropTargetListener);
    }

    void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTarget != null) {
            this.fDropTarget.removeDropTargetListener(dropTargetListener);
        }
    }

    private void removeTabNow(Tab tab) {
        this.remove(tab);
        tab.dispose();
        this.fTabList.remove(tab);
    }

    private void addDragDetector(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.fGrip.addMouseListener((MouseListener)mouseInputListener);
        this.fGrip.addMouseMotionListener((MouseMotionListener)mouseInputListener);
    }

    private Desktop getDesktop() {
        return this.fDocumentContainer.getDesktop();
    }

    private Action getCloseAllExceptAction(DTClient dTClient) {
        Action action = this.fDocumentContainer.getCloseAllExceptAction(dTClient);
        return !(action instanceof TargetedAction) || ((TargetedAction)((Object)action)).hasAnyTargets() ? action : null;
    }

    private Action getCloseAllAction() {
        Action action = this.fDocumentContainer.getCloseAllAction();
        if (!(action instanceof TargetedAction) || ((TargetedAction)((Object)action)).hasAnyTargets()) {
            ChildAction childAction = new ChildAction(this.fDocumentContainer.getCloseAllAction());
            childAction.setName(this.fDocumentContainer.getDesktop().getString("action.CloseAll"));
            return childAction;
        }
        return null;
    }

    private Action getCloseSelectAction() {
        Action action = this.fDocumentContainer.getCloseSelectAction();
        return !(action instanceof TargetedAction) || ((TargetedAction)((Object)action)).hasAnyTargets() ? action : null;
    }

    private Action getAlphabetizeAction() {
        return this.fDocumentContainer.getGroup().getAlphabetizeAction();
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(0, 0);
        if (DTDocumentTabs.getOrientation(this.fEdge) == 0) {
            Dimension dimension2;
            if (this.fGrip.isVisible()) {
                dimension.width += this.fGrip.getPreferredSize().width;
            }
            if (this.fNewDocumentTab != null) {
                dimension2 = this.fNewDocumentTab.getPreferredSize();
                dimension.width += dimension2.width;
                if (dimension2.height > dimension.height) {
                    dimension.height = dimension2.height;
                }
            }
            for (Tab tab : this.fTabList) {
                dimension2 = tab.getPreferredSize();
                dimension.width += dimension2.width;
                if (dimension2.height <= dimension.height) continue;
                dimension.height = dimension2.height;
            }
            dimension.width -= (this.getComponentCount() - 2) * this.fHorizontalOverlap;
        } else {
            Dimension dimension3;
            if (this.fGrip.isVisible()) {
                dimension.height += this.fGrip.getPreferredSize().height;
            }
            if (this.fNewDocumentTab != null) {
                dimension3 = this.fNewDocumentTab.getPreferredSize();
                dimension.height += dimension3.height;
                if (dimension3.width > dimension.width) {
                    dimension.width = dimension3.width;
                }
            }
            for (Tab tab : this.fTabList) {
                dimension3 = tab.getPreferredSize();
                dimension.height += dimension3.height;
                if (dimension3.width <= dimension.width) continue;
                dimension.width = dimension3.width;
            }
            dimension.height -= (this.getComponentCount() - 2) * this.fVerticalOverlap;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (dimension.width > this.fMaxWidth) {
            dimension.width = this.fMaxWidth;
        }
        return dimension;
    }

    public void doLayout() {
        Serializable serializable;
        int n;
        if (this.fTabDragger != null || this.fIsEditingTitle || this.fAnimator.isRunning() || this.fPendingAdditions != null || this.fPendingRemovals != null) {
            return;
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (n2 == 0 || n3 == 0) {
            return;
        }
        Insets insets = this.getInsets();
        int n4 = n3 - insets.top - insets.bottom;
        Dimension dimension = this.fGrip.isVisible() ? this.fGrip.getPreferredSize() : new Dimension(0, 0);
        int n5 = insets.left;
        int n6 = insets.top;
        this.fShowingTabRange = this.computeTabBounds();
        this.fOverflowButton.setVisible(this.fShowingTabRange != null);
        if (this.fShowingTabRange != null) {
            this.fOverflowButton.setCount(this.fTabList.size() - this.fShowingTabRange.count());
        }
        if (DTDocumentTabs.getOrientation(this.fEdge) == 0) {
            n = this.fEdge == 1 ? 0 : 0;
            this.fGrip.setBounds(n5, n, dimension.width, n3 - 0 - 1);
            n5 += dimension.width;
            if (this.fOverflowButton.isVisible()) {
                serializable = this.fOverflowButton.getPreferredSize();
                this.fOverflowButton.setBounds(n5, n + (n4 - ((Dimension)serializable).height) / 2, ((Dimension)serializable).width, ((Dimension)serializable).height);
            }
        } else if (!this.fOverflowButton.isVisible()) {
            this.fGrip.setBounds(this.fEdge == 7 ? 0 : 4, n6, n2 - 3 - 1, dimension.height);
            n6 += dimension.height;
        } else {
            Dimension dimension2 = this.fOverflowButton.getPreferredSize();
            if (this.fEdge == 7) {
                this.fOverflowButton.setBounds(0, 0, dimension2.width, dimension2.height);
                this.fGrip.setBounds(this.fOverflowButton.getX() + dimension2.width, n6 + (dimension2.height - dimension.height) / 2, n2 - 3 - 1 - dimension2.width, dimension.height);
            } else {
                this.fGrip.setBounds(4, n6 + (dimension2.height - dimension.height) / 2, n2 - 3 - 1 - dimension2.width, dimension.height);
                this.fOverflowButton.setBounds(this.fGrip.getX() + this.fGrip.getWidth(), 0, dimension2.width, dimension2.height);
            }
            n6 += dimension2.height;
        }
        for (n = 0; n < this.fTabList.size(); ++n) {
            serializable = this.fTabList.get(n);
            boolean bl = this.fShowingTabRange == null || this.fShowingTabRange.contains(n);
            ((JComponent)serializable).setVisible(bl);
            if (!bl) continue;
            ((Component)serializable).setBounds(((Tab)serializable).iBounds);
        }
        if (this.fNewDocumentTab != null) {
            this.fNewDocumentTab.setBounds(this.fNewDocumentTab.iBounds);
        }
    }

    public void paintChildren(Graphics graphics) {
        int n;
        boolean bl;
        if (!this.fAnimator.isRunning()) {
            super.paintChildren(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        OverflowButton overflowButton = this.fOverflowButton.isVisible() ? this.fOverflowButton : (this.fGrip.isVisible() ? this.fGrip : null);
        boolean bl2 = bl = this.fNewDocumentTab != null && this.fNewDocumentTab.isVisible();
        if (DTDocumentTabs.getOrientation(this.fEdge) == 0) {
            n = overflowButton == null ? 0 : ((Component)((Object)overflowButton)).getX() + ((Component)((Object)overflowButton)).getWidth() + 2;
            int n2 = bl ? this.fNewDocumentTab.getX() + this.fNewDocumentTab.getWidth() / 2 : this.getWidth();
            graphics2D.clip(new Rectangle(n, 0, n2 - n, this.getHeight()));
        } else {
            n = overflowButton == null ? 0 : ((Component)((Object)overflowButton)).getY() + ((Component)((Object)overflowButton)).getHeight() + 2;
            int n3 = bl ? this.fNewDocumentTab.getY() + this.fNewDocumentTab.getHeight() / 2 : this.getHeight();
            graphics2D.clip(new Rectangle(0, n, this.getWidth(), n3 - n));
        }
        super.paintChildren(graphics);
        graphics2D.setClip(shape);
        if (this.fGrip.isVisible()) {
            Graphics graphics2 = graphics.create(this.fGrip.getX(), this.fGrip.getY(), this.fGrip.getWidth(), this.fGrip.getHeight());
            this.fGrip.paint(graphics2);
            graphics2.dispose();
        }
        if (this.fOverflowButton.isVisible()) {
            Graphics graphics3 = graphics.create(this.fOverflowButton.getX(), this.fOverflowButton.getY(), this.fOverflowButton.getWidth(), this.fOverflowButton.getHeight());
            this.fOverflowButton.paint(graphics3);
            graphics3.dispose();
        }
        if (this.fNewDocumentTab != null && this.fNewDocumentTab.isVisible()) {
            Graphics graphics4 = graphics.create(this.fNewDocumentTab.getX(), this.fNewDocumentTab.getY(), this.fNewDocumentTab.getWidth(), this.fNewDocumentTab.getHeight());
            this.fNewDocumentTab.paint(graphics4);
            graphics4.dispose();
        }
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        switch (this.fEdge) {
            case 1: {
                n4 = n6 = n2 - insets.bottom - 1;
                break;
            }
            case 5: {
                n4 = n6 = insets.top;
                break;
            }
            case 7: {
                n3 = n5 = n - insets.right - 1;
                break;
            }
            case 3: {
                n3 = n5 = insets.left;
            }
        }
        graphics.setColor(this.fAppearFocused ? FOCUSED_OUTLINE_COLOR : OUTLINE_COLOR);
        graphics.drawLine(n3, n4, n5, n6);
    }

    private Range computeTabBounds() {
        int n = this.fTabList.size();
        Range range = null;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Insets insets = this.getInsets();
        int n4 = n2 - insets.left - insets.right;
        int n5 = n3 - insets.top - insets.bottom;
        Dimension dimension = this.fGrip.isVisible() ? this.fGrip.getPreferredSize() : new Dimension(0, 0);
        int n6 = insets.left;
        int n7 = insets.top;
        boolean bl = DTDocumentTabs.getOrientation(this.fEdge) == 0;
        for (Tab tab : this.fTabList) {
            Dimension dimension2 = tab.getPreferredSize();
            tab.iBounds = new Rectangle(n6, n7, dimension2.width, dimension2.height);
        }
        if (this.fNewDocumentTab != null) {
            Iterator<Tab> iterator = this.fNewDocumentTab.getPreferredSize();
            this.fNewDocumentTab.iBounds = new Rectangle(n6, n7, ((Dimension)((Object)iterator)).width, ((Dimension)((Object)iterator)).height);
        }
        if (bl) {
            Object object;
            for (Tab tab : this.fTabList) {
                ((Tab)tab).iBounds.height = n5;
            }
            if (this.fNewDocumentTab != null) {
                ((Tab)this.fNewDocumentTab).iBounds.height = n5;
            }
            int n8 = 0;
            int n9 = 0;
            for (Tab tab : this.fTabList) {
                n8 += ((Tab)tab).iBounds.width;
                if (((Tab)tab).iBounds.width <= this.fMinTabWidth) continue;
                n9 += ((Tab)tab).iBounds.width - this.fMinTabWidth;
            }
            int n10 = (n - 1) * this.fHorizontalOverlap;
            if (this.fNewDocumentTab != null) {
                n10 += this.fHorizontalOverlap;
            }
            n8 -= n10;
            n4 -= dimension.width;
            if (this.fNewDocumentTab != null) {
                n4 -= ((Tab)this.fNewDocumentTab).iBounds.width;
            }
            n6 += dimension.width;
            if (n8 > n4 && this.fShrinkTabsToFit) {
                int n11 = n8 - n4;
                object = this.fTabList.iterator();
                while (object.hasNext()) {
                    Tab tab = object.next();
                    if (((Tab)tab).iBounds.width <= this.fMinTabWidth) continue;
                    int n12 = n11 * (((Tab)tab).iBounds.width - this.fMinTabWidth) / n9 + 1;
                    int n13 = Math.max(((Tab)tab).iBounds.width - n12, this.fMinTabWidth);
                    n8 -= ((Tab)tab).iBounds.width - n13;
                    ((Tab)tab).iBounds.width = n13;
                }
            }
            int n14 = 0;
            if (n8 > n4 && n > 1) {
                range = new Range(0, n - 1);
                if (this.fShowingTabRange != null) {
                    while (range.iHigh > this.fShowingTabRange.iHigh && n8 > n4 && !((Tab)(object = this.fTabList.get(range.iHigh))).isSelected() && object != this.fJustAddedTab) {
                        int n15 = ((Tab)object).iBounds.width - this.fHorizontalOverlap;
                        n8 -= n15;
                        n14 += n15;
                        --range.iHigh;
                    }
                    while (range.iLow < this.fShowingTabRange.iLow && n8 > n4 && !((Tab)(object = this.fTabList.get(range.iLow))).isSelected()) {
                        int n16 = ((Tab)object).iBounds.width - this.fHorizontalOverlap;
                        n8 -= n16;
                        n6 -= n16;
                        ++range.iLow;
                    }
                }
                while (range.iHigh > range.iLow && n8 > n4 && !((Tab)(object = this.fTabList.get(range.iHigh))).isSelected() && object != this.fJustAddedTab) {
                    int n17 = ((Tab)object).iBounds.width - this.fHorizontalOverlap;
                    n8 -= n17;
                    n14 += n17;
                    --range.iHigh;
                }
                while (range.iLow < range.iHigh && n8 > n4 && !((Tab)(object = this.fTabList.get(range.iLow))).isSelected()) {
                    int n18 = ((Tab)object).iBounds.width - this.fHorizontalOverlap;
                    n8 -= n18;
                    n6 -= n18;
                    ++range.iLow;
                }
                if (this.fJustAddedTab != null) {
                    while (range.iHigh > range.iLow && n8 > n4 && !((Tab)(object = this.fTabList.get(range.iHigh))).isSelected()) {
                        int n19 = ((Tab)object).iBounds.width - this.fHorizontalOverlap;
                        n8 -= n19;
                        n14 += n19;
                        --range.iHigh;
                    }
                    this.fJustAddedTab = null;
                }
                n6 += this.fOverflowButton.getPreferredSize().width;
            }
            for (Tab tab : this.fTabList) {
                ((Tab)tab).iBounds.x = n6;
                n6 += ((Tab)tab).iBounds.width - this.fHorizontalOverlap;
            }
            if (this.fNewDocumentTab != null) {
                ((Tab)this.fNewDocumentTab).iBounds.x = n6 - n14;
            }
        } else {
            for (Tab tab : this.fTabList) {
                ((Tab)tab).iBounds.width = n4;
            }
            if (this.fNewDocumentTab != null) {
                ((Tab)this.fNewDocumentTab).iBounds.width = n4;
            }
            int n20 = 0;
            int n21 = 0;
            if (n > 0) {
                n20 = ((Tab)this.fTabList.get((int)0)).iBounds.height;
                int n22 = n20 - this.fVerticalOverlap;
                int n23 = n20 + (n - 1) * n22;
                n5 -= dimension.height;
                if (this.fNewDocumentTab != null) {
                    n5 -= n22;
                }
                n7 += dimension.height;
                if (n23 > n5) {
                    int n24;
                    int n25 = ((n5 -= this.fOverflowButton.getPreferredSize().height - dimension.height - 9) - n20) / n22 + 1;
                    int n26 = n - n25;
                    range = new Range(0, n - 1);
                    for (n24 = 0; n24 < n && !this.fTabList.get(n24).isSelected(); ++n24) {
                    }
                    if (this.fShowingTabRange != null) {
                        range.iHigh = Math.max(Math.min(this.fShowingTabRange.iHigh, n - 1), Math.max(n - 1 - n26, n24));
                        n26 = range.count() - n25;
                        range.iLow = Math.min(this.fShowingTabRange.iLow, Math.min(n26, n24));
                        n26 = range.count() - n25;
                    }
                    if (n26 > 0) {
                        range.iHigh = Math.max(range.iHigh - n26, n24);
                        n26 = range.count() - n25;
                    }
                    if (n26 > 0) {
                        range.iLow = Math.min(range.iLow + n26, n24);
                    }
                    n7 += this.fOverflowButton.getPreferredSize().height - dimension.height - 9;
                    n7 -= range.iLow * n22;
                    n21 = n - 1 - range.iHigh;
                }
            }
            for (Tab tab : this.fTabList) {
                ((Tab)tab).iBounds.y = n7;
                n7 += n20 - this.fVerticalOverlap;
            }
            if (this.fNewDocumentTab != null) {
                if (n20 == 0) {
                    n20 = ((Tab)this.fNewDocumentTab).iBounds.height;
                }
                ((Tab)this.fNewDocumentTab).iBounds.y = n7 - n21 * (n20 - this.fVerticalOverlap);
            }
        }
        return range;
    }

    private void updateOverlap() {
        if (this.fDrawClosedTabs) {
            this.fHorizontalOverlap = 1;
            this.fVerticalOverlap = 1;
        } else {
            this.fHorizontalOverlap = 22;
            this.fVerticalOverlap = 19;
        }
        this.fExcessHorizontalOverlap = Math.max(0, this.fHorizontalOverlap - 18);
    }

    private static int getGripOrientation(int n) {
        return n == 3 || n == 7 ? 1 : 0;
    }

    private static int getOrientation(int n) {
        return n == 3 || n == 7 ? 1 : 0;
    }

    private void refreshTabZOrder() {
        for (int i = 0; i < this.fTabList.size(); ++i) {
            this.setPosition(this.fTabList.get(i), i);
        }
    }

    private void slideTabIntoView(Tab tab) {
        if (this.fShowingTabRange == null || this.fPendingAdditions != null) {
            return;
        }
        int n = this.fTabList.indexOf(tab);
        if (!this.fShowingTabRange.contains(n)) {
            if (this.fAnimator.isRunning()) {
                this.fAnimator.stop();
            }
            for (int i = 0; i < this.fTabList.size(); ++i) {
                Tab tab2;
                if (this.fShowingTabRange.contains(i) || (tab2 = this.fTabList.get(i)).iBounds == null) continue;
                tab2.setBounds(tab2.iBounds);
                tab2.setVisible(true);
            }
            this.computeTabBounds();
            for (Tab tab2 : this.fTabList) {
                this.fAnimator.setupAnimation(tab2);
            }
            this.fAnimator.addDoneListener(new AnimationDoneListener(){

                @Override
                public void animationDone(boolean bl) {
                    DTDocumentTabs.this.revalidate();
                    DTDocumentTabs.this.repaint();
                }
            });
            this.fAnimator.start();
        }
    }

    private void addGlobalMenuItems(JPopupMenu jPopupMenu) {
        Action action;
        JMenu jMenu;
        Action action2;
        Action action3 = this.getNewContextAction();
        if (action3 != null) {
            jPopupMenu.add(action3);
            jPopupMenu.addSeparator();
        }
        boolean bl = false;
        Action action4 = this.getCloseAllAction();
        if (action4 != null) {
            jPopupMenu.add(action4);
            bl = true;
        }
        if ((action2 = this.getCloseSelectAction()) != null) {
            jPopupMenu.add(action2);
            bl = true;
        }
        if (bl) {
            jPopupMenu.addSeparator();
        }
        if ((jMenu = this.createMoveSubMenu()) != null) {
            jPopupMenu.add(jMenu);
        }
        if (DTDocumentTabs.getOrientation(this.fEdge) == 0 && this.fProperties != null) {
            jPopupMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)this.fProperties.getToggleShrinkToFitAction()));
        }
        if ((action = this.getAlphabetizeAction()) != null) {
            jPopupMenu.add((JMenuItem)new MJCheckBoxMenuItem(action));
        }
    }

    private Action getNewContextAction() {
        if (this.fNewDocumentTab != null) {
            ChildAction childAction = new ChildAction((Action)this.fNewDocumentTab.iAction);
            childAction.putValue("SmallIcon", ChildAction.NULL_VALUE);
            return childAction;
        }
        return null;
    }

    private JMenu createMoveSubMenu() {
        if (this.fProperties == null) {
            return null;
        }
        MJMenu mJMenu = new MJMenu(this.getDesktop().getString("menu.BarPosition"));
        mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)this.fProperties.getMoveAction(1)));
        mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)this.fProperties.getMoveAction(5)));
        mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)this.fProperties.getMoveAction(7)));
        mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)this.fProperties.getMoveAction(3)));
        if (this.fDocumentContainer.getGroup().permitDocumentBarHide() && !this.fDocumentContainer.getGroup().placeToolBarsWithDocumentBar()) {
            mJMenu.addSeparator();
            mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)this.fProperties.getMoveAction(-1)));
        }
        return mJMenu;
    }

    private boolean shouldAnimate() {
        return sAnimationEnabled && this.isVisible() && !this.fDocumentContainer.isRestoringDocuments() && !this.fDocumentContainer.isChangingArrangement();
    }

    static {
        SELECTED_LIGHT_COLOR = new Color(255, 255, 255);
        SELECTED_DARK_COLOR = new Color(245, 245, 248);
        FOCUSED_DARK_COLOR = new Color(221, 231, 239);
        DESELECTED_LIGHT_COLOR = new Color(226, 226, 226);
        DESELECTED_DARK_COLOR = new Color(216, 216, 216);
        OUTLINE_COLOR = new Color(148, 148, 148);
        FOCUSED_OUTLINE_COLOR = new Color(49, 101, 156);
        SELECTED_TEXT_COLOR = Color.black;
        DESELECTED_TEXT_COLOR = new Color(64, 64, 64);
        HIGHLIGHT_CENTER_COLOR = new Color(255, 255, 255, 128);
        HIGHLIGHT_EDGE_COLOR = new Color(255, 255, 255, 32);
        EDIT_LAYER = POPUP_LAYER;
        TSLookAndFeel.install();
        sAnimationEnabled = Prefs.getBooleanPref((String)ANIMATION_PREFERENCE, (boolean)true);
        PrefListener prefListener = new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                sAnimationEnabled = Prefs.getBooleanPref((String)DTDocumentTabs.ANIMATION_PREFERENCE, (boolean)true);
            }
        };
        Prefs.addListener((PrefListener)prefListener, (String)ANIMATION_PREFERENCE);
        DURATION_PER_PIXEL = 2500.0f / (float)Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    private class PendingRemovals
    implements Runnable {
        List<Tab> iTabsToRemove = new ArrayList<Tab>();

        private PendingRemovals() {
        }

        @Override
        public void run() {
            if (DTDocumentTabs.this.fPendingRemovals == null) {
                return;
            }
            if (this.iTabsToRemove.size() == DTDocumentTabs.this.fTabList.size()) {
                for (Tab tab : DTDocumentTabs.this.fTabList) {
                    DTDocumentTabs.this.remove(tab);
                    tab.dispose();
                }
                DTDocumentTabs.this.fTabList.clear();
                DTDocumentTabs.this.fPendingRemovals = null;
                return;
            }
            ArrayList arrayList = new ArrayList(DTDocumentTabs.this.fTabList);
            arrayList.removeAll(this.iTabsToRemove);
            List list = DTDocumentTabs.this.fTabList;
            DTDocumentTabs.this.fTabList = arrayList;
            DTDocumentTabs.this.computeTabBounds();
            DTDocumentTabs.this.fTabList = list;
            switch (DTDocumentTabs.this.fEdge) {
                case 1: {
                    for (Tab tab : this.iTabsToRemove) {
                        if (tab.iBounds != null) {
                            ((Tab)tab).iBounds.y += ((Tab)tab).iBounds.height;
                        }
                        tab.setEnabled(false);
                    }
                    break;
                }
                case 5: {
                    for (Tab tab : this.iTabsToRemove) {
                        if (tab.iBounds != null) {
                            ((Tab)tab).iBounds.y -= ((Tab)tab).iBounds.height;
                        }
                        tab.setEnabled(false);
                    }
                    break;
                }
                case 7: {
                    for (Tab tab : this.iTabsToRemove) {
                        if (tab.iBounds != null) {
                            ((Tab)tab).iBounds.x += ((Tab)tab).iBounds.width;
                        }
                        tab.setEnabled(false);
                    }
                    break;
                }
                case 3: {
                    for (Tab tab : this.iTabsToRemove) {
                        if (tab.iBounds != null) {
                            ((Tab)tab).iBounds.x -= ((Tab)tab).iBounds.width;
                        }
                        tab.setEnabled(false);
                    }
                    break;
                }
            }
            for (Tab tab : DTDocumentTabs.this.fTabList) {
                if (tab.iBounds == null) continue;
                tab.setVisible(true);
                DTDocumentTabs.this.fAnimator.setupAnimation(tab);
            }
            if (DTDocumentTabs.this.fNewDocumentTab != null) {
                DTDocumentTabs.this.fAnimator.setupAnimation(DTDocumentTabs.this.fNewDocumentTab);
            }
            DTDocumentTabs.this.fAnimator.addDoneListener(new AnimationDoneListener(){

                @Override
                public void animationDone(boolean bl) {
                    DTDocumentTabs.this.fPendingRemovals = null;
                    for (Tab tab : PendingRemovals.this.iTabsToRemove) {
                        DTDocumentTabs.this.removeTabNow(tab);
                    }
                    DTDocumentTabs.this.revalidate();
                    DTDocumentTabs.this.repaint();
                }
            });
            DTDocumentTabs.this.fAnimator.start();
        }
    }

    private class PendingAdditions
    implements Runnable {
        List<Tab> iTabsToAdd = new ArrayList<Tab>();

        private PendingAdditions() {
        }

        @Override
        public void run() {
            if (DTDocumentTabs.this.fPendingAdditions == null) {
                return;
            }
            ArrayList arrayList = new ArrayList(DTDocumentTabs.this.fTabList);
            arrayList.removeAll(this.iTabsToAdd);
            for (Tab tab : arrayList) {
                if (tab.isVisible() || tab.iBounds == null) continue;
                tab.setBounds(tab.iBounds);
                tab.setVisible(true);
            }
            DTDocumentTabs.this.fShowingTabRange = DTDocumentTabs.this.computeTabBounds();
            switch (DTDocumentTabs.this.fEdge) {
                case 1: {
                    for (Tab tab : this.iTabsToAdd) {
                        tab.setBounds(((Tab)tab).iBounds.x, ((Tab)tab).iBounds.y + ((Tab)tab).iBounds.height, ((Tab)tab).iBounds.width, ((Tab)tab).iBounds.height);
                    }
                    break;
                }
                case 5: {
                    for (Tab tab : this.iTabsToAdd) {
                        tab.setBounds(((Tab)tab).iBounds.x, ((Tab)tab).iBounds.y - ((Tab)tab).iBounds.height, ((Tab)tab).iBounds.width, ((Tab)tab).iBounds.height);
                    }
                    break;
                }
                case 7: {
                    for (Tab tab : this.iTabsToAdd) {
                        tab.setBounds(((Tab)tab).iBounds.x + ((Tab)tab).iBounds.width, ((Tab)tab).iBounds.y, ((Tab)tab).iBounds.width, ((Tab)tab).iBounds.height);
                    }
                    break;
                }
                case 3: {
                    for (Tab tab : this.iTabsToAdd) {
                        tab.setBounds(((Tab)tab).iBounds.x - ((Tab)tab).iBounds.width, ((Tab)tab).iBounds.y, ((Tab)tab).iBounds.width, ((Tab)tab).iBounds.height);
                    }
                    break;
                }
            }
            for (Tab tab : DTDocumentTabs.this.fTabList) {
                DTDocumentTabs.this.fAnimator.setupAnimation(tab);
            }
            if (DTDocumentTabs.this.fNewDocumentTab != null) {
                DTDocumentTabs.this.fAnimator.setupAnimation(DTDocumentTabs.this.fNewDocumentTab);
            }
            DTDocumentTabs.this.fAnimator.addDoneListener(new AnimationDoneListener(){

                @Override
                public void animationDone(boolean bl) {
                    if (DTDocumentTabs.this.fNewDocumentTab != null) {
                        DTDocumentTabs.this.fNewDocumentTab.setVisible(true);
                    }
                    DTDocumentTabs.this.fPendingAdditions = null;
                    DTDocumentTabs.this.revalidate();
                    DTDocumentTabs.this.repaint();
                }
            });
            DTDocumentTabs.this.fAnimator.start();
        }
    }

    private class Animator
    implements ActionListener {
        private final Timer iTimer = new Timer(33, this);
        private final List<AnimationDoneListener> fDoneListeners = new ArrayList<AnimationDoneListener>();
        private final Interpolator iInterpolator = new SplineInterpolator(0.2f, 0.1f, 0.75f, 0.95f);

        private Animator() {
        }

        private void addDoneListener(AnimationDoneListener animationDoneListener) {
            this.fDoneListeners.add(animationDoneListener);
        }

        void setupAnimation(Tab tab) {
            this.setupAnimation(tab, System.currentTimeMillis());
        }

        void setupAnimation(Tab tab, long l) {
            tab.iStartBounds = tab.getBounds();
            tab.iDiffs = new Rectangle(((Tab)tab).iBounds.x - ((Tab)tab).iStartBounds.x, ((Tab)tab).iBounds.y - ((Tab)tab).iStartBounds.y, ((Tab)tab).iBounds.width - ((Tab)tab).iStartBounds.width, ((Tab)tab).iBounds.height - ((Tab)tab).iStartBounds.height);
            int n = Math.max(Math.abs(((Tab)tab).iDiffs.x), Math.max(Math.abs(((Tab)tab).iDiffs.y), Math.max(Math.abs(((Tab)tab).iDiffs.width), Math.abs(((Tab)tab).iDiffs.height))));
            tab.iStartTime = l;
            tab.iDuration = Math.min(Math.max((int)((float)n * DURATION_PER_PIXEL), 250), 1500);
        }

        private void start() {
            if (!this.iTimer.isRunning()) {
                this.iTimer.start();
            }
        }

        private void stop() {
            if (this.iTimer.isRunning()) {
                this.iTimer.stop();
                this.fireDoneNotification(true);
            }
        }

        private boolean isRunning() {
            return this.iTimer.isRunning();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            long l = System.currentTimeMillis();
            ArrayList<Tab> arrayList = DTDocumentTabs.this.fTabList;
            if (DTDocumentTabs.this.fNewDocumentTab != null) {
                arrayList = new ArrayList<Tab>(arrayList.size() + 1);
                arrayList.addAll(DTDocumentTabs.this.fTabList);
                arrayList.add(DTDocumentTabs.this.fNewDocumentTab);
            }
            for (Tab tab : arrayList) {
                if (tab.iStartBounds == null) continue;
                float f = (float)(l - tab.iStartTime) / (float)tab.iDuration;
                f = f > 1.0f ? 1.0f : this.iInterpolator.interpolate(f);
                int n = ((Tab)tab).iStartBounds.x + (int)(f * (float)((Tab)tab).iDiffs.x);
                int n2 = ((Tab)tab).iStartBounds.y + (int)(f * (float)((Tab)tab).iDiffs.y);
                int n3 = ((Tab)tab).iStartBounds.width + (int)(f * (float)((Tab)tab).iDiffs.width);
                int n4 = ((Tab)tab).iStartBounds.height + (int)(f * (float)((Tab)tab).iDiffs.height);
                tab.setBounds(n, n2, n3, n4);
                if (f < 1.0f) {
                    bl = true;
                    continue;
                }
                tab.iStartBounds = null;
                tab.iDiffs = null;
            }
            if (!bl) {
                this.iTimer.stop();
                this.fireDoneNotification(false);
            }
        }

        private void fireDoneNotification(boolean bl) {
            ArrayList<AnimationDoneListener> arrayList = new ArrayList<AnimationDoneListener>(this.fDoneListeners);
            this.fDoneListeners.clear();
            for (AnimationDoneListener animationDoneListener : arrayList) {
                animationDoneListener.animationDone(bl);
            }
        }
    }

    private static interface AnimationDoneListener {
        public void animationDone(boolean var1);
    }

    private class TabDragger
    implements AnimationDoneListener {
        private final Tab iTab;
        private Point iInitialLocation;
        private int iInitialIndex;
        private int iCurrentIndex;
        private int iLowerLocationLimit;
        private int iUpperLocationLimit;
        private boolean iHasDraggedOff;
        private boolean iOrderHasChanged;
        private boolean iIsBelowLimit;
        private boolean iIsAboveLimit;

        private TabDragger(Tab tab) {
            this.iTab = tab;
        }

        private void initiateDragOff(MouseEvent mouseEvent) {
            this.iHasDraggedOff = true;
            DTDocumentTabs.this.fDocumentContainer.startClientDrag(this.iTab.iDocument, mouseEvent.getComponent());
        }

        private void beginDrag() {
            this.iInitialLocation = this.iTab.iBounds.getLocation();
            this.iCurrentIndex = this.iInitialIndex = DTDocumentTabs.this.fTabList.indexOf(this.iTab);
            Range range = DTDocumentTabs.this.fShowingTabRange != null ? DTDocumentTabs.this.fShowingTabRange : new Range(0, DTDocumentTabs.this.fTabList.size() - 1);
            Rectangle rectangle = ((Tab)DTDocumentTabs.this.fTabList.get(range.iLow)).iBounds;
            Rectangle rectangle2 = ((Tab)DTDocumentTabs.this.fTabList.get(range.iHigh)).iBounds;
            if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0) {
                this.iLowerLocationLimit = rectangle.x;
                this.iUpperLocationLimit = rectangle2.x + rectangle2.width;
            } else {
                this.iLowerLocationLimit = rectangle.y;
                this.iUpperLocationLimit = rectangle2.y + rectangle2.height;
            }
            DTDocumentTabs.this.remove(this.iTab);
            DTDocumentTabs.this.setLayer(this.iTab, JLayeredPane.DRAG_LAYER);
            DTDocumentTabs.this.add(this.iTab);
        }

        private void continueDrag(int n) {
            int n2;
            int n3 = 0;
            this.iIsAboveLimit = false;
            this.iIsBelowLimit = false;
            if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0) {
                n2 = ((Tab)this.iTab).iBounds.x;
                ((Tab)this.iTab).iBounds.x = this.iInitialLocation.x + n;
                if (((Tab)this.iTab).iBounds.x < this.iLowerLocationLimit) {
                    ((Tab)this.iTab).iBounds.x = this.iLowerLocationLimit;
                    this.iIsBelowLimit = true;
                } else if (((Tab)this.iTab).iBounds.x + ((Tab)this.iTab).iBounds.width > this.iUpperLocationLimit) {
                    ((Tab)this.iTab).iBounds.x = this.iUpperLocationLimit - ((Tab)this.iTab).iBounds.width;
                    this.iIsAboveLimit = true;
                }
                if (((Tab)this.iTab).iBounds.x < n2) {
                    n3 = -1;
                } else if (((Tab)this.iTab).iBounds.x > n2) {
                    n3 = 1;
                }
            } else {
                n2 = ((Tab)this.iTab).iBounds.y;
                ((Tab)this.iTab).iBounds.y = this.iInitialLocation.y + n;
                if (((Tab)this.iTab).iBounds.y < this.iLowerLocationLimit) {
                    ((Tab)this.iTab).iBounds.y = this.iLowerLocationLimit;
                    this.iIsBelowLimit = true;
                } else if (((Tab)this.iTab).iBounds.y + ((Tab)this.iTab).iBounds.height > this.iUpperLocationLimit) {
                    ((Tab)this.iTab).iBounds.y = this.iUpperLocationLimit - ((Tab)this.iTab).iBounds.height;
                    this.iIsAboveLimit = true;
                }
                if (((Tab)this.iTab).iBounds.y < n2) {
                    n3 = -1;
                } else if (((Tab)this.iTab).iBounds.y > n2) {
                    n3 = 1;
                }
            }
            if (n3 != 0) {
                this.iTab.setBounds(this.iTab.iBounds);
            }
            if (this.iIsBelowLimit || this.iIsAboveLimit) {
                if (!DTDocumentTabs.this.fAnimator.isRunning()) {
                    this.slideTabs();
                }
            } else if (n3 != 0) {
                int n4;
                n2 = this.iInitialIndex < this.iCurrentIndex ? this.iCurrentIndex : this.iCurrentIndex - 1;
                int n5 = n4 = this.iInitialIndex > this.iCurrentIndex ? this.iCurrentIndex : this.iCurrentIndex + 1;
                if (n2 == this.iInitialIndex) {
                    ++n2;
                }
                if (n4 == this.iInitialIndex) {
                    ++n4;
                }
                if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0) {
                    if (n3 < 0 && n2 >= 0) {
                        Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(n2);
                        if (((Tab)this.iTab).iBounds.x + 9 < ((Tab)tab).iBounds.x + ((Tab)tab).iBounds.width / 2) {
                            ((Tab)tab).iBounds.x += ((Tab)this.iTab).iBounds.width - DTDocumentTabs.this.fHorizontalOverlap;
                            --this.iCurrentIndex;
                            DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                            DTDocumentTabs.this.fAnimator.start();
                            this.iOrderHasChanged = true;
                        }
                    } else if (n3 > 0 && n4 < DTDocumentTabs.this.fTabList.size()) {
                        Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(n4);
                        if (((Tab)this.iTab).iBounds.x + ((Tab)this.iTab).iBounds.width - 9 > ((Tab)tab).iBounds.x + ((Tab)tab).iBounds.width / 2) {
                            ((Tab)tab).iBounds.x -= ((Tab)this.iTab).iBounds.width - DTDocumentTabs.this.fHorizontalOverlap;
                            ++this.iCurrentIndex;
                            DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                            DTDocumentTabs.this.fAnimator.start();
                            this.iOrderHasChanged = true;
                        }
                    }
                } else if (n3 < 0 && n2 >= 0) {
                    Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(n2);
                    if (((Tab)this.iTab).iBounds.y + 9 < ((Tab)tab).iBounds.y + ((Tab)tab).iBounds.height / 2) {
                        ((Tab)tab).iBounds.y += ((Tab)this.iTab).iBounds.height - DTDocumentTabs.this.fVerticalOverlap;
                        --this.iCurrentIndex;
                        DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                        DTDocumentTabs.this.fAnimator.start();
                        this.iOrderHasChanged = true;
                    }
                } else if (n3 > 0 && n4 < DTDocumentTabs.this.fTabList.size()) {
                    Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(n4);
                    if (((Tab)this.iTab).iBounds.y + ((Tab)this.iTab).iBounds.height - 9 > ((Tab)tab).iBounds.y + ((Tab)tab).iBounds.height / 2) {
                        ((Tab)tab).iBounds.y -= ((Tab)this.iTab).iBounds.height - DTDocumentTabs.this.fVerticalOverlap;
                        ++this.iCurrentIndex;
                        DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                        DTDocumentTabs.this.fAnimator.start();
                        this.iOrderHasChanged = true;
                    }
                }
            }
        }

        private void endDrag() {
            this.iIsBelowLimit = false;
            this.iIsAboveLimit = false;
            if (DTDocumentTabs.this.fAnimator.isRunning()) {
                DTDocumentTabs.this.fAnimator.stop();
            }
            DTDocumentTabs.this.fTabDragger = null;
            if (this.iHasDraggedOff || !DTDocumentTabs.this.fTabList.contains(this.iTab)) {
                DTDocumentTabs.this.revalidate();
                DTDocumentTabs.this.repaint();
            } else {
                DTDocumentTabs.this.fAnimator.setupAnimation(this.iTab);
                DTDocumentTabs.this.fAnimator.addDoneListener(new AnimationDoneListener(){

                    @Override
                    public void animationDone(boolean bl) {
                        if (DTDocumentTabs.this.fTabList.contains(TabDragger.this.iTab)) {
                            TabDragger.this.restoreTab();
                        }
                    }
                });
                DTDocumentTabs.this.fAnimator.start();
            }
        }

        private void restoreTab() {
            DTDocumentTabs.this.remove(this.iTab);
            DTDocumentTabs.this.setLayer(this.iTab, this.iTab.isSelected() ? JLayeredPane.PALETTE_LAYER : JLayeredPane.DEFAULT_LAYER);
            DTDocumentTabs.this.add(this.iTab);
            if (this.iCurrentIndex != this.iInitialIndex) {
                DTDocumentTabs.this.fTabList.remove(this.iInitialIndex);
                DTDocumentTabs.this.fTabList.add(this.iCurrentIndex, this.iTab);
                this.iTab.iDocument.getGroup().setAlphabetizeDocuments(false);
                if (!this.iTab.isSelected() && DTDocumentTabs.this.fShowingTabRange != null && !DTDocumentTabs.this.fShowingTabRange.contains(this.iCurrentIndex)) {
                    this.iTab.select();
                }
            }
            DTDocumentTabs.this.refreshTabZOrder();
            DTDocumentTabs.this.revalidate();
            DTDocumentTabs.this.repaint();
        }

        private void slideTabs() {
            boolean bl = DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0;
            boolean bl2 = false;
            if (this.iIsBelowLimit && this.iCurrentIndex > 0) {
                if (bl) {
                    Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(this.iCurrentIndex - 1);
                    int n = ((Tab)this.iTab).iBounds.x + ((Tab)this.iTab).iBounds.width;
                    tab.setLocation(n - ((Tab)tab).iBounds.width, ((Tab)tab).iBounds.y);
                    tab.setVisible(true);
                    ((Tab)tab).iBounds.x = n - DTDocumentTabs.this.fHorizontalOverlap;
                    DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                    int n2 = ((Tab)tab).iBounds.x + ((Tab)tab).iBounds.width - DTDocumentTabs.this.fHorizontalOverlap;
                    for (int i = this.iCurrentIndex; i < DTDocumentTabs.this.fTabList.size(); ++i) {
                        Tab tab2 = (Tab)DTDocumentTabs.this.fTabList.get(i);
                        if (tab2 == this.iTab) continue;
                        ((Tab)tab2).iBounds.x = n2;
                        n2 += ((Tab)tab2).iBounds.width - DTDocumentTabs.this.fHorizontalOverlap;
                        DTDocumentTabs.this.fAnimator.setupAnimation(tab2);
                    }
                } else {
                    Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(this.iCurrentIndex - 1);
                    int n = ((Tab)this.iTab).iBounds.y + ((Tab)this.iTab).iBounds.height;
                    tab.setLocation(((Tab)tab).iBounds.x, n - ((Tab)tab).iBounds.height);
                    tab.setVisible(true);
                    ((Tab)tab).iBounds.y = n - DTDocumentTabs.this.fVerticalOverlap;
                    DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                    int n3 = ((Tab)tab).iBounds.y + ((Tab)tab).iBounds.height - DTDocumentTabs.this.fVerticalOverlap;
                    for (int i = this.iCurrentIndex; i < DTDocumentTabs.this.fTabList.size(); ++i) {
                        Tab tab3 = (Tab)DTDocumentTabs.this.fTabList.get(i);
                        if (tab3 == this.iTab) continue;
                        ((Tab)tab3).iBounds.y = n3;
                        n3 += ((Tab)tab3).iBounds.height - DTDocumentTabs.this.fVerticalOverlap;
                        DTDocumentTabs.this.fAnimator.setupAnimation(tab3);
                    }
                }
                --this.iCurrentIndex;
                bl2 = true;
            } else if (this.iIsAboveLimit && this.iCurrentIndex < DTDocumentTabs.this.fTabList.size() - 1) {
                if (bl) {
                    Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(this.iCurrentIndex + 1);
                    int n = ((Tab)this.iTab).iBounds.x;
                    tab.setLocation(n, ((Tab)tab).iBounds.y);
                    tab.setVisible(true);
                    ((Tab)tab).iBounds.x = n - ((Tab)tab).iBounds.width + DTDocumentTabs.this.fHorizontalOverlap;
                    DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                    int n4 = ((Tab)tab).iBounds.x;
                    for (int i = this.iCurrentIndex; i >= 0; --i) {
                        Tab tab4 = (Tab)DTDocumentTabs.this.fTabList.get(i);
                        if (tab4 == this.iTab) continue;
                        ((Tab)tab4).iBounds.x = n4 -= ((Tab)tab4).iBounds.width - DTDocumentTabs.this.fHorizontalOverlap;
                        DTDocumentTabs.this.fAnimator.setupAnimation(tab4);
                    }
                } else {
                    Tab tab = (Tab)DTDocumentTabs.this.fTabList.get(this.iCurrentIndex + 1);
                    int n = ((Tab)this.iTab).iBounds.y;
                    tab.setLocation(((Tab)tab).iBounds.x, n);
                    tab.setVisible(true);
                    ((Tab)tab).iBounds.y = n - ((Tab)tab).iBounds.height + DTDocumentTabs.this.fVerticalOverlap;
                    DTDocumentTabs.this.fAnimator.setupAnimation(tab);
                    int n5 = ((Tab)tab).iBounds.y;
                    for (int i = this.iCurrentIndex; i >= 0; --i) {
                        Tab tab5 = (Tab)DTDocumentTabs.this.fTabList.get(i);
                        if (tab5 == this.iTab) continue;
                        ((Tab)tab5).iBounds.y = n5 -= ((Tab)tab5).iBounds.height - DTDocumentTabs.this.fVerticalOverlap;
                        DTDocumentTabs.this.fAnimator.setupAnimation(tab5);
                    }
                }
                ++this.iCurrentIndex;
                bl2 = true;
            }
            if (bl2) {
                DTDocumentTabs.this.fAnimator.addDoneListener(this);
                DTDocumentTabs.this.fAnimator.start();
            }
        }

        @Override
        public void animationDone(boolean bl) {
            if (this.iIsBelowLimit || this.iIsAboveLimit) {
                Timer timer = new Timer(200, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (TabDragger.this.iIsBelowLimit || TabDragger.this.iIsAboveLimit) {
                            TabDragger.this.slideTabs();
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        }
    }

    class TabsDragger
    extends MouseInputAdapter {
        int iLastEdge;

        TabsDragger(Component component) {
            this.iLastEdge = DTDocumentTabs.this.fEdge;
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n = DTDragUtilities.getNearestEdge(point = SwingUtilities.convertPoint(component, point, DTDocumentTabs.this.getParent()), DTDocumentTabs.this.getParent().getSize(), 0.4f);
            if (n != 0 && n != DTDocumentTabs.this.fEdge) {
                DTDocumentTabs.this.setEdge(n);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupSuccesor((MouseEvent)mouseEvent)) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
        }
    }

    private class TabsDragDetector
    extends DTDragDetector {
        private TabsDragDetector() {
        }

        @Override
        protected String getHint(MouseEvent mouseEvent) {
            return DTDocumentTabs.this.fDocumentContainer.getDesktop().getString("status.ToMoveDocumentBar");
        }

        @Override
        protected void startDrag(MouseEvent mouseEvent) {
            if (!DTDocumentTabs.this.isAdjustingWidth()) {
                new TabsDragger(mouseEvent.getComponent());
            }
        }
    }

    private static class OverflowButtonUI
    extends DropDownButtonUI {
        private OverflowButtonUI() {
        }

        protected void paintContent(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
            this.paintContent(graphics2D, abstractButton, rectangle, false);
        }
    }

    private class OverflowButton
    extends TSDropDownButton
    implements PopupListener {
        private int iOverflowCount;

        private OverflowButton() {
            this.setName(DTDocumentTabs.this.fDocumentContainer.getGroup().getShortTitle() + "DocumentOverflowButton");
            this.setUI((ButtonUI)((Object)new OverflowButtonUI()));
            this.setFocusTraversable(false);
            this.setPopupListener(this);
        }

        public void setUI(ButtonUI buttonUI) {
            if (buttonUI instanceof OverflowButtonUI) {
                super.setUI(buttonUI);
            }
        }

        private void setCount(int n) {
            if (n != this.iOverflowCount) {
                this.iOverflowCount = n;
                this.repaint();
            }
        }

        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth("+88");
            int n2 = fontMetrics.getHeight();
            if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0) {
                return new Dimension(4 + n, 4 + n2 + 0 + 4);
            }
            return new Dimension(8 + n + 0 + 7, 4 + n2);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            String string = "+" + this.iOverflowCount;
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.getHeight();
            if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0) {
                int n5 = (n - n3) / 2;
                int n6 = (n2 - n4 - 0 - 4) / 2;
                LAFUtil.drawString((Graphics)graphics, (String)string, (int)n5, (int)(n6 + fontMetrics.getAscent()));
                n5 = (n - 7) / 2;
                LAFUtil.paintDarkTriangle((Graphics2D)((Graphics2D)graphics), (int)n5, (int)(n6 += n4 + 0));
            } else {
                int n7 = n - 4 - 7;
                int n8 = (n2 - 4) / 2;
                LAFUtil.paintDarkTriangle((Graphics2D)((Graphics2D)graphics), (int)n7, (int)n8);
                n8 = (n2 - n4) / 2;
                LAFUtil.drawString((Graphics)graphics, (String)string, (int)(n7 -= n3 + 2), (int)(n8 + fontMetrics.getAscent()));
            }
        }

        public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
            int n;
            Object object2;
            ArrayList<DTClient> arrayList = new ArrayList<DTClient>(DTDocumentTabs.this.fTabList.size());
            for (Object object2 : DTDocumentTabs.this.fTabList) {
                arrayList.add(((Tab)object2).iDocument);
            }
            Window window = WindowUtils.getTopmostWindow((Component)((Object)this));
            object2 = new DTDocumentList(arrayList, DTDocumentTabs.this.fShowingTabRange);
            final JComponent jComponent2 = ((DTDocumentList)object2).getComponent();
            Dimension dimension = jComponent2.getPreferredSize();
            Point point = new Point(0, this.getHeight());
            SwingUtilities.convertPointToScreen(point, (Component)((Object)this));
            Rectangle rectangle = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)new Point(point.x, point.y));
            int n2 = rectangle.y + rectangle.height - point.y - 50;
            int n3 = point.y - this.getHeight() - rectangle.y - 50;
            if (n2 < dimension.height) {
                if (n3 > n2 + 100) {
                    if (n3 < dimension.height) {
                        dimension.height = n3;
                    }
                    point.y -= this.getHeight() + dimension.height;
                } else {
                    dimension.height = n2;
                }
                dimension.width += new MJScrollBar((int)1).getPreferredSize().width;
            }
            if (point.x + dimension.width > (n = rectangle.x + rectangle.width)) {
                point.x = n - dimension.width - 3;
            }
            Rectangle rectangle2 = LAFUtil.convertRectangleFromScreen((Rectangle)new Rectangle(point.x, point.y, dimension.width, dimension.height), (Component)window);
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            final Component component2 = component != null && !SwingUtilities.isDescendingFrom(component, (Component)((Object)DTDocumentTabs.this.fDocumentContainer)) ? null : component;
            final OverlayManager overlayManager = OverlayManagers.get((Component)((Object)this));
            if (overlayManager != null) {
                final OverlayConstraints overlayConstraints = OverlayConstraints.popup((Component)((Object)this), (Component)jComponent2);
                overlayConstraints.setBounds(rectangle2);
                new DeferredRunnable(component2 == null ? 3 : 1, (DTDocumentList)object2){
                    final /* synthetic */ DTDocumentList val$list;
                    {
                        this.val$list = dTDocumentList;
                        super(n);
                    }

                    @Override
                    public void doTask() {
                        final Overlay overlay = overlayManager.addOverlay((Component)jComponent2, overlayConstraints);
                        OverflowButton.this.putClientProperty("popup.overlay", overlay);
                        Disposer.register((Disposable)new Disposable(){

                            public void dispose() {
                                if (component2 != null) {
                                    component2.requestFocus();
                                }
                                OverflowButton.this.putClientProperty("popup.overlay", null);
                                OverflowButton.this.getModel().setSelected(false);
                            }
                        }, (Disposable)overlay);
                        AbstractAction abstractAction = new AbstractAction("escape"){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                overlayManager.removeOverlay(overlay);
                            }
                        };
                        this.val$list.setCloseAction(abstractAction);
                        jComponent2.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
                        jComponent2.getActionMap().put("escape", abstractAction);
                        jComponent2.putClientProperty("temporary-focus-owner", true);
                        if (PlatformInfo.isLinux()) {
                            jComponent2.requestFocus();
                        }
                    }
                }.run();
            }
        }
    }

    private class LocalMouseListener
    extends MouseInputAdapter {
        private int iInitialX;
        private int iInitialWidth;
        private int iCursor = 0;

        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.checkContextTrigger(mouseEvent)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.iCursor != 0) {
                DTDocumentTabs.this.fIsAdjustingWidth = true;
                this.iInitialX = SwingUtilities.convertPoint((Component)mouseEvent.getComponent(), (Point)mouseEvent.getPoint(), (Component)DTDocumentTabs.this.getParent()).x;
                this.iInitialWidth = DTDocumentTabs.this.getWidth();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.checkContextTrigger(mouseEvent)) {
                return;
            }
            DTDocumentTabs.this.fIsAdjustingWidth = false;
            this.restoreDefaultCursor();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!DTDocumentTabs.this.fIsAdjustingWidth) {
                this.restoreDefaultCursor();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 1) {
                int n = this.getCursor(mouseEvent.getX());
                if (n == 0) {
                    DTDocumentTabs.this.setCursor(null);
                } else if (n != this.iCursor) {
                    DTDocumentTabs.this.setCursor(Cursor.getPredefinedCursor(n));
                }
                this.iCursor = n;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (DTDocumentTabs.this.fIsAdjustingWidth) {
                int n = SwingUtilities.convertPoint((Component)mouseEvent.getComponent(), (Point)mouseEvent.getPoint(), (Component)DTDocumentTabs.this.getParent()).x;
                int n2 = n - this.iInitialX;
                if (DTDocumentTabs.this.fEdge == 3) {
                    n2 = -n2;
                }
                int n3 = this.iInitialWidth + n2;
                int n4 = 67;
                DTDocumentTabs.this.fMaxWidth = Integer.MAX_VALUE;
                if (n3 < n4) {
                    n3 = n4;
                } else if (n3 >= DTDocumentTabs.this.getPreferredSize().width) {
                    n3 = DTDocumentTabs.this.getPreferredSize().width;
                }
                DTDocumentTabs.this.setMaxWidth(n3);
                DTDocumentTabs.this.revalidate();
                DTDocumentTabs.this.repaint();
                DTDocumentTabs.this.getParent().revalidate();
                DTDocumentTabs.this.getParent().repaint();
            }
        }

        private int getCursor(int n) {
            if (DTDocumentTabs.this.fEdge == 7) {
                if (n >= DTDocumentTabs.this.getWidth() - 3 - 1) {
                    return 10;
                }
            } else if (DTDocumentTabs.this.fEdge == 3 && n <= 4) {
                return 11;
            }
            return 0;
        }

        void restoreDefaultCursor() {
            if (this.iCursor != 0) {
                DTDocumentTabs.this.setCursor(null);
                this.iCursor = 0;
            }
        }

        private boolean checkContextTrigger(MouseEvent mouseEvent) {
            Component component;
            Point point;
            if (mouseEvent.isPopupTrigger() && DTDocumentTabs.this.contains(point = SwingUtilities.convertPoint(component = mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)DTDocumentTabs.this)))) {
                MJPopupMenu mJPopupMenu = new MJPopupMenu();
                mJPopupMenu.setCleanupUponClose(true);
                DTDocumentTabs.this.addGlobalMenuItems((JPopupMenu)mJPopupMenu);
                mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
                return true;
            }
            return false;
        }
    }

    private static class CloseButton
    extends MJButton {
        private CloseButton(DTClient dTClient) {
            this.setName("CloseDocument" + dTClient.getComponentName());
            this.setActionCommand("Close");
            this.addActionListener((ActionListener)dTClient.getCloseAction());
            this.setVisible(dTClient.permitUserClose());
            this.setOpaque(false);
            this.setFocusTraversable(false);
            this.setIcon(MiscellaneousIcon.CLOSE_TAB.getIcon());
            this.setRolloverIcon(MiscellaneousIcon.CLOSE_TAB_HOVER.getIcon());
            this.setPressedIcon(MiscellaneousIcon.CLOSE_TAB_PRESSED.getIcon());
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getIcon().getIconWidth() + 2, this.getIcon().getIconHeight() + 2);
        }

        public void paint(Graphics graphics) {
            ButtonModel buttonModel = this.getModel();
            Icon icon = buttonModel.isPressed() ? this.getPressedIcon() : (buttonModel.isRollover() ? this.getRolloverIcon() : this.getIcon());
            icon.paintIcon((Component)((Object)this), graphics, 1, 1);
        }
    }

    public class Tab
    extends JComponent
    implements PropertyChangeListener,
    MouseInputListener,
    Comparable {
        private DTClient iDocument;
        private MJAbstractAction iAction;
        private MJButton iCloseButton;
        private MJTextField iTitleEditor;
        private boolean iSuppressEditorFocusLostResponse;
        private Dimension iLastSize;
        private int iLastEdge;
        private Shape iShape;
        private Shape iOpenShape;
        private Shape iCloseLine;
        private Rectangle iInfoIconRect;
        private Rectangle iTitleRect;
        private Component iPreviousFocusOwner;
        private boolean iIsMouseOver;
        private Point iOverPoint;
        private boolean iIsMousePressed;
        private boolean iPressedOnTitle;
        private Point iPressedPoint;
        private String iDisplayedText;
        private Rectangle iBounds;
        private Rectangle iStartBounds;
        private Rectangle iDiffs;
        private long iStartTime;
        private int iDuration;
        private String iHint;
        private DTFrame iHintFrame;
        private boolean iIsShowingTextCursor;

        private Tab(DTClient dTClient) {
            this.iDocument = dTClient;
            this.iAction = dTClient.getSelectAction();
            this.init();
            WeakPropertyChangeCoupler.attach((Action)dTClient.getSelectAction(), (PropertyChangeListener)this);
            dTClient.addPropertyListener(this);
            this.iCloseButton = new CloseButton(dTClient);
            this.add((Component)this.iCloseButton);
            this.iCloseButton.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Tab.this.mouseClicked(mouseEvent);
                }
            });
        }

        private Tab(MJAbstractAction mJAbstractAction) {
            this.iAction = mJAbstractAction;
            this.init();
        }

        private void init() {
            Font font;
            this.setName(this.iAction.getComponentName() + "Button");
            this.setOpaque(false);
            this.setLayout(null);
            this.setToolTipText(" ");
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (LanguageUtils.isCJK() && (font = FontUtils.getSystemUIFont()).getSize() < 13) {
                this.setFont(font.deriveFont(13.0f));
            }
        }

        public String getText() {
            return this.iDocument != null ? this.iDocument.getShortTitle() : null;
        }

        private void setAction(MJAbstractAction mJAbstractAction) {
            this.iAction = mJAbstractAction;
        }

        private boolean isSelected() {
            return this.iDocument != null && this.iAction.isSelected() && (DTDocumentTabs.this.fSelectingTab == null || DTDocumentTabs.this.fSelectingTab == this);
        }

        private void select() {
            this.iAction.actionPerformed(new ActionEvent(this, 1001, "select"));
        }

        private void dispose() {
            WeakPropertyChangeCoupler.detach((Action)this.iAction, (PropertyChangeListener)this);
            this.iDocument.removePropertyListener(this);
            this.iCloseButton.removeActionListener((ActionListener)this.iDocument.getCloseAction());
            this.iHintFrame = null;
        }

        @Override
        public Dimension getPreferredSize() {
            int n;
            Icon icon;
            int n2;
            Dimension dimension = new Dimension();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = this.iDocument == null ? 0 : fontMetrics.stringWidth(this.iDocument.getShortTitle());
            int n4 = fontMetrics.getHeight();
            int n5 = n2 = this.iCloseButton == null ? 0 : this.iCloseButton.getPreferredSize().width + 2;
            int n6 = this.iDocument == null ? ((Icon)this.iAction.getValue("SmallIcon")).getIconWidth() : ((icon = this.iDocument.getInfoIcon()) == null ? 0 : icon.getIconWidth() + 6);
            dimension.width = n3 + n2 + n6;
            if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0) {
                dimension.width += 18;
                if (!DTDocumentTabs.this.fDrawClosedTabs) {
                    dimension.width += 18;
                }
                dimension.height = Math.max(18, n4 + 2);
                if (this.iDocument != null) {
                    dimension.width += 2 * DTDocumentTabs.this.fExcessHorizontalOverlap;
                }
                n = n4 + 6;
            } else {
                int n7 = DTDocumentTabs.this.fDrawClosedTabs ? 0 : 18;
                dimension.width += 18;
                dimension.height = Math.max(18 + n7, n4 + 2);
                n = n4 + 6 + n7;
            }
            if (dimension.height < n) {
                dimension.height = n;
            }
            return dimension;
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.getSize();
            this.updateShape(dimension, DTDocumentTabs.this.fEdge);
            if (this.iCloseButton != null && this.iCloseButton.isVisible()) {
                Dimension dimension2 = this.iCloseButton.getPreferredSize();
                int n = dimension.width - (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0 && !DTDocumentTabs.this.fDrawClosedTabs ? 9 + DTDocumentTabs.this.fExcessHorizontalOverlap - 2 : 2);
                this.iCloseButton.setBounds(n - dimension2.width - 2, (dimension.height - dimension2.height + 1) / 2, dimension2.width, dimension2.height);
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            Color[] colorArray;
            int n2;
            boolean bl;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            boolean bl2 = this.isSelected();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            boolean bl3 = bl = DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0 || bl2 || this.iIsMouseOver || DTDocumentTabs.this.fTabDragger != null && DTDocumentTabs.this.fTabDragger.iTab == this || this.iTitleEditor != null;
            if (bl) {
                Object object;
                int n5;
                Color color;
                Color color2;
                if (bl2) {
                    color2 = SELECTED_LIGHT_COLOR;
                    color = DTDocumentTabs.this.fAppearFocused ? FOCUSED_DARK_COLOR : SELECTED_DARK_COLOR;
                    n2 = DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0 ? 2 * n4 / 3 : (2 * n4 - 9) / 3;
                    n5 = DTDocumentTabs.this.fAppearFocused ? n4 / 4 : 3;
                } else {
                    color2 = DESELECTED_LIGHT_COLOR;
                    color = DESELECTED_DARK_COLOR;
                    n2 = DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0 ? n4 / 3 : (n4 + 9) / 3;
                    n5 = 3;
                }
                if (DTDocumentTabs.this.fEdge == 1) {
                    object = color2;
                    color2 = color;
                    color = object;
                }
                graphics2D.setPaint(new GradientPaint(0.0f, n2 - n5, color2, 0.0f, n2 + n5, color));
                graphics2D.fill(this.iShape);
                if (bl2 && this.iCloseLine != null) {
                    graphics2D.setColor(SELECTED_LIGHT_COLOR);
                    object = graphics2D.getStroke();
                    if (PlatformInfo.isMacintosh() && DTUtilities.isHighDPI()) {
                        graphics2D.setStroke(new BasicStroke(2.0f));
                    }
                    graphics2D.draw(this.iCloseLine);
                    graphics2D.setStroke((Stroke)object);
                }
                if (this.iIsMouseOver && !bl2) {
                    object = new float[]{0.0f, 1.0f};
                    colorArray = new Color[]{HIGHLIGHT_CENTER_COLOR, HIGHLIGHT_EDGE_COLOR};
                    graphics2D.setPaint(new RadialGradientPaint(this.iOverPoint, 120.0f, (float[])object, colorArray));
                    graphics2D.fill(this.iShape);
                }
                object = graphics2D.getClip();
                if (!bl2 && PlatformInfo.isMacintosh() && DTUtilities.isHighDPI()) {
                    if (DTDocumentTabs.this.fEdge == 1) {
                        graphics2D.clipRect(0, 0, n3, n4 - 1);
                    } else if (DTDocumentTabs.this.fEdge == 7) {
                        graphics2D.clipRect(0, 0, n3 - 1, n4);
                    }
                }
                graphics2D.setColor(DTDocumentTabs.this.fAppearFocused && bl2 ? FOCUSED_OUTLINE_COLOR : OUTLINE_COLOR);
                graphics2D.draw(bl2 && this.iOpenShape != null ? this.iOpenShape : this.iShape);
                graphics2D.setClip((Shape)object);
            }
            boolean bl4 = DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0;
            int n6 = n = bl4 && !DTDocumentTabs.this.fDrawClosedTabs ? 18 : 9;
            n2 = this.iCloseButton != null && this.iCloseButton.isVisible() ? this.iCloseButton.getX() - 2 : (DTDocumentTabs.this.fEdge == 7 ? n3 - 9 : (DTDocumentTabs.this.fEdge == 3 ? n3 - 2 : n3 - 9 - 2));
            if (this.iDocument == null) {
                Icon icon = (Icon)this.iAction.getValue("SmallIcon");
                if (bl4) {
                    if (DTDocumentTabs.this.fTabList.size() > 0) {
                        n += DTDocumentTabs.this.fExcessHorizontalOverlap / 2;
                    }
                } else {
                    n = (n3 - icon.getIconWidth()) / 2;
                }
                icon.paintIcon(this, graphics, n, (n4 - icon.getIconHeight()) / 2);
            } else {
                int n7;
                Icon icon;
                if (bl4) {
                    n += DTDocumentTabs.this.fExcessHorizontalOverlap;
                }
                if ((icon = this.iDocument.getInfoIcon()) != null) {
                    int n8 = icon.getIconWidth();
                    int n9 = icon.getIconHeight();
                    n7 = (n4 - icon.getIconHeight()) / 2;
                    this.iInfoIconRect = new Rectangle(n, n7, n8, n9);
                    icon.paintIcon(this, graphics, n, n7);
                    n += n8 + 6;
                }
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                colorArray = SimpleStringTrimmer.getSharedEndTrimmer().shortenString(this.iDocument.getShortTitle(), fontMetrics, n2 - n);
                n7 = (n4 - fontMetrics.getHeight()) / 2;
                if (this.iTitleEditor == null) {
                    graphics2D.setColor(bl2 ? SELECTED_TEXT_COLOR : DESELECTED_TEXT_COLOR);
                    LAFUtil.drawString((Graphics)graphics2D, (String)colorArray, (int)n, (int)(n7 + fontMetrics.getAscent() - 1));
                }
                this.iDisplayedText = colorArray;
                this.iTitleRect = new Rectangle(n, n7, fontMetrics.stringWidth((String)colorArray), fontMetrics.getHeight());
            }
        }

        private void createShape(Dimension dimension, int n) {
            if (DTDocumentTabs.this.fDrawClosedTabs) {
                this.iShape = new RoundRectangle2D.Float(0.0f, 0.0f, dimension.width - 1, dimension.height - 1, 9.0f, 9.0f);
                this.iOpenShape = null;
                this.iCloseLine = null;
                return;
            }
            int[] nArray = new int[12];
            int[] nArray2 = new int[12];
            if (DTDocumentTabs.getOrientation(n) == 0) {
                nArray[0] = 0;
                nArray[3] = nArray[4] = nArray[0] + 9;
                nArray[2] = nArray[4];
                nArray[1] = nArray[4];
                nArray[5] = nArray[4] + 9;
                nArray[6] = dimension.width - 1 - 18;
                nArray[9] = nArray[10] = nArray[6] + 9;
                nArray[8] = nArray[10];
                nArray[7] = nArray[10];
                nArray[11] = nArray[10] + 9;
                if (n == 1) {
                    nArray2[10] = nArray2[11] = dimension.height - 1;
                    nArray2[1] = nArray2[11];
                    nArray2[0] = nArray2[11];
                    nArray2[2] = nArray2[9] = nArray2[1] - 9;
                    nArray2[8] = 9;
                    nArray2[3] = 9;
                    nArray2[7] = 0;
                    nArray2[6] = 0;
                    nArray2[5] = 0;
                    nArray2[4] = 0;
                } else {
                    nArray2[11] = 0;
                    nArray2[10] = 0;
                    nArray2[1] = 0;
                    nArray2[0] = 0;
                    nArray2[9] = 9;
                    nArray2[2] = 9;
                    nArray2[3] = nArray2[8] = dimension.height - 9 - 1;
                    nArray2[6] = nArray2[7] = dimension.height - 1;
                    nArray2[5] = nArray2[7];
                    nArray2[4] = nArray2[7];
                }
            } else {
                nArray2[0] = 0;
                nArray2[3] = nArray2[4] = nArray2[0] + 9;
                nArray2[2] = nArray2[4];
                nArray2[1] = nArray2[4];
                nArray2[5] = nArray2[4] + 9;
                nArray2[6] = dimension.height - 1 - 18;
                nArray2[9] = nArray2[10] = nArray2[6] + 9;
                nArray2[8] = nArray2[10];
                nArray2[7] = nArray2[10];
                nArray2[11] = nArray2[10] + 9;
                if (n == 7) {
                    nArray[10] = nArray[11] = dimension.width - 1;
                    nArray[1] = nArray[11];
                    nArray[0] = nArray[11];
                    nArray[2] = nArray[9] = nArray[1] - 9;
                    nArray[8] = 9;
                    nArray[3] = 9;
                    nArray[7] = 0;
                    nArray[6] = 0;
                    nArray[5] = 0;
                    nArray[4] = 0;
                } else {
                    nArray[11] = 0;
                    nArray[10] = 0;
                    nArray[1] = 0;
                    nArray[0] = 0;
                    nArray[9] = 9;
                    nArray[2] = 9;
                    nArray[3] = nArray[8] = dimension.width - 9 - 1;
                    nArray[6] = nArray[7] = dimension.width - 1;
                    nArray[5] = nArray[7];
                    nArray[4] = nArray[7];
                }
            }
            Path2D.Float float_ = new Path2D.Float();
            float_.moveTo(nArray[0], nArray2[0]);
            float_.curveTo(nArray[1], nArray2[1], nArray[1], nArray2[1], nArray[2], nArray2[2]);
            for (int i = 3; i < 12; i += 2) {
                float_.lineTo(nArray[i], nArray2[i]);
                float_.curveTo(nArray[++i], nArray2[i], nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
            }
            this.iOpenShape = (Shape)float_.clone();
            this.iCloseLine = new Line2D.Float(nArray[0], nArray2[0], nArray[11], nArray2[11]);
            float_.closePath();
            this.iShape = float_;
        }

        private void updateShape(Dimension dimension, int n) {
            if (this.iShape == null || !dimension.equals(this.iLastSize) || this.iLastEdge != n) {
                this.createShape(dimension, n);
                this.iLastSize = dimension;
                this.iLastEdge = n;
            }
        }

        @Override
        public String getToolTipText() {
            Window window = SwingUtilities.windowForComponent(this);
            if (window != null && window.isActive() && this.iIsMouseOver) {
                if (this.iDocument != null) {
                    String string = this.iDocument.getTitle();
                    if (!string.equals(this.iDisplayedText)) {
                        return string;
                    }
                } else if (this.iAction != null) {
                    return this.iAction.getTip();
                }
            }
            return null;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string;
            if (this.iDocument != null && this.iInfoIconRect != null && this.iInfoIconRect.contains(mouseEvent.getPoint()) && (string = this.iDocument.getInfoToolTip()) != null) {
                return string;
            }
            return this.getToolTipText();
        }

        private void initiateTitleEdit() {
            DTDocumentTabs.this.fIsEditingTitle = true;
            this.iTitleEditor = new MJTextField(this.iDocument.getShortTitle());
            this.iTitleEditor.setName("DTDocumentTabs:TitleEditor");
            this.iTitleEditor.setSelectAllOnFocus(false);
            this.iTitleEditor.setBorder(null);
            Insets insets = this.iTitleEditor.getMargin();
            this.add((Component)this.iTitleEditor);
            this.iTitleEditor.setBounds(this.iTitleRect.x - insets.left, this.iTitleRect.y - insets.top, this.iTitleRect.width + insets.left + insets.right, this.iTitleRect.height + insets.top + insets.bottom);
            if (!this.iDocument.getShortTitle().equals(this.iDisplayedText)) {
                this.extendTitleEditorIfNecessary();
            }
            this.iPreviousFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            this.iTitleEditor.requestFocusInWindow();
            this.iTitleEditor.selectAll();
            this.iTitleEditor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Tab.this.commitTitleEdit();
                }
            });
            this.iTitleEditor.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary() && !Tab.this.iSuppressEditorFocusLostResponse) {
                        Tab.this.discardTitleEdit();
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Tab.this.iSuppressEditorFocusLostResponse = false;
                }
            });
            this.iTitleEditor.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        Tab.this.discardTitleEdit();
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if (!Tab.this.iDocument.getTitleChangeHandler().isPermissibleTitleCharacter(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                }
            });
            this.iTitleEditor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    Tab.this.extendTitleEditorIfNecessary();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    Tab.this.extendTitleEditorIfNecessary();
                }
            });
        }

        private void extendTitleEditorIfNecessary() {
            Rectangle rectangle = this.iTitleEditor.getBounds();
            Dimension dimension = this.iTitleEditor.getPreferredSize();
            if (dimension.width > rectangle.width) {
                Rectangle rectangle2 = this.getBounds();
                if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0) {
                    this.setBounds(rectangle2.x, rectangle2.y, rectangle2.width + dimension.width - rectangle.width, rectangle2.height);
                }
                if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 1 && rectangle.x + dimension.width > rectangle2.width - 20) {
                    dimension.width = rectangle2.width - 20 - rectangle.x;
                }
                this.iTitleEditor.setBounds(rectangle.x, rectangle.y, dimension.width, rectangle.height);
                int n = JLayeredPane.getLayer(this);
                if (JLayeredPane.DEFAULT_LAYER.equals(n)) {
                    this.iSuppressEditorFocusLostResponse = true;
                    DTDocumentTabs.this.remove(this);
                    DTDocumentTabs.this.setLayer(this, EDIT_LAYER);
                    DTDocumentTabs.this.add(this);
                    this.iTitleEditor.requestFocusInWindow();
                }
                this.revalidate();
                this.repaint();
            }
        }

        private void commitTitleEdit() {
            String string = this.iTitleEditor.getText();
            if (this.iDocument.getTitleChangeHandler().updateTitle(string)) {
                this.endTitleEdit();
            }
        }

        private void discardTitleEdit() {
            this.endTitleEdit();
        }

        private void endTitleEdit() {
            if (this.iTitleEditor != null) {
                if (this.iPreviousFocusOwner != null) {
                    this.iPreviousFocusOwner.requestFocusInWindow();
                }
                this.remove((Component)this.iTitleEditor);
                this.iTitleEditor = null;
                DTDocumentTabs.this.fIsEditingTitle = false;
                int n = JLayeredPane.getLayer(this);
                if (EDIT_LAYER.equals(n)) {
                    DTDocumentTabs.this.remove(this);
                    DTDocumentTabs.this.setLayer(this, this.iDocument.isSelected() ? JLayeredPane.PALETTE_LAYER : JLayeredPane.DEFAULT_LAYER);
                    DTDocumentTabs.this.add(this);
                    if (!this.iDocument.isSelected()) {
                        DTDocumentTabs.this.refreshTabZOrder();
                    }
                }
                DTDocumentTabs.this.revalidate();
                DTDocumentTabs.this.repaint();
            }
        }

        private Action getEditTitleAction() {
            DTTitleChangeHandler dTTitleChangeHandler = this.iDocument.getTitleChangeHandler();
            if (dTTitleChangeHandler != null) {
                return new MJAbstractAction(dTTitleChangeHandler.getEditTitleMenuItemLabel()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Tab.this.initiateTitleEdit();
                    }
                };
            }
            return null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.iDocument == propertyChangeEvent.getSource()) {
                if (DTClientProperty.PERMIT_USER_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
                    this.iCloseButton.setVisible(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                    this.revalidate();
                    this.repaint();
                } else if (DTClientProperty.INFO_ICON.toString().equals(propertyChangeEvent.getPropertyName())) {
                    this.revalidate();
                    this.repaint();
                } else if (DTClientProperty.SHORT_TITLE.toString().equals(propertyChangeEvent.getPropertyName()) || DTClientProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
                    if (DTDocumentTabs.this.fComparator != null && this.iDocument.getGroup().getAlphabetizeDocuments()) {
                        Collections.sort(DTDocumentTabs.this.fTabList);
                    }
                    this.revalidate();
                    this.repaint();
                }
            } else if ("checked".equals(propertyChangeEvent.getPropertyName())) {
                Integer n;
                DTDocumentTabs.this.remove(this);
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl) {
                    n = JLayeredPane.PALETTE_LAYER;
                } else {
                    n = JLayeredPane.DEFAULT_LAYER;
                    this.updateCursor(false);
                }
                DTDocumentTabs.this.setLayer(this, n);
                DTDocumentTabs.this.add(this);
                DTDocumentTabs.this.refreshTabZOrder();
                if (bl && DTDocumentTabs.this.shouldAnimate()) {
                    DTDocumentTabs.this.fSelectingTab = this;
                    DTDocumentTabs.this.slideTabIntoView(this);
                    DTDocumentTabs.this.fSelectingTab = null;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isEnabled() || this.iDocument == null) {
                return;
            }
            if (SwingUtilities.isMiddleMouseButton(mouseEvent) && this.iDocument.permitUserClose()) {
                this.iDocument.getCloseAction().actionPerformed(new ActionEvent(this, 0, "Close", mouseEvent.getModifiers()));
            } else if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && DTDocumentTabs.this.fDocumentContainer.getArrangement() != 1) {
                this.iDocument.getMaximizeAction().actionPerformed(new ActionEvent(this, 0, "Maximize", mouseEvent.getModifiers()));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (!this.iIsMouseOver) {
                this.iIsMouseOver = true;
                this.iOverPoint = mouseEvent.getPoint();
            }
            if (this.checkContextTrigger(mouseEvent)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.iIsMousePressed = true;
                this.iPressedPoint = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)DTDocumentTabs.this));
                this.iPressedOnTitle = this.iTitleRect != null && this.iTitleRect.contains(mouseEvent.getX(), mouseEvent.getY());
                this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.checkContextTrigger(mouseEvent)) {
                return;
            }
            if (this.iIsMousePressed) {
                if (this.isTitleEditable() && this.isSelected() && DTDocumentTabs.this.fTabDragger == null && this.iPressedOnTitle && this.iTitleRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    this.initiateTitleEdit();
                    this.updateCursor(false);
                } else if (this.iIsMouseOver && DTDocumentTabs.this.fTabDragger == null) {
                    this.select();
                }
                this.iIsMousePressed = false;
                this.iPressedOnTitle = false;
                this.iPressedPoint = null;
                if (DTDocumentTabs.this.fTabDragger != null) {
                    DTDocumentTabs.this.fTabDragger.endDrag();
                }
                this.repaint();
            }
        }

        private boolean isTitleEditable() {
            return this.iDocument != null && this.iDocument.getTitleChangeHandler() != null;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.iIsMouseOver = true;
                this.iOverPoint = mouseEvent.getPoint();
                this.showHint(mouseEvent);
                this.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.iIsMouseOver) {
                this.iIsMouseOver = false;
                this.iOverPoint = null;
                this.clearHint();
                this.repaint();
                this.updateCursor(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iIsMousePressed) {
                if (this.iDocument != null) {
                    boolean bl;
                    boolean bl2 = DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0;
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)DTDocumentTabs.this));
                    int n = bl2 ? point.x - this.iPressedPoint.x : point.y - this.iPressedPoint.y;
                    Rectangle rectangle = new Rectangle(0, 0, DTDocumentTabs.this.getWidth(), DTDocumentTabs.this.getHeight());
                    rectangle.grow(6, 6);
                    boolean bl3 = bl = !rectangle.contains(point);
                    if (DTDocumentTabs.this.fTabDragger == null && (bl || n >= 5 || n <= -5)) {
                        this.updateCursor(false);
                        DTDocumentTabs.this.fTabDragger = new TabDragger(this);
                        if (bl) {
                            DTDocumentTabs.this.fTabDragger.initiateDragOff(mouseEvent);
                        } else {
                            DTDocumentTabs.this.fTabDragger.beginDrag();
                        }
                    }
                    if (DTDocumentTabs.this.fTabDragger != null && !DTDocumentTabs.this.fTabDragger.iHasDraggedOff) {
                        if (bl && (!DTDocumentTabs.this.fTabDragger.iOrderHasChanged || !bl2 && (point.x < -50 || point.x > this.getWidth() + 50) || bl2 && (point.y < -50 || point.y > this.getHeight() + 50))) {
                            DTDocumentTabs.this.fTabDragger.initiateDragOff(mouseEvent);
                        } else {
                            DTDocumentTabs.this.fTabDragger.continueDrag(n);
                        }
                    }
                } else {
                    boolean bl = this.contains(mouseEvent.getX(), mouseEvent.getY());
                    if (bl != this.iIsMouseOver) {
                        this.iIsMouseOver = bl;
                        this.iOverPoint = bl ? mouseEvent.getPoint() : null;
                        this.repaint();
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.iTitleEditor != null) {
                return;
            }
            this.iIsMouseOver = true;
            this.iOverPoint = mouseEvent.getPoint();
            this.repaint();
            this.updateCursor(this.isTitleEditable() && this.isSelected() && this.iTitleRect.contains(this.iOverPoint));
        }

        private void updateCursor(boolean bl) {
            if (bl != this.iIsShowingTextCursor) {
                if (bl) {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                } else {
                    this.setCursor(null);
                }
                this.iIsShowingTextCursor = bl;
            }
        }

        @Override
        public boolean contains(int n, int n2) {
            return this.iShape != null && this.iShape.contains(n, n2);
        }

        private void showHint(MouseEvent mouseEvent) {
            this.iHint = this.getHint();
            if (this.iHint != null) {
                this.iHintFrame = DTFrame.getFrame(mouseEvent);
                if (this.iHintFrame != null) {
                    DTDragUtilities.showHint(this.iHintFrame, this.iHint);
                }
            }
        }

        private String getHint() {
            if (this.iDocument == null) {
                return null;
            }
            if (!this.iDocument.permitUserUndock() && DTDocumentTabs.this.fDocumentContainer.getArrangement() == 1 && DTDocumentTabs.this.fTabList.size() < 2) {
                return null;
            }
            Object[] objectArray = new Object[]{this.iDocument.getShortTitle()};
            return MessageFormat.format(DTDocumentTabs.this.fDocumentContainer.getDesktop().getString("status.ToMoveThisOrButton"), objectArray);
        }

        private void clearHint() {
            if (this.iHint != null && this.iHintFrame != null) {
                DTDragUtilities.showHint(this.iHintFrame, null);
                this.iHint = null;
                this.iHintFrame = null;
            }
        }

        private boolean checkContextTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && this.iDocument != null) {
                DTMenu dTMenu = new DTMenu("");
                this.addContextMenuItems(dTMenu);
                MJPopupMenu mJPopupMenu = new MJPopupMenu();
                mJPopupMenu.setCleanupUponClose(true);
                for (Component component : dTMenu.getMenuComponents()) {
                    mJPopupMenu.add(component);
                }
                mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
                return true;
            }
            return false;
        }

        private void addContextMenuItems(DTMenu dTMenu) {
            JMenu jMenu;
            Action action;
            JMenu jMenu2;
            Action action2;
            Action action3;
            Object object;
            Action action4 = DTDocumentTabs.this.getNewContextAction();
            if (action4 != null) {
                dTMenu.add(action4);
                dTMenu.addSeparator();
            }
            boolean bl = false;
            Action action5 = this.getEditTitleAction();
            if (action5 != null) {
                dTMenu.add(action5);
                bl = true;
            }
            if (DTDocumentTabs.this.fDocumentContainer.getArrangement() != 1 && this.iDocument.permitUserMaximize()) {
                dTMenu.add((Action)this.iDocument.getMaximizeAction());
                bl = true;
            }
            if (this.iDocument.permitUserUndock()) {
                object = new ChildAction((Action)this.iDocument.getUndockAction());
                object.putValue("AcceleratorKey", ChildAction.NULL_VALUE);
                dTMenu.add((Action)object);
                bl = true;
            }
            if (this.iDocument.permitUserClose()) {
                dTMenu.add((Action)this.iDocument.getCloseAction());
                bl = true;
            }
            if ((object = DTDocumentTabs.this.getCloseAllExceptAction(this.iDocument)) != null) {
                dTMenu.add((Action)object);
                bl = true;
            }
            if ((action3 = DTDocumentTabs.this.getCloseAllAction()) != null) {
                dTMenu.add(action3);
                bl = true;
            }
            if ((action2 = DTDocumentTabs.this.getCloseSelectAction()) != null) {
                dTMenu.add(action2);
                bl = true;
            }
            if (bl) {
                dTMenu.addSeparator();
            }
            if ((jMenu2 = DTDocumentTabs.this.createMoveSubMenu()) != null) {
                dTMenu.add(jMenu2);
            }
            if (DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0 && DTDocumentTabs.this.fProperties != null) {
                dTMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)DTDocumentTabs.this.fProperties.getToggleShrinkToFitAction()));
            }
            if ((action = DTDocumentTabs.this.getAlphabetizeAction()) != null) {
                dTMenu.add((JMenuItem)new MJCheckBoxMenuItem(action));
            }
            if ((jMenu = this.iDocument.getContextMenu()) != null) {
                dTMenu.merge(jMenu);
            }
        }

        public int compareTo(Object object) {
            return DTDocumentTabs.this.fComparator == null ? 0 : DTDocumentTabs.this.fComparator.compare(this.iDocument, ((Tab)object).iDocument);
        }
    }

    static class NeighborBorder
    extends AbstractBorder {
        NeighborBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 0;
            insets.left = 0;
            insets.top = 0;
            insets.bottom = 1;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            n2 = n4 - 0;
            graphics.setColor(SELECTED_LIGHT_COLOR);
            graphics.fillRect(n, n2, n3, 0);
            graphics.setColor(OUTLINE_COLOR);
            graphics.drawLine(n, n2 - 1, n + n3, n2 - 1);
        }
    }

    private class CustomBorder
    extends AbstractBorder {
        private CustomBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            switch (DTDocumentTabs.this.fEdge) {
                case 1: {
                    insets.top = 0;
                    insets.bottom = 0;
                    break;
                }
                case 5: {
                    insets.top = 0;
                    insets.bottom = 0;
                    break;
                }
                case 7: {
                    insets.left = 0;
                    insets.right = 3;
                    break;
                }
                case 3: {
                    insets.left = 3;
                    insets.right = 0;
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            switch (DTDocumentTabs.this.fEdge) {
                case 1: {
                    n2 = n4 - 0;
                }
                case 5: {
                    n4 = 0;
                    break;
                }
                case 7: {
                    n = n3 - 3;
                }
                case 3: {
                    n3 = 3;
                }
            }
            graphics.setColor(SELECTED_LIGHT_COLOR);
            graphics.fillRect(n, n2, n3, n4);
            if (DTDocumentTabs.this.fAppearFocused) {
                boolean bl = DTDocumentTabs.getOrientation(DTDocumentTabs.this.fEdge) == 0;
                graphics.setColor(FOCUSED_OUTLINE_COLOR);
                int n5 = n + n3;
                int n6 = n2 + n4;
                if (bl && n4 > 0) {
                    graphics.drawLine(n, n2, n, n6);
                    graphics.drawLine(n5 - 1, n2, n5 - 1, n6);
                } else if (!bl && n3 > 0) {
                    graphics.drawLine(n, n2, n5, n2);
                    graphics.drawLine(n, n6 - 1, n5, n6 - 1);
                }
            }
        }
    }

    static interface EdgeListener {
        public void tabsMoved(DTDocumentTabs var1, int var2);
    }

    static enum Motion {
        BACK,
        FORWARD,
        TO_BEGINING,
        TO_END;

    }
}

