/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.accessories.CollapseToolstripAction;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTLayoutActions;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTToolBarLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class DTLayoutToolSetFactory {
    public static final String TOOL_SET_NAME = "desktop_layout_toolset";
    private static List<WeakReference<TSDropDownButton>> sLayoutDropDowns = new ArrayList<WeakReference<TSDropDownButton>>();

    private DTLayoutToolSetFactory() {
    }

    public static TSToolSet createToolSet(final Desktop desktop, DTMultipleClientFrame dTMultipleClientFrame, final Toolstrip toolstrip) {
        String string;
        TSToolSetContents tSToolSetContents = new TSToolSetContents(TOOL_SET_NAME, Desktop.sRes);
        final TSToolSet tSToolSet = new TSToolSet(tSToolSetContents);
        IconSet iconSet = new IconSet(new Icon[]{IconEnumerationUtils.getIcon((String)"view_ts_24.png"), IconEnumerationUtils.getIcon((String)"view_ts_16.png")});
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("layout").setType(TSToolSetContents.ToolType.DROP_DOWN).setIcon((Icon)iconSet), new TSToolSetContents.Dependency[0]);
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("layouts").setType(TSToolSetContents.ToolType.GROUP), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layout")});
        DTLayoutLibrary dTLayoutLibrary = desktop.getLayoutLibrary();
        String string2 = desktop.getString("SetLayoutDescription");
        for (int i = 0; i < dTLayoutLibrary.factoryLayoutCount(); ++i) {
            String string3 = dTLayoutLibrary.getLayoutReferenceName(i);
            String object2 = MJUtilities.exciseMnemonic((String)dTLayoutLibrary.getFactoryLayoutDisplayName(i));
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string3).setLabel(object2).setIcon(dTLayoutLibrary.getFactoryLayoutIcon(i)).setDescription(MessageFormat.format(string2, object2)).setStyle(ListStyle.ICON_TEXT), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts")});
            tSToolSet.configureAndAdd(string3, (Action)((Object)new DTLayoutActions.RestoreAction(desktop, i)));
        }
        tSToolSetContents.addSeparator(new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts")});
        IconSet iconSet2 = new IconSet(new Icon[]{new ImageIcon(DTLayoutToolSetFactory.class.getResource("resources/user_layout_24.png")), new ImageIcon(DTLayoutToolSetFactory.class.getResource("resources/user_layout_16.png"))});
        for (int i = 0; i < dTLayoutLibrary.userLayoutCount(); ++i) {
            String string3 = dTLayoutLibrary.getUserLayoutName(i);
            string = DTLayoutToolSetFactory.userToolName(string3);
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setLabel(string3).setIcon((Icon)iconSet2).setDescription(MessageFormat.format(string2, string3)).setStyle(ListStyle.ICON_TEXT), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts")});
            DTLayoutActions.RestoreAction restoreAction = new DTLayoutActions.RestoreAction(desktop, dTLayoutLibrary.factoryLayoutCount() + i);
            restoreAction.putValue("toolstrip-context-menu-contributor", new UserLayoutMenuContributor(desktop, string3));
            tSToolSet.configureAndAdd(string, (Action)((Object)restoreAction));
        }
        dTLayoutLibrary.addListener(new DTLayoutLibrary.Listener((Icon)iconSet2, string2, desktop, dTLayoutLibrary){
            final /* synthetic */ Icon val$userLayoutIcon;
            final /* synthetic */ String val$descriptionTemplate;
            final /* synthetic */ Desktop val$desktop;
            final /* synthetic */ DTLayoutLibrary val$layoutLibrary;
            {
                this.val$userLayoutIcon = icon;
                this.val$descriptionTemplate = string;
                this.val$desktop = desktop;
                this.val$layoutLibrary = dTLayoutLibrary;
            }

            @Override
            public void userLayoutAdded(String string) {
                String string2 = DTLayoutToolSetFactory.userToolName(string);
                tSToolSet.getContents().addTool(new TSToolSetContents.ToolParameters(string2).setLabel(string).setIcon(this.val$userLayoutIcon).setDescription(MessageFormat.format(this.val$descriptionTemplate, string)).setStyle(ListStyle.ICON_TEXT), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts").setReferencePosition(TSToolSetContents.Position.END).setReferenceOffset(-3)});
                DTLayoutActions.RestoreAction restoreAction = new DTLayoutActions.RestoreAction(this.val$desktop, this.val$layoutLibrary.indexOf(string));
                restoreAction.putValue("toolstrip-context-menu-contributor", new UserLayoutMenuContributor(this.val$desktop, string));
                tSToolSet.configureAndAdd(string2, (Action)((Object)restoreAction));
                this.updated();
            }

            @Override
            public void userLayoutRemoved(String string) {
                String string2 = DTLayoutToolSetFactory.userToolName(string);
                tSToolSet.getContents().removeTool(string2, new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts")});
                tSToolSet.removeAction(string2);
                this.updated();
            }

            @Override
            public void userLayoutRenamed(String string, String string2) {
                String string3 = DTLayoutToolSetFactory.userToolName(string2);
                String string4 = DTLayoutToolSetFactory.userToolName(string);
                tSToolSet.getContents().addTool(new TSToolSetContents.ToolParameters(string3).setLabel(string2).setIcon(this.val$userLayoutIcon).setDescription(MessageFormat.format(this.val$descriptionTemplate, string2)).setStyle(ListStyle.ICON_TEXT), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts").setReferenceToolName(string4).setReferencePosition(TSToolSetContents.Position.AFTER)});
                DTLayoutActions.RestoreAction restoreAction = new DTLayoutActions.RestoreAction(this.val$desktop, this.val$layoutLibrary.indexOf(string2));
                restoreAction.putValue("toolstrip-context-menu-contributor", new UserLayoutMenuContributor(this.val$desktop, string2));
                tSToolSet.configureAndAdd(string3, (Action)((Object)restoreAction));
                this.userLayoutRemoved(string);
                this.updated();
            }

            private void updated() {
                this.val$desktop.getToolstripRegistry().replaceToolSetContents(tSToolSet.getContents());
            }
        });
        tSToolSetContents.addSeparator(new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts")});
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("save_layout"), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts")});
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("organize_layouts"), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layouts")});
        tSToolSet.configureAndAdd("save_layout", (Action)((Object)new DTLayoutActions.SaveAction(desktop)));
        tSToolSet.configureAndAdd("organize_layouts", (Action)((Object)new DTLayoutActions.OrganizeAction(desktop)));
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("show").setType(TSToolSetContents.ToolType.GROUP), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("layout")});
        for (DTClient dTClient : desktop.getSingletons()) {
            if (dTClient.isDockableTearOff() || !dTClient.offerToggle()) continue;
            string = "toggle_" + dTClient.getName();
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setType(TSToolSetContents.ToolType.CHECK_BOX).setLabel(dTClient.getShortTitle()), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("show")});
            tSToolSet.addAction(string, (Action)dTClient.getToggleAction());
        }
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("toggle_titles").setType(TSToolSetContents.ToolType.CHECK_BOX), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("show")});
        tSToolSet.configureAndAdd("toggle_titles", dTMultipleClientFrame.getToggleTitlesAction());
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("toggle_toolstrip").setType(TSToolSetContents.ToolType.CHECK_BOX), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("show")});
        tSToolSet.configureAndAdd("toggle_toolstrip", (Action)new ChildAction((Action)new CollapseToolstripAction(toolstrip, true)));
        for (DTClient dTClient : desktop.getSingletons()) {
            if (!dTClient.isDockableTearOff()) continue;
            string = dTClient.getName() + "_display";
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setType(TSToolSetContents.ToolType.DROP_DOWN).setLabel(dTClient.getShortTitle()), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("show")});
            tSToolSet.addListDecorator(string, (TSToolSet.ListDecorator)new TearOffOptionsListDecorator(dTClient));
        }
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("qab_location").setType(TSToolSetContents.ToolType.DROP_DOWN), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("show")});
        for (DTToolBarLocation.Region region : DTFrame.SUPPORTED_QUICK_ACCESS_REGIONS) {
            string = region.toString().toLowerCase(Locale.ENGLISH);
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setType(TSToolSetContents.ToolType.CHECK_BOX), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("qab_location")});
            tSToolSet.configureAndAdd(string, dTMultipleClientFrame.getQuickAccessMoveAction(region));
        }
        tSToolSet.addDecorator("layout", new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                TSDropDownButton tSDropDownButton = (TSDropDownButton)jComponent;
                tSDropDownButton.setEnabled(!desktop.isLayoutLocked());
                sLayoutDropDowns.add(new WeakReference<TSDropDownButton>(tSDropDownButton));
                Iterator iterator = sLayoutDropDowns.iterator();
                while (iterator.hasNext()) {
                    if (((WeakReference)iterator.next()).get() != null) continue;
                    iterator.remove();
                }
            }
        });
        tSToolSet.addListDecorator("layout", new TSToolSet.ListDecorator(){

            public void decorateList(PopupList popupList) {
                if (TSRobot.getQuickAccessToolBar((Toolstrip)toolstrip) == null && popupList.getModel() instanceof DefaultListModel) {
                    DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
                    for (int i = 0; i < defaultListModel.getSize(); ++i) {
                        ListItem listItem = (ListItem)defaultListModel.get(i);
                        if (!"desktop_layout_toolset:qab_location".equals(listItem.getName())) continue;
                        defaultListModel.remove(i);
                        break;
                    }
                }
            }
        });
        return tSToolSet;
    }

    public static void setLayoutDropDownsEnabled(boolean bl) {
        for (WeakReference<TSDropDownButton> weakReference : sLayoutDropDowns) {
            TSDropDownButton tSDropDownButton = (TSDropDownButton)weakReference.get();
            if (tSDropDownButton == null) continue;
            tSDropDownButton.setEnabled(bl);
        }
    }

    private static String userToolName(String string) {
        return "user_layout_" + string;
    }

    private static class TearOffOptionsListDecorator
    implements TSToolSet.ListDecorator {
        private DTClient iSingleton;

        private TearOffOptionsListDecorator(DTClient dTClient) {
            this.iSingleton = dTClient;
        }

        public void decorateList(PopupList popupList) {
            DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
            for (Action action : this.iSingleton.createTearOffShowActions()) {
                ListItem listItem = TSFactory.createListItemFromAction((Action)action, (ListStyle)ListStyle.TEXT_ONLY);
                listItem.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
                listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)((MJAbstractAction)action).isSelected());
                defaultListModel.addElement(listItem);
            }
        }
    }

    private static class UserLayoutMenuContributor
    implements TSContextMenuContributor {
        private final Desktop fDesktop;
        private final String fLayoutName;

        private UserLayoutMenuContributor(Desktop desktop, String string) {
            this.fDesktop = desktop;
            this.fLayoutName = string;
        }

        public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
            jPopupMenu.insert(new JPopupMenu.Separator(), 0);
            jPopupMenu.insert((Action)((Object)new DTLayoutActions.DeleteAction(this.fDesktop, this.fLayoutName)), 0);
        }
    }
}

