/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentArranger;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocumentTabs;
import com.mathworks.widgets.desk.DTDocumentTabsProperties;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTRelativeLocation;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

class DTTabbedDocumentPane
extends MJPanel
implements DTContainer,
DTDocumentArranger,
DTDropTarget,
PropertyChangeListener {
    protected DTDocumentContainer fDocumentContainer;
    private DTDocumentTabs fTabs;
    protected DTClient fVisibleDocument;
    private boolean fRestoringDocuments;
    private boolean fShowFocus;
    private Rectangle fFocusRect;
    private DropTarget fDropTarget;
    private JToolBar fTopRightToolBar;
    private JToolBar fTopLeftToolBar;
    private JComponent fBlankPanel;

    DTTabbedDocumentPane(DTDocumentContainer dTDocumentContainer, DTDocumentTabsProperties dTDocumentTabsProperties) {
        this.setLayout(null);
        this.fDocumentContainer = dTDocumentContainer;
        this.fTabs = new DTDocumentTabs(this.fDocumentContainer);
        this.fTabs.setProperties(dTDocumentTabsProperties);
        dTDocumentTabsProperties.register(this.fTabs);
        this.fTabs.addEdgeListener(new DTDocumentTabs.EdgeListener(){

            @Override
            public void tabsMoved(DTDocumentTabs dTDocumentTabs, int n) {
                DTTabbedDocumentPane.this.updateToolBarBorders();
                if (DTTabbedDocumentPane.this.fBlankPanel != null) {
                    DTTabbedDocumentPane.this.fBlankPanel.setVisible(n != 1);
                }
                DTTabbedDocumentPane.this.revalidate();
                DTTabbedDocumentPane.this.repaint();
            }
        });
        this.add((Component)((Object)this.fTabs));
    }

    DTDocumentTabs getTabs() {
        return this.fTabs;
    }

    void setGripVisible(boolean bl) {
        this.fTabs.setGripVisible(bl);
    }

    void setShowFocus(boolean bl) {
        if (this.fShowFocus != bl) {
            this.fShowFocus = bl;
            this.revalidate();
            this.repaint();
            this.fTabs.setAppearFocused(this.fShowFocus && this.fVisibleDocument != null && this.fVisibleDocument.isSelected());
        }
    }

    void setNewAction(Action action) {
        this.fTabs.setNewAction(action);
    }

    void setTopLeftToolBar(JToolBar jToolBar) {
        if (this.fTopLeftToolBar != null) {
            this.remove(this.fTopLeftToolBar);
        }
        this.fTopLeftToolBar = jToolBar;
        if (jToolBar != null) {
            this.addToolBar(jToolBar);
        }
        this.updateBlankPanel();
        this.updateToolBarBorders();
        this.revalidate();
        this.repaint();
    }

    void setTopRightToolBar(JToolBar jToolBar) {
        if (this.fTopRightToolBar != null) {
            this.remove(this.fTopRightToolBar);
        }
        this.fTopRightToolBar = jToolBar;
        if (jToolBar != null) {
            this.addToolBar(jToolBar);
        }
        this.updateBlankPanel();
        this.updateToolBarBorders();
        this.revalidate();
        this.repaint();
    }

    private void addToolBar(JToolBar jToolBar) {
        jToolBar.setFloatable(false);
        this.add(jToolBar);
    }

    private void updateBlankPanel() {
        if (this.fTopLeftToolBar != null || this.fTopRightToolBar != null) {
            if (this.fBlankPanel == null) {
                this.fBlankPanel = new MJPanel();
                this.fBlankPanel.setName("TabsPlaceHolder");
                this.fBlankPanel.setBorder(DTBorderFactory.createBottomSeparatorBorder());
                this.fBlankPanel.setVisible(this.fTabs.getEdge() != 1);
                this.add(this.fBlankPanel);
            }
        } else if (this.fBlankPanel != null) {
            this.remove(this.fBlankPanel);
            this.fBlankPanel = null;
        }
    }

    private void updateToolBarBorders() {
        Border border;
        Border border2 = border = this.fTabs.getEdge() == 1 ? new DTDocumentTabs.NeighborBorder() : DTBorderFactory.createBottomSeparatorBorder();
        if (this.fTopLeftToolBar != null) {
            this.fTopLeftToolBar.setBorder(border);
        }
        if (this.fTopRightToolBar != null) {
            this.fTopRightToolBar.setBorder(border);
        }
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        boolean bl;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl2 = bl = this.fVisibleDocument == null || dTClient.isSelected() || !this.fVisibleDocument.isSelected();
        if (this.fVisibleDocument != null && bl) {
            this.hide(this.fVisibleDocument);
        }
        dTClient.getInternalFrame().setTitleBarVisible(false);
        this.add((Component)((Object)dTClient.getInternalFrame()));
        this.fTabs.addTabForDocument(dTClient);
        if (this.fShowFocus) {
            dTClient.addPropertyListener(this);
        }
        if (this.fRestoringDocuments || !bl) {
            this.hide(dTClient);
        } else {
            this.show(dTClient);
        }
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        boolean bl = dTClient.isSelected();
        this.remove((Component)((Object)dTClient.getInternalFrame()));
        this.fTabs.removeTabForDocument(dTClient);
        dTClient.getInternalFrame().setTitleBarVisible(true);
        if (this.fShowFocus) {
            dTClient.removePropertyListener(this);
        }
        if (dTClient == this.fVisibleDocument) {
            this.fVisibleDocument = this.getMostRecentlySelected();
            if (this.fVisibleDocument != null) {
                this.show(this.fVisibleDocument);
                if (bl && dTClient.isClosing()) {
                    this.fVisibleDocument.setSelected(true);
                }
            } else {
                if (bl && dTClient.isClosing()) {
                    this.requestFocus();
                }
                this.revalidate();
                this.repaint();
            }
        } else {
            dTClient.getInternalFrame().setVisible(true);
        }
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        List<DTClient> list = this.fTabs.getDocuments();
        if (bl || list.size() < 2) {
            return dTSelectable == this.fVisibleDocument ? null : this.fVisibleDocument;
        }
        if (dTSelectable == null) {
            return list.get(0);
        }
        int n = list.indexOf(dTSelectable);
        return n < list.size() - 1 ? list.get(n + 1) : null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        List<DTClient> list = this.fTabs.getDocuments();
        if (bl || list.size() < 2) {
            return dTSelectable == this.fVisibleDocument ? null : this.fVisibleDocument;
        }
        if (dTSelectable == null) {
            return list.get(list.size() - 1);
        }
        int n = list.indexOf(dTSelectable);
        return n > 0 ? list.get(n - 1) : null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        if (dTClient == this.fVisibleDocument) {
            return;
        }
        if (this.fVisibleDocument != null) {
            if (scope == DTContainer.Scope.GROUP && this.fVisibleDocument.getGroup() != dTClient.getGroup()) {
                return;
            }
            this.fVisibleDocument.setSelected(false);
            this.hide(this.fVisibleDocument);
        }
        this.show(dTClient);
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
    }

    @Override
    public boolean isEmpty() {
        return this.fTabs.getDocuments().isEmpty();
    }

    @Override
    public List<DTClient> getOrderedDocuments() {
        return this.fTabs.getDocuments();
    }

    @Override
    public DTClient getFrontDocument() {
        return this.getVisibleDocument();
    }

    @Override
    public void addAllDocuments(List<DTClient> list, DTClient dTClient) {
        this.beginRestore();
        for (DTClient dTClient2 : list) {
            this.add(dTClient2, null);
        }
        if (dTClient != null) {
            this.toFront(dTClient, null);
        }
        this.endRestore();
    }

    @Override
    public List<DTClient> removeAllDocuments() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof DTClientFrame)) continue;
            DTClientFrame dTClientFrame = (DTClientFrame)((Object)component);
            component.setVisible(true);
            dTClientFrame.setTitleBarVisible(true);
            this.remove(component);
        }
        List<DTClient> list = this.fTabs.getDocuments();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DTClient dTClient = (DTClient)iterator.next();
            dTClient.removePropertyListener(this);
        }
        this.fTabs.removeAllTabs();
        this.fVisibleDocument = null;
        return list;
    }

    @Override
    public Rectangle getTabsBounds() {
        return this.fTabs.getBounds();
    }

    @Override
    public Insets getTabsInsets() {
        Insets insets = this.getInsets();
        switch (this.fTabs.getEdge()) {
            case 1: {
                insets.top += this.fTabs.getHeight();
                break;
            }
            case 5: {
                insets.bottom += this.fTabs.getHeight();
                break;
            }
            case 3: {
                insets.right += this.fTabs.getWidth();
                break;
            }
            case 7: {
                insets.left += this.fTabs.getWidth();
            }
        }
        return insets;
    }

    @Override
    public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.fDropTarget == null) {
            this.fDropTarget = new DropTarget();
            this.fDropTarget.setComponent((Component)((Object)this));
        }
        this.fDropTarget.addDropTargetListener(dropTargetListener);
        this.fTabs.addDropTargetListener(dropTargetListener);
    }

    @Override
    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTarget != null) {
            this.fDropTarget.removeDropTargetListener(dropTargetListener);
            this.fTabs.removeDropTargetListener(dropTargetListener);
        }
    }

    DTClient getVisibleDocument() {
        return this.fVisibleDocument;
    }

    private DTClient getMostRecentlySelected() {
        return DTUtilities.getMostRecentlySelected(this.fTabs.getDocuments());
    }

    void beginRestore() {
        this.fRestoringDocuments = true;
    }

    void endRestore() {
        this.fRestoringDocuments = false;
        DTClient dTClient = this.getMostRecentlySelected();
        if (dTClient != null) {
            this.toFront(dTClient, DTContainer.Scope.FRAME);
        }
    }

    protected void show(DTClient dTClient) {
        dTClient.getInternalFrame().setVisible(true);
        dTClient.getSelectAction().setSelected(true);
        this.fVisibleDocument = dTClient;
        if (this.fShowFocus) {
            this.fTabs.setAppearFocused(this.fVisibleDocument.isSelected());
        }
        this.repaint();
    }

    protected void hide(DTClient dTClient) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && (component == dTClient.getComponent() || SwingUtilities.isDescendingFrom(component, dTClient.getComponent()))) {
            this.requestFocusInWindow();
        }
        dTClient.getInternalFrame().setVisible(false);
        dTClient.getSelectAction().setSelected(false);
        if (dTClient == this.fVisibleDocument) {
            this.fVisibleDocument = null;
        }
        this.repaint();
    }

    public void doLayout() {
        Cloneable cloneable;
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Insets insets = this.getInsets();
        Dimension dimension = this.fTabs.getEdge() == -1 ? new Dimension(0, 0) : this.fTabs.getPreferredSize();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n2 - insets.left - insets.right, n3 - insets.top - insets.bottom);
        int n4 = 0;
        int n5 = 0;
        int n6 = n = this.fTabs.getEdge() == 1 ? dimension.height : 0;
        if (this.fTopLeftToolBar != null) {
            cloneable = this.fTopLeftToolBar.getPreferredSize();
            cloneable.height = Math.max(n, cloneable.height);
            this.fTopLeftToolBar.setBounds(insets.left, insets.top, cloneable.width, cloneable.height);
            n4 = cloneable.width;
            n = cloneable.height;
        }
        if (this.fTopRightToolBar != null) {
            cloneable = this.fTopRightToolBar.getPreferredSize();
            cloneable.height = Math.max(n, cloneable.height);
            this.fTopRightToolBar.setBounds(n2 - insets.right - cloneable.width, insets.top, cloneable.width, cloneable.height);
            n5 = cloneable.width;
            n = cloneable.height;
            if (this.fTopLeftToolBar != null && cloneable.height > this.fTopLeftToolBar.getHeight()) {
                this.fTopLeftToolBar.setSize(this.fTopLeftToolBar.getWidth(), cloneable.height);
            }
        }
        if (this.fBlankPanel != null) {
            if (this.fTabs.getEdge() != 1) {
                this.fBlankPanel.setBounds(insets.left + n4, insets.top, rectangle.width - n4 - n5, n);
                rectangle.y += n;
                rectangle.height -= n;
            } else {
                this.fBlankPanel.setBounds(0, 0, 0, 0);
            }
        }
        cloneable = new Rectangle(rectangle.x, rectangle.y, dimension.width, n);
        switch (this.fTabs.getEdge()) {
            case 1: {
                ((Rectangle)cloneable).width = rectangle.width - n4 - n5;
                rectangle.y += n;
                rectangle.height -= n;
                ((Rectangle)cloneable).x += n4;
                break;
            }
            case 5: {
                ((Rectangle)cloneable).height = dimension.height;
                ((Rectangle)cloneable).width = rectangle.width;
                ((Rectangle)cloneable).y = n3 - insets.bottom - dimension.height;
                rectangle.height -= dimension.height;
                break;
            }
            case 3: {
                ((Rectangle)cloneable).height = rectangle.height;
                ((Rectangle)cloneable).x = n2 - insets.right - dimension.width;
                rectangle.width -= dimension.width;
                break;
            }
            case 7: {
                ((Rectangle)cloneable).height = rectangle.height;
                rectangle.x += dimension.width;
                rectangle.width -= dimension.width;
            }
        }
        if (this.fShowFocus) {
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
            switch (this.fTabs.getEdge()) {
                case 1: {
                    --rectangle.y;
                }
                case 5: {
                    ++rectangle.height;
                    break;
                }
                case 7: {
                    --rectangle.x;
                }
                case 3: {
                    ++rectangle.width;
                }
            }
            this.fFocusRect = new Rectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        }
        if (this.fTabs.isVisible()) {
            this.fTabs.setBounds((Rectangle)cloneable);
        }
        for (DTClient dTClient : this.getOrderedDocuments()) {
            dTClient.getInternalFrame().setBounds(rectangle);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.fVisibleDocument == null) {
            graphics.setColor(UIManager.getColor("control"));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.fShowFocus && this.fFocusRect != null) {
            graphics.setColor(this.fVisibleDocument != null && this.fVisibleDocument.isSelected() ? DTDocumentTabs.FOCUSED_OUTLINE_COLOR : UIManager.getColor("control"));
            graphics.drawRect(this.fFocusRect.x, this.fFocusRect.y, this.fFocusRect.width, this.fFocusRect.height);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.fVisibleDocument && "Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
            this.fTabs.setAppearFocused(this.fVisibleDocument.isSelected());
            this.repaint();
        }
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        if (!(object instanceof DTClient) || !this.contains(n, n2)) {
            return null;
        }
        return new DTRelativeLocation(this.getReferenceLocation(), object == this.fVisibleDocument && this.fTabs.getDocuments().size() == 1 ? 0 : DTDragUtilities.getNearestEdge(new Point(n, n2), this.getSize(), 0.25f));
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        return dTLocation == null ? DTDragUtilities.getToLeaveHint(object) : DTDragUtilities.getToOutlineHint(object);
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        if (dTLocation == null) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        if (dTLocation instanceof DTRelativeLocation) {
            int n = rectangle.height / 2;
            int n2 = rectangle.width / 2;
            switch (((DTRelativeLocation)dTLocation).getDirection()) {
                case 5: {
                    rectangle.y += n;
                }
                case 1: {
                    rectangle.height -= n;
                    break;
                }
                case 3: {
                    rectangle.x += n2;
                }
                case 7: {
                    rectangle.width -= n2;
                }
            }
        }
        DTDragUtilities.getDropOutlinePainter().show(this.getParent(), rectangle.x, rectangle.y, rectangle.width, rectangle.height, DTDropOutlinePainter.OutlineType.RECTANGLE);
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
    }

    protected DTLocation getReferenceLocation() {
        return this.fVisibleDocument == null ? null : this.fVisibleDocument.getLocation();
    }
}

