/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJTiledPane;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentArranger;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocumentTabsProperties;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTRelativeLocation;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTabbedDocumentPane;
import com.mathworks.widgets.desk.DTTiledLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTTiledPane
extends MJTiledPane
implements DTContainer,
DTDocumentArranger,
MJTiledPane.GridListener,
DTDropTarget,
PropertyChangeListener {
    private DTDocumentContainer fDocumentContainer;
    private DropTarget fDropTarget;
    private int fTargetTile = -1;
    private boolean fHasAddedAny;
    private EmptyTileSweeper fEmptyTileSweeper;
    private boolean fShouldEliminateEmptyTiles;
    private boolean fIsDropInProgress;
    private static final String ELIMINATE_EMPTIES_ATTRIBUTE = "EliminateEmpties";
    private static final String YES_VALUE = "yes";
    private static final String NO_VALUE = "no";

    DTTiledPane(DTDocumentContainer dTDocumentContainer) {
        this.init(dTDocumentContainer);
    }

    DTTiledPane(DTDocumentContainer dTDocumentContainer, Dimension dimension) {
        super(dimension);
        this.init(dTDocumentContainer);
        this.updateEmptyEliminationRule();
    }

    DTTiledPane(DTDocumentContainer dTDocumentContainer, Object object) {
        this.init(dTDocumentContainer);
        if (object != null) {
            this.restoreState(object);
        } else {
            this.updateEmptyEliminationRule();
        }
    }

    private void init(DTDocumentContainer dTDocumentContainer) {
        this.setName("DesktopTiledPane");
        this.setOpaque(true);
        this.fFavorSelectedUponMerge = false;
        this.fDocumentContainer = dTDocumentContainer;
        this.addGridListener(this);
    }

    private void updateEmptyEliminationRule() {
        this.fShouldEliminateEmptyTiles = this.getGridSize().width * this.getGridSize().height <= 2 || this.fIsDropInProgress;
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        DTTabbedDocumentPane dTTabbedDocumentPane;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        int n = -1;
        if (dTLocation instanceof DTTiledLocation) {
            n = dTLocation.getTile();
        }
        if (n == -1 || n >= this.getTileCount()) {
            n = this.chooseTileForNew(dTClient);
            dTLocation = DTLocation.create(n);
        }
        if ((dTTabbedDocumentPane = this.getTabbedPaneInTile(n)) == null) {
            dTTabbedDocumentPane = this.createTabbedPane();
            this.add((Component)((Object)dTTabbedDocumentPane), n);
        }
        dTTabbedDocumentPane.add(dTOccupant, dTLocation);
        dTLocation.setContainer(this.fDocumentContainer);
        dTLocation.setFrame(this.fDocumentContainer.getFrame());
        dTClient.setLocation(dTLocation);
        if (dTClient.getInternalFrame().isSelected()) {
            this.setSelectedTile(n);
        }
        dTClient.addPropertyListener(this);
        if (this.fEmptyTileSweeper != null) {
            this.fEmptyTileSweeper.restart();
        } else if (!this.fHasAddedAny && !this.fDocumentContainer.isChangingArrangement()) {
            this.fEmptyTileSweeper = new EmptyTileSweeper();
            this.fEmptyTileSweeper.start();
        }
        this.fHasAddedAny = true;
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        int n = this.getTileContaining(dTClient);
        if (n == -1) {
            return;
        }
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
        if (dTTabbedDocumentPane == null) {
            return;
        }
        dTTabbedDocumentPane.remove(dTClient);
        if (dTTabbedDocumentPane.isEmpty() && !dTClient.getGroup().isClosing()) {
            this.remove(n);
            if (this.fShouldEliminateEmptyTiles) {
                this.eliminateTile(n, -1);
            }
            this.disposeTabbedDocumentPane(dTTabbedDocumentPane);
            this.updateLocations();
        }
        dTClient.removePropertyListener(this);
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        int n = !(dTSelectable instanceof DTClient) ? 0 : this.getTileContaining((DTClient)dTSelectable);
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
        DTClient dTClient = (DTClient)dTTabbedDocumentPane.getNext(dTSelectable, bl);
        if (dTClient != null) {
            return dTClient;
        }
        dTTabbedDocumentPane = null;
        ++n;
        while (n < this.fTileCount && dTTabbedDocumentPane == null) {
            dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
            ++n;
        }
        return dTTabbedDocumentPane == null ? null : dTTabbedDocumentPane.getNext(null, bl);
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        int n = !(dTSelectable instanceof DTClient) ? this.fTileCount - 1 : this.getTileContaining((DTClient)dTSelectable);
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
        DTClient dTClient = (DTClient)dTTabbedDocumentPane.getPrevious(dTSelectable, bl);
        if (dTClient != null) {
            return dTClient;
        }
        dTTabbedDocumentPane = null;
        --n;
        while (n >= 0 && dTTabbedDocumentPane == null) {
            dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
            --n;
        }
        return dTTabbedDocumentPane == null ? null : dTTabbedDocumentPane.getPrevious(null, bl);
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        int n = this.getTileContaining(dTClient);
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
        if (dTTabbedDocumentPane != null) {
            dTTabbedDocumentPane.toFront(dTClient, scope);
        }
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
    }

    @Override
    public boolean isEmpty() {
        for (DTTabbedDocumentPane dTTabbedDocumentPane : this.getTabbedPanes()) {
            if (dTTabbedDocumentPane.isEmpty()) continue;
            return false;
        }
        return true;
    }

    void syncTabProperties() {
        for (DTTabbedDocumentPane dTTabbedDocumentPane : this.getTabbedPanes()) {
            dTTabbedDocumentPane.getTabs().getProperties().syncFromParent();
        }
    }

    @Override
    public List<DTClient> getOrderedDocuments() {
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>();
        for (DTTabbedDocumentPane dTTabbedDocumentPane : this.getTabbedPanes()) {
            arrayList.addAll(dTTabbedDocumentPane.getOrderedDocuments());
        }
        return arrayList;
    }

    @Override
    public DTClient getFrontDocument() {
        DTTabbedDocumentPane dTTabbedDocumentPane;
        int n = this.getSelectedTile();
        if (n != -1 && (dTTabbedDocumentPane = this.getTabbedPaneInTile(n)) != null) {
            return dTTabbedDocumentPane.getFrontDocument();
        }
        return null;
    }

    @Override
    public void addAllDocuments(List<DTClient> list, DTClient dTClient) {
        int n;
        int n2 = n = dTClient == null ? -1 : list.indexOf(dTClient);
        if (list.size() > 2 && this.getTileCount() == 2 && n != -1) {
            int n3;
            if (n == list.size() - 1) {
                --n;
            }
            for (n3 = 0; n3 <= n; ++n3) {
                this.add(list.get(n3), DTLocation.create(0));
            }
            while (n3 < list.size()) {
                this.add(list.get(n3), DTLocation.create(1));
                ++n3;
            }
        } else {
            int n4;
            int n5 = Math.min(this.getTileCount(), list.size());
            for (n4 = 0; n4 < n5; ++n4) {
                this.add(list.get(n4), DTLocation.create(n4));
            }
            while (n4 < list.size()) {
                this.add(list.get(n4), DTLocation.create(n5 - 1));
                ++n4;
            }
            if (list.size() > this.getTileCount()) {
                if (n < this.getTileCount() - 1) {
                    n = this.getTileCount() - 1;
                }
                this.getTabbedPaneInTile(this.getTileCount() - 1).toFront(list.get(n), null);
            }
        }
    }

    @Override
    public List<DTClient> removeAllDocuments() {
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>();
        for (DTTabbedDocumentPane propertyChangeListener : this.getTabbedPanes()) {
            arrayList.addAll(propertyChangeListener.removeAllDocuments());
        }
        for (DTClient dTClient : arrayList) {
            dTClient.removePropertyListener(this);
        }
        return arrayList;
    }

    @Override
    public Rectangle getTabsBounds() {
        return new Rectangle();
    }

    @Override
    public Insets getTabsInsets() {
        return this.getInsets();
    }

    @Override
    public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.fDropTarget == null) {
            this.fDropTarget = new LocalDropTarget();
            this.fDropTarget.setComponent((Component)((Object)this));
        }
        this.fDropTarget.addDropTargetListener(dropTargetListener);
    }

    @Override
    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTarget != null) {
            this.fDropTarget.removeDropTargetListener(dropTargetListener);
        }
    }

    public void setGridSize(Dimension dimension) {
        List<DTClient> list = null;
        if (dimension.width * dimension.height != this.getTileCount()) {
            list = this.removeAllDocuments();
        }
        super.setGridSize(dimension);
        if (list != null && !list.isEmpty()) {
            this.addAllDocuments(list, null);
        }
    }

    void move(DTClient dTClient, int n) {
        this.move(dTClient, this.getTileContaining(dTClient), n);
    }

    void move(DTClient dTClient, int n, int n2) {
        if (n == -1 || n == n2) {
            return;
        }
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
        dTTabbedDocumentPane.remove(dTClient);
        DTTabbedDocumentPane dTTabbedDocumentPane2 = this.getTabbedPaneInTile(n2);
        if (dTTabbedDocumentPane2 == null) {
            dTTabbedDocumentPane2 = this.createTabbedPane();
            this.add((Component)((Object)dTTabbedDocumentPane2), n2);
        }
        ((DTTiledLocation)dTClient.getLocation()).setTile(n2);
        dTTabbedDocumentPane2.add(dTClient, null);
        if (dTTabbedDocumentPane.isEmpty()) {
            this.remove(n);
            if (this.fShouldEliminateEmptyTiles) {
                this.eliminateTile(n, n2);
            }
            this.disposeTabbedDocumentPane(dTTabbedDocumentPane);
            this.updateLocations();
        }
    }

    DTClient getFrontDocumentInTile(int n) {
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
        if (dTTabbedDocumentPane != null) {
            return dTTabbedDocumentPane.getFrontDocument();
        }
        return null;
    }

    void endRestore() {
        for (DTTabbedDocumentPane dTTabbedDocumentPane : this.getTabbedPanes()) {
            dTTabbedDocumentPane.endRestore();
        }
    }

    private DTTabbedDocumentPane createTabbedPane() {
        DTDocumentTabsProperties dTDocumentTabsProperties = new DTDocumentTabsProperties(this.fDocumentContainer.getTabProperties());
        TabbedPane tabbedPane = new TabbedPane(this.fDocumentContainer, dTDocumentTabsProperties);
        tabbedPane.setGripVisible(this.fTileCount <= 2);
        tabbedPane.setShowFocus(true);
        this.setNewAction(tabbedPane);
        tabbedPane.getTabs().setProperties(dTDocumentTabsProperties);
        dTDocumentTabsProperties.register(tabbedPane.getTabs());
        this.fDocumentContainer.getTabProperties().register(tabbedPane.getTabs());
        return tabbedPane;
    }

    private void setNewAction(final DTTabbedDocumentPane dTTabbedDocumentPane) {
        Action action = this.fDocumentContainer.getGroup().getNewAction();
        if (action != null) {
            action = new ChildAction(action){

                public void actionPerformed(ActionEvent actionEvent) {
                    DTTiledPane.this.fTargetTile = DTTiledPane.this.getTileContaining((Component)((Object)dTTabbedDocumentPane));
                    super.actionPerformed(actionEvent);
                }
            };
        }
        dTTabbedDocumentPane.setNewAction(action);
    }

    private void disposeTabbedDocumentPane(DTTabbedDocumentPane dTTabbedDocumentPane) {
        this.fDocumentContainer.getTabProperties().unregister(dTTabbedDocumentPane.getTabs());
    }

    private List<DTTabbedDocumentPane> getTabbedPanes() {
        int n = this.getTileCount();
        ArrayList<DTTabbedDocumentPane> arrayList = new ArrayList<DTTabbedDocumentPane>(n);
        for (int i = 0; i < n; ++i) {
            DTTabbedDocumentPane dTTabbedDocumentPane = (DTTabbedDocumentPane)((Object)this.getComponentInTile(i));
            if (dTTabbedDocumentPane == null) continue;
            arrayList.add(dTTabbedDocumentPane);
        }
        return arrayList;
    }

    private DTTabbedDocumentPane getTabbedPaneInTile(int n) {
        return n == -1 ? null : (DTTabbedDocumentPane)((Object)this.getComponentInTile(n));
    }

    private int getTileContaining(DTClient dTClient) {
        DTLocation dTLocation = dTClient.getLocation();
        return dTLocation == null ? -1 : dTLocation.getTile();
    }

    int chooseTileForNew(DTClient dTClient) {
        int n = -1;
        if (this.fTargetTile != -1) {
            n = this.fTargetTile;
            this.fTargetTile = -1;
        }
        int n2 = this.getSelectedTile();
        if (n == -1 && n2 != -1 && this.isTileEmpty(n2)) {
            n = n2;
        }
        if (n == -1) {
            n = this.getFirstUnoccupiedTile();
        }
        if (n == -1) {
            n = n2;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public void gridSizeChanged(MJTiledPane mJTiledPane, Dimension dimension, Dimension dimension2) {
        Component[] componentArray;
        int n = dimension.width * dimension.height;
        int n2 = dimension2.width * dimension2.height;
        if (n <= 2 && n2 > 2 || n > 2 && n2 <= 2) {
            componentArray = this.getTabbedPanes().iterator();
            while (componentArray.hasNext()) {
                DTTabbedDocumentPane object = (DTTabbedDocumentPane)componentArray.next();
                this.setNewAction(object);
                object.setGripVisible(this.fTileCount <= 2);
            }
        }
        if (n2 < n) {
            for (Component component : componentArray = this.getComponents()) {
                if (this.getTileContaining(component) != -1) continue;
                TabbedPane tabbedPane = (TabbedPane)((Object)component);
                this.remove((Component)((Object)tabbedPane));
                this.disposeTabbedDocumentPane(tabbedPane);
            }
        }
        this.updateEmptyEliminationRule();
    }

    public void tilesMerged(MJTiledPane mJTiledPane, int n, int n2) {
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
        for (Component component : this.getComponentsRemovedByMerge()) {
            DTTabbedDocumentPane dTTabbedDocumentPane2 = (DTTabbedDocumentPane)((Object)component);
            List<DTClient> list = dTTabbedDocumentPane2.removeAllDocuments();
            for (DTClient dTClient : list) {
                dTTabbedDocumentPane.add(dTClient, null);
            }
            this.disposeTabbedDocumentPane(dTTabbedDocumentPane2);
        }
        if (this.getTileCount() > 1) {
            this.updateLocations();
        }
    }

    public void tileSplit(MJTiledPane mJTiledPane, int n, int n2) {
    }

    private void updateLocations() {
        int n = this.getTileCount();
        for (int i = 0; i < n; ++i) {
            DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(i);
            if (dTTabbedDocumentPane == null) continue;
            for (DTClient dTClient : dTTabbedDocumentPane.getOrderedDocuments()) {
                DTLocation dTLocation = dTClient.getLocation();
                if (!(dTLocation instanceof DTTiledLocation) || dTLocation.getTile() == i) continue;
                ((DTTiledLocation)dTLocation).setTile(i);
                dTClient.locationChanged();
            }
        }
    }

    private int getFirstUnoccupiedTile() {
        for (int i = 0; i < this.fTileCount; ++i) {
            DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(i);
            if (dTTabbedDocumentPane != null && !dTTabbedDocumentPane.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DTClient dTClient;
        int n;
        Object object = propertyChangeEvent.getSource();
        if (object instanceof DTClient && "Occupant Selected".equals(propertyChangeEvent.getPropertyName()) && (n = this.getTileContaining(dTClient = (DTClient)object)) != -1 && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            this.setSelectedTile(n);
        }
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        int n3 = this.getTileAt(n, n2);
        if (n3 == -1) {
            return null;
        }
        DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n3);
        if (dTTabbedDocumentPane == null || dTTabbedDocumentPane.isEmpty()) {
            DTTiledLocation dTTiledLocation = new DTTiledLocation(n3);
            dTTiledLocation.setFrame(this.fDocumentContainer.getFrame());
            dTTiledLocation.setContainer(this.fDocumentContainer);
            return dTTiledLocation;
        }
        Point point = SwingUtilities.convertPoint((Component)((Object)this), n, n2, (Component)((Object)dTTabbedDocumentPane));
        return dTTabbedDocumentPane.getDropLocation(object, point.x, point.y, dTLocation);
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        return dTLocation == null ? DTDragUtilities.getToLeaveHint(object) : DTDragUtilities.getToOutlineHint(object);
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        if (dTLocation instanceof DTTiledLocation) {
            Rectangle rectangle = this.getTilePixelRect(dTLocation.getTile());
            DTDragUtilities.getDropOutlinePainter().show((Component)((Object)this), rectangle.x, rectangle.y, rectangle.width, rectangle.height, DTDropOutlinePainter.OutlineType.RECTANGLE);
        } else if (dTLocation instanceof DTRelativeLocation) {
            int n = ((DTRelativeLocation)dTLocation).getReferenceLocation().getTile();
            DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n);
            dTTabbedDocumentPane.drawDropOutline(dTLocation);
        }
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        this.fIsDropInProgress = true;
        DTClient dTClient = (DTClient)object;
        int n = dTClient.getLocation().getTile();
        if (dTLocation instanceof DTTiledLocation || dTLocation instanceof DTRelativeLocation && ((DTRelativeLocation)dTLocation).getDirection() == 0) {
            this.move(dTClient, n, dTLocation.getTile());
        } else {
            int n2;
            int n3 = dTLocation.getTile();
            int n4 = ((DTRelativeLocation)dTLocation).getDirection();
            Rectangle rectangle = this.getTileCellRect(n3);
            if (n4 == 1 || n4 == 5) {
                this.splitNorthSouth(rectangle.y, rectangle.x);
                n2 = this.getOccupyingTile(rectangle.y + 1, rectangle.x);
            } else {
                this.splitEastWest(rectangle.y, rectangle.x);
                n2 = this.getOccupyingTile(rectangle.y, rectangle.x + 1);
            }
            if (n4 == 1 || n4 == 7) {
                DTTabbedDocumentPane dTTabbedDocumentPane = this.getTabbedPaneInTile(n3);
                this.remove(n3);
                this.add((Component)((Object)dTTabbedDocumentPane), n2);
                this.updateLocations();
                this.move(dTClient, n3);
            } else {
                this.updateLocations();
                this.move(dTClient, n2);
            }
        }
        this.fIsDropInProgress = false;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(UIManager.getColor("control"));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(graphics);
    }

    public Object getState() {
        return new DTState(this);
    }

    public void restoreState(Object object) {
        if (!(object instanceof DTState)) {
            throw new IllegalArgumentException("Argument must be of class DTTiledPane.DTState");
        }
        DTState dTState = (DTState)((Object)object);
        super.restoreState(object);
        this.fShouldEliminateEmptyTiles = dTState.fEliminateEmpties;
    }

    public static Object stateFromXML(SimpleElement simpleElement) throws DataFormatException {
        return new DTState(simpleElement);
    }

    private static class DTState
    extends MJTiledPane.State {
        private boolean fEliminateEmpties;

        private DTState(DTTiledPane dTTiledPane) {
            super((MJTiledPane)dTTiledPane);
            this.fEliminateEmpties = dTTiledPane.fShouldEliminateEmptyTiles;
        }

        private DTState(SimpleElement simpleElement) throws DataFormatException {
            super(simpleElement);
            this.fEliminateEmpties = simpleElement.hasAttribute(DTTiledPane.ELIMINATE_EMPTIES_ATTRIBUTE) ? DTTiledPane.YES_VALUE.equalsIgnoreCase(simpleElement.getAttribute(DTTiledPane.ELIMINATE_EMPTIES_ATTRIBUTE)) : this.fGridSize.width * this.fGridSize.height <= 2;
        }

        public Element toXML(Document document) {
            Element element = super.toXML(document);
            element.setAttribute(DTTiledPane.ELIMINATE_EMPTIES_ATTRIBUTE, this.fEliminateEmpties ? DTTiledPane.YES_VALUE : DTTiledPane.NO_VALUE);
            return element;
        }
    }

    private class EmptyTileSweeper
    implements ActionListener {
        private Timer iTimer = new Timer(250, this);

        private EmptyTileSweeper() {
            this.iTimer.setRepeats(false);
        }

        private void start() {
            this.iTimer.start();
        }

        private void restart() {
            this.iTimer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            DTGroup dTGroup = DTTiledPane.this.fDocumentContainer.getGroup();
            if (dTGroup != null && dTGroup.isShowing() && !dTGroup.isClosing()) {
                while (DTTiledPane.this.fTileCount > 0) {
                    int n = DTTiledPane.this.fTileCount;
                    for (int i = 0; i < DTTiledPane.this.fTileCount; ++i) {
                        DTTabbedDocumentPane dTTabbedDocumentPane = DTTiledPane.this.getTabbedPaneInTile(i);
                        if (dTTabbedDocumentPane != null && !dTTabbedDocumentPane.isEmpty()) continue;
                        if (dTTabbedDocumentPane != null) {
                            DTTiledPane.this.remove((Component)((Object)dTTabbedDocumentPane));
                            DTTiledPane.this.disposeTabbedDocumentPane(dTTabbedDocumentPane);
                        }
                        DTTiledPane.this.eliminateTile(i, -1);
                        if (DTTiledPane.this.fTileCount < n) break;
                    }
                    if (DTTiledPane.this.fTileCount == n) break;
                    bl = true;
                }
            }
            DTTiledPane.this.fEmptyTileSweeper = null;
            if (bl) {
                DTTiledPane.this.updateLocations();
            }
        }
    }

    private class TabbedPane
    extends DTTabbedDocumentPane {
        TabbedPane(DTDocumentContainer dTDocumentContainer, DTDocumentTabsProperties dTDocumentTabsProperties) {
            super(dTDocumentContainer, dTDocumentTabsProperties);
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (this.fVisibleDocument != null) {
                Rectangle rectangle = this.fVisibleDocument.getInternalFrame().getBounds();
                rectangle.translate(this.getX(), this.getY());
                for (DTClient dTClient : this.getOrderedDocuments()) {
                    if (dTClient.getLocation() == null) continue;
                    dTClient.getLocation().setFrameBounds(rectangle);
                }
            }
        }
    }

    class LocalDropTarget
    extends DropTarget {
        LocalDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent == null) {
                return;
            }
            Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
            Point point = dropTargetDropEvent.getLocation();
            if (component != DTTiledPane.this) {
                point = SwingUtilities.convertPoint(component, point, (Component)((Object)DTTiledPane.this));
            }
            if (point != null) {
                DTTiledPane.this.fTargetTile = DTTiledPane.this.getTileAt(point);
            }
            super.drop(dropTargetDropEvent);
        }
    }
}

