/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ContrastingIcon;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class DTTitleButton
extends MJButton {
    private int fType;
    private final String fTargetName;
    private Action fAction;
    private boolean fIsActive;
    private boolean fParentUsesActiveColor = true;
    private String fTargetShortTitle;
    private static HashMap<IconData, Icon> sIconCache = new HashMap(12);
    private static IconData sTargetIconData = new IconData();
    private static Insets sDefaultMargin = new Insets(0, -1, 0, 0);
    private static final int DEFAULT_WIDTH = -1;
    private static final int DEFAULT_HEIGHT = -1;
    static final int DOCK = 0;
    static final int UNDOCK = 1;
    static final int MINIMIZE = 2;
    public static final int MAXIMIZE = 3;
    public static final int RESTORE = 4;
    public static final int ANCHOR = 5;
    public static final int DETACH = 6;
    public static final int CLOSE = 7;
    static final int SHOW_ACTIONS = 8;
    static final int SHOW_ACTIONS_NO_TITLE = 9;
    static final int DYNAMIC = 10;
    static final String DOCK_COMMAND = "Dock";
    static final String UNDOCK_COMMAND = "Undock";
    static final String MINIMIZE_COMMAND = "Minimize";
    static final String MAXIMIZE_COMMAND = "Maximize";
    static final String RESTORE_COMMAND = "Restore";
    static final String ANCHOR_COMMAND = "Anchor";
    static final String DETACH_COMMAND = "Detach";
    static final String SHOW_ACTIONS_COMMAND = "Show Actions";
    static final String CLOSE_COMMAND = "Close";
    private static final int NORMAL = 0;
    private static final int INACTIVE = 1;
    private static final String[] sCommands;
    private static final String[] sGenericTipKey;
    private static final String[] sSpecificTipKey;
    private static String[] sIconFilename;
    private static String[] sLightIconFilename;

    public DTTitleButton(int n) {
        this(n, null, null);
    }

    DTTitleButton(int n, String string, String string2) {
        this.fType = n;
        this.fTargetName = string;
        this.fTargetShortTitle = string2;
        this.setActionCommand(sCommands[n]);
        this.init();
    }

    public DTTitleButton(Action action, String string) {
        this.fAction = action;
        this.fType = 10;
        this.fTargetName = string;
        this.setActionCommand((String)action.getValue("ActionCommandKey"));
        this.addActionListener(this.fAction);
        action.addPropertyChangeListener(new ActionPropertyListener(this));
        this.init();
    }

    private void init() {
        this.updateName();
        this.setFocusTraversable(false);
        this.setDefaultCapable(false);
        this.setOpaque(false);
        this.setMargin(sDefaultMargin);
        if (PlatformInfo.isMacintosh()) {
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setBackground(new Color(0, 0, 0, 0));
        } else {
            this.setFlyOverAppearance(true);
        }
        this.updateIcons();
    }

    public void addNotify() {
        super.addNotify();
        this.updateTip();
    }

    void setType(int n) {
        if (this.fType == n) {
            return;
        }
        this.fType = n;
        if (n != 10) {
            this.setActionCommand(sCommands[n]);
            this.updateName();
            this.updateIcons();
            this.updateTip();
        }
    }

    int getType() {
        return this.fType;
    }

    int getCurrentType() {
        return this.fType == 10 ? DTTitleButton.getTypeFromAction(this.fAction) : this.fType;
    }

    public void setActive(boolean bl) {
        if (bl != this.fIsActive) {
            this.fIsActive = bl;
            this.updateIcons();
        }
    }

    void setTargetShortTitle(String string) {
        if (this.fTargetShortTitle == string) {
            return;
        }
        this.fTargetShortTitle = string;
        this.updateName();
        this.updateTip();
    }

    void setParentUsesActiveColor(boolean bl) {
        if (this.fParentUsesActiveColor != bl) {
            this.fParentUsesActiveColor = bl;
            this.updateIcons();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener instanceof ExtendedAction && ((ExtendedAction)actionListener).getComponentName() != null) {
            this.setName(((ExtendedAction)actionListener).getComponentName() + "Button");
        }
        super.addActionListener(actionListener);
    }

    public ActionListener getActionListener() {
        ActionListener[] actionListenerArray = this.getActionListeners();
        return actionListenerArray.length == 0 ? null : actionListenerArray[actionListenerArray.length - 1];
    }

    private void updateName() {
        if (this.fType != 10) {
            this.setName(sCommands[this.fType] + (this.fTargetName != null ? this.fTargetName : (this.fTargetShortTitle != null ? this.fTargetShortTitle : "")) + "Button");
        }
    }

    protected String getTip() {
        if (this.fType == 10) {
            String string = null;
            if (this.fAction != null) {
                string = (String)this.fAction.getValue("Name");
                int n = (Integer)this.fAction.getValue("MnemonicKey");
                if (n != 0) {
                    string = MJUtilities.removeMnemonicText((String)string, (int)n);
                }
            }
            return string;
        }
        if (this.fTargetShortTitle == null) {
            return this.getGenericTip();
        }
        Object[] objectArray = new Object[]{this.fTargetShortTitle};
        return MessageFormat.format(Desktop.getString((Component)((Object)this), sSpecificTipKey[this.fType]), objectArray);
    }

    void updateTip() {
        this.setToolTipText(this.getTip());
    }

    String getGenericTip() {
        return Desktop.getString((Component)((Object)this), sGenericTipKey[this.getCurrentType()]);
    }

    private static int getTypeFromAction(Action action) {
        String string = (String)action.getValue("ComponentName");
        if (string != null) {
            if (string.startsWith(DOCK_COMMAND)) {
                return 0;
            }
            if (string.startsWith(UNDOCK_COMMAND)) {
                return 1;
            }
            if (string.startsWith(MINIMIZE_COMMAND)) {
                return 2;
            }
            if (string.startsWith(MAXIMIZE_COMMAND)) {
                return 3;
            }
            if (string.startsWith(RESTORE_COMMAND)) {
                return 4;
            }
            if (string.startsWith(ANCHOR_COMMAND)) {
                return 5;
            }
            if (string.startsWith(CLOSE_COMMAND)) {
                return 7;
            }
        }
        return -1;
    }

    void updateIcons() {
        int n = -1;
        int n2 = -1;
        Icon icon = this.getIcon(n, n2, this.fIsActive ? 0 : 1);
        this.setIcon(icon);
        this.setRolloverIcon(icon);
    }

    private Icon getIcon(int n, int n2, int n3) {
        sTargetIconData.fType = this.fType;
        sTargetIconData.fReferenceIcon = this.fAction == null ? null : (Icon)this.fAction.getValue("SmallIcon");
        sTargetIconData.fState = n3;
        sTargetIconData.fWidth = n;
        sTargetIconData.fHeight = n2;
        sTargetIconData.fColor = this.getIconColor(n3);
        Icon icon = sIconCache.get(sTargetIconData);
        if (icon == null) {
            icon = this.createIcon(sTargetIconData);
            sIconCache.put(new IconData(sTargetIconData), icon);
        }
        return icon;
    }

    private Color getIconColor(int n) {
        if (n == 0 && this.fParentUsesActiveColor || UIManager.getColor("control").equals(Color.black)) {
            return Color.white;
        }
        return Color.black;
    }

    private Icon createIcon(IconData iconData) {
        Icon icon = null;
        if (iconData.fReferenceIcon instanceof ContrastingIcon) {
            ContrastingIcon contrastingIcon = (ContrastingIcon)iconData.fReferenceIcon;
            icon = iconData.fColor.equals(Color.black) ? contrastingIcon.getDarkIcon() : contrastingIcon.getLightIcon();
        } else {
            if (iconData.fReferenceIcon instanceof ImageIcon) {
                icon = iconData.fColor.equals(Color.black) ? iconData.fReferenceIcon : new ImageIcon(((ImageIcon)iconData.fReferenceIcon).getImage());
            } else if (this.fType != 10) {
                icon = new ImageIcon(DTTitleBar.class.getResource("resources/" + sIconFilename[iconData.fType]));
            }
            if (icon != null && !iconData.fColor.equals(Color.black)) {
                icon = sLightIconFilename[iconData.fType] != null ? new ImageIcon(DTTitleBar.class.getResource("resources/" + sLightIconFilename[iconData.fType])) : IconUtils.changeIconColor((ImageIcon)((ImageIcon)icon), (Color)iconData.fColor);
            }
        }
        return icon;
    }

    static {
        if (PlatformInfo.isMacintosh()) {
            sDefaultMargin = new Insets(0, 2, 0, 2);
        }
        sCommands = new String[]{DOCK_COMMAND, UNDOCK_COMMAND, MINIMIZE_COMMAND, MAXIMIZE_COMMAND, RESTORE_COMMAND, ANCHOR_COMMAND, DETACH_COMMAND, CLOSE_COMMAND, SHOW_ACTIONS_COMMAND, SHOW_ACTIONS_COMMAND};
        sGenericTipKey = new String[]{"tooltip.Dock", "tooltip.Undock", "tooltip.Minimize", "tooltip.Maximize", "tooltip.Restore", "tooltip.Anchor", "tooltip.Detach", "tooltip.Close", "tooltip.ShowActions", "tooltip.ShowActions"};
        sSpecificTipKey = new String[]{"tooltip.DockThis", "tooltip.UndockThis", "tooltip.MinimizeThis", "tooltip.MaximizeThis", "tooltip.RestoreThis", "tooltip.AnchorThis", "tooltip.DetachThis", "tooltip.CloseThis", "tooltip.ShowActionsForThis", "tooltip.ShowActionsForThis"};
        sIconFilename = new String[]{"dock.gif", "undock.gif", "minimize.gif", "maximize.gif", "restore.gif", "anchor.gif", "detach.gif", "closebox.gif", "show_actions_dark.png", "show_actions_no_title_dark.png"};
        sLightIconFilename = new String[]{null, null, null, null, null, null, null, null, "show_actions_light.png", "show_actions_no_title_light.png"};
    }

    private static class ActionPropertyListener
    implements PropertyChangeListener {
        private WeakReference<DTTitleButton> iButtonReference;

        ActionPropertyListener(DTTitleButton dTTitleButton) {
            this.iButtonReference = new WeakReference<DTTitleButton>(dTTitleButton);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DTTitleButton dTTitleButton = (DTTitleButton)((Object)this.iButtonReference.get());
            if (dTTitleButton == null) {
                if (propertyChangeEvent.getSource() instanceof Action) {
                    ((Action)propertyChangeEvent.getSource()).removePropertyChangeListener(this);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                dTTitleButton.updateIcons();
            } else if (propertyChangeEvent.getPropertyName().equals("Name") || propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                dTTitleButton.updateTip();
            }
        }
    }

    private static class IconData {
        private int fType;
        private int fState;
        private int fWidth;
        private int fHeight;
        private Icon fReferenceIcon;
        private Color fColor;

        IconData() {
        }

        IconData(IconData iconData) {
            this.fType = iconData.fType;
            this.fState = iconData.fState;
            this.fWidth = iconData.fWidth;
            this.fHeight = iconData.fHeight;
            this.fColor = iconData.fColor;
            this.fReferenceIcon = iconData.fReferenceIcon;
        }

        public boolean equals(Object object) {
            if (object instanceof IconData) {
                IconData iconData = (IconData)object;
                return this.fType == iconData.fType && this.fState == iconData.fState && this.fWidth == iconData.fWidth && this.fHeight == iconData.fHeight && this.fColor == iconData.fColor && this.fReferenceIcon == iconData.fReferenceIcon;
            }
            return false;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.fType;
            n = 37 * n + this.fState;
            n = 37 * n + this.fWidth;
            n = 37 * n + this.fHeight;
            n = 37 * n + this.fColor.hashCode();
            if (this.fReferenceIcon != null) {
                n = 37 * n + this.fReferenceIcon.hashCode();
            }
            return n;
        }
    }
}

