/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTPlaceHolderAction;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class DTToolBar
extends MJPanel {
    protected Desktop fDesktop;
    protected DTFrame fFrame;
    protected DTClient fClient;
    protected DTDocumentContainer fDocumentContainer;
    protected MJToolBar fWestBox;
    protected MJToolBar fEastBox;
    protected MJButton fCutButton;
    protected MJButton fCopyButton;
    protected MJButton fPasteButton;
    protected MJButton fUndoButton;
    protected MJButton fRedoButton;

    public DTToolBar(Desktop desktop, DTFrame dTFrame) {
        this.setName("DesktopToolBar");
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.setLayout(new BorderLayout());
        this.fWestBox = new MJToolBar();
        this.fWestBox.setFloatable(false);
        this.fWestBox.setBorder(BorderFactory.createEmptyBorder());
        this.fEastBox = new MJToolBar();
        this.fEastBox.setFloatable(false);
        this.fEastBox.setBorder(BorderFactory.createEmptyBorder());
        this.populate();
        this.add((Component)this.fWestBox, "West");
        this.add((Component)this.fEastBox, "East");
    }

    protected void populate() {
        this.fCutButton = this.addTo(this.fWestBox, (Action)((Object)DTPlaceHolderAction.getCutPlaceHolder(this.fDesktop)));
        this.fCopyButton = this.addTo(this.fWestBox, (Action)((Object)DTPlaceHolderAction.getCopyPlaceHolder(this.fDesktop)));
        this.fPasteButton = this.addTo(this.fWestBox, (Action)((Object)DTPlaceHolderAction.getPastePlaceHolder(this.fDesktop)));
        this.fUndoButton = this.addTo(this.fWestBox, (Action)((Object)DTPlaceHolderAction.getUndoPlaceHolder(this.fDesktop)));
        this.fRedoButton = this.addTo(this.fWestBox, (Action)((Object)DTPlaceHolderAction.getRedoPlaceHolder(this.fDesktop)));
    }

    protected MJButton addTo(MJToolBar mJToolBar, Action action) {
        return (MJButton)mJToolBar.add(action);
    }

    protected MJToggleButton addToggleTo(MJToolBar mJToolBar, Action action) {
        return (MJToggleButton)mJToolBar.addToggle(action);
    }

    protected void addSeparatorTo(MJToolBar mJToolBar) {
        mJToolBar.addSeparator();
    }

    protected void addTo(MJToolBar mJToolBar, Component component) {
        mJToolBar.add(component);
    }

    protected void setClient(DTClient dTClient) {
        if (dTClient != this.fClient) {
            JMenuBar jMenuBar;
            if (this.fCutButton != null) {
                this.fCutButton.setAction((Action)((Object)DTPlaceHolderAction.getCutPlaceHolder(this.fDesktop)));
            }
            if (this.fCopyButton != null) {
                this.fCopyButton.setAction((Action)((Object)DTPlaceHolderAction.getCopyPlaceHolder(this.fDesktop)));
            }
            if (this.fPasteButton != null) {
                this.fPasteButton.setAction((Action)((Object)DTPlaceHolderAction.getPastePlaceHolder(this.fDesktop)));
            }
            if (this.fUndoButton != null) {
                this.fUndoButton.setAction((Action)((Object)DTPlaceHolderAction.getUndoPlaceHolder(this.fDesktop)));
            }
            if (this.fRedoButton != null) {
                this.fRedoButton.setAction((Action)((Object)DTPlaceHolderAction.getRedoPlaceHolder(this.fDesktop)));
            }
            if (dTClient != null && (jMenuBar = dTClient.getMenuBar()) != null) {
                this.merge(jMenuBar);
            }
        }
        this.fClient = dTClient;
    }

    DTClient getClient() {
        return this.fClient;
    }

    void setDocumentContainer(DTDocumentContainer dTDocumentContainer) {
    }

    protected void merge(JMenuBar jMenuBar) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (DTMenuMergeTag.getTag(jMenu) != DTMenuMergeTag.EDIT) continue;
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (!(jMenuItem instanceof MJMenuItem)) continue;
                Action action = jMenuItem.getAction();
                DTMenuMergeTag dTMenuMergeTag = DTMenuMergeTag.getTag(jMenuItem);
                AbstractButton abstractButton = null;
                if (dTMenuMergeTag != null) {
                    if (dTMenuMergeTag == DTMenuMergeTag.CUT) {
                        abstractButton = this.fCutButton;
                    } else if (dTMenuMergeTag == DTMenuMergeTag.COPY) {
                        abstractButton = this.fCopyButton;
                    } else if (dTMenuMergeTag == DTMenuMergeTag.PASTE) {
                        abstractButton = this.fPasteButton;
                    } else if (dTMenuMergeTag == DTMenuMergeTag.UNDO) {
                        abstractButton = this.fUndoButton;
                    } else if (dTMenuMergeTag == DTMenuMergeTag.REDO) {
                        abstractButton = this.fRedoButton;
                    }
                }
                if (abstractButton == null) continue;
                abstractButton.setAction(action);
                abstractButton.setText(null);
            }
        }
    }

    protected void dispose() {
        if (this.fCutButton != null) {
            this.fCutButton.setAction(null);
        }
        if (this.fCopyButton != null) {
            this.fCopyButton.setAction(null);
        }
        if (this.fPasteButton != null) {
            this.fPasteButton.setAction(null);
        }
        if (this.fUndoButton != null) {
            this.fUndoButton.setAction(null);
        }
        if (this.fRedoButton != null) {
            this.fRedoButton.setAction(null);
        }
    }
}

