/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarFactory;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.xml.XMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DTToolBarUtilities {
    static void saveConfiguration(Desktop desktop, DTToolBarInfo dTToolBarInfo, DTToolBarConfiguration dTToolBarConfiguration) {
        try {
            File file = new File(DTToolBarUtilities.getSavePath(desktop, dTToolBarInfo));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = dTToolBarConfiguration.toXML(document, null);
            document.appendChild(element);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)"utf-8");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    static DTToolBarConfiguration recallConfiguration(Desktop desktop, DTToolBarInfo dTToolBarInfo) {
        DTToolBarConfiguration dTToolBarConfiguration = dTToolBarInfo.getDefaultConfig();
        File file = new File(DTToolBarUtilities.getSavePath(desktop, dTToolBarInfo));
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
                SimpleElement simpleElement = simpleDOMParser.parse((Reader)bufferedReader);
                dTToolBarConfiguration = new DTToolBarConfiguration(simpleElement);
                dTToolBarConfiguration = DTToolBarFactory.reconcile(dTToolBarInfo.getToolSet(), dTToolBarConfiguration, dTToolBarInfo.getDefaultConfig());
                fileInputStream.close();
            }
            catch (Exception exception) {
                dTToolBarConfiguration = dTToolBarInfo.getDefaultConfig();
            }
        }
        return dTToolBarConfiguration;
    }

    static String getSavePath(Desktop desktop, DTToolBarInfo dTToolBarInfo) {
        return FileUtils.getPreferencesDirectory() + System.getProperty("file.separator") + dTToolBarInfo.getKey() + desktop.getDesktopName() + "ToolBar.xml";
    }
}

