/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.find;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindPanel;
import com.mathworks.widgets.find.FindParentListener;
import com.mathworks.widgets.find.FindPrefs;
import com.mathworks.widgets.find.FindRunnable;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public final class FindDialog {
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.find.resources.RES_FindDialog");
    public static final String LOOKIN_COMBOBOX_NAME = "Look In Field";
    public static final String FIND_COMBOBOX_NAME = "Find Field";
    public static final String FIND_NEXT_BUTTON_NAME = "Find Button";
    public static final String FIND_PREVIOUS_BUTTON_NAME = "Find Back Button";
    public static final String REPLACE_BUTTON_NAME = "Replace Button";
    public static final String REPLACE_ALL_BUTTON_NAME = "ReplaceAll Button";
    public static final String CLOSE_BUTTON_NAME = "Close Button";
    public static final String REPLACE_COMBOBOX_NAME = "Replace Field";
    public static final int MATCH_CASE = 1;
    public static final int WRAP_AROUND = 2;
    public static final int WHOLE_WORD = 4;
    public static final int REVERSE = 8;
    public static final int LIMIT_SEARCH_TO_SELECTION = 16;
    public static final int FIND_REPLACE = 1;
    public static final int FIND = 2;
    public static final int HISTORY_LIMIT = 20;
    private static FindDialog sInstance;
    private static boolean sReparenting;
    private final FindParentListener fParentListener = new FindParentListener(){

        @Override
        public void focusGained(FindClientInterface findClientInterface) {
        }

        @Override
        public void docked(FindClientInterface findClientInterface) {
            FindDialog.this.attachToClientLater(findClientInterface);
        }

        @Override
        public void undocked(FindClientInterface findClientInterface) {
            FindDialog.this.attachToClientLater(findClientInterface);
        }

        @Override
        public void closing(FindClientInterface findClientInterface) {
            FindDialog.this.close();
        }

        @Override
        public void setSearchString(String string) {
            FindDialog.this.fPanel.setSearchText(string);
        }

        @Override
        public Window getWindow() {
            return FindDialog.this.fDialog;
        }
    };
    private final PropertyChangeListener fPanelListener = new PropertyChangeListener(){
        private final List<String> iHeavyProperties = Arrays.asList("look-in", "replace-allowed");

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (FindDialog.this.fSuppressPropertyChangeReaction) {
                return;
            }
            if (this.iHeavyProperties.contains(propertyChangeEvent.getPropertyName())) {
                FindDialog.this.prepareForInput();
            } else if (propertyChangeEvent.getPropertyName().equals("default-button")) {
                FindDialog.this.fDialog.getRootPane().setDefaultButton((JButton)FindDialog.this.fPanel.getDefaultButton());
            } else if (propertyChangeEvent.getPropertyName().equals("client")) {
                FindDialog.this.attachToClient((FindClientInterface)propertyChangeEvent.getOldValue(), (FindClientInterface)propertyChangeEvent.getNewValue());
            }
        }
    };
    private final WindowListener fWindowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            FindDialog.this.close();
        }
    };
    private FindPanel fPanel;
    private MJDialog fDialog;
    private Point fDefaultLocation;
    private boolean fSuppressPropertyChangeReaction;

    private FindDialog() {
    }

    static FindDialog getInstance() {
        assert (SwingUtilities.isEventDispatchThread());
        if (sInstance == null) {
            sInstance = new FindDialog();
        }
        return sInstance;
    }

    public static FindDialog invoke(FindClientInterface findClientInterface, String string, int n) {
        if (findClientInterface == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        FindDialog findDialog = FindDialog.getInstance();
        findDialog.attachToClient(findDialog.getClient(), findClientInterface);
        FindPanel findPanel = findDialog.getPanel();
        findPanel.setSearchHistory(FindPrefs.getSearchHistory());
        findPanel.setReplaceHistory(FindPrefs.getReplaceHistory());
        findPanel.setSearchText(string == null || string.length() == 0 ? FindPrefs.getSearchHistory().get(0) : string);
        findPanel.setOptions(n == 0 ? FindPrefs.getOptions() : n);
        Component component = findClientInterface.getInvoker();
        if (component != null && SwingUtilities.windowForComponent(component) != null && !SwingUtilities.windowForComponent(component).isFocused()) {
            findClientInterface.bringForward();
        }
        findDialog.fSuppressPropertyChangeReaction = true;
        findPanel.setLookIn(findClientInterface);
        findDialog.fSuppressPropertyChangeReaction = false;
        findDialog.prepareForInput();
        findDialog.show();
        findPanel.notifyInvokeOrRun();
        return findDialog;
    }

    private void prepareForInput() {
        this.fDialog.setTitle(BUNDLE.getString(this.fPanel.isReplaceAllowed() ? "title.FindAndReplace" : "title.Find"));
        this.fDialog.pack();
        this.fDialog.getRootPane().setDefaultButton((JButton)this.fPanel.getDefaultButton());
        this.fPanel.requestFocusInWindow();
    }

    private FindPanel getPanel() {
        return this.fPanel;
    }

    static void runWithCurrentSettings(FindRunnable findRunnable) {
        FindDialog findDialog = FindDialog.getInstance();
        FindEvent findEvent = new FindEvent(findDialog, findDialog.getText(), findDialog.getReplaceText(), findDialog.getOptions());
        FindPanel findPanel = findDialog.getPanel();
        FindPrefs.save(findDialog.getOptions(), findPanel.getSearchHistory(), findPanel.getReplaceHistory());
        if (findEvent.getFindString().length() > 0) {
            findRunnable.run(FindDialog.getInstance().getPanel().getLookIn().getClient(), findEvent);
        }
        findDialog.getPanel().notifyInvokeOrRun();
    }

    public static void registerComponent(FindClientInterface findClientInterface, String[] stringArray, int n) {
        FindClientRegistry.register(findClientInterface, stringArray, n == 1);
    }

    public static void unregister(FindClientInterface findClientInterface) {
        FindClientRegistry.unregister(findClientInterface);
    }

    public static void registerDynamicComponent(String string, FindClientInterface findClientInterface, String[] stringArray, int n) {
        FindClientRegistry.register(string, findClientInterface, stringArray, n == 1);
    }

    public static void unregisterDynamicComponent(String string) {
        FindClientRegistry.unregister(string);
    }

    public static boolean isReparenting() {
        return sReparenting;
    }

    public FindClientInterface getClient() {
        return this.fPanel != null ? this.fPanel.getLookIn().getClient() : null;
    }

    private void show() {
        this.fDialog.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FindDialog.this.fDialog != null) {
                    FindDialog.this.fDialog.toFront();
                    FindDialog.this.fPanel.requestFocus();
                }
            }
        });
    }

    void close() {
        FindClientInterface findClientInterface;
        FindPanel findPanel = this.fPanel;
        if (findPanel != null) {
            FindPrefs.save(this.getOptions(), findPanel.getSearchHistory(), findPanel.getReplaceHistory());
        }
        if ((findClientInterface = this.getClient()) != null) {
            findClientInterface.removeFindParentListener(this.fParentListener);
        }
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FindDialog.this.fDialog != null) {
                    FindDialog.this.fDialog.setFocusTraversalPolicy(null);
                    FindDialog.this.fDialog.dispose();
                    FindDialog.this.fDialog = null;
                }
                if (FindDialog.this.fPanel != null) {
                    FindDialog.this.fPanel.removePropertyChangeListener(FindDialog.this.fPanelListener);
                    FindDialog.this.fPanel.dispose();
                    FindDialog.this.fPanel = null;
                }
            }
        });
    }

    private void attachToClientLater(final FindClientInterface findClientInterface) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindDialog.this.attachToClient(FindDialog.this.getClient(), findClientInterface);
            }
        });
    }

    private static FindPanel copy(FindPanel findPanel, FindClientInterface findClientInterface) {
        FindPanel findPanel2 = new FindPanel();
        if (findPanel != null) {
            findPanel2.setOptions(findPanel.getOptions());
            findPanel2.setLookIn(findClientInterface);
            findPanel2.setReplaceText(findPanel.getReplaceText());
            findPanel2.setSearchText(findPanel.getSearchText());
        }
        return findPanel2;
    }

    private void attachToClient(FindClientInterface findClientInterface, FindClientInterface findClientInterface2) {
        Window window;
        Component component;
        sReparenting = true;
        if (this.fDialog != null) {
            this.fDefaultLocation = this.fDialog.getLocation();
        }
        Window window2 = (component = findClientInterface2.getInvoker()) instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        Window window3 = window = this.fDialog != null ? this.fDialog.getOwner() : null;
        if (findClientInterface != null && findClientInterface != findClientInterface2) {
            findClientInterface.removeFindParentListener(this.fParentListener);
            findClientInterface2.bringForward();
        }
        if (this.fDialog == null || window2 != window) {
            String string;
            if (this.fPanel != null) {
                this.fPanel.removePropertyChangeListener(this.fPanelListener);
            }
            boolean bl = false;
            if (this.fDialog != null) {
                bl = true;
                this.fDialog.removeWindowListener(this.fWindowListener);
                this.fDialog.setFocusTraversalPolicy(null);
                this.fDialog.dispose();
            }
            this.fPanel = FindDialog.copy(this.fPanel, findClientInterface2);
            String string2 = string = this.fPanel.isReplaceAllowed() ? BUNDLE.getString("title.FindAndReplace") : BUNDLE.getString("title.Find");
            if (window2 instanceof Dialog) {
                this.fDialog = new MJDialog((Dialog)window2, string, false);
            } else {
                Frame frame = WindowUtils.getFrameForComponent((Component)window2);
                this.fDialog = new MJDialog(frame, string, false);
            }
            this.fDialog.catchPrematureKeyEvents(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
            this.fDialog.setName("MyFindFrame");
            this.fDialog.getContentPane().add(this.fPanel.getComponent());
            this.fDialog.setResizable(false);
            this.fDialog.pack();
            this.fDialog.getRootPane().setDefaultButton((JButton)this.fPanel.getDefaultButton());
            this.fDialog.setFocusTraversalPolicy(this.fPanel.createFocusTraversalPolicy());
            this.fDialog.addWindowListener(this.fWindowListener);
            this.fPanel.addPropertyChangeListener(this.fPanelListener);
            if (this.fDefaultLocation == null) {
                this.fDialog.setLocationRelativeTo((Component)window2);
            } else {
                this.fDialog.setLocation(this.fDefaultLocation);
                WindowUtils.ensureOnScreen((Window)this.fDialog);
            }
            if (bl) {
                this.show();
            }
        }
        if (findClientInterface != findClientInterface2) {
            findClientInterface2.addFindParentListener(this.fParentListener);
        }
        sReparenting = false;
    }

    private static void resetSingleton() {
        sInstance = null;
        FindClientRegistry.clear();
    }

    public static FindDialog getReplaceDialog() {
        return sInstance;
    }

    public String getText() {
        return this.fPanel.getSearchText();
    }

    public String getReplaceText() {
        return this.fPanel.getReplaceText();
    }

    public int getOptions() {
        return this.fPanel != null ? this.fPanel.getOptions() : 0;
    }
}

