/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Combiner;
import com.mathworks.util.Holder;
import com.mathworks.util.RequestAggregator;
import com.mathworks.util.TypeFilter;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableModel;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import com.mathworks.widgets.grouptable.TransactionProcessor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

final class GroupingTablePopulator<T> {
    private final RequestAggregator<TypeFilter.TargetedRequest<T>> fOnDemandLoadQueue;
    private final TransactionProcessor<T> fTransactionProcessor;
    private final GroupingTableModel<T> fModel;
    private GroupingTable<T> fTable;

    GroupingTablePopulator(GroupingTableModel<T> groupingTableModel) {
        this.fModel = groupingTableModel;
        this.fTransactionProcessor = new TransactionProcessor();
        this.fOnDemandLoadQueue = new RequestAggregator((Combiner)new TypeFilter(), 10);
    }

    WorkMonitor getWorkMonitor() {
        return this.fModel.getWorkMonitor();
    }

    void setTable(GroupingTable<T> groupingTable) {
        assert (this.fTable == null);
        this.fTable = groupingTable;
    }

    public GroupingTable<T> getTable() {
        return this.fTable;
    }

    void requestTransaction(GroupingTableTransaction<T> groupingTableTransaction, GroupingTableTransaction.Target<T> target) {
        this.fTransactionProcessor.request(groupingTableTransaction, target);
    }

    void waitForPendingTransactions() {
        this.fOnDemandLoadQueue.waitForPendingRequests();
        this.fTransactionProcessor.waitForPendingTransactions();
    }

    void notifyExpanded(GroupingTableRow<T> groupingTableRow) {
        if (!groupingTableRow.isPlaceholder() && groupingTableRow.isAnyVerticalAttributeMissing()) {
            this.fOnDemandLoadQueue.request((Runnable)((Object)new VerticalAttributeLoader(groupingTableRow)));
        }
    }

    void notifyVisible(GroupingTableRow<T> groupingTableRow) {
        if (!groupingTableRow.isPlaceholder()) {
            if (!groupingTableRow.isExpandableStateInitialized()) {
                this.fOnDemandLoadQueue.request((Runnable)((Object)new ExpandableStateInitializer(groupingTableRow)));
            }
            if (groupingTableRow.isAnyVerticalAttributeMissing()) {
                this.fOnDemandLoadQueue.request((Runnable)((Object)new VerticalAttributeLoader(groupingTableRow)));
            }
        }
    }

    void notifyChildrenRemoved(GroupingTableRow<T> groupingTableRow) {
        this.fModel.refresh();
    }

    public GroupingTableModel getModel() {
        return this.fModel;
    }

    void notifyChildrenAdded(GroupingTableRow<T> groupingTableRow) {
        this.fModel.refresh();
    }

    private boolean checkRowVisibleSynchronouslyOnEDT(final GroupingTableRow<T> groupingTableRow) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.fTable.isRowVisible(groupingTableRow);
        }
        final Holder holder = new Holder();
        holder.set((Object)false);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    holder.set((Object)GroupingTablePopulator.this.fTable.isRowVisible(groupingTableRow));
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
        return (Boolean)holder.get();
    }

    private class VerticalAttributeLoader
    extends RowLoadRequest {
        VerticalAttributeLoader(GroupingTableRow<T> groupingTableRow) {
            super(groupingTableRow);
        }

        public void run() {
            final GroupingTableRow groupingTableRow = this.getRow();
            if (GroupingTablePopulator.this.checkRowVisibleSynchronouslyOnEDT(groupingTableRow)) {
                int n = groupingTableRow.getLoadedVerticalAttributeCount();
                groupingTableRow.loadAllNonLoadedVerticalAttributes();
                if (groupingTableRow.getLoadedVerticalAttributeCount() != n) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GroupingTablePopulator.this.fTable.adjustRowHeight(groupingTableRow);
                            GroupingTablePopulator.this.fTable.revalidate();
                            GroupingTablePopulator.this.fTable.repaint();
                        }
                    });
                }
            }
        }
    }

    private class ExpandableStateInitializer
    extends RowLoadRequest {
        ExpandableStateInitializer(GroupingTableRow<T> groupingTableRow) {
            super(groupingTableRow);
        }

        public void run() {
            if (GroupingTablePopulator.this.checkRowVisibleSynchronouslyOnEDT(this.getRow())) {
                this.getRow().initializeExpandableState();
            }
        }
    }

    private abstract class RowLoadRequest
    implements TypeFilter.TargetedRequest<T> {
        private final GroupingTableRow<T> fRow;

        RowLoadRequest(GroupingTableRow<T> groupingTableRow) {
            this.fRow = groupingTableRow;
        }

        protected GroupingTableRow<T> getRow() {
            return this.fRow;
        }

        public T getTarget() {
            return this.fRow.getItem();
        }
    }
}

