/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.widgets.login.AuthenticationException;
import com.mathworks.widgets.login.AuthenticationListener;
import com.mathworks.widgets.login.AuthenticationResponse;
import com.mathworks.widgets.login.AutoAssociate;
import com.mathworks.widgets.login.CompletionStatus;
import com.mathworks.widgets.login.FailureType;
import com.mathworks.widgets.login.LogOut;
import com.mathworks.widgets.login.LoginResponse;
import com.mathworks.widgets.login.ValidationListener;
import com.mathworks.widgets.login.ValidationStrategy;
import com.mathworks.widgets.login.WorkFlowCancelledException;
import com.mathworks.widgets.login.WorkFlowReturn;
import javax.swing.SwingUtilities;

public class AuthenticationAndAssociationWorkFlow {
    private final ValidationStrategy fValidationStrategy;
    private WorkFlowState fWorkFlowState = WorkFlowState.NOT_STARTED;

    public AuthenticationAndAssociationWorkFlow(ValidationStrategy validationStrategy) {
        assert (validationStrategy != null && validationStrategy.getLoginPersistenceStrategy() != null) : "ValidationWorkFlow must be created with non-null ValidationStrategy and non-null ValidationStrategy LoginPersistenceStrategy";
        this.fValidationStrategy = validationStrategy;
    }

    public synchronized void startWorkFlow() {
        if (!this.workFlowStarted()) {
            this.setWorkFlowState(WorkFlowState.STARTED);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AuthenticationResponse authenticationResponse;
                    if (AuthenticationAndAssociationWorkFlow.this.forceNewAuthentication()) {
                        AuthenticationAndAssociationWorkFlow.logOut();
                        AuthenticationAndAssociationWorkFlow.this.doAuthentication();
                        return;
                    }
                    try {
                        authenticationResponse = AuthenticationAndAssociationWorkFlow.this.checkAuthenticatedAlready();
                    }
                    catch (AuthenticationException authenticationException) {
                        AuthenticationAndAssociationWorkFlow.this.doAuthentication();
                        return;
                    }
                    catch (WorkFlowCancelledException workFlowCancelledException) {
                        return;
                    }
                    AuthenticationAndAssociationWorkFlow.this.doValidation(authenticationResponse);
                }
            });
            thread.start();
        }
    }

    public synchronized void cancelWorkFlow() {
        this.setWorkFlowState(WorkFlowState.CANCELLED);
        this.workFlowComplete(CompletionStatus.CANCELLED, null, null);
    }

    private synchronized void setWorkFlowState(WorkFlowState workFlowState) {
        this.fWorkFlowState = workFlowState;
    }

    private synchronized Object getWorkFlowState() {
        return this.fWorkFlowState;
    }

    private synchronized boolean workFlowStarted() {
        return this.getWorkFlowState() == WorkFlowState.STARTED;
    }

    private synchronized boolean workFlowCancelled() {
        return this.getWorkFlowState() == WorkFlowState.CANCELLED;
    }

    private void workFlowComplete(CompletionStatus completionStatus, LoginResponse loginResponse, FailureType failureType) {
        this.fValidationStrategy.workFlowComplete(new WorkFlowReturn(completionStatus, loginResponse, failureType));
    }

    private boolean forceNewAuthentication() {
        return this.fValidationStrategy.forceNewAuthentication();
    }

    private boolean canAuthenticate() {
        return this.fValidationStrategy.getValidationConsumer().hasDisplay();
    }

    private synchronized AuthenticationResponse checkAuthenticatedAlready() throws AuthenticationException, WorkFlowCancelledException {
        if (this.workFlowCancelled()) {
            throw new WorkFlowCancelledException();
        }
        String string = this.fValidationStrategy.getLoginPersistenceStrategy().readLoginToken();
        if (string != null && string.length() > 0) {
            return new AuthenticationResponse(string, this.fValidationStrategy.getLoginPersistenceStrategy().readMwaUserName());
        }
        throw new AuthenticationException();
    }

    private synchronized void doAuthentication() {
        if (this.workFlowCancelled()) {
            return;
        }
        if (!this.canAuthenticate()) {
            this.workFlowComplete(CompletionStatus.FAILED, null, FailureType.NOT_SUPPORTED);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AuthenticationAndAssociationWorkFlow.this.fValidationStrategy.doAuthentication(new WorkFlowAuthenticationListener());
            }
        });
    }

    private synchronized void doValidation(AuthenticationResponse authenticationResponse) {
        if (this.workFlowCancelled()) {
            return;
        }
        this.fValidationStrategy.doValidation(authenticationResponse, new WorkFlowValidationListener());
    }

    private static void logOut() {
        LogOut logOut = new LogOut();
        logOut.logOutMWA();
    }

    private void closeLogin() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AuthenticationAndAssociationWorkFlow.this.fValidationStrategy.getUniversalLoginHandler().closeLogin();
            }
        });
    }

    private void doValidationSuccess(final LoginResponse loginResponse) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                AuthenticationAndAssociationWorkFlow.this.workFlowComplete(CompletionStatus.SUCCEEDED, loginResponse, null);
            }
        });
        thread.start();
    }

    private void doValidationFailure(final FailureType failureType) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                AuthenticationAndAssociationWorkFlow.this.workFlowComplete(CompletionStatus.FAILED, null, failureType);
            }
        });
        thread.start();
    }

    private class WorkFlowValidationListener
    implements ValidationListener {
        private WorkFlowValidationListener() {
        }

        @Override
        public void valid(AuthenticationResponse authenticationResponse) {
            AuthenticationAndAssociationWorkFlow.this.doValidationSuccess(authenticationResponse);
        }

        @Override
        public void notValid() {
            AuthenticationAndAssociationWorkFlow.logOut();
            AuthenticationAndAssociationWorkFlow.this.doAuthentication();
        }
    }

    private class WorkFlowAuthenticationListener
    implements AuthenticationListener {
        private WorkFlowAuthenticationListener() {
        }

        @Override
        public void authenticated(AuthenticationResponse authenticationResponse) {
            AuthenticationAndAssociationWorkFlow.this.closeLogin();
            AutoAssociate.autoAssociate(authenticationResponse.getToken(), AuthenticationAndAssociationWorkFlow.this.fValidationStrategy.getClientString());
            AuthenticationAndAssociationWorkFlow.this.doValidationSuccess(authenticationResponse);
        }

        @Override
        public void notAuthenticated() {
            AuthenticationAndAssociationWorkFlow.this.doValidationFailure(FailureType.AUTHENTICATION_FAILURE);
        }
    }

    private static enum WorkFlowState {
        NOT_STARTED,
        STARTED,
        CANCELLED;

    }
}

