/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.internal.loginws.client.v2.LoginServiceClient;
import com.mathworks.widgets.login.AuthenticationResponse;
import com.mathworks.widgets.login.LoginServiceWrapper;
import com.mathworks.widgets.login.ProxySettings;
import com.mathworks.widgets.login.UniversalLoginComponent;
import com.mathworks.widgets.login.ValidateResultWrapper;
import com.mathworks.widgets.login.ValidationListener;
import com.mathworks.widgets.login.WebServiceError;
import com.mathworks.widgets.login.logging.Log;
import java.util.List;

class Validate {
    private Validate() {
    }

    static void validateToken(AuthenticationResponse authenticationResponse, ValidationListener validationListener, String string, String string2, ProxySettings proxySettings) {
        LoginServiceClient loginServiceClient = Validate.getDefaultLoginService(string2, proxySettings);
        Validate.validateToken(authenticationResponse, validationListener, string, string2, loginServiceClient);
    }

    private static LoginServiceClient getDefaultLoginService(String string, ProxySettings proxySettings) {
        return LoginServiceWrapper.getDefaultLoginService(UniversalLoginComponent.getWsEndpoint(), UniversalLoginComponent.getClientVersion(string), proxySettings);
    }

    static void validateToken(AuthenticationResponse authenticationResponse, ValidationListener validationListener, String string, String string2, LoginServiceClient loginServiceClient) {
        ValidateTokenRunnable validateTokenRunnable = new ValidateTokenRunnable(authenticationResponse, validationListener, string, UniversalLoginComponent.getClientVersion(string2), loginServiceClient);
        validateTokenRunnable.run();
    }

    private static class ValidateTokenRunnable
    implements Runnable {
        private final AuthenticationResponse iAuthenticationResponse;
        private final ValidationListener iValidationListener;
        private final String iValidationCriteria;
        private final String iClientVersion;
        private final LoginServiceClient iLoginService;

        private ValidateTokenRunnable(AuthenticationResponse authenticationResponse, ValidationListener validationListener, String string, String string2, LoginServiceClient loginServiceClient) {
            this.iAuthenticationResponse = authenticationResponse;
            this.iValidationListener = validationListener;
            this.iValidationCriteria = string;
            this.iClientVersion = string2;
            this.iLoginService = loginServiceClient;
        }

        @Override
        public void run() {
            assert (this.iLoginService != null);
            String string = this.iAuthenticationResponse.getToken();
            ValidateResultWrapper validateResultWrapper = LoginServiceWrapper.getInstance().validateToken(string, this.iValidationCriteria, this.iClientVersion, this.iLoginService);
            boolean bl = validateResultWrapper.isValid();
            if (!bl) {
                List<WebServiceError> list = validateResultWrapper.getErrors();
                List<String> list2 = UniversalLoginComponent.formatLoginError(list);
                Log.getInstance().getLogger().fine(this.iClientVersion + ": Web service client returned " + ValidateResultWrapper.class.getName() + " not valid, " + list2);
            }
            if (bl) {
                this.iValidationListener.valid(this.iAuthenticationResponse);
            } else {
                this.iValidationListener.notValid();
            }
        }
    }
}

